/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.plaf.synthetica;

import de.javasoft.plaf.synthetica.BackwardAccessController;
import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.SyntheticaTitlePane;
import de.javasoft.plaf.synthetica.painter.RootPanePainter;
import de.javasoft.plaf.synthetica.painter.SyntheticaPainter;
import de.javasoft.plaf.synthetica.util.JavaVersion;
import de.javasoft.plaf.synthetica.util.OS;
import java.awt.AWTEvent;
import java.awt.AWTException;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.LayoutManager2;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.security.PrivilegedExceptionAction;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLayeredPane;
import javax.swing.JMenuBar;
import javax.swing.JRootPane;
import javax.swing.JWindow;
import javax.swing.MenuElement;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicRootPaneUI;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;

public class SyntheticaRootPaneUI
extends BasicRootPaneUI {
    private Window window;
    private JRootPane rootPane;
    private LayoutManager layoutManager;
    private LayoutManager oldLayoutManager;
    private AWTEventListener awtMouseListener;
    private MouseInputListener mouseInputListener;
    private WindowListener windowListener;
    private ComponentListener windowShapeResizeListener;
    private ComponentListener windowMenuBarResizeListener;
    private ComponentListener rootPaneResizeListener;
    private MouseEventProcessor mouseEventProcessor;
    private JComponent titlePane;
    private Insets resizeInsets;
    public static final boolean EVAL_COPY = false;
    public static final int EVAL_HEIGHT = 16;
    public static final String EVAL_TEXT = "Synthetica - Unregistered Evaluation Copy!";
    private SnapState snapState;
    private Rectangle preSnapBounds;
    private WeakReference<JComponent> headerShadowComponent;
    private JComponent headerShadow;

    public static ComponentUI createUI(JComponent jComponent) {
        return new SyntheticaRootPaneUI();
    }

    public static final boolean isEvalCopy() {
        return false;
    }

    @Override
    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        this.rootPane = (JRootPane)jComponent;
        if (this.isDecorated(this.rootPane)) {
            this.installClientDecorations(this.rootPane);
        }
        if (this.isHeaderShadowEnabled()) {
            this.installHeaderListener(this.rootPane);
        }
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
        this.uninstallClientDecorations(this.rootPane);
        this.uninstallHeaderListener(this.rootPane);
        this.rootPane = null;
    }

    private void installClientDecorations(JRootPane jRootPane) {
        String string;
        SyntheticaTitlePane syntheticaTitlePane = new SyntheticaTitlePane(jRootPane, this);
        try {
            string = SyntheticaLookAndFeel.getString("Synthetica.rootPane.titlePane.className", this.rootPane);
            if (string != null) {
                syntheticaTitlePane = (SyntheticaTitlePane)Class.forName(string).getDeclaredConstructor(JRootPane.class, BasicRootPaneUI.class).newInstance(jRootPane, this);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setTitlePane(jRootPane, syntheticaTitlePane);
        this.installBorder(jRootPane);
        this.installWindowListeners(jRootPane, jRootPane.getParent());
        this.installLayout(jRootPane);
        if (this.window instanceof Dialog && SyntheticaLookAndFeel.getBoolean("Synthetica.rootPane.dialogStyle.enabled", this.window, false) && SyntheticaLookAndFeel.getClientProperty("Synthetica.style", this.rootPane, null) == null) {
            string = SyntheticaLookAndFeel.getString("Synthetica.rootPane.dialogStyle.defaultName", this.window, "Dialog");
            this.rootPane.putClientProperty("Synthetica.style", string);
            Container container = this.rootPane.getContentPane();
            if (container == null || container.getName().startsWith("null.")) {
                // empty if block
            }
            container.setName(String.valueOf(string) + ".contentPane");
        } else if (this.window instanceof Frame && SyntheticaLookAndFeel.getBoolean("Synthetica.rootPane.frameStyle.enabled", this.window, false) && SyntheticaLookAndFeel.getClientProperty("Synthetica.style", this.rootPane, null) == null) {
            string = SyntheticaLookAndFeel.getString("Synthetica.rootPane.frameStyle.defaultName", this.window, "Frame");
            this.rootPane.putClientProperty("Synthetica.style", string);
            Container container = this.rootPane.getContentPane();
            if (container == null || container.getName().startsWith("null.")) {
                // empty if block
            }
            container.setName(String.valueOf(string) + ".contentPane");
        }
    }

    private void uninstallClientDecorations(JRootPane jRootPane) {
        if (this.titlePane != null && this.titlePane instanceof SyntheticaTitlePane) {
            ((SyntheticaTitlePane)this.titlePane).uninstallListeners(jRootPane);
        }
        this.setTitlePane(jRootPane, null);
        this.uninstallBorder(jRootPane);
        this.uninstallWindowListeners(jRootPane);
        this.uninstallLayout(jRootPane);
    }

    public JComponent getTitlePane() {
        return this.titlePane;
    }

    protected GraphicsConfiguration getGraphicsConfiguration(Window window) {
        return window.getGraphicsConfiguration();
    }

    void installBorder(JRootPane jRootPane) {
        if (this.isDecorated(jRootPane)) {
            jRootPane.setBorder(new Border(){

                @Override
                public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
                    SynthContext synthContext = SyntheticaLookAndFeel.createContext((JComponent)component, Region.ROOT_PANE, 0);
                    SyntheticaPainter.getInstance().paintRootPaneBorder(synthContext, graphics, n, n2, n3, n4);
                }

                @Override
                public Insets getBorderInsets(Component component) {
                    if (SyntheticaRootPaneUI.this.isMaximized(SyntheticaRootPaneUI.this.window)) {
                        return new Insets(0, 0, 0, 0);
                    }
                    Insets insets = SyntheticaRootPaneUI.this.getDefaultBorderInsets();
                    if (SyntheticaRootPaneUI.this.getRootPaneBorderText() != null) {
                        insets = (Insets)insets.clone();
                        insets.bottom += SyntheticaLookAndFeel.getInstance().scaleInteger(16).intValue();
                        insets.left += SyntheticaLookAndFeel.getInt("Synthetica.rootPane.margin.left", SyntheticaRootPaneUI.this.window, 0, true);
                    }
                    return insets;
                }

                @Override
                public boolean isBorderOpaque() {
                    return false;
                }
            });
        }
    }

    private Insets getDefaultBorderInsets() {
        Insets insets = SyntheticaLookAndFeel.getInsets("Synthetica.rootPane.border.size", (Component)this.window, true, true);
        if (insets == null) {
            insets = SyntheticaLookAndFeel.getInsets("Synthetica.rootPane.border.insets", (Component)this.window, false, true);
        }
        return insets;
    }

    public String getRootPaneBorderText() {
        return SyntheticaLookAndFeel.getString("Synthetica.rootPane.borderText", this.window);
    }

    private void uninstallBorder(JRootPane jRootPane) {
        jRootPane.setBorder(null);
    }

    private void installWindowListeners(JRootPane jRootPane, Component component) {
        this.window = component == null ? null : (component instanceof Window ? (Window)component : SwingUtilities.getWindowAncestor(component));
        this.resizeInsets = SyntheticaLookAndFeel.getInsets("Synthetica.rootPane.resizeInsets", this.window, this.getDefaultBorderInsets(), true, false);
        if (this.window != null) {
            if (this.getMouseInputListener() == null) {
                this.setMouseInputListener(new MouseInputHandler());
            }
            if (this.getAWTMouseInputListener() == null) {
                this.setAWTMouseInputListener(new AWTMouseInputHandler());
            }
            if (this.windowListener == null) {
                if (!SyntheticaLookAndFeel.isWindowOpacityEnabled(this.window)) {
                    if (OS.getCurrentOS() == OS.Mac) {
                        SyntheticaLookAndFeel.setWindowOpaque(this.window, false);
                    } else {
                        try {
                            SyntheticaLookAndFeel.setWindowOpaque(this.window, false);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                boolean bl = SyntheticaLookAndFeel.getBoolean("Synthetica.window.contentPane.opaque", this.window, true);
                this.setContentPaneOpaque(this.window, bl);
                this.windowListener = new WindowAdapter(){

                    @Override
                    public void windowOpened(WindowEvent windowEvent) {
                        Window window = windowEvent.getWindow();
                        if (!SyntheticaLookAndFeel.isWindowOpacityEnabled(SyntheticaRootPaneUI.this.window)) {
                            SyntheticaLookAndFeel.setWindowOpaque(window, false);
                            if (SyntheticaLookAndFeel.getBoolean("Synthetica.window.contentPane.opaque", SyntheticaRootPaneUI.this.window, true)) {
                                SyntheticaRootPaneUI.this.setContentPaneOpaque(window, true);
                            }
                        }
                        if (SyntheticaRootPaneUI.this.snapState == null && SyntheticaRootPaneUI.this.preSnapBounds == null) {
                            SyntheticaRootPaneUI.this.preSnapBounds = windowEvent.getWindow().getBounds();
                        }
                    }

                    @Override
                    public void windowDeactivated(WindowEvent windowEvent) {
                        if (SyntheticaRootPaneUI.this.mouseInputListener instanceof MouseInputHandler) {
                            ((MouseInputHandler)SyntheticaRootPaneUI.this.mouseInputListener).cancelDragResize();
                            ((MouseInputHandler)SyntheticaRootPaneUI.this.mouseInputListener).cancelSnap();
                        }
                    }
                };
                this.window.addWindowListener(this.windowListener);
            }
            if (SyntheticaLookAndFeel.isWindowShapeEnabled(this.window)) {
                if (this.windowShapeResizeListener == null && SyntheticaLookAndFeel.isWindowShapeSupported(this.window)) {
                    this.windowShapeResizeListener = new ComponentAdapter(){

                        @Override
                        public void componentResized(ComponentEvent componentEvent) {
                            Window window = (Window)componentEvent.getComponent();
                            SyntheticaLookAndFeel.updateWindowShape(window);
                        }
                    };
                    this.window.addComponentListener(this.windowShapeResizeListener);
                } else if (OS.getCurrentOS() == OS.Mac) {
                    SyntheticaLookAndFeel.updateWindowShape(this.window);
                }
            }
            if (this.titlePane instanceof SyntheticaTitlePane && ((SyntheticaTitlePane)this.titlePane).showMenuBarInTitlePane() && this.windowMenuBarResizeListener == null) {
                this.windowMenuBarResizeListener = new ComponentAdapter(){

                    @Override
                    public void componentResized(ComponentEvent componentEvent) {
                        SyntheticaRootPaneUI.this.rootPane.doLayout();
                    }
                };
                this.window.addComponentListener(this.windowMenuBarResizeListener);
            }
        }
    }

    private void installHeaderListener(JRootPane jRootPane) {
        if (this.rootPaneResizeListener == null) {
            this.rootPaneResizeListener = new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent componentEvent) {
                    if (SyntheticaRootPaneUI.this.getHeaderShadowComponent() == null) {
                        SyntheticaRootPaneUI.this.updateHeaderShadow();
                    }
                }
            };
            jRootPane.addComponentListener(this.rootPaneResizeListener);
        }
    }

    private void uninstallHeaderListener(JRootPane jRootPane) {
        if (this.rootPaneResizeListener != null) {
            jRootPane.removeComponentListener(this.rootPaneResizeListener);
            this.rootPaneResizeListener = null;
        }
    }

    private void setContentPaneOpaque(Window window, boolean bl) {
        if (window instanceof JDialog && ((JDialog)window).getContentPane() instanceof JComponent) {
            ((JComponent)((JDialog)window).getContentPane()).setOpaque(bl);
        } else if (window instanceof JFrame && ((JFrame)window).getContentPane() instanceof JComponent) {
            ((JComponent)((JFrame)window).getContentPane()).setOpaque(bl);
        } else if (window instanceof JWindow && ((JWindow)window).getContentPane() instanceof JComponent) {
            ((JComponent)((JWindow)window).getContentPane()).setOpaque(bl);
        }
    }

    private void uninstallWindowListeners(JRootPane jRootPane) {
        if (this.window != null) {
            if (this.awtMouseListener != null) {
                this.removeAWTMouseListener(this.awtMouseListener);
            }
            this.window.removeWindowListener(this.windowListener);
            this.window.removeComponentListener(this.windowShapeResizeListener);
            this.window.removeComponentListener(this.windowMenuBarResizeListener);
        }
        this.awtMouseListener = null;
        if (this.mouseInputListener instanceof MouseInputHandler) {
            this.mouseInputListener = null;
        }
        this.windowListener = null;
        this.windowShapeResizeListener = null;
        this.windowMenuBarResizeListener = null;
        this.window = null;
    }

    private void installLayout(JRootPane jRootPane) {
        if (this.layoutManager == null) {
            this.layoutManager = new SyntheticaRootLayout();
        }
        this.oldLayoutManager = jRootPane.getLayout();
        jRootPane.setLayout(this.layoutManager);
    }

    private void uninstallLayout(JRootPane jRootPane) {
        if (this.oldLayoutManager != null) {
            jRootPane.setLayout(this.oldLayoutManager);
        }
        this.oldLayoutManager = null;
        this.layoutManager = null;
    }

    private void setTitlePane(JRootPane jRootPane, JComponent jComponent) {
        JLayeredPane jLayeredPane = jRootPane.getLayeredPane();
        if (this.titlePane != null) {
            this.titlePane.setVisible(false);
            jLayeredPane.remove(this.titlePane);
        }
        if (jComponent != null) {
            jLayeredPane.add((Component)jComponent, JLayeredPane.FRAME_CONTENT_LAYER);
            jComponent.setVisible(true);
        }
        this.titlePane = jComponent;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        super.propertyChange(propertyChangeEvent);
        String string = propertyChangeEvent.getPropertyName();
        if (string == null) {
            return;
        }
        if (string.equals("windowDecorationStyle")) {
            this.uninstallClientDecorations(this.rootPane);
            if (this.isDecorated(this.rootPane)) {
                this.installClientDecorations(this.rootPane);
            }
        } else if (string.equals("ancestor")) {
            this.uninstallWindowListeners(this.rootPane);
            if (this.isDecorated(this.rootPane) && propertyChangeEvent.getNewValue() != null) {
                this.installWindowListeners(this.rootPane, this.rootPane.getParent());
            }
        } else if (string.equals("Synthetica.style") && this.titlePane instanceof SyntheticaTitlePane) {
            ((SyntheticaTitlePane)this.titlePane).updateLayoutStyle();
        }
    }

    public void setMaximizedBounds(Frame frame) {
        Boolean bl;
        if (SyntheticaLookAndFeel.isSystemPropertySet("synthetica.frame.fullscreen", SyntheticaLookAndFeel.getInstance().isSwingUIScalingEnabled())) {
            return;
        }
        Boolean bl2 = SyntheticaLookAndFeel.isSystemPropertySet("synthetica.frame.respectScreenBoundsX", null);
        if (bl2 == null & (bl = SyntheticaLookAndFeel.isSystemPropertySet("synthetica.frame.respectScreenBoundsY", null)) == null && (JavaVersion.JAVA11 || JavaVersion.JAVA15_OR_ABOVE)) {
            bl2 = bl = Boolean.valueOf(true);
        }
        frame.setMaximizedBounds(this.getMaximizedBounds(this.getGraphicsConfiguration(frame), bl2 == null ? false : bl2, bl == null ? false : bl));
    }

    private Rectangle getMaximizedBounds(GraphicsConfiguration graphicsConfiguration, boolean bl, boolean bl2) {
        Rectangle rectangle = graphicsConfiguration.getBounds();
        if (!bl) {
            rectangle.x = 0;
        }
        if (!bl2) {
            rectangle.y = 0;
        }
        Insets insets = Toolkit.getDefaultToolkit().getScreenInsets(graphicsConfiguration);
        if (SyntheticaLookAndFeel.isSystemPropertySet("synthetica.frame.ignoreScreenInsets")) {
            return rectangle;
        }
        if (!SyntheticaLookAndFeel.isSystemPropertySet("synthetica.frame.disableAutoHideTaskBarCorrection") && insets.bottom == 0) {
            ++insets.bottom;
        }
        Rectangle rectangle2 = new Rectangle(rectangle.x + insets.left, rectangle.y + insets.top, rectangle.width - (insets.left + insets.right), rectangle.height - (insets.top + insets.bottom));
        return rectangle2;
    }

    private boolean isDecorated(JRootPane jRootPane) {
        return jRootPane.getWindowDecorationStyle() != 0;
    }

    public MouseInputListener getMouseInputListener() {
        return this.mouseInputListener;
    }

    public void setMouseInputListener(MouseInputListener mouseInputListener) {
        this.mouseInputListener = mouseInputListener;
    }

    private AWTEventListener getAWTMouseInputListener() {
        return this.awtMouseListener;
    }

    private void setAWTMouseInputListener(AWTEventListener aWTEventListener) {
        if (this.awtMouseListener != null && this.window != null) {
            this.removeAWTMouseListener(this.awtMouseListener);
        }
        this.awtMouseListener = aWTEventListener;
        if (this.awtMouseListener != null && this.window != null) {
            this.addAWTMouseListener(this.awtMouseListener);
        }
        if (this.getMouseEventProcesor() == null) {
            this.mouseEventProcessor = new MouseEventProcessor();
        }
    }

    private void addAWTMouseListener(AWTEventListener aWTEventListener) {
        Toolkit.getDefaultToolkit().addAWTEventListener(aWTEventListener, 48L);
    }

    private void removeAWTMouseListener(AWTEventListener aWTEventListener) {
        Toolkit.getDefaultToolkit().removeAWTEventListener(aWTEventListener);
    }

    public MouseEventProcessor getMouseEventProcesor() {
        return this.mouseEventProcessor;
    }

    public void setMouseEventProcessor(MouseEventProcessor mouseEventProcessor) {
        this.mouseEventProcessor = mouseEventProcessor;
    }

    public void setHeaderShadowComponent(JComponent jComponent) {
        if (jComponent == null) {
            this.uninstallHeaderShadowComponent();
        } else if (jComponent != this.getHeaderShadowComponent()) {
            this.installHeaderShadowComponent(jComponent);
        }
        this.updateHeaderShadow();
    }

    public JComponent getHeaderShadowComponent() {
        return this.headerShadowComponent == null ? null : (JComponent)this.headerShadowComponent.get();
    }

    public boolean isHeaderShadowEnabled() {
        return !this.getHeaderShadowType().equals((Object)HeaderShadowType.NONE);
    }

    private void installHeaderShadowComponent(JComponent jComponent) {
        JComponent jComponent2;
        ComponentListener componentListener;
        PropertyChangeListener propertyChangeListener = (PropertyChangeListener)jComponent.getClientProperty("Synthetica.headerShadow.ancestorListener");
        if (propertyChangeListener == null) {
            propertyChangeListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if ("ancestor".equals(propertyChangeEvent.getPropertyName())) {
                        if (propertyChangeEvent.getNewValue() == null) {
                            SyntheticaRootPaneUI.this.uninstallHeaderShadowComponent();
                        }
                        SyntheticaRootPaneUI.this.updateHeaderShadow();
                    }
                }
            };
            jComponent.putClientProperty("Synthetica.headerShadow.ancestorListener", propertyChangeListener);
            jComponent.addPropertyChangeListener(propertyChangeListener);
        }
        if ((componentListener = (ComponentListener)jComponent.getClientProperty("Synthetica.headerShadow.componentListener")) == null) {
            componentListener = new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent componentEvent) {
                    SyntheticaRootPaneUI.this.updateHeaderShadow();
                }
            };
            jComponent.putClientProperty("Synthetica.headerShadow.componentListener", componentListener);
            jComponent.addComponentListener(componentListener);
        }
        if ((jComponent2 = this.getHeaderShadowComponent()) == null || jComponent == null || jComponent != jComponent2 && jComponent.getLocationOnScreen().y + jComponent.getHeight() > jComponent2.getLocationOnScreen().y + jComponent2.getHeight()) {
            this.headerShadowComponent = new WeakReference<JComponent>(jComponent);
        }
    }

    private void uninstallHeaderShadowComponent() {
        this.headerShadowComponent = null;
    }

    private void updateHeaderShadow() {
        if (this.headerShadow == null && !"ToolBar.FloatingWindow".equals(this.rootPane.getName())) {
            this.headerShadow = new JComponent(){

                @Override
                protected void paintComponent(Graphics graphics) {
                    JComponent jComponent = SyntheticaRootPaneUI.this.getProperHeaderShadowComponent();
                    if (jComponent != null) {
                        super.paintComponent(graphics);
                        SyntheticaRootPaneUI.this.paintHeaderShadowBackground(SyntheticaRootPaneUI.this.rootPane, graphics, 0, 0, this.getWidth(), this.getHeight());
                    }
                }
            };
            this.headerShadow.setName("HeaderShadow");
            this.headerShadow.setOpaque(false);
            this.rootPane.getLayeredPane().add((Component)this.headerShadow, (Object)(JLayeredPane.PALETTE_LAYER + 1));
        }
        JComponent jComponent = this.getProperHeaderShadowComponent();
        if (this.headerShadow != null && jComponent != null) {
            Point point = jComponent.getLocation();
            Point point2 = SwingUtilities.convertPoint(jComponent.getParent(), point, this.headerShadow.getParent());
            this.headerShadow.setBounds(point2.x, point2.y + jComponent.getHeight(), jComponent.getWidth(), SyntheticaLookAndFeel.getInt("Synthetica.rootPane.headerShadow.size", this.rootPane, 6, true));
        }
    }

    private JComponent getProperHeaderShadowComponent() {
        if (this.rootPane == null) {
            return null;
        }
        HeaderShadowType headerShadowType = this.getHeaderShadowType();
        if (headerShadowType == HeaderShadowType.TITLEPANE_ONLY) {
            return this.getTitlePane();
        }
        if (this.isHeaderShadowComponentValid()) {
            return this.getHeaderShadowComponent();
        }
        if (headerShadowType == HeaderShadowType.NORMAL || headerShadowType == HeaderShadowType.SHADOW_COMPONENT_MENUBAR_ONLY) {
            JMenuBar jMenuBar = this.rootPane.getJMenuBar() == null ? (headerShadowType == HeaderShadowType.SHADOW_COMPONENT_MENUBAR_ONLY ? null : this.getTitlePane()) : this.rootPane.getJMenuBar();
            return jMenuBar instanceof SyntheticaTitlePane && !((SyntheticaTitlePane)((Object)jMenuBar)).isTitlePaneEnabled() ? null : jMenuBar;
        }
        return null;
    }

    private boolean isHeaderShadowComponentValid() {
        JComponent jComponent = this.getHeaderShadowComponent();
        if (this.headerShadow != null && jComponent != null && jComponent.getRootPane() == this.rootPane) {
            Point point = jComponent.getLocation();
            point = SwingUtilities.convertPoint(jComponent.getParent(), point, this.headerShadow.getParent());
            return point.y + jComponent.getHeight() < this.headerShadow.getParent().getHeight();
        }
        return false;
    }

    private HeaderShadowType getHeaderShadowType() {
        String string = SyntheticaLookAndFeel.getString("Synthetica.rootPane.headerShadow.type", this.window);
        return string == null ? HeaderShadowType.NONE : HeaderShadowType.valueOf(string);
    }

    private void paintHeaderShadowBackground(JRootPane jRootPane, Graphics graphics, int n, int n2, int n3, int n4) {
        RootPanePainter.getInstance().paintHeaderShadowBackground(jRootPane, null, graphics, n, n2, n3, n4);
    }

    void snapNext(Window window) {
        if (this.snapState == null && !this.isMaximized(window)) {
            this.preSnapBounds = window.getBounds();
        } else if (this.isMaximized(window) && this.titlePane instanceof SyntheticaTitlePane) {
            ((SyntheticaTitlePane)this.titlePane).restore();
            this.snapState = null;
        }
        GraphicsConfiguration graphicsConfiguration = this.getGraphicsConfiguration(window);
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] graphicsDeviceArray = graphicsEnvironment.getScreenDevices();
        int n = graphicsDeviceArray.length;
        int n2 = 0;
        while (n2 < n) {
            GraphicsDevice graphicsDevice = graphicsDeviceArray[n2];
            GraphicsConfiguration graphicsConfiguration2 = graphicsDevice.getDefaultConfiguration();
            if (graphicsConfiguration == graphicsConfiguration2 && this.snapState == SnapState.SNAP_LEFT) {
                this.restoreSnappedWindow(window, graphicsConfiguration2, true);
                break;
            }
            if (this.snapState == SnapState.SNAP_RIGHT) {
                boolean bl;
                Rectangle rectangle = this.getMultiScreenBounds();
                boolean bl2 = graphicsConfiguration.getBounds().x + graphicsConfiguration.getBounds().width == rectangle.x + rectangle.width;
                boolean bl3 = bl = graphicsConfiguration2.getBounds().x == rectangle.x;
                if (bl2 && bl || graphicsConfiguration2.getBounds().x > graphicsConfiguration.getBounds().x + graphicsConfiguration.getBounds().width - 1) {
                    this.snapLeft(graphicsConfiguration2, window);
                    break;
                }
            } else if (graphicsConfiguration == graphicsConfiguration2) {
                this.snapRight(graphicsConfiguration2, window);
                break;
            }
            ++n2;
        }
    }

    void snapPrev(Window window) {
        if (this.snapState == null && !this.isMaximized(window)) {
            this.preSnapBounds = window.getBounds();
        } else if (this.isMaximized(window) && this.titlePane instanceof SyntheticaTitlePane) {
            ((SyntheticaTitlePane)this.titlePane).restore();
            this.snapState = null;
        }
        GraphicsConfiguration graphicsConfiguration = this.getGraphicsConfiguration(window);
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] graphicsDeviceArray = graphicsEnvironment.getScreenDevices();
        int n = graphicsDeviceArray.length;
        int n2 = 0;
        while (n2 < n) {
            GraphicsDevice graphicsDevice = graphicsDeviceArray[n2];
            GraphicsConfiguration graphicsConfiguration2 = graphicsDevice.getDefaultConfiguration();
            if (graphicsConfiguration == graphicsConfiguration2 && this.snapState == SnapState.SNAP_RIGHT) {
                this.restoreSnappedWindow(window, graphicsConfiguration2, true);
                break;
            }
            if (this.snapState == SnapState.SNAP_LEFT) {
                boolean bl;
                Rectangle rectangle = this.getMultiScreenBounds();
                boolean bl2 = graphicsConfiguration.getBounds().x == rectangle.x;
                boolean bl3 = bl = graphicsConfiguration2.getBounds().x + graphicsConfiguration2.getBounds().width == rectangle.x + rectangle.width;
                if (bl2 && bl || graphicsConfiguration2.getBounds().x + graphicsConfiguration2.getBounds().width - 1 < graphicsConfiguration.getBounds().x) {
                    this.snapRight(graphicsConfiguration2, window);
                    break;
                }
            } else if (graphicsConfiguration == graphicsConfiguration2) {
                this.snapLeft(graphicsConfiguration2, window);
                break;
            }
            ++n2;
        }
    }

    private void snapLeft(GraphicsConfiguration graphicsConfiguration, Window window) {
        this.snapState = SnapState.SNAP_LEFT;
        Rectangle rectangle = this.getMaximizedBounds(graphicsConfiguration, true, true);
        rectangle.width /= 2;
        window.setBounds(this.justifySnapBounds(rectangle, this.snapState));
    }

    private void snapRight(GraphicsConfiguration graphicsConfiguration, Window window) {
        this.snapState = SnapState.SNAP_RIGHT;
        Rectangle rectangle = this.getMaximizedBounds(graphicsConfiguration, true, true);
        rectangle.width /= 2;
        rectangle.x += rectangle.width;
        window.setBounds(this.justifySnapBounds(rectangle, this.snapState));
    }

    void restoreSnappedWindow(Window window, GraphicsConfiguration graphicsConfiguration, boolean bl) {
        if (this.preSnapBounds != null) {
            if (bl) {
                Rectangle rectangle = this.getMaximizedBounds(graphicsConfiguration, true, true);
                if (rectangle.intersects(this.preSnapBounds)) {
                    window.setLocation(this.preSnapBounds.x, this.preSnapBounds.y);
                } else {
                    Rectangle rectangle2 = this.toRelativeScreenBounds(this.preSnapBounds);
                    if (rectangle2 != null) {
                        window.setLocation(Math.max(rectangle.x, Math.min(rectangle.x + rectangle.width - rectangle2.width, rectangle.x + rectangle2.x)), Math.max(rectangle.y, Math.min(rectangle.y + rectangle.height - rectangle2.height, rectangle.y + rectangle2.y)));
                    }
                }
            }
            window.setSize(this.preSnapBounds.width, this.preSnapBounds.height);
        }
        this.snapState = null;
    }

    private Rectangle toRelativeScreenBounds(Rectangle rectangle) {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] graphicsDeviceArray = graphicsEnvironment.getScreenDevices();
        int n = graphicsDeviceArray.length;
        int n2 = 0;
        while (n2 < n) {
            GraphicsDevice graphicsDevice = graphicsDeviceArray[n2];
            GraphicsConfiguration graphicsConfiguration = graphicsDevice.getDefaultConfiguration();
            Rectangle rectangle2 = graphicsConfiguration.getBounds();
            Rectangle rectangle3 = new Rectangle(rectangle.x - rectangle2.x, rectangle.y - rectangle2.y, rectangle.width, rectangle.height);
            if (rectangle2.intersects(rectangle)) {
                return rectangle3;
            }
            ++n2;
        }
        return null;
    }

    private Rectangle getMultiScreenBounds() {
        Rectangle rectangle = new Rectangle();
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] graphicsDeviceArray = graphicsEnvironment.getScreenDevices();
        int n = graphicsDeviceArray.length;
        int n2 = 0;
        while (n2 < n) {
            GraphicsDevice graphicsDevice = graphicsDeviceArray[n2];
            rectangle = rectangle.union(graphicsDevice.getDefaultConfiguration().getBounds());
            ++n2;
        }
        return rectangle;
    }

    private Rectangle justifySnapBounds(Rectangle rectangle, SnapState snapState) {
        Insets insets = SyntheticaLookAndFeel.getInsets("Synthetica.rootPane.snap.insets", (Component)this.window, false, true);
        Rectangle rectangle2 = new Rectangle(rectangle);
        switch (snapState) {
            case SNAP_LEFT: {
                rectangle2.x -= insets.left;
                rectangle2.y -= insets.top;
                rectangle2.width += insets.left;
                rectangle2.height += insets.top + insets.bottom;
                break;
            }
            case SNAP_RIGHT: {
                rectangle2.y -= insets.top;
                rectangle2.width += insets.right;
                rectangle2.height += insets.top + insets.bottom;
                break;
            }
            case SNAP_HEIGHT: {
                rectangle2.y -= insets.top;
                rectangle2.height += insets.top + insets.bottom;
            }
        }
        return rectangle2;
    }

    boolean isSnapEnabled(Window window) {
        boolean bl = true;
        if (SyntheticaLookAndFeel.getBoolean("Synthetica.rootPane.snap.translucencyCheck.enabled", null, false)) {
            GraphicsConfiguration graphicsConfiguration = this.getGraphicsConfiguration(window);
            try {
                Method method = GraphicsConfiguration.class.getMethod("isTranslucencyCapable", new Class[0]);
                Object object = method.invoke((Object)graphicsConfiguration, null);
                bl = object instanceof Boolean ? (Boolean)object : false;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
        return bl && window instanceof Frame && ((Frame)window).isResizable() && SyntheticaLookAndFeel.getBoolean("Synthetica.rootPane.snap.enabled", this.window, true);
    }

    private boolean isMaximized(Window window) {
        return window instanceof Frame && (((Frame)window).getExtendedState() & 6) == 6;
    }

    private class AWTMouseInputHandler
    implements AWTEventListener {
        private AWTMouseInputHandler() {
        }

        @Override
        public void eventDispatched(AWTEvent aWTEvent) {
            Object object = aWTEvent.getSource();
            if (object instanceof Component) {
                Window window;
                Component component = (Component)object;
                Window window2 = window = component instanceof Window ? (Window)component : SwingUtilities.getWindowAncestor(component);
                if (SyntheticaRootPaneUI.this.window != window || !(aWTEvent instanceof MouseEvent) || SyntheticaRootPaneUI.this.rootPane == null) {
                    return;
                }
                SyntheticaRootPaneUI.this.mouseEventProcessor.process(SyntheticaRootPaneUI.this.rootPane, (MouseEvent)aWTEvent);
            }
        }
    }

    private static enum HeaderShadowType {
        NONE,
        NORMAL,
        SHADOW_COMPONENT_MENUBAR_ONLY,
        SHADOW_COMPONENT_ONLY,
        TITLEPANE_ONLY;

    }

    public static class MouseEventProcessor {
        public void process(JRootPane jRootPane, MouseEvent mouseEvent) {
            boolean bl;
            boolean bl2;
            Component component = mouseEvent.getComponent();
            int n = mouseEvent.getID();
            boolean bl3 = bl2 = SwingUtilities.getAncestorOfClass(SyntheticaTitlePane.class, component) != null;
            if (component.getCursor() != Cursor.getDefaultCursor() && (bl2 || component instanceof MenuElement)) {
                Window window = SwingUtilities.getWindowAncestor(jRootPane);
                window.setCursor(Cursor.getDefaultCursor());
            }
            boolean bl4 = bl = bl2 || component instanceof MenuElement;
            if (bl) {
                return;
            }
            MouseInputListener mouseInputListener = ((SyntheticaRootPaneUI)jRootPane.getUI()).getMouseInputListener();
            if (mouseInputListener == null) {
                return;
            }
            if (n == 500) {
                mouseInputListener.mouseClicked(mouseEvent);
            } else if (n == 506) {
                mouseInputListener.mouseDragged(mouseEvent);
            } else if (n == 504) {
                mouseInputListener.mouseEntered(mouseEvent);
            } else if (n == 505) {
                mouseInputListener.mouseExited(mouseEvent);
            } else if (n == 503) {
                mouseInputListener.mouseMoved(mouseEvent);
            } else if (n == 501) {
                mouseInputListener.mousePressed(mouseEvent);
            } else if (n == 502) {
                mouseInputListener.mouseReleased(mouseEvent);
            }
            if (mouseInputListener instanceof MouseInputHandler && ((MouseInputHandler)mouseInputListener).isResizing()) {
                mouseEvent.consume();
            }
        }
    }

    private class MouseInputHandler
    implements MouseInputListener {
        private static final int WINDOW_MOVE = 1;
        private static final int WINDOW_RESIZE = 2;
        private int windowAction;
        private int dragXOffset;
        private int dragYOffset;
        private Dimension dragDimension;
        private int resizeType;
        private int minimumYPos;
        private int maximumYPos;
        private boolean liveResize;
        private boolean liveDrag;
        private Rectangle resizeBounds;
        private JWindow dragResizeWindow;
        private JWindow snapWindow;
        private SnapState tmpSnapState;
        private int preSnapXOffset;
        private Point dragStart;
        private Point dragStartOnScreen;
        private boolean windowMenuKeyEmulationRunning;
        private int snapThreshold;
        private int snapHeightThreshold;
        private int snapCornerSize;
        private final PrivilegedExceptionAction<?> locationAction;
        private Frame frame;
        private Dialog dialog;

        private MouseInputHandler() {
            this.liveResize = SyntheticaLookAndFeel.getBoolean("Synthetica.rootPane.liveResizeEnabled", SyntheticaRootPaneUI.this.window, true);
            this.liveDrag = SyntheticaLookAndFeel.getBoolean("Synthetica.rootPane.liveDragEnabled", SyntheticaRootPaneUI.this.window, true);
            this.snapThreshold = 12;
            this.snapHeightThreshold = 24;
            this.snapCornerSize = 24;
            this.locationAction = new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws HeadlessException {
                    PointerInfo pointerInfo = MouseInfo.getPointerInfo();
                    return pointerInfo == null ? null : pointerInfo.getLocation();
                }
            };
            this.frame = null;
            this.dialog = null;
            if (SyntheticaRootPaneUI.this.window instanceof Frame) {
                this.frame = (Frame)SyntheticaRootPaneUI.this.window;
            } else if (SyntheticaRootPaneUI.this.window instanceof Dialog) {
                this.dialog = (Dialog)SyntheticaRootPaneUI.this.window;
            }
        }

        private Point getPoint(MouseEvent mouseEvent) {
            return SwingUtilities.convertPoint(mouseEvent.getComponent(), mouseEvent.getPoint(), SyntheticaRootPaneUI.this.window);
        }

        private boolean isInTitlePane(MouseEvent mouseEvent) {
            Point point = SwingUtilities.convertPoint(SyntheticaRootPaneUI.this.window, this.getPoint(mouseEvent), SyntheticaRootPaneUI.this.titlePane);
            return SyntheticaRootPaneUI.this.titlePane.contains(point);
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (!SyntheticaRootPaneUI.this.isDecorated(SyntheticaRootPaneUI.this.rootPane) || this.windowMenuKeyEmulationRunning) {
                return;
            }
            SyntheticaRootPaneUI.this.window.toFront();
            Rectangle rectangle = SyntheticaRootPaneUI.this.getGraphicsConfiguration(SyntheticaRootPaneUI.this.window).getBounds();
            this.minimumYPos = rectangle.y;
            this.maximumYPos = rectangle.y + rectangle.height;
            this.dragStart = this.getPoint(mouseEvent);
            this.dragStartOnScreen = new Point(this.dragStart);
            SwingUtilities.convertPointToScreen(this.dragStartOnScreen, SyntheticaRootPaneUI.this.window);
            Point point = SwingUtilities.convertPoint(SyntheticaRootPaneUI.this.window, this.dragStart, SyntheticaRootPaneUI.this.titlePane);
            int n = this.position2Cursor(SyntheticaRootPaneUI.this.window, this.dragStart.x, this.dragStart.y);
            if (n == 0 && SyntheticaRootPaneUI.this.titlePane != null && SyntheticaRootPaneUI.this.titlePane.contains(point) && (this.dialog != null || this.frame != null && this.frame.getExtendedState() != 6)) {
                this.windowAction = 1;
                this.dragXOffset = this.dragStart.x;
                this.dragYOffset = this.dragStart.y;
                if (!this.liveDrag && this.dragResizeWindow == null) {
                    this.dragResizeWindow = this.createDragResizeWindow();
                    this.dragResizeWindow.setBounds(SyntheticaRootPaneUI.this.window.getBounds());
                    this.dragResizeWindow.setVisible(true);
                }
            } else if (this.isWindowResizable()) {
                this.dragXOffset = this.dragStart.x;
                this.dragYOffset = this.dragStart.y;
                this.dragDimension = new Dimension(SyntheticaRootPaneUI.this.window.getWidth(), SyntheticaRootPaneUI.this.window.getHeight());
                this.resizeType = this.position2Cursor(SyntheticaRootPaneUI.this.window, this.dragStart.x, this.dragStart.y);
                if (this.resizeType != 0) {
                    this.windowAction = 2;
                }
                if (!this.liveResize && this.resizeType != 0 && this.dragResizeWindow == null) {
                    this.dragResizeWindow = this.createDragResizeWindow();
                    this.dragResizeWindow.setCursor(Cursor.getPredefinedCursor(n));
                    this.dragResizeWindow.setBounds(SyntheticaRootPaneUI.this.window.getBounds());
                    this.dragResizeWindow.setVisible(true);
                }
            }
            if (SyntheticaRootPaneUI.this.isSnapEnabled(SyntheticaRootPaneUI.this.window) && SyntheticaRootPaneUI.this.snapState == null) {
                SyntheticaRootPaneUI.this.preSnapBounds = SyntheticaRootPaneUI.this.window.getBounds();
                this.preSnapXOffset = this.dragXOffset;
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            Rectangle rectangle;
            if (this.windowMenuKeyEmulationRunning) {
                return;
            }
            if (SyntheticaLookAndFeel.getBoolean("Synthetica.rootPane.nativeWindowMenuSupport.enabled", SyntheticaRootPaneUI.this.window, false) && mouseEvent.getButton() == 3 && this.isInTitlePane(mouseEvent) && (OS.getCurrentOS() == OS.Windows || OS.getCurrentOS() == OS.Linux) && this.snapWindow == null) {
                this.windowMenuKeyEmulationRunning = true;
                try {
                    final Robot robot = new Robot();
                    if (OS.getCurrentOS() == OS.Windows) {
                        robot.keyPress(18);
                        robot.keyPress(32);
                    } else if (OS.getCurrentOS() == OS.Linux) {
                        robot.keyPress(18);
                        robot.mousePress(4096);
                        robot.mouseRelease(4096);
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                Thread.sleep(100L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            if (OS.getCurrentOS() == OS.Windows) {
                                robot.keyRelease(32);
                            }
                            robot.keyRelease(18);
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    MouseInputHandler.this.windowMenuKeyEmulationRunning = false;
                                }
                            });
                        }
                    });
                }
                catch (AWTException aWTException) {
                    aWTException.printStackTrace();
                }
                return;
            }
            if (this.dragResizeWindow != null && (this.windowAction == 2 && !this.liveResize || this.windowAction == 1 && !this.liveDrag)) {
                rectangle = this.dragResizeWindow.getBounds();
                this.dragResizeWindow.setVisible(false);
                this.dragResizeWindow.dispose();
                if (this.windowAction == 2 && this.resizeBounds != null) {
                    SyntheticaRootPaneUI.this.window.setBounds(this.resizeBounds);
                } else {
                    SyntheticaRootPaneUI.this.window.setBounds(rectangle);
                }
                this.dragResizeWindow = null;
                this.resizeBounds = null;
            }
            if (this.snapWindow != null) {
                rectangle = this.snapWindow.getBounds();
                if (this.tmpSnapState == SnapState.SNAP_MAXIMIZED && SyntheticaRootPaneUI.this.titlePane instanceof SyntheticaTitlePane) {
                    ((SyntheticaTitlePane)SyntheticaRootPaneUI.this.titlePane).maximize();
                } else {
                    SyntheticaRootPaneUI.this.window.setBounds(SyntheticaRootPaneUI.this.justifySnapBounds(rectangle, this.tmpSnapState));
                }
                this.disposeSnapWindow();
                SyntheticaRootPaneUI.this.snapState = this.tmpSnapState;
                this.tmpSnapState = null;
            }
            if (this.windowAction == 2 && !SyntheticaRootPaneUI.this.window.isValid()) {
                SyntheticaRootPaneUI.this.window.validate();
                SyntheticaRootPaneUI.this.rootPane.repaint();
            }
            this.windowAction = -1;
            this.resizeType = -1;
            SyntheticaRootPaneUI.this.window.setCursor(Cursor.getDefaultCursor());
        }

        private void cancelDragResize() {
            if (this.dragResizeWindow != null && (this.windowAction == 2 && !this.liveResize || this.windowAction == 1 && !this.liveDrag)) {
                this.dragResizeWindow.setVisible(false);
                this.dragResizeWindow.dispose();
                this.dragResizeWindow = null;
                this.resizeBounds = null;
            }
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            if (!SyntheticaRootPaneUI.this.isDecorated(SyntheticaRootPaneUI.this.rootPane) || this.windowMenuKeyEmulationRunning) {
                return;
            }
            Point point = this.getPoint(mouseEvent);
            int n = this.position2Cursor(SyntheticaRootPaneUI.this.window, point.x, point.y);
            if (n != 0 && this.isWindowResizable()) {
                SyntheticaRootPaneUI.this.window.setCursor(Cursor.getPredefinedCursor(n));
            } else {
                SyntheticaRootPaneUI.this.window.setCursor(Cursor.getDefaultCursor());
            }
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            this.mouseMoved(mouseEvent);
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            SyntheticaRootPaneUI.this.window.setCursor(Cursor.getDefaultCursor());
        }

        private void cancelSnap() {
            if (this.windowAction == 1 || this.windowAction == 2) {
                this.resetSnapState();
            }
        }

        private void resetSnapState() {
            if (this.snapWindow != null) {
                this.disposeSnapWindow();
            }
            this.tmpSnapState = null;
            SyntheticaRootPaneUI.this.snapState = null;
        }

        private void disposeSnapWindow() {
            this.snapWindow.setVisible(false);
            this.snapWindow.dispose();
            this.snapWindow = null;
        }

        private void unsnap(Window window) {
            SyntheticaRootPaneUI.this.restoreSnappedWindow(window, SyntheticaRootPaneUI.this.getGraphicsConfiguration(window), false);
            this.dragXOffset = this.preSnapXOffset;
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            boolean bl;
            if (this.windowMenuKeyEmulationRunning) {
                return;
            }
            GraphicsConfiguration graphicsConfiguration = !this.liveDrag && this.dragResizeWindow != null ? SyntheticaRootPaneUI.this.getGraphicsConfiguration(this.dragResizeWindow) : SyntheticaRootPaneUI.this.getGraphicsConfiguration(SyntheticaRootPaneUI.this.window);
            Insets insets = Toolkit.getDefaultToolkit().getScreenInsets(graphicsConfiguration);
            this.minimumYPos = graphicsConfiguration.getBounds().y + insets.top;
            this.maximumYPos = graphicsConfiguration.getBounds().y + graphicsConfiguration.getBounds().height - insets.bottom - SyntheticaRootPaneUI.this.titlePane.getHeight() - ((SyntheticaRootPaneUI)SyntheticaRootPaneUI.this).rootPane.getInsets().top;
            Rectangle rectangle = SyntheticaRootPaneUI.this.getMultiScreenBounds();
            int n = rectangle.x + insets.left;
            int n2 = rectangle.x + rectangle.width - insets.left - insets.right;
            boolean bl2 = SyntheticaLookAndFeel.isSystemPropertySet("synthetica.window.respectMinimumYPos");
            boolean bl3 = SyntheticaLookAndFeel.isSystemPropertySet("synthetica.window.respectMaximumYPos");
            int n3 = SyntheticaLookAndFeel.getInstance().scaleInteger(this.snapThreshold);
            int n4 = SyntheticaLookAndFeel.getInstance().scaleInteger(this.snapHeightThreshold);
            int n5 = SyntheticaLookAndFeel.getInstance().scaleInteger(this.snapCornerSize);
            if (SyntheticaRootPaneUI.this.isMaximized(SyntheticaRootPaneUI.this.window) && this.dragStart != null && mouseEvent.getComponent() instanceof Window && this.isInTitlePane(mouseEvent) && SyntheticaLookAndFeel.getBoolean("Synthetica.rootPane.restoreByDragFromMaximized.enabled", SyntheticaRootPaneUI.this.window, true)) {
                int n6 = SyntheticaLookAndFeel.getInt("Synthetica.rootPane.restoreByDragFromMaximized.threshold", SyntheticaRootPaneUI.this.window, 4, true);
                boolean bl4 = bl = Math.abs(this.dragStart.x - mouseEvent.getX()) > n6 || Math.abs(this.dragStart.y - mouseEvent.getY()) > n6;
                if (bl) {
                    if (SyntheticaRootPaneUI.this.titlePane instanceof SyntheticaTitlePane) {
                        ((SyntheticaTitlePane)SyntheticaRootPaneUI.this.titlePane).restore();
                    }
                    this.windowAction = 1;
                    if (this.dragXOffset <= 0) {
                        this.dragXOffset = SyntheticaRootPaneUI.this.window.getWidth() / 2;
                    }
                    if (this.dragYOffset <= 0) {
                        this.dragYOffset = SyntheticaRootPaneUI.this.titlePane.getHeight() / 2;
                    }
                    if (!this.liveDrag) {
                        this.dragResizeWindow = this.createDragResizeWindow();
                        this.dragResizeWindow.setBounds(SyntheticaRootPaneUI.this.window.getBounds());
                        this.dragResizeWindow.setVisible(true);
                    }
                }
            }
            if (this.windowAction == 1) {
                Point point = (Point)BackwardAccessController.doPrivileged(this.locationAction);
                if (point == null) {
                    point = this.getPoint(mouseEvent);
                    SwingUtilities.convertPointToScreen(point, (Component)mouseEvent.getSource());
                }
                point.x -= this.dragXOffset;
                point.y -= this.dragYOffset;
                if (bl2 && point.y < this.minimumYPos) {
                    point.y = this.minimumYPos;
                }
                if (bl3 && point.y > this.maximumYPos) {
                    point.y = this.maximumYPos;
                }
                if ((bl = SyntheticaRootPaneUI.this.isSnapEnabled(SyntheticaRootPaneUI.this.window)) && SyntheticaRootPaneUI.this.snapState == SnapState.SNAP_HEIGHT && point.y < this.minimumYPos + n4) {
                    point.y = this.minimumYPos - SyntheticaLookAndFeel.getInsets((String)"Synthetica.rootPane.snap.insets", (Component)((SyntheticaRootPaneUI)SyntheticaRootPaneUI.this).window, (boolean)false, (boolean)true).top;
                }
                if (this.liveDrag) {
                    SyntheticaRootPaneUI.this.window.setLocation(point);
                } else {
                    this.dragResizeWindow.setLocation(point);
                }
                if (bl) {
                    Rectangle rectangle2;
                    GraphicsConfiguration graphicsConfiguration2 = this.liveDrag ? SyntheticaRootPaneUI.this.getGraphicsConfiguration(SyntheticaRootPaneUI.this.window) : SyntheticaRootPaneUI.this.getGraphicsConfiguration(this.dragResizeWindow);
                    Point point2 = new Point(point.x + this.dragXOffset, point.y + this.dragYOffset);
                    if (point2.y <= this.minimumYPos) {
                        this.tmpSnapState = SnapState.SNAP_MAXIMIZED;
                        if (this.snapWindow == null) {
                            this.snapWindow = this.createSnapWindow();
                        }
                        this.snapWindow.setBounds(SyntheticaRootPaneUI.this.getMaximizedBounds(graphicsConfiguration2, true, true));
                        this.snapWindow.setVisible(true);
                    } else if (point2.x <= n) {
                        this.tmpSnapState = SnapState.SNAP_LEFT;
                        if (this.snapWindow == null) {
                            this.snapWindow = this.createSnapWindow();
                        }
                        rectangle2 = SyntheticaRootPaneUI.this.getMaximizedBounds(graphicsConfiguration2, true, true);
                        rectangle2.width /= 2;
                        this.snapWindow.setBounds(rectangle2);
                        this.snapWindow.setVisible(true);
                    } else if (point2.x >= n2 - 1) {
                        this.tmpSnapState = SnapState.SNAP_RIGHT;
                        if (this.snapWindow == null) {
                            this.snapWindow = this.createSnapWindow();
                        }
                        rectangle2 = SyntheticaRootPaneUI.this.getMaximizedBounds(graphicsConfiguration2, true, true);
                        rectangle2.width /= 2;
                        rectangle2.x += rectangle2.width;
                        this.snapWindow.setBounds(rectangle2);
                        this.snapWindow.setVisible(true);
                    } else if (point2.y <= this.minimumYPos + n5 && point2.x <= n + n5) {
                        this.tmpSnapState = SnapState.SNAP_TOP_LEFT;
                        if (this.snapWindow == null) {
                            this.snapWindow = this.createSnapWindow();
                        }
                        rectangle2 = SyntheticaRootPaneUI.this.getMaximizedBounds(graphicsConfiguration2, true, true);
                        rectangle2.width /= 2;
                        rectangle2.height /= 2;
                        this.snapWindow.setBounds(rectangle2);
                        this.snapWindow.setVisible(true);
                    } else if (point2.y <= this.minimumYPos + n5 && point2.x >= n2 - 1 - n5) {
                        this.tmpSnapState = SnapState.SNAP_TOP_RIGHT;
                        if (this.snapWindow == null) {
                            this.snapWindow = this.createSnapWindow();
                        }
                        rectangle2 = SyntheticaRootPaneUI.this.getMaximizedBounds(graphicsConfiguration2, true, true);
                        rectangle2.width /= 2;
                        rectangle2.height /= 2;
                        rectangle2.x += rectangle2.width;
                        this.snapWindow.setBounds(rectangle2);
                        this.snapWindow.setVisible(true);
                    } else if (point2.y >= this.maximumYPos - 1 - n5 && point2.x <= n + n5) {
                        this.tmpSnapState = SnapState.SNAP_BOTTOM_LEFT;
                        if (this.snapWindow == null) {
                            this.snapWindow = this.createSnapWindow();
                        }
                        rectangle2 = SyntheticaRootPaneUI.this.getMaximizedBounds(graphicsConfiguration2, true, true);
                        ++rectangle2.height;
                        rectangle2.width /= 2;
                        rectangle2.height /= 2;
                        rectangle2.y += rectangle2.height - 1;
                        this.snapWindow.setBounds(rectangle2);
                        this.snapWindow.setVisible(true);
                    } else if (point2.y >= this.maximumYPos - 1 - n5 && point2.x >= n2 - 1 - n5) {
                        this.tmpSnapState = SnapState.SNAP_BOTTOM_RIGHT;
                        if (this.snapWindow == null) {
                            this.snapWindow = this.createSnapWindow();
                        }
                        rectangle2 = SyntheticaRootPaneUI.this.getMaximizedBounds(graphicsConfiguration2, true, true);
                        ++rectangle2.height;
                        rectangle2.width /= 2;
                        rectangle2.height /= 2;
                        rectangle2.x += rectangle2.width;
                        rectangle2.y += rectangle2.height - 1;
                        this.snapWindow.setBounds(rectangle2);
                        this.snapWindow.setVisible(true);
                    } else if (this.snapWindow != null && point2.y > this.minimumYPos + n3 && point2.x > n + n3 && point2.x < n2 - n3) {
                        this.disposeSnapWindow();
                    }
                    if (SyntheticaRootPaneUI.this.snapState != null && this.snapWindow == null && (SyntheticaRootPaneUI.this.snapState != SnapState.SNAP_HEIGHT || point.y >= this.minimumYPos + n4)) {
                        boolean bl5;
                        int n7 = SyntheticaLookAndFeel.getInt("Synthetica.rootPane.snap.restoreThreshold", SyntheticaRootPaneUI.this.window, 0, true);
                        boolean bl6 = bl5 = Math.abs(this.dragStartOnScreen.x - mouseEvent.getXOnScreen()) > n7 || Math.abs(this.dragStartOnScreen.y - mouseEvent.getYOnScreen()) > n7;
                        if (bl5) {
                            this.unsnap(!this.liveDrag && this.dragResizeWindow != null ? this.dragResizeWindow : SyntheticaRootPaneUI.this.window);
                            if (this.dragXOffset <= 0) {
                                this.dragXOffset = SyntheticaRootPaneUI.this.window.getWidth() / 2;
                            }
                            if (this.dragYOffset <= 0) {
                                this.dragYOffset = SyntheticaRootPaneUI.this.titlePane.getHeight() / 2;
                            }
                        }
                    }
                }
            } else if (this.windowAction == 2) {
                int n8;
                if (SyntheticaRootPaneUI.this.isSnapEnabled(SyntheticaRootPaneUI.this.window) && (this.resizeType == 9 || this.resizeType == 8) && SyntheticaRootPaneUI.this.snapState != null) {
                    this.resetSnapState();
                }
                Point point = this.getPoint(mouseEvent);
                Dimension dimension = (Dimension)SyntheticaLookAndFeel.get("Synthetica.rootPane.minimumWindowSize", SyntheticaRootPaneUI.this.window);
                if (SyntheticaLookAndFeel.getBoolean("Synthetica.rootPane.fallBelowMinimumWindowSize", SyntheticaRootPaneUI.this.window, true) && (mouseEvent.getModifiersEx() & 0x80) == 128) {
                    dimension = new Dimension(4, 4);
                }
                if (dimension == null) {
                    dimension = SyntheticaRootPaneUI.this.window.getMinimumSize();
                }
                this.resizeBounds = SyntheticaRootPaneUI.this.window.getBounds();
                Rectangle rectangle3 = new Rectangle(this.resizeBounds);
                if (this.resizeType == 11 || this.resizeType == 7 || this.resizeType == 5) {
                    this.resizeBounds.width = Math.max(dimension.width, this.dragDimension.width + point.x - this.dragXOffset);
                }
                if (this.resizeType == 9 || this.resizeType == 4 || this.resizeType == 5) {
                    this.resizeBounds.height = Math.max(dimension.height, this.dragDimension.height + point.y - this.dragYOffset);
                    if (SyntheticaRootPaneUI.this.isSnapEnabled(SyntheticaRootPaneUI.this.window) && this.resizeType == 9) {
                        this.setSnapHeightState(mouseEvent);
                    }
                }
                if (this.resizeType == 8 || this.resizeType == 6 || this.resizeType == 7) {
                    n8 = point.y - this.dragYOffset;
                    this.resizeBounds.y += n8;
                    this.resizeBounds.height -= n8;
                    if (this.resizeBounds.height < dimension.height) {
                        this.resizeBounds.y += this.resizeBounds.height - dimension.height;
                        this.resizeBounds.height = dimension.height;
                    }
                    if (SyntheticaRootPaneUI.this.isSnapEnabled(SyntheticaRootPaneUI.this.window) && this.resizeType == 8) {
                        this.setSnapHeightState(mouseEvent);
                    }
                }
                if (this.resizeType == 10 || this.resizeType == 6 || this.resizeType == 4) {
                    n8 = point.x - this.dragXOffset;
                    this.resizeBounds.x += n8;
                    this.resizeBounds.width -= n8;
                    if (this.resizeBounds.width < dimension.width) {
                        this.resizeBounds.x += this.resizeBounds.width - dimension.width;
                        this.resizeBounds.width = dimension.width;
                    }
                }
                if (bl2 && this.resizeBounds.y < this.minimumYPos) {
                    this.resizeBounds.y = this.minimumYPos;
                }
                if (!this.resizeBounds.equals(rectangle3)) {
                    if (this.liveResize) {
                        SyntheticaRootPaneUI.this.window.setBounds(this.resizeBounds);
                    } else {
                        this.dragResizeWindow.setBounds(this.resizeBounds);
                    }
                }
            }
        }

        private void setSnapHeightState(MouseEvent mouseEvent) {
            int n = SyntheticaLookAndFeel.getInstance().scaleInteger(this.snapThreshold);
            Point point = (Point)BackwardAccessController.doPrivileged(this.locationAction);
            if (point == null) {
                point = this.getPoint(mouseEvent);
                SwingUtilities.convertPointToScreen(point, (Component)mouseEvent.getSource());
            }
            int n2 = this.maximumYPos + ((SyntheticaRootPaneUI)SyntheticaRootPaneUI.this).rootPane.getInsets().top + SyntheticaRootPaneUI.this.titlePane.getHeight() - 1;
            if ((point.y <= this.minimumYPos || point.y >= n2) && this.snapWindow == null) {
                this.tmpSnapState = SnapState.SNAP_HEIGHT;
                this.snapWindow = this.createSnapWindow();
                this.snapWindow.setCursor(Cursor.getPredefinedCursor(8));
                Rectangle rectangle = SyntheticaRootPaneUI.this.getMaximizedBounds(SyntheticaRootPaneUI.this.getGraphicsConfiguration(SyntheticaRootPaneUI.this.window), true, true);
                Rectangle rectangle2 = SyntheticaRootPaneUI.this.window.getBounds();
                rectangle.x = rectangle2.x;
                rectangle.width = rectangle2.width;
                this.snapWindow.setBounds(rectangle);
                this.snapWindow.setVisible(true);
            } else if (this.snapWindow != null && point.y > this.minimumYPos + n && point.y < n2 - n) {
                this.disposeSnapWindow();
            }
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (this.frame == null || this.windowMenuKeyEmulationRunning) {
                return;
            }
            Point point = SwingUtilities.convertPoint(SyntheticaRootPaneUI.this.window, this.getPoint(mouseEvent), SyntheticaRootPaneUI.this.titlePane);
            if (SyntheticaRootPaneUI.this.titlePane != null && SyntheticaRootPaneUI.this.titlePane.contains(point) && mouseEvent.getClickCount() == 2 && mouseEvent.getButton() == 1) {
                if (SyntheticaRootPaneUI.this.snapState != null) {
                    if (SyntheticaRootPaneUI.this.isMaximized(this.frame) && SyntheticaRootPaneUI.this.titlePane instanceof SyntheticaTitlePane) {
                        ((SyntheticaTitlePane)SyntheticaRootPaneUI.this.titlePane).restore();
                    }
                    SyntheticaRootPaneUI.this.restoreSnappedWindow(this.frame, SyntheticaRootPaneUI.this.getGraphicsConfiguration(this.frame), true);
                } else if (this.frame.isResizable() && this.isFrameResizable() && SyntheticaRootPaneUI.this.titlePane instanceof SyntheticaTitlePane) {
                    ((SyntheticaTitlePane)SyntheticaRootPaneUI.this.titlePane).maximize();
                } else if (this.frame.isResizable() && !this.isFrameResizable() && SyntheticaRootPaneUI.this.titlePane instanceof SyntheticaTitlePane) {
                    ((SyntheticaTitlePane)SyntheticaRootPaneUI.this.titlePane).restore();
                }
            }
        }

        private int position2Cursor(Window window, int n, int n2) {
            int n3 = window.getWidth();
            int n4 = window.getHeight();
            if (n < ((SyntheticaRootPaneUI)SyntheticaRootPaneUI.this).resizeInsets.left && n2 < ((SyntheticaRootPaneUI)SyntheticaRootPaneUI.this).resizeInsets.top) {
                return 6;
            }
            if (n > n3 - ((SyntheticaRootPaneUI)SyntheticaRootPaneUI.this).resizeInsets.right && n2 < ((SyntheticaRootPaneUI)SyntheticaRootPaneUI.this).resizeInsets.top) {
                return 7;
            }
            if (n < ((SyntheticaRootPaneUI)SyntheticaRootPaneUI.this).resizeInsets.left && n2 > n4 - ((SyntheticaRootPaneUI)SyntheticaRootPaneUI.this).resizeInsets.bottom) {
                return 4;
            }
            if (n > n3 - ((SyntheticaRootPaneUI)SyntheticaRootPaneUI.this).resizeInsets.right && n2 > n4 - ((SyntheticaRootPaneUI)SyntheticaRootPaneUI.this).resizeInsets.bottom) {
                return 5;
            }
            if (n < ((SyntheticaRootPaneUI)SyntheticaRootPaneUI.this).resizeInsets.left) {
                return 10;
            }
            if (n > n3 - ((SyntheticaRootPaneUI)SyntheticaRootPaneUI.this).resizeInsets.right) {
                return 11;
            }
            if (n2 < ((SyntheticaRootPaneUI)SyntheticaRootPaneUI.this).resizeInsets.top) {
                return 8;
            }
            if (n2 > n4 - ((SyntheticaRootPaneUI)SyntheticaRootPaneUI.this).resizeInsets.bottom) {
                return 9;
            }
            return 0;
        }

        private JWindow createDragResizeWindow() {
            JWindow jWindow = new JWindow(SyntheticaRootPaneUI.this.window);
            if (OS.getCurrentOS() == OS.Mac) {
                jWindow.getRootPane().putClientProperty("Window.shadow", Boolean.FALSE);
            }
            jWindow.getRootPane().setContentPane(new JComponent(){

                @Override
                public void paintComponent(Graphics graphics) {
                    super.paintComponents(graphics);
                    MouseInputHandler.this.paintResizeBackground(SyntheticaRootPaneUI.this.rootPane, graphics, 0, 0, this.getWidth(), this.getHeight());
                }
            });
            SyntheticaLookAndFeel.setWindowOpaque(jWindow, false);
            return jWindow;
        }

        private JWindow createSnapWindow() {
            JWindow jWindow = new JWindow();
            if (OS.getCurrentOS() == OS.Mac) {
                jWindow.getRootPane().putClientProperty("Window.shadow", Boolean.FALSE);
            }
            jWindow.getRootPane().setContentPane(new JComponent(){

                @Override
                public void paintComponent(Graphics graphics) {
                    super.paintComponents(graphics);
                    MouseInputHandler.this.paintSnapBackground(SyntheticaRootPaneUI.this.rootPane, graphics, 0, 0, this.getWidth(), this.getHeight());
                }
            });
            SyntheticaLookAndFeel.setWindowOpaque(jWindow, false);
            return jWindow;
        }

        private void paintResizeBackground(JRootPane jRootPane, Graphics graphics, int n, int n2, int n3, int n4) {
            RootPanePainter.getInstance().paintResizeBackground(jRootPane, null, graphics, n, n2, n3, n4);
        }

        private void paintSnapBackground(JRootPane jRootPane, Graphics graphics, int n, int n2, int n3, int n4) {
            RootPanePainter.getInstance().paintSnapBackground(jRootPane, null, graphics, n, n2, n3, n4);
        }

        private boolean isFrameResizable() {
            return this.frame != null && this.frame.isResizable() && (this.frame.getExtendedState() & 6) == 0;
        }

        private boolean isDialogResizable() {
            return this.dialog != null && this.dialog.isResizable();
        }

        private boolean isWindowResizable() {
            return this.isFrameResizable() || this.isDialogResizable();
        }

        public boolean isResizing() {
            return this.windowAction == 2;
        }
    }

    private static enum SnapState {
        SNAP_LEFT,
        SNAP_RIGHT,
        SNAP_HEIGHT,
        SNAP_MAXIMIZED,
        SNAP_TOP_LEFT,
        SNAP_TOP_RIGHT,
        SNAP_BOTTOM_LEFT,
        SNAP_BOTTOM_RIGHT;

    }

    private static class SyntheticaRootLayout
    implements LayoutManager2 {
        private SyntheticaRootLayout() {
        }

        @Override
        public void addLayoutComponent(String string, Component component) {
        }

        @Override
        public void removeLayoutComponent(Component component) {
        }

        @Override
        public void addLayoutComponent(Component component, Object object) {
        }

        @Override
        public float getLayoutAlignmentX(Container container) {
            return 0.0f;
        }

        @Override
        public float getLayoutAlignmentY(Container container) {
            return 0.0f;
        }

        @Override
        public void invalidateLayout(Container container) {
        }

        @Override
        public Dimension preferredLayoutSize(Container container) {
            Insets insets = container.getInsets();
            JRootPane jRootPane = (JRootPane)container;
            JComponent jComponent = ((SyntheticaRootPaneUI)jRootPane.getUI()).titlePane;
            Dimension dimension = new Dimension(0, 0);
            dimension = jRootPane.getContentPane() != null ? jRootPane.getContentPane().getPreferredSize() : jRootPane.getSize();
            dimension = dimension == null ? new Dimension(0, 0) : dimension;
            Dimension dimension2 = new Dimension(0, 0);
            if (jRootPane.getJMenuBar() != null) {
                dimension2 = jRootPane.getJMenuBar().getPreferredSize();
            }
            dimension2 = dimension2 == null ? new Dimension(0, 0) : dimension2;
            Dimension dimension3 = jComponent.getPreferredSize();
            dimension3 = dimension3 == null ? new Dimension(0, 0) : dimension3;
            int n = Math.max(dimension.width, Math.max(dimension2.width, dimension3.width)) + insets.left + insets.right;
            int n2 = dimension.height + dimension2.height + dimension3.height + insets.top + insets.bottom;
            return new Dimension(n, n2);
        }

        @Override
        public Dimension minimumLayoutSize(Container container) {
            Insets insets = container.getInsets();
            JRootPane jRootPane = (JRootPane)container;
            JComponent jComponent = ((SyntheticaRootPaneUI)jRootPane.getUI()).titlePane;
            Dimension dimension = new Dimension(0, 0);
            dimension = jRootPane.getContentPane() != null ? jRootPane.getContentPane().getMinimumSize() : jRootPane.getSize();
            dimension = dimension == null ? new Dimension(0, 0) : dimension;
            Dimension dimension2 = new Dimension(0, 0);
            if (jRootPane.getJMenuBar() != null) {
                dimension2 = jRootPane.getJMenuBar().getMinimumSize();
            }
            dimension2 = dimension2 == null ? new Dimension(0, 0) : dimension2;
            Dimension dimension3 = jComponent.getMinimumSize();
            dimension3 = dimension3 == null ? new Dimension(0, 0) : dimension3;
            int n = Math.max(dimension.width, Math.max(dimension2.width, dimension3.width)) + insets.left + insets.right;
            int n2 = dimension.height + dimension2.height + dimension3.height + insets.top + insets.bottom;
            return new Dimension(n, n2);
        }

        @Override
        public Dimension maximumLayoutSize(Container container) {
            int n;
            Insets insets = container.getInsets();
            JRootPane jRootPane = (JRootPane)container;
            JComponent jComponent = ((SyntheticaRootPaneUI)jRootPane.getUI()).titlePane;
            Dimension dimension = new Dimension(0, 0);
            dimension = jRootPane.getContentPane() != null ? jRootPane.getContentPane().getMaximumSize() : jRootPane.getSize();
            dimension = dimension == null ? new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE) : dimension;
            Dimension dimension2 = new Dimension(0, 0);
            if (jRootPane.getJMenuBar() != null) {
                dimension2 = jRootPane.getJMenuBar().getMaximumSize();
            }
            dimension2 = dimension2 == null ? new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE) : dimension2;
            Dimension dimension3 = jComponent.getMaximumSize();
            dimension3 = dimension3 == null ? new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE) : dimension3;
            int n2 = Math.max(dimension.width, Math.max(dimension2.width, dimension3.width));
            if (n2 != Integer.MAX_VALUE) {
                n2 += insets.left + insets.right;
            }
            if ((n = Math.max(dimension.height, Math.max(dimension2.height, dimension3.height))) != Integer.MAX_VALUE) {
                n += insets.top + insets.bottom;
            }
            return new Dimension(n2, n);
        }

        @Override
        public void layoutContainer(Container container) {
            Container container2;
            JMenuBar jMenuBar;
            JRootPane jRootPane = (JRootPane)container;
            Rectangle rectangle = jRootPane.getBounds();
            Insets insets = jRootPane.getInsets() != null ? jRootPane.getInsets() : new Insets(0, 0, 0, 0);
            int n = rectangle.width - insets.right - insets.left;
            int n2 = rectangle.height - insets.top - insets.bottom;
            int n3 = 0;
            if (jRootPane.getLayeredPane() != null) {
                jRootPane.getLayeredPane().setBounds(insets.left, insets.top, n, n2);
            }
            if (jRootPane.getGlassPane() != null) {
                jRootPane.getGlassPane().setBounds(insets.left, insets.top, n, n2);
            }
            JComponent jComponent = ((SyntheticaRootPaneUI)jRootPane.getUI()).titlePane;
            Dimension dimension = null;
            if (jComponent.isEnabled() && (dimension = jComponent.getPreferredSize()) != null) {
                jComponent.setBounds(0, 0, n, dimension.height);
                n3 += dimension.height;
            }
            if ((jMenuBar = jRootPane.getJMenuBar()) != null && jComponent instanceof SyntheticaTitlePane) {
                container2 = (SyntheticaTitlePane)jComponent;
                Dimension dimension2 = jMenuBar.getPreferredSize();
                if (((SyntheticaTitlePane)container2).showMenuBarInTitlePane()) {
                    boolean bl = jMenuBar.getComponentOrientation().isLeftToRight();
                    JComponent jComponent2 = (JComponent)SyntheticaLookAndFeel.findComponent("RootPane.menuBar", (Container)jComponent);
                    if (jComponent2 != null) {
                        int n4;
                        Insets insets2 = jComponent2.getInsets();
                        n3 = jComponent2.getY() + insets2.top;
                        int n5 = ((SyntheticaTitlePane)container2).clipMenuBarWidth() ? jComponent2.getX() : (n4 = bl ? jComponent2.getX() : 0);
                        int n6 = ((SyntheticaTitlePane)container2).clipMenuBarWidth() ? jComponent2.getWidth() - insets2.left - insets2.right : (bl ? n - jComponent2.getX() : jComponent2.getX() + jComponent2.getWidth());
                        jMenuBar.setBounds(n4 + insets2.left, n3, n6, dimension2.height);
                        n3 += insets2.top + insets2.bottom + dimension2.height;
                        JComponent jComponent3 = ((SyntheticaTitlePane)container2).getUserComponent();
                        if (jComponent3 != null && ((SyntheticaTitlePane)container2).getLayoutStyle() == SyntheticaTitlePane.LayoutStyle.SECONDARYMENU) {
                            n3 += jComponent3.getPreferredSize().height;
                        }
                        n3 = Math.max(n3, dimension == null ? 0 : dimension.height);
                    }
                } else {
                    jMenuBar.setBounds(0, n3, n, dimension2.height);
                    n3 += dimension2.height;
                }
            }
            if ((container2 = jRootPane.getContentPane()) != null) {
                container2.setBounds(0, n3, n, n2 < n3 ? 0 : n2 - n3);
            }
        }
    }
}

