/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.plaf.synthetica.painter;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.painter.AnimationThreadFactory;
import de.javasoft.plaf.synthetica.util.HiDpi;
import de.javasoft.plaf.synthetica.util.Synthetica2DUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.FilteredImageSource;
import java.awt.image.RGBImageFilter;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.plaf.ColorUIResource;

public class ImagePainter {
    public static final Logger logger = Logger.getLogger(ImagePainter.class.getName());
    public static final int STRETCHED = 0;
    public static final int TILED = 1;
    private Graphics g;
    private int x;
    private int y;
    private int w;
    private int h;
    private int iw;
    private int ih;
    private Image image;
    private Insets sInsets;
    private Insets dInsets;
    private int xPolicy;
    private int yPolicy;
    private WeakReference<JComponent> weakComponent;
    private AnimationThreadFactory.AnimationThread animationThread;
    private String id;
    private int angle = 0;
    private boolean flipHorizontal;
    private boolean flipVertical;
    private boolean animationEnabled;
    private static long initDuration = -1L;
    private static int initOperations = 0;
    private static long paintDuration = 0L;
    private static int paintOperations = 0;
    private static HashMap<String, Image> imageCache = new HashMap();
    private static boolean debug = SyntheticaLookAndFeel.isSystemPropertySet("synthetica.debug");
    private static final String SYNTHETICA_BACKGROUND = "Synthetica.background";
    private static final String SYNTHETICA_BACKGROUND_ALPHA = "Synthetica.background.alpha";
    private static final String SYNTHETICA_BLEND_MODE = "Synthetica.background.blendMode";
    private static final String SYNTHETICA_DEFAULT_BLEND_MODE = "Synthetica.background.defaultBlendMode";
    private static final boolean RESPECT_PARENT_BACKGROUND = SyntheticaLookAndFeel.getBoolean("Synthetica.background.respectParent", null, false);

    public ImagePainter(JComponent jComponent, int n, int n2, int n3, int n4, Graphics graphics, int n5, int n6, int n7, int n8, String string, Insets insets, Insets insets2, int n9, int n10) {
        this(jComponent, null, n, n2, n3, n4, graphics, n5, n6, n7, n8, string, insets, insets2, n9, n10);
    }

    public ImagePainter(JComponent jComponent, String string, int n, int n2, int n3, int n4, Graphics graphics, int n5, int n6, int n7, int n8, String string2, Insets insets, Insets insets2, int n9, int n10) {
        this(jComponent, string, n, n2, n3, n4, graphics, n5, n6, n7, n8, string2, insets, insets2, n9, n10, false, false);
    }

    public ImagePainter(JComponent jComponent, String string, int n, int n2, int n3, int n4, Graphics graphics, int n5, int n6, int n7, int n8, String string2, Insets insets, Insets insets2, int n9, int n10, boolean bl, boolean bl2) {
        Object object;
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Image Path: " + string2);
        }
        if (!debug && string2 == null) {
            return;
        }
        if (debug && initDuration == -1L) {
            Frame[] frameArray = Frame.getFrames();
            int n11 = 0;
            while (n11 < frameArray.length) {
                if (frameArray[n11] instanceof JFrame) {
                    ((JFrame)frameArray[n11]).getRootPane().registerKeyboardAction(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            System.out.println("inits: " + initOperations + " in " + initDuration + " ms");
                            System.out.println("paint: " + paintOperations + " in " + paintDuration + " ms");
                            initDuration = 0L;
                            initOperations = 0;
                            paintDuration = 0L;
                            paintOperations = 0;
                            Frame[] frameArray = Frame.getFrames();
                            int n = 0;
                            while (n < frameArray.length) {
                                Frame frame = frameArray[n];
                                if (frame instanceof JFrame && ((JFrame)frame).getRootPane() != null) {
                                    frame.setSize(640, 550);
                                    frame.validate();
                                    ((JFrame)frame).getRootPane().repaint();
                                }
                                ++n;
                            }
                        }
                    }, "durationAction", KeyStroke.getKeyStroke(123, 640), 1);
                }
                ++n11;
            }
        }
        long l = System.currentTimeMillis();
        if (string == null) {
            string = "null";
        }
        this.id = string;
        this.flipHorizontal = bl;
        this.flipVertical = bl2;
        if (jComponent != null) {
            this.weakComponent = new WeakReference<JComponent>(jComponent);
            if (jComponent.getClientProperty("Synthetica.flipHorizontal") != null && ((Boolean)jComponent.getClientProperty("Synthetica.flipHorizontal")).booleanValue()) {
                this.flipHorizontal = true;
            }
            if (jComponent.getClientProperty("Synthetica.flipVertical") != null && ((Boolean)jComponent.getClientProperty("Synthetica.flipVertical")).booleanValue()) {
                this.flipVertical = true;
            }
        }
        if (this.flipHorizontal) {
            insets = this.flipLeftRight(insets);
            insets2 = this.flipLeftRight(insets2);
        }
        if (this.flipVertical) {
            insets = this.flipTopBottom(insets);
            insets2 = this.flipTopBottom(insets2);
        }
        String[] stringArray = string2.split(",");
        this.animationEnabled = this.isAnimationEnabled(jComponent);
        if (this.animationEnabled && jComponent != null && n2 > 0) {
            object = AnimationThreadFactory.createThread(n2);
            Rectangle rectangle = new Rectangle(n5, n6, n7, n8);
            if (jComponent instanceof JTabbedPane && !string.equals("null")) {
                rectangle = ((JTabbedPane)jComponent).getBoundsAt(Integer.parseInt(string.split("/")[1]));
            }
            ((AnimationThreadFactory.AnimationThread)object).addComponent(jComponent, this.id, n4, n3, stringArray, n, rectangle);
            this.animationThread = object;
        }
        this.g = graphics;
        this.x = n5;
        this.y = n6;
        this.w = n7;
        this.h = n8;
        String[] stringArray2 = stringArray;
        int n12 = stringArray.length;
        int n13 = 0;
        while (n13 < n12) {
            object = stringArray2[n13];
            this.image = imageCache.get(object);
            if (this.image == null) {
                URL uRL = SyntheticaLookAndFeel.getResource((String)object);
                if (uRL == null) {
                    throw new RuntimeException("File not found: " + (String)object);
                }
                try {
                    this.image = this.toCompatibleImage(ImageIO.read(uRL), true, this.isHiDpiImage((String)object));
                }
                catch (IOException iOException) {
                    throw new RuntimeException(iOException);
                }
                imageCache.put((String)object, this.image);
            }
            ++n13;
        }
        this.iw = this.image.getWidth(null);
        this.ih = this.image.getHeight(null);
        this.sInsets = insets == null ? null : SyntheticaLookAndFeel.getInstance().scaleInsets(insets);
        this.dInsets = insets2 == null ? null : SyntheticaLookAndFeel.getInstance().scaleInsets(insets2);
        this.xPolicy = n9;
        this.yPolicy = n10;
        if (debug) {
            long l2 = System.currentTimeMillis();
            long l3 = l2 - l;
            initDuration += l3;
            ++initOperations;
        }
    }

    private Insets flipLeftRight(Insets insets) {
        if (insets == null) {
            return null;
        }
        return new Insets(insets.top, insets.right, insets.bottom, insets.left);
    }

    private Insets flipTopBottom(Insets insets) {
        if (insets == null) {
            return null;
        }
        return new Insets(insets.bottom, insets.left, insets.top, insets.right);
    }

    private boolean isAnimationEnabled(JComponent jComponent) {
        return SyntheticaLookAndFeel.getBoolean("Synthetica.animation.enabled", jComponent, true);
    }

    public ImagePainter(JComponent jComponent, Graphics graphics, int n, int n2, int n3, int n4, String string, Insets insets, Insets insets2, int n5, int n6) {
        this(jComponent, -1, -1, -1, -1, graphics, n, n2, n3, n4, string, insets, insets2, n5, n6);
    }

    public ImagePainter(Graphics graphics, int n, int n2, int n3, int n4, String string, Insets insets, Insets insets2, int n5, int n6) {
        this(null, graphics, n, n2, n3, n4, string, insets, insets2, n5, n6);
    }

    public ImagePainter(JComponent jComponent, int n, int n2, int n3, Insets insets, Graphics graphics, int n4, int n5, int n6, int n7, String string, Insets insets2, Insets insets3, int n8, int n9) {
        this(jComponent, n, n2, n3, insets, graphics, n4, n5, n6, n7, string, insets2, insets3, n8, n9, false, false);
    }

    public ImagePainter(JComponent jComponent, int n, int n2, int n3, Insets insets, Graphics graphics, int n4, int n5, int n6, int n7, String string, Insets insets2, Insets insets3, int n8, int n9, boolean bl, boolean bl2) {
        this(jComponent, null, -1, -1, -1, -1, graphics, n4, n5, n6, n7, string, insets2, insets3, n8, n9, bl, bl2);
        if (!debug && string == null) {
            return;
        }
        Image image = imageCache.get(string);
        if (image == null || !(image instanceof BufferedImage)) {
            try {
                image = this.toCompatibleImage(ImageIO.read(SyntheticaLookAndFeel.getResource(string)), true, this.isHiDpiImage(string));
                imageCache.put(string, image);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.image = jComponent.createImage(new FilteredImageSource(image.getSource(), new Colorizer(0, n, n2, n3, image.getWidth(null), image.getHeight(null), insets)));
    }

    public ImagePainter(JComponent jComponent, Graphics graphics, int n, int n2, int n3, int n4, String string, Insets insets, Insets insets2, Insets insets3, Insets insets4, int n5, int n6) {
        this(graphics, n, n2, n3, n4, string, insets, insets2, n5, n6);
        String string2 = String.valueOf(string) + "_EXCLUDED_OUTER_INSETS";
        Image image = imageCache.get(string2);
        if (image == null) {
            int n7 = SyntheticaLookAndFeel.getInstance().scaleInteger(this.iw - insets.left - insets.right);
            int n8 = SyntheticaLookAndFeel.getInstance().scaleInteger(this.ih - insets.top - insets.bottom);
            BufferedImage bufferedImage = new BufferedImage(n7, n8, 2);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            this.g = graphics2D;
            this.x = 0;
            this.y = 0;
            this.w = n7;
            this.h = n8;
            this.draw();
            graphics2D.dispose();
            imageCache.put(string2, bufferedImage);
            image = bufferedImage;
            this.g = graphics;
            this.x = n;
            this.y = n2;
            this.w = n3;
            this.h = n4;
        }
        this.image = image;
        this.iw = this.image.getWidth(null);
        this.ih = this.image.getHeight(null);
        this.sInsets = SyntheticaLookAndFeel.getInstance().scaleInsets(insets3);
        this.dInsets = SyntheticaLookAndFeel.getInstance().scaleInsets(insets4);
    }

    public ImagePainter(Image image, Graphics graphics, int n, int n2, int n3, int n4, Insets insets, Insets insets2) {
        this(image, graphics, n, n2, n3, n4, insets, insets2, true);
    }

    public ImagePainter(Image image, Graphics graphics, int n, int n2, int n3, int n4, Insets insets, Insets insets2, boolean bl) {
        this.image = this.toCompatibleImage(image, bl, false);
        this.iw = this.image.getWidth(null);
        this.ih = this.image.getHeight(null);
        this.g = graphics;
        this.x = n;
        this.y = n2;
        this.w = n3;
        this.h = n4;
        this.sInsets = bl ? SyntheticaLookAndFeel.getInstance().scaleInsets(insets) : insets;
        this.dInsets = bl ? SyntheticaLookAndFeel.getInstance().scaleInsets(insets2) : insets2;
    }

    private boolean isHiDpiImage(String string) {
        return string.contains("@");
    }

    public static void clearImageCache() {
        imageCache.clear();
    }

    public void setAngle(int n) {
        this.angle = n;
        if (this.animationThread != null && this.weakComponent != null && !(this.weakComponent.get() instanceof JTabbedPane) && n != 0) {
            this.animationThread.rotateRepaintRect((JComponent)this.weakComponent.get(), this.id);
        }
    }

    public void draw() {
        this.drawBorder();
        this.drawCenter();
    }

    public void drawBorder() {
        this.drawTopLeft();
        this.drawTopCenter();
        this.drawTopRight();
        this.drawLeft();
        this.drawRight();
        this.drawBottomLeft();
        this.drawBottomCenter();
        this.drawBottomRight();
    }

    public void drawCenter() {
        if (this.animationEnabled && this.weakComponent != null && this.animationThread != null) {
            this.image = imageCache.get(this.animationThread.getImagePath((JComponent)this.weakComponent.get(), this.id));
        }
        if (this.dInsets == null || this.sInsets == null) {
            return;
        }
        this.drawImage(this.image, this.g, this.x + this.dInsets.left, this.y + this.dInsets.top, this.x + this.w - this.dInsets.right, this.y + this.h - this.dInsets.bottom, this.sInsets.left, this.sInsets.top, this.iw - this.sInsets.right, this.ih - this.sInsets.bottom, this.xPolicy, this.yPolicy);
    }

    public void drawTopLeft() {
        if (this.animationEnabled && this.weakComponent != null && this.animationThread != null) {
            this.image = imageCache.get(this.animationThread.getImagePath((JComponent)this.weakComponent.get(), this.id));
        }
        this.drawImage(this.image, this.g, this.x, this.y, this.x + this.dInsets.left, Math.min(this.y + this.h - this.dInsets.bottom, this.y + this.dInsets.top), 0, 0, this.sInsets.left, Math.min(this.h - this.sInsets.bottom, this.sInsets.top), 0, 0);
    }

    public void drawTopRight() {
        if (this.animationEnabled && this.weakComponent != null && this.animationThread != null) {
            this.image = imageCache.get(this.animationThread.getImagePath((JComponent)this.weakComponent.get(), this.id));
        }
        this.drawImage(this.image, this.g, this.x + this.w - this.dInsets.right, this.y, this.x + this.w, Math.min(this.y + this.h - this.dInsets.bottom, this.y + this.dInsets.top), this.iw - this.sInsets.right, 0, this.iw, Math.min(this.h - this.sInsets.bottom, this.sInsets.top), 0, 0);
    }

    public void drawBottomLeft() {
        if (this.animationEnabled && this.weakComponent != null && this.animationThread != null) {
            this.image = imageCache.get(this.animationThread.getImagePath((JComponent)this.weakComponent.get(), this.id));
        }
        this.drawImage(this.image, this.g, this.x, this.y + this.h - this.dInsets.bottom, this.x + this.dInsets.left, this.y + this.h, 0, this.ih - this.sInsets.bottom, this.sInsets.left, this.ih, 0, 0);
    }

    public void drawBottomRight() {
        if (this.animationEnabled && this.weakComponent != null && this.animationThread != null) {
            this.image = imageCache.get(this.animationThread.getImagePath((JComponent)this.weakComponent.get(), this.id));
        }
        this.drawImage(this.image, this.g, this.x + this.w - this.dInsets.right, this.y + this.h - this.dInsets.bottom, this.x + this.w, this.y + this.h, this.iw - this.sInsets.right, this.ih - this.sInsets.bottom, this.iw, this.ih, 0, 0);
    }

    public void drawTopCenter() {
        if (this.animationEnabled && this.weakComponent != null && this.animationThread != null) {
            this.image = imageCache.get(this.animationThread.getImagePath((JComponent)this.weakComponent.get(), this.id));
        }
        this.drawImage(this.image, this.g, this.x + this.dInsets.left, this.y, this.x + this.w - this.dInsets.right, Math.min(this.y + this.h - this.dInsets.bottom, this.y + this.dInsets.top), this.sInsets.left, 0, this.iw - this.sInsets.right, Math.min(this.h - this.sInsets.bottom, this.sInsets.top), this.xPolicy, this.yPolicy);
    }

    public void drawLeft() {
        if (this.animationEnabled && this.weakComponent != null && this.animationThread != null) {
            this.image = imageCache.get(this.animationThread.getImagePath((JComponent)this.weakComponent.get(), this.id));
        }
        this.drawImage(this.image, this.g, this.x, this.y + this.dInsets.top, this.x + this.dInsets.left, this.y + this.h - this.dInsets.bottom, 0, this.sInsets.top, this.sInsets.left, this.ih - this.sInsets.bottom, this.xPolicy, this.yPolicy);
    }

    public void drawRight() {
        if (this.animationEnabled && this.weakComponent != null && this.animationThread != null) {
            this.image = imageCache.get(this.animationThread.getImagePath((JComponent)this.weakComponent.get(), this.id));
        }
        this.drawImage(this.image, this.g, this.x + this.w - this.dInsets.right, this.y + this.dInsets.top, this.x + this.w, this.y + this.h - this.dInsets.bottom, this.iw - this.sInsets.right, this.sInsets.top, this.iw, this.ih - this.sInsets.bottom, this.xPolicy, this.yPolicy);
    }

    public void drawBottomCenter() {
        if (this.animationEnabled && this.weakComponent != null && this.animationThread != null) {
            this.image = imageCache.get(this.animationThread.getImagePath((JComponent)this.weakComponent.get(), this.id));
        }
        this.drawImage(this.image, this.g, this.x + this.dInsets.left, this.y + this.h - this.dInsets.bottom, this.x + this.w - this.dInsets.right, this.y + this.h, this.sInsets.left, this.ih - this.sInsets.bottom, this.iw - this.sInsets.right, this.ih, this.xPolicy, this.yPolicy);
    }

    /*
     * Unable to fully structure code
     */
    private void drawImage(Image var1_1, Graphics var2_2, int var3_3, int var4_4, int var5_5, int var6_6, int var7_7, int var8_8, int var9_9, int var10_10, int var11_11, int var12_12) throws IllegalArgumentException {
        block22: {
            block21: {
                if (var1_1 == null) {
                    return;
                }
                if (this.angle != 0) {
                    this.rotateGraphics(var2_2, true);
                }
                if (this.flipHorizontal) {
                    var1_1 = Synthetica2DUtils.flipHorizontal(var1_1);
                }
                if (this.flipVertical) {
                    var1_1 = Synthetica2DUtils.flipVertical(var1_1);
                }
                if (this.weakComponent != null) {
                    var13_13 = (JComponent)this.weakComponent.get();
                    var14_15 = ImagePainter.RESPECT_PARENT_BACKGROUND != false ? var13_13.getBackground() : (var13_13.isBackgroundSet() != false ? var13_13.getBackground() : null);
                    var15_16 = (float)SyntheticaLookAndFeel.getInt("Synthetica.background.alpha", (Component)var13_13, 10) / 100.0f;
                    if (var13_13.getClientProperty("Synthetica.background") != null || var14_15 != null && !(var14_15 instanceof ColorUIResource) && !(var14_15 instanceof SystemColor)) {
                        if (!(var1_1 instanceof BufferedImage)) {
                            var16_19 = new BufferedImage(var1_1.getWidth(null), var1_1.getHeight(null), 2);
                            var16_19.getGraphics().drawImage(var1_1, 0, 0, null);
                            var1_1 = var16_19;
                        }
                        var14_15 = SyntheticaLookAndFeel.getClientProperty("Synthetica.background", var13_13, var14_15);
                        var15_16 = SyntheticaLookAndFeel.getClientProperty("Synthetica.background.alpha", var13_13, Float.valueOf(var15_16)).floatValue();
                        v0 = var16_20 = var14_15 == null ? 255 : var14_15.getAlpha();
                        if (var16_20 < 255) {
                            var15_16 = 0.99999f;
                        }
                        var17_21 = SyntheticaLookAndFeel.getString("Synthetica.background.blendMode", var13_13);
                        if ((var17_21 = SyntheticaLookAndFeel.getClientProperty("Synthetica.background.blendMode", var13_13, var17_21)) == null || var17_21.isEmpty()) {
                            if (var15_16 == 1.0f) {
                                var17_21 = SyntheticaLookAndFeel.getString("Synthetica.background.defaultBlendMode", var13_13, Synthetica2DUtils.BlendMode.MULTIPLY.toString());
                                var1_1 = Synthetica2DUtils.createColorizedImage((BufferedImage)var1_1, var14_15, var17_21);
                            } else {
                                var1_1 = Synthetica2DUtils.createColorizedImage((BufferedImage)var1_1, var14_15, var15_16);
                            }
                        } else if (Synthetica2DUtils.BlendMode.ALPHA.toString().equals(var17_21)) {
                            var1_1 = Synthetica2DUtils.createColorizedImage((BufferedImage)var1_1, var14_15, var15_16);
                        } else if (Synthetica2DUtils.BlendMode.valueOf(var17_21) != null) {
                            var1_1 = Synthetica2DUtils.createColorizedImage((BufferedImage)var1_1, var14_15, var17_21);
                        }
                    }
                }
                var13_14 = System.currentTimeMillis();
                if (var11_11 != 0 || var12_12 != 0) break block21;
                var2_2.drawImage(var1_1, var3_3, var4_4, var5_5, var6_6, var7_7, var8_8, var9_9, var10_10, null);
                break block22;
            }
            var15_17 = var3_3;
            var16_20 = var9_9 - var7_7;
            var17_22 = var10_10 - var8_8;
            ** GOTO lbl64
            {
                var18_24 = var5_5;
                if (var11_11 == 1) {
                    var18_24 = Math.min(var5_5, var3_3 + var16_20);
                }
                var19_25 = var6_6;
                if (var12_12 == 1) {
                    var19_25 = Math.min(var6_6, var4_4 + var17_22);
                }
                var20_26 = var11_11 == 1 ? Math.min(var9_9, var7_7 + (var18_24 - var3_3)) : var9_9;
                var21_27 = var12_12 == 1 ? Math.min(var10_10, var8_8 + (var19_25 - var4_4)) : var10_10;
                var2_2.drawImage(var1_1, var3_3, var4_4, var18_24, var19_25, var7_7, var8_8, var20_26, var21_27, null);
                if (var11_11 == 0) ** GOTO lbl61
                var3_3 += var16_20;
                do {
                    if (var3_3 < var5_5) continue block0;
lbl61:
                    // 2 sources

                    if (var12_12 == 0) break block0;
                    var3_3 = var15_17;
                    var4_4 += var17_22;
lbl64:
                    // 2 sources

                } while (var4_4 < var6_6);
            }
        }
        if (this.angle != 0) {
            this.rotateGraphics(var2_2, false);
        }
        var15_18 = System.currentTimeMillis();
        var17_23 = var15_18 - var13_14;
        if (ImagePainter.debug && var17_23 > 100L) {
            System.out.println("Paint performance lack: " + var17_23 + " ms " + this.findImage(var1_1));
        }
        ImagePainter.paintDuration += var17_23;
        ++ImagePainter.paintOperations;
    }

    private void rotateGraphics(Graphics graphics, boolean bl) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (bl) {
            graphics2D.translate(this.angle > 0 ? this.h : 0, this.angle > 0 ? 0 : this.w);
            graphics2D.rotate(Math.toRadians(this.angle), this.x, this.y);
        } else {
            graphics2D.rotate(Math.toRadians(-this.angle), this.x, this.y);
            graphics2D.translate(this.angle > 0 ? -this.h : 0, this.angle > 0 ? 0 : -this.w);
        }
    }

    private String findImage(Image image) {
        String string = null;
        Set<Map.Entry<String, Image>> set = imageCache.entrySet();
        for (Map.Entry<String, Image> entry : set) {
            if (entry.getValue() != image) continue;
            string = entry.getKey();
            break;
        }
        return string;
    }

    private BufferedImage toCompatibleImage(Image image, boolean bl, boolean bl2) {
        boolean bl3;
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice graphicsDevice = graphicsEnvironment.getDefaultScreenDevice();
        GraphicsConfiguration graphicsConfiguration = graphicsDevice.getDefaultConfiguration();
        int n = image.getWidth(null);
        int n2 = image.getHeight(null);
        if (bl) {
            SyntheticaLookAndFeel syntheticaLookAndFeel = SyntheticaLookAndFeel.getInstance();
            n = !bl2 ? syntheticaLookAndFeel.scaleInteger(n) : syntheticaLookAndFeel.scaleInteger(n * 100) / syntheticaLookAndFeel.getHiDpiImageScaleFactor();
            n2 = !bl2 ? syntheticaLookAndFeel.scaleInteger(n2) : syntheticaLookAndFeel.scaleInteger(n2 * 100) / syntheticaLookAndFeel.getHiDpiImageScaleFactor();
        }
        boolean bl4 = bl3 = SyntheticaLookAndFeel.getInstance().getScaleFactor() != 1.0f;
        if (bl && bl3) {
            image = HiDpi.scaleImage(image, n, n2);
        }
        BufferedImage bufferedImage = graphicsConfiguration.createCompatibleImage(n, n2, 3);
        Graphics graphics = bufferedImage.getGraphics();
        graphics.drawImage(image, 0, 0, n, n2, null);
        graphics.dispose();
        return bufferedImage;
    }

    private static class Colorizer
    extends RGBImageFilter {
        private int a;
        private int r;
        private int g;
        private int b;
        private int w;
        private int h;
        private Insets insets;

        public Colorizer(int n, int n2, int n3, int n4, int n5, int n6, Insets insets) {
            this.canFilterIndexColorModel = true;
            this.a = n;
            this.r = n2;
            this.g = n3;
            this.b = n4;
            this.w = n5;
            this.h = n6;
            this.insets = insets;
        }

        @Override
        public int filterRGB(int n, int n2, int n3) {
            if (n < this.insets.left || n > this.w - this.insets.right - 1 || n2 < this.insets.top || n2 > this.h - this.insets.bottom - 1) {
                return n3;
            }
            Color color = new Color(n3, true);
            int n4 = Math.min(Math.max(color.getRed() + color.getRed() * this.r / 100, 0), 255);
            int n5 = Math.min(Math.max(color.getGreen() + color.getGreen() * this.g / 100, 0), 255);
            int n6 = Math.min(Math.max(color.getBlue() + color.getBlue() * this.b / 100, 0), 255);
            int n7 = Math.min(Math.max(color.getAlpha() + color.getAlpha() * this.a / 100, 0), 255);
            return new Color(n4, n5, n6, n7).getRGB();
        }
    }
}

