/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.plaf.synthetica.painter;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.SyntheticaState;
import de.javasoft.plaf.synthetica.painter.ImagePainter;
import de.javasoft.plaf.synthetica.painter.SyntheticaComponentPainter;
import de.javasoft.plaf.synthetica.painter.SyntheticaPainterState;
import de.javasoft.plaf.synthetica.painter.UIKey;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.util.HashMap;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JProgressBar;
import javax.swing.plaf.synth.SynthContext;

public class ProgressBarPainter
extends SyntheticaComponentPainter {
    public static final String UI_KEY = "Synthetica.ProgressBarPainter";
    private static HashMap<String, Image> imgCache = new HashMap();

    protected ProgressBarPainter() {
    }

    public static ProgressBarPainter getInstance() {
        return ProgressBarPainter.getInstance(null);
    }

    public static ProgressBarPainter getInstance(SynthContext synthContext) {
        SyntheticaComponentPainter syntheticaComponentPainter = (SyntheticaComponentPainter)instances.get(ProgressBarPainter.getPainterClassName(synthContext, ProgressBarPainter.class, UI_KEY));
        if (syntheticaComponentPainter == null) {
            syntheticaComponentPainter = ProgressBarPainter.getInstance(synthContext, ProgressBarPainter.class, UI_KEY);
        }
        return (ProgressBarPainter)syntheticaComponentPainter;
    }

    public void paintProgressBarBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
    }

    public void paintProgressBarBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        this.paintProgressBarBackground(synthContext, graphics, n, n2, n3, n4, false);
    }

    protected void paintProgressBarBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4, boolean bl) {
        Insets insets;
        JProgressBar jProgressBar = (JProgressBar)synthContext.getComponent();
        Insets insets2 = synthContext.getStyle().getInsets(synthContext, null);
        Insets insets3 = jProgressBar.getInsets();
        n3 -= insets3.left + insets3.right - insets2.left - insets2.right;
        n4 -= insets3.top + insets3.bottom - insets2.top - insets2.bottom;
        n += insets3.left - insets2.left;
        n2 += insets3.top - insets2.top;
        int n5 = jProgressBar.getValue() > 0 || jProgressBar.isIndeterminate() ? SyntheticaState.State.ACTIVE.toInt() : 0;
        SyntheticaPainterState syntheticaPainterState = new SyntheticaPainterState(synthContext, n5, false);
        UIKey uIKey = new UIKey("progressBar.x.background", syntheticaPainterState);
        if (jProgressBar.getOrientation() == 1) {
            uIKey = new UIKey("progressBar.y.background", syntheticaPainterState);
        }
        Insets insets4 = insets = (Insets)uIKey.findProperty(synthContext, "insets", 2);
        String string = uIKey.resolveImagePath(synthContext, 1);
        uIKey = new UIKey("progressBar.background", syntheticaPainterState);
        if (string != null) {
            int n6 = SyntheticaLookAndFeel.getInt(uIKey.get("animation.cycles"), (Component)jProgressBar, 1);
            int n7 = SyntheticaLookAndFeel.getInt(uIKey.get("animation.delay"), (Component)jProgressBar, 50);
            int n8 = SyntheticaLookAndFeel.getInt(uIKey.get("animation.type"), (Component)jProgressBar, 6);
            if (syntheticaPainterState.isSet(SyntheticaState.State.ACTIVE)) {
                n8 = SyntheticaLookAndFeel.getInt(uIKey.get("animation.type"), (Component)jProgressBar, 5);
            }
            ImagePainter imagePainter = new ImagePainter((JComponent)jProgressBar, n6, n7, n8, syntheticaPainterState.getState(), graphics, n, n2, n3, n4, string, insets, insets4, 0, 0);
            if (bl) {
                imagePainter.drawBorder();
            } else if (this.isBorderPainted(jProgressBar)) {
                imagePainter.draw();
            } else {
                imagePainter.drawCenter();
            }
        }
    }

    public void paintProgressBarForeground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        int n6;
        int n7;
        int n8;
        Insets insets;
        Graphics2D graphics2D = (Graphics2D)graphics;
        JProgressBar jProgressBar = (JProgressBar)synthContext.getComponent();
        jProgressBar.putClientProperty("Synthetica.progressBar.textFillStart", n5 == 0 ? n : n2);
        jProgressBar.putClientProperty("Synthetica.progressBar.textFillAmount", n5 == 0 ? n3 : n4);
        SyntheticaPainterState syntheticaPainterState = new SyntheticaPainterState(synthContext);
        UIKey uIKey = new UIKey(jProgressBar.isIndeterminate() ? "progressBar.x.indeterminate" : "progressBar.x", syntheticaPainterState);
        if (n5 == 1) {
            uIKey = new UIKey(jProgressBar.isIndeterminate() ? "progressBar.y.indeterminate" : "progressBar.y", syntheticaPainterState);
        }
        if ((insets = (Insets)uIKey.findProperty(synthContext, "insets", 2)) == null) {
            insets = new Insets(0, 0, 0, 0);
        }
        Insets insets2 = insets;
        boolean bl = SyntheticaLookAndFeel.getBoolean("Synthetica.progressBar.respectMinimumBarImageSize", jProgressBar, true);
        if (n5 == 0) {
            int n9 = n8 = bl ? insets.left + insets.right : 1;
            if (n3 < n8) {
                return;
            }
        } else {
            int n10 = n8 = bl ? insets.top + insets.bottom : 1;
            if (n4 < n8) {
                return;
            }
        }
        n8 = n3;
        int n11 = n4;
        int n12 = SyntheticaLookAndFeel.getBoolean("Synthetica.progressBar.tiled", jProgressBar) ? 1 : 0;
        String string = uIKey.resolveImagePath(synthContext, 2);
        if (!SyntheticaLookAndFeel.getBoolean("Synthetica.progressBar.continuous", jProgressBar)) {
            Image image = imgCache.get(string);
            if (image == null) {
                image = new ImageIcon(SyntheticaLookAndFeel.getResource(string)).getImage();
                imgCache.put(string, image);
            }
            n7 = image.getWidth(null) - insets.left - insets.right;
            n6 = image.getHeight(null) - insets.top - insets.bottom;
            n8 = (n3 - insets.left - insets.right) / n7 * n7 + insets.left + insets.right;
            n11 = (n4 - insets.top - insets.bottom) / n6 * n6 + insets.top + insets.bottom;
            n12 = 1;
        }
        int n13 = SyntheticaLookAndFeel.getInt(uIKey.get("animation.cycles"), (Component)jProgressBar, -1);
        n7 = SyntheticaLookAndFeel.getInt(uIKey.get("animation.delay"), (Component)jProgressBar, 70);
        n6 = SyntheticaLookAndFeel.getInt(uIKey.get("animation.type"), (Component)jProgressBar, 0);
        RenderingHints renderingHints = graphics2D.getRenderingHints();
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        ImagePainter imagePainter = null;
        if (n5 == 0) {
            imagePainter = new ImagePainter((JComponent)jProgressBar, n13, n7, n6, syntheticaPainterState.getState(), graphics, n, n2, n8, n4, string, insets, insets2, n12, 0);
            if (this.isBorderPainted(jProgressBar)) {
                imagePainter.draw();
            } else {
                imagePainter.drawCenter();
            }
        } else {
            imagePainter = new ImagePainter((JComponent)jProgressBar, n13, n7, n6, syntheticaPainterState.getState(), graphics, n, n2 - n11 + n4, n3, n11, string, insets, insets2, 0, n12);
            if (this.isBorderPainted(jProgressBar)) {
                imagePainter.draw();
            } else {
                imagePainter.drawCenter();
            }
        }
        graphics2D.setRenderingHints(renderingHints);
    }

    protected boolean isBorderPainted(JProgressBar jProgressBar) {
        return jProgressBar.isBorderPainted() && jProgressBar.getBorder() != null;
    }

    @Override
    public int getCacheHash(SynthContext synthContext, int n, int n2, int n3, String string) {
        if (string.equals("paintProgressBarForeground")) {
            return -1;
        }
        JProgressBar jProgressBar = (JProgressBar)synthContext.getComponent();
        int n4 = jProgressBar.getOrientation();
        int n5 = super.getCacheHash(synthContext, n, n2, n3, string);
        n5 = 31 * n5 + n4;
        return n5;
    }
}

