/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.plaf.synthetica.styles;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.styles.StyleWrapper;
import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Rectangle;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.plaf.basic.BasicTabbedPaneUI;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthStyle;

public class TabbedPaneStyle
extends StyleWrapper {
    private static TabbedPaneStyle instance = new TabbedPaneStyle();

    private TabbedPaneStyle() {
    }

    public static SynthStyle getStyle(SynthStyle synthStyle, JComponent jComponent, Region region) {
        if (SyntheticaLookAndFeel.getJVMCompatibilityMode() == SyntheticaLookAndFeel.JVMCompatibilityMode.SUN) {
            TabbedPaneStyle.installTabLayoutManager((JTabbedPane)jComponent);
        }
        if (SyntheticaLookAndFeel.getStyleName(jComponent) == null) {
            instance.setStyle(synthStyle);
            return instance;
        }
        TabbedPaneStyle tabbedPaneStyle = new TabbedPaneStyle();
        tabbedPaneStyle.setStyle(synthStyle);
        return tabbedPaneStyle;
    }

    @Override
    public Font getFont(SynthContext synthContext) {
        if (SyntheticaLookAndFeel.getBoolean("Synthetica.tabbedPane.tab.selected.bold", synthContext.getComponent())) {
            return super.getFont(synthContext).deriveFont(1);
        }
        return super.getFont(synthContext);
    }

    private static void installTabLayoutManager(JTabbedPane jTabbedPane) {
        if (jTabbedPane.getLayout().getClass().getName().contains(TabbedPaneStyle.class.getName())) {
            return;
        }
        if (!SyntheticaLookAndFeel.getBoolean("Synthetica.tabbedPane.tabs.stretch", jTabbedPane) && (SyntheticaLookAndFeel.get("Synthetica.tabbedPane.rotateTabRuns", jTabbedPane) == null || SyntheticaLookAndFeel.getBoolean("Synthetica.tabbedPane.rotateTabRuns", jTabbedPane))) {
            return;
        }
        if (jTabbedPane.getTabLayoutPolicy() == 1) {
            TabbedPaneStyle.installScrollLayout(jTabbedPane);
        } else {
            TabbedPaneStyle.installWrapLayout(jTabbedPane);
        }
    }

    private static void installWrapLayout(final JTabbedPane jTabbedPane) {
        BasicTabbedPaneUI basicTabbedPaneUI;
        BasicTabbedPaneUI basicTabbedPaneUI2 = basicTabbedPaneUI = (BasicTabbedPaneUI)jTabbedPane.getUI();
        basicTabbedPaneUI2.getClass();
        jTabbedPane.setLayout(new BasicTabbedPaneUI.TabbedPaneLayout(basicTabbedPaneUI2){

            @Override
            protected void calculateTabRects(int n, int n2) {
                super.calculateTabRects(n, n2);
                if (SyntheticaLookAndFeel.getBoolean("Synthetica.tabbedPane.tabs.stretch", jTabbedPane) && n2 > 0) {
                    Object object;
                    Serializable serializable;
                    Rectangle[] rectangleArray = null;
                    try {
                        serializable = Class.forName("javax.swing.plaf.basic.BasicTabbedPaneUI");
                        object = serializable.getDeclaredField("rects");
                        ((Field)object).setAccessible(true);
                        rectangleArray = (Rectangle[])((Field)object).get(basicTabbedPaneUI);
                    }
                    catch (Exception exception) {
                        throw new RuntimeException(exception);
                    }
                    serializable = jTabbedPane.getInsets();
                    object = new Insets(0, 0, 0, 0);
                    try {
                        Class<?> clazz = Class.forName("javax.swing.plaf.basic.BasicTabbedPaneUI");
                        Method method = clazz.getDeclaredMethod("getTabAreaInsets", Integer.TYPE);
                        method.setAccessible(true);
                        object = (Insets)method.invoke((Object)basicTabbedPaneUI, n);
                    }
                    catch (Exception exception) {
                        throw new RuntimeException(exception);
                    }
                    int n3 = jTabbedPane.getWidth() - (((Insets)serializable).right + ((Insets)object).right + ((Insets)serializable).left + ((Insets)object).left);
                    int n4 = SyntheticaLookAndFeel.getInt("Synthetica.tabbedPane.tabs.maxStretchFactor", (Component)jTabbedPane, 3);
                    int n5 = 0;
                    int n6 = n2 - 1;
                    Rectangle rectangle = rectangleArray[n6];
                    int n7 = rectangle.x + rectangle.width - rectangleArray[n5].x;
                    if (n7 >= n3 || n7 < 1) {
                        return;
                    }
                    boolean bl = n3 / n7 > n4;
                    jTabbedPane.putClientProperty("Synthetica.maxStretchExceeded", bl);
                    int n8 = SyntheticaLookAndFeel.getInt("Synthetica.tabbedPane.tabs.centeredTabsFactor", (Component)jTabbedPane, n4);
                    int n9 = bl ? n7 * n8 : n3;
                    int n10 = n9 - (rectangle.x + rectangle.width) + ((Insets)serializable).left + ((Insets)object).left;
                    int n11 = (n3 - n9) / 2;
                    float f = (float)n10 / (float)n7;
                    int n12 = n5;
                    while (n12 <= n6) {
                        Rectangle rectangle2 = rectangleArray[n12];
                        rectangle2.x = n12 == n5 ? (rectangle2.x += n11) : rectangleArray[n12 - 1].x + rectangleArray[n12 - 1].width;
                        rectangle2.width += Math.round((float)rectangle2.width * f);
                        ++n12;
                    }
                }
            }

            @Override
            protected void rotateTabRuns(int n, int n2) {
                if (SyntheticaLookAndFeel.get("Synthetica.tabbedPane.rotateTabRuns", jTabbedPane) == null || SyntheticaLookAndFeel.getBoolean("Synthetica.tabbedPane.rotateTabRuns", jTabbedPane)) {
                    super.rotateTabRuns(n, n2);
                }
            }
        });
    }

    private static void installScrollLayout(JTabbedPane jTabbedPane) {
    }
}

