/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.plaf.synthetica.util;

import de.javasoft.plaf.synthetica.util.Synthetica2DUtils;
import java.awt.Composite;
import java.awt.CompositeContext;
import java.awt.RenderingHints;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;

public class LuminosityComposite
implements Composite,
CompositeContext {
    public static final LuminosityComposite Luminosity = new LuminosityComposite();

    @Override
    public void compose(Raster raster, Raster raster2, WritableRaster writableRaster) {
        int n = Math.min(raster.getWidth(), raster2.getWidth());
        int n2 = Math.min(raster.getHeight(), raster2.getHeight());
        int[] nArray = new int[n];
        int[] nArray2 = new int[n];
        int n3 = 0;
        while (n3 < n2) {
            raster.getDataElements(0, n3, n, 1, nArray);
            raster2.getDataElements(0, n3, n, 1, nArray2);
            int n4 = 0;
            while (n4 < n) {
                nArray2[n4] = LuminosityComposite.luminostyRGB(nArray2[n4], nArray[n4]);
                ++n4;
            }
            writableRaster.setDataElements(0, n3, n, 1, nArray2);
            ++n3;
        }
    }

    static int luminostyRGB(int n, int n2) {
        int n3 = n & 0xFF;
        int n4 = n2 & 0xFF;
        int n5 = n >> 8 & 0xFF;
        int n6 = n2 >> 8 & 0xFF;
        int n7 = n >> 16 & 0xFF;
        int n8 = n2 >> 16 & 0xFF;
        int n9 = n >> 24 & 0xFF;
        int n10 = n2 >> 24 & 0xFF;
        float[] fArray = Synthetica2DUtils.RGBtoHSL(n7, n5, n3);
        float[] fArray2 = Synthetica2DUtils.RGBtoHSL(n8, n6, n4);
        int[] nArray = Synthetica2DUtils.HSLtoRGB(fArray2[0], fArray2[1], fArray[2]);
        int n11 = Math.min(255, n10 + n9 - n10 * n9 / 255);
        return nArray[2] | nArray[1] << 8 | nArray[0] << 16 | n11 << 24;
    }

    @Override
    public CompositeContext createContext(ColorModel colorModel, ColorModel colorModel2, RenderingHints renderingHints) {
        return this;
    }

    @Override
    public void dispose() {
    }
}

