/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.plaf.synthetica.util;

import java.awt.Composite;
import java.awt.CompositeContext;
import java.awt.RenderingHints;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;

public class SoftLightComposite
implements Composite,
CompositeContext {
    public static final SoftLightComposite SoftLight = new SoftLightComposite();

    @Override
    public void compose(Raster raster, Raster raster2, WritableRaster writableRaster) {
        int n = Math.min(raster.getWidth(), raster2.getWidth());
        int n2 = Math.min(raster.getHeight(), raster2.getHeight());
        int[] nArray = new int[n];
        int[] nArray2 = new int[n];
        int n3 = 0;
        while (n3 < n2) {
            raster.getDataElements(0, n3, n, 1, nArray);
            raster2.getDataElements(0, n3, n, 1, nArray2);
            int n4 = 0;
            while (n4 < n) {
                nArray2[n4] = SoftLightComposite.softLightRGB(nArray[n4], nArray2[n4]);
                ++n4;
            }
            writableRaster.setDataElements(0, n3, n, 1, nArray2);
            ++n3;
        }
    }

    static int softLightRGB(int n, int n2) {
        int n3 = n & 0xFF;
        int n4 = n2 & 0xFF;
        int n5 = n3 * n4 / 255;
        int n6 = n5 + n3 * (255 - (255 - n3) * (255 - n4) / 255 - n5) / 255;
        int n7 = n >> 8 & 0xFF;
        int n8 = n2 >> 8 & 0xFF;
        int n9 = n7 * n8 / 255;
        int n10 = n9 + n7 * (255 - (255 - n7) * (255 - n8) / 255 - n9) / 255;
        int n11 = n >> 16 & 0xFF;
        int n12 = n2 >> 16 & 0xFF;
        int n13 = n11 * n12 / 255;
        int n14 = n13 + n11 * (255 - (255 - n11) * (255 - n12) / 255 - n13) / 255;
        int n15 = n >> 24 & 0xFF;
        int n16 = n2 >> 24 & 0xFF;
        int n17 = Math.min(255, n15 + n16 - n15 * n16 / 255);
        return n6 | n10 << 8 | n14 << 16 | n17 << 24;
    }

    @Override
    public CompositeContext createContext(ColorModel colorModel, ColorModel colorModel2, RenderingHints renderingHints) {
        return this;
    }

    @Override
    public void dispose() {
    }
}

