/*
 * Decompiled with CFR 0.152.
 */
package icu.jnet.whatsjava.encryption;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import icu.jnet.whatsjava.constants.BinaryConstants;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Set;

public class BinaryEncoder {
    private List<Byte> data;

    public byte[] encode(String buffer) {
        this.data = new ArrayList<Byte>();
        this.writeNode(buffer);
        byte[] dataArray = new byte[this.data.size()];
        for (int i = 0; i < this.data.size(); ++i) {
            dataArray[i] = this.data.get(i);
        }
        return dataArray;
    }

    private void writeNode(String node) {
        if (node == null || node.equals("")) {
            return;
        }
        JsonArray jsonNodeArray = JsonParser.parseString(node).getAsJsonArray();
        if (jsonNodeArray.size() != 3) {
            System.err.println("Invalid node: " + node);
        } else {
            JsonObject jsonAttributes = null;
            Set<String> validAttributes = null;
            int jsonAttributesNum = 0;
            JsonElement children = null;
            if (!jsonNodeArray.get(2).isJsonNull()) {
                if (jsonNodeArray.get(2).isJsonArray()) {
                    children = jsonNodeArray.get(2).getAsJsonArray();
                } else if (jsonNodeArray.get(2).isJsonObject()) {
                    children = jsonNodeArray.get(2).getAsJsonObject();
                }
            }
            if (!jsonNodeArray.get(1).isJsonNull()) {
                jsonAttributes = jsonNodeArray.get(1).getAsJsonObject();
                validAttributes = jsonAttributes.keySet();
                jsonAttributesNum = jsonAttributes.size();
            }
            this.writeListStart(2 * jsonAttributesNum + 1 + (children != null ? 1 : 0));
            this.writeString(jsonNodeArray.get(0).getAsString(), false);
            if (!jsonNodeArray.get(1).isJsonNull()) {
                this.writeAttributes(jsonAttributes, validAttributes);
            }
            this.writeChildren(children);
        }
    }

    private void writeChildren(Object children) {
        if (children == null) {
            return;
        }
        if (children instanceof String) {
            this.writeString((String)children, true);
        } else if (children instanceof JsonArray) {
            this.writeListStart(((JsonArray)children).size());
            for (JsonElement element : (JsonArray)children) {
                String node = element.toString();
                if (node == null) continue;
                this.writeNode(node);
            }
        } else if (children instanceof JsonObject) {
            String base64Message = ((JsonObject)children).get("webmessage").getAsString();
            byte[] message = Base64.getDecoder().decode(base64Message);
            int[] intMessage = new int[message.length];
            for (int i = 0; i < message.length; ++i) {
                intMessage[i] = message[i] & 0xFF;
            }
            this.writeByteLength(intMessage.length);
            this.pushBytes(intMessage);
        }
    }

    private void writeAttributes(JsonObject attrs, Set<String> keys) {
        for (String key : keys) {
            this.writeString(key, false);
            this.writeString(attrs.get(key).isJsonNull() ? null : attrs.get(key).getAsString(), false);
        }
    }

    private void writeByteLength(int length) {
        if ((long)length >= Long.MAX_VALUE) {
            System.err.println("String to large to encode: " + length);
        }
        if (length >= 0x100000) {
            this.pushByte(254);
            this.pushInt(length, 4, false);
        } else if (length >= 256) {
            this.pushByte(253);
            this.pushInt20(length);
        } else {
            this.pushByte(252);
            this.pushByte(length);
        }
    }

    private void writeStringRaw(String str) {
        this.writeByteLength(str.length());
        this.pushString(str);
    }

    private void writeJid(String left, String right) {
        this.pushByte(250);
        if (left != null && left.length() > 0) {
            this.writeString(left, false);
        } else {
            this.writeToken(0);
        }
        this.writeString(right, false);
    }

    private void writeListStart(int listSize) {
        if (listSize == 0) {
            this.pushByte(0);
        } else if (listSize < 256) {
            this.pushBytes(new int[]{248, listSize});
        } else {
            this.pushBytes(new int[]{249, listSize});
        }
    }

    private void writeString(String token, boolean i) {
        if (token != null && token.equals("c.us")) {
            token = "s.whatsapp.net";
        }
        int tokenIndex = 0;
        for (int t = 0; t < BinaryConstants.singleByteTokens.length; ++t) {
            if (BinaryConstants.singleByteTokens[t] == null && token == null) {
                tokenIndex = t;
                break;
            }
            if (BinaryConstants.singleByteTokens[t] == null || !BinaryConstants.singleByteTokens[t].equals(token)) continue;
            tokenIndex = t;
            break;
        }
        if (!i && token != null && token.equals("s.whatsapp.net")) {
            this.writeToken(tokenIndex);
        } else if (tokenIndex > 0) {
            if (tokenIndex < 256) {
                this.writeToken(tokenIndex);
            } else {
                int overflow = tokenIndex - 256;
                int dictionaryIndex = overflow >> 8;
                if (dictionaryIndex < 0 || dictionaryIndex > 3) {
                    System.err.println("Double byte dictionary token out of range: " + token + ", " + tokenIndex);
                }
                this.writeToken(236 + dictionaryIndex);
                this.writeToken(overflow % 256);
            }
        } else if (token != null) {
            int jidSepIndex = token.indexOf(64);
            if (jidSepIndex <= 0) {
                this.writeStringRaw(token);
            } else {
                this.writeJid(token.substring(0, jidSepIndex), token.substring(jidSepIndex + 1, token.length()));
            }
        }
    }

    private void writeToken(int token) {
        if (token < 245) {
            this.pushByte(token);
        } else if (token <= 500) {
            System.err.println("Invalid token");
        }
    }

    private void pushByte(int value) {
        this.data.add((byte)(value & 0xFF));
    }

    private void pushBytes(int[] intArray) {
        for (int i : intArray) {
            this.data.add((byte)i);
        }
    }

    private void pushString(String str) {
        byte[] byteArray = str.getBytes();
        int[] intArray = new int[byteArray.length];
        for (int i = 0; i < byteArray.length; ++i) {
            intArray[i] = byteArray[i] & 0xFF;
        }
        this.pushBytes(intArray);
    }

    private void pushInt(int value, int n, boolean littleEndian) {
        int i = 0;
        while (i < n) {
            int curShift = littleEndian ? i : n - 1 - i;
            this.data.add((byte)(value >> curShift * 8 & 0xFF));
            ++n;
        }
    }

    private void pushInt20(int value) {
        this.pushBytes(new int[]{value >> 16 & 0xF, value >> 8 & 0xFF, value & 0xFF});
    }
}

