/*
 * Decompiled with CFR 0.152.
 */
package icu.jnet.whatsjava.encryption;

import icu.jnet.whatsjava.encryption.AES;
import icu.jnet.whatsjava.encryption.EncryptionKeyPair;
import icu.jnet.whatsjava.helper.Utils;
import java.util.Arrays;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;

public class BinaryEncryption {
    public static byte[] decrypt(byte[] message, EncryptionKeyPair keyPair) throws DecoderException {
        String hexMessage = Hex.encodeHexString(message, true);
        int commaIndex = hexMessage.indexOf("2c");
        if (commaIndex < 1) {
            System.err.println("Invalid binary message");
            return null;
        }
        String strMessageContent = hexMessage.substring(commaIndex + 2, hexMessage.length());
        byte[] messageContent = Hex.decodeHex(strMessageContent);
        byte[] checksum = Arrays.copyOfRange(messageContent, 0, 32);
        messageContent = Arrays.copyOfRange(messageContent, 32, messageContent.length);
        byte[] hmacComputedChecksum = Utils.signHMAC(keyPair.getMacKey(), messageContent);
        if (Arrays.equals(hmacComputedChecksum, checksum)) {
            return AES.decrypt(messageContent, keyPair.getEncKey());
        }
        return null;
    }

    public static byte[] encrypt(byte[] message, EncryptionKeyPair keyPair) {
        return AES.encrypt(message, keyPair.getEncKey());
    }
}

