/*
 * Decompiled with CFR 0.152.
 */
package icu.jnet.whatsjava.encryption;

import icu.jnet.whatsjava.encryption.AES;
import icu.jnet.whatsjava.helper.Utils;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import javax.imageio.ImageIO;

public class MediaEncryption {
    public static String MEDIA_TYPE_IMAGE = "WhatsApp Image Keys";
    public static String MEDIA_TYPE_VIDEO = "WhatsApp Video Keys";
    public static String MEDIA_TYPE_AUDIO = "WhatsApp Audio Keys";
    public static String MEDIA_TYPE_DOCUMENT = "WhatsApp Document Keys";

    public static byte[] decrypt(byte[] mediaKey, String url, String mediaType) {
        byte[] mediaKeyExpanded = Utils.expandUsingHKDF(mediaKey, 112, mediaType.getBytes());
        byte[] iv = Arrays.copyOfRange(mediaKeyExpanded, 0, 16);
        byte[] cipherKey = Arrays.copyOfRange(mediaKeyExpanded, 16, 48);
        byte[] macKey = Arrays.copyOfRange(mediaKeyExpanded, 48, 80);
        byte[] encryptedMedia = Utils.urlToEncryptedMedia(url);
        if (encryptedMedia != null) {
            byte[] message;
            byte[] hmacSign;
            byte[] file = Arrays.copyOfRange(encryptedMedia, 0, encryptedMedia.length - 10);
            byte[] mac = Arrays.copyOfRange(encryptedMedia, encryptedMedia.length - 10, encryptedMedia.length);
            if (Arrays.equals(mac, Arrays.copyOfRange(hmacSign = Utils.signHMAC(macKey, message = ByteBuffer.allocate(iv.length + file.length).put(iv).put(file).array()), 0, 10))) {
                return AES.decrypt(file, cipherKey, iv);
            }
        }
        return null;
    }

    public static BufferedImage convertBytesToImage(byte[] bytes) {
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
            return ImageIO.read(bais);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

