/*
 * Decompiled with CFR 0.152.
 */
package icu.jnet.whatsjava.helper;

import at.favre.lib.crypto.HKDF;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import icu.jnet.whatsjava.encryption.BinaryEncoder;
import icu.jnet.whatsjava.encryption.BinaryEncryption;
import icu.jnet.whatsjava.encryption.EncryptionKeyPair;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.time.Instant;
import java.util.Random;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.io.FileUtils;

public class Utils {
    private static int wsRequestCount = 0;
    public static String WHATSAPP_WEB_VERSION = "[2,2126,11]";
    private static String binaryMessageTag = "";

    public static byte[] randomBytes(int length) {
        Random rand = new Random();
        byte[] clientId = new byte[length];
        rand.nextBytes(clientId);
        return clientId;
    }

    public static JsonObject encodeValidJson(String message, String splitStart) {
        String rawSplitMessage = message.replaceFirst(splitStart, "##").split("##")[1];
        String rawMessage = rawSplitMessage.substring(0, rawSplitMessage.length() - 1);
        return JsonParser.parseString(rawMessage).getAsJsonObject();
    }

    public static JsonObject encodeValidJson(String message) {
        String raw = message.replaceFirst("[,]", "##").split("##")[1];
        return JsonParser.parseString(raw).getAsJsonObject();
    }

    private static String getMessageTag() {
        return Instant.now().getEpochSecond() + ".--" + wsRequestCount++;
    }

    private static String getBinaryMessageTag() {
        if (binaryMessageTag.isEmpty()) {
            binaryMessageTag = String.valueOf(new Random().nextInt(900) + 100);
        }
        return binaryMessageTag + ".--" + wsRequestCount++;
    }

    public static int getMessageCount() {
        return wsRequestCount;
    }

    public static String buildWebSocketJsonRequest(int requestType, String ... content) {
        String messageTag = Utils.getMessageTag();
        String request = "";
        switch (requestType) {
            case 0: {
                request = String.format("[\"admin\", \"init\", " + WHATSAPP_WEB_VERSION + ", [\"Ubuntu\", \"Firefox\", \"Unknown\"], \"%s\", true]", content[0]);
                break;
            }
            case 1: {
                request = String.format("[\"admin\", \"login\", \"%s\", \"%s\", \"%s\", \"takeover\"]", content[0], content[1], content[2]);
                break;
            }
            case 2: {
                request = String.format("[\"admin\", \"challenge\", \"%s\", \"%s\", \"%s\"]", content[0], content[1], content[2]);
                break;
            }
            case 3: {
                request = "[\"admin\",\"Conn\",\"reref\"]";
                break;
            }
            case 4: {
                request = String.format("[\"query\", \"ProfilePicThumb\", \"%s\"]", content[0]);
                break;
            }
            case 6: {
                request = String.format("[\"query\", \"Status\", \"%s\"]", content[0]);
                break;
            }
            case 7: {
                request = String.format("[\"action\", \"presence\", \"subscribe\", \"%s\"]", content[0]);
            }
        }
        return messageTag + "," + request;
    }

    public static byte[] buildWebSocketBinaryRequest(EncryptionKeyPair keyPair, String json, byte ... waTags) {
        String tag = null;
        if (json.contains("extendedTextMessage")) {
            tag = json.split(" id: \"")[1].split("\"")[0] + ",";
        }
        BinaryEncoder encoder = new BinaryEncoder();
        byte[] encoded = encoder.encode(json);
        byte[] encrypted = BinaryEncryption.encrypt(encoded, keyPair);
        byte[] hmacSign = Utils.signHMAC(keyPair.getMacKey(), encrypted);
        byte[] messageTag = tag != null ? tag.getBytes() : (Utils.getBinaryMessageTag() + ",").getBytes();
        return ByteBuffer.allocate(messageTag.length + waTags.length + hmacSign.length + encrypted.length).put(messageTag).put(waTags).put(hmacSign).put(encrypted).array();
    }

    public static byte[] expandUsingHKDF(byte[] key, int expandedLength, byte[] info) {
        byte[] pseudoRandomKey = HKDF.fromHmacSha256().extract(null, key);
        return HKDF.fromHmacSha256().expand(pseudoRandomKey, info, expandedLength);
    }

    public static byte[] signHMAC(byte[] hmacValidationKey, byte[] hmacValidationMessage) {
        try {
            Mac hasher = Mac.getInstance("HmacSHA256");
            hasher.init(new SecretKeySpec(hmacValidationKey, "HmacSHA256"));
            return hasher.doFinal(hmacValidationMessage);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static byte[] urlToEncryptedMedia(String url) {
        try {
            Path path = Files.createTempFile(null, ".enc", new FileAttribute[0]);
            File tmpFile = path.toFile();
            byte[] encryptedMedia = null;
            try {
                FileUtils.copyURLToFile(new URL(url), tmpFile);
                encryptedMedia = Files.readAllBytes(path);
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
            tmpFile.delete();
            return encryptedMedia;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static byte[] urlToUnencryptedMedia(String url) {
        try {
            Path path = Files.createTempFile(null, ".jpg", new FileAttribute[0]);
            File tmpFile = path.toFile();
            byte[] unencryptedMedia = null;
            FileUtils.copyURLToFile(new URL(url), tmpFile);
            unencryptedMedia = Files.readAllBytes(path);
            tmpFile.delete();
            return unencryptedMedia;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void waitMill(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }
}

