/*
 * Decompiled with CFR 0.152.
 */
package icu.jnet.whatsjava.messages.generic;

import icu.jnet.whatsjava.encryption.proto.ProtoBuf;

public class WAConversationMessage {
    private final String text;
    private QuotedTextMessage quotedTextMessage;

    public WAConversationMessage(ProtoBuf.WebMessageInfo message) {
        if (message.getMessage().hasConversation()) {
            this.text = message.getMessage().getConversation();
        } else {
            ProtoBuf.ExtendedTextMessage extendedMessage = message.getMessage().getExtendedTextMessage();
            this.text = extendedMessage.getText();
            if (extendedMessage.hasContextInfo()) {
                ProtoBuf.Message quoted = extendedMessage.getContextInfo().getQuotedMessage();
                String stanzaId = extendedMessage.getContextInfo().getStanzaId();
                String participant = extendedMessage.getContextInfo().getParticipant();
                String quotedMessage = quoted.hasExtendedTextMessage() ? quoted.getExtendedTextMessage().getText() : quoted.getConversation();
                this.quotedTextMessage = new QuotedTextMessage(stanzaId, participant, quotedMessage);
            }
        }
    }

    public String getText() {
        return this.text;
    }

    public boolean hasQuotedTextMessage() {
        return this.quotedTextMessage != null;
    }

    public QuotedTextMessage getQuotedTextMessage() {
        return this.quotedTextMessage;
    }

    public static class QuotedTextMessage {
        private final String stanzaId;
        private final String participant;
        private final String quotedMessage;

        public QuotedTextMessage(String stanzaId, String participant, String quotedMessage) {
            this.stanzaId = stanzaId;
            this.participant = participant;
            this.quotedMessage = quotedMessage;
        }

        public String getStanzaId() {
            return this.stanzaId;
        }

        public String getParticipant() {
            return this.participant;
        }

        public String getText() {
            return this.quotedMessage;
        }
    }
}

