/*
 * Decompiled with CFR 0.152.
 */
package icu.jnet.whatsjava.messages.generic;

import icu.jnet.whatsjava.encryption.MediaEncryption;
import icu.jnet.whatsjava.encryption.proto.ProtoBuf;
import java.awt.image.BufferedImage;

public class WAImageMessage {
    private final String mimetype;
    private final String url;
    private final String caption;
    private final byte[] fileSha256;
    private final byte[] mediaKey;
    private final long fileLength;
    private final int width;
    private final int height;
    private final BufferedImage jpegThumbnail;
    private final BufferedImage jpegFullResolution;

    public WAImageMessage(ProtoBuf.WebMessageInfo message) {
        ProtoBuf.ImageMessage imageMessage = message.getMessage().getImageMessage();
        this.url = imageMessage.getUrl();
        this.mimetype = imageMessage.getMimetype();
        this.fileSha256 = imageMessage.getFileSha256().toByteArray();
        this.fileLength = imageMessage.getFileLength();
        this.height = imageMessage.getHeight();
        this.width = imageMessage.getWidth();
        this.mediaKey = imageMessage.getMediaKey().toByteArray();
        this.caption = imageMessage.getCaption();
        this.jpegThumbnail = MediaEncryption.convertBytesToImage(imageMessage.getJpegThumbnail().toByteArray());
        byte[] decryptedBytes = MediaEncryption.decrypt(this.mediaKey, this.url, MediaEncryption.MEDIA_TYPE_IMAGE);
        this.jpegFullResolution = decryptedBytes != null ? MediaEncryption.convertBytesToImage(decryptedBytes) : this.jpegThumbnail;
    }

    public String getMimetype() {
        return this.mimetype;
    }

    public String getUrl() {
        return this.url;
    }

    public String getCaption() {
        return this.caption;
    }

    public byte[] getFileSha256() {
        return this.fileSha256;
    }

    public byte[] getMediaKey() {
        return this.mediaKey;
    }

    public BufferedImage getJpegThumbnail() {
        return this.jpegThumbnail;
    }

    public BufferedImage getJpegFullResolution() {
        return this.jpegFullResolution;
    }

    public long getFileLength() {
        return this.fileLength;
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }
}

