/*
 * Decompiled with CFR 0.152.
 */
package icu.jnet.whatsjava.whatsapp;

import com.google.gson.JsonObject;
import com.neovisionaries.ws.client.PayloadGenerator;
import com.neovisionaries.ws.client.WebSocket;
import com.neovisionaries.ws.client.WebSocketAdapter;
import com.neovisionaries.ws.client.WebSocketException;
import com.neovisionaries.ws.client.WebSocketFactory;
import icu.jnet.whatsjava.encryption.BinaryDecoder;
import icu.jnet.whatsjava.encryption.BinaryEncryption;
import icu.jnet.whatsjava.encryption.EncryptionKeyPair;
import icu.jnet.whatsjava.helper.AuthCredentials;
import icu.jnet.whatsjava.helper.QRGen;
import icu.jnet.whatsjava.helper.Utils;
import icu.jnet.whatsjava.listener.ClientActionInterface;
import icu.jnet.whatsjava.listener.ClientActionListener;
import icu.jnet.whatsjava.messages.WAMessageParser;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;

public class WABackendConnector
extends WebSocketAdapter
implements PayloadGenerator {
    private final String WHATSAPP_SERVER = "wss://web.whatsapp.com/ws";
    private final String HEADER_ORIGIN = "https://web.whatsapp.com";
    private final String HEADER_USER_AGENT = "User-Agent: Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:78.0) Gecko/20100101 Firefox/78.0";
    private String credentialsPath = "credentials.json";
    private AuthCredentials auth;
    private boolean printQRCode = false;
    protected ClientActionInterface listener = new ClientActionListener();
    protected WebSocket ws;
    private final List<String> textMessageBuffer = new ArrayList<String>();

    public WABackendConnector() {
        this.auth = AuthCredentials.loadAuthCredentials(this.credentialsPath);
    }

    public int openConnection() {
        try {
            this.disconnect();
            this.auth = AuthCredentials.loadAuthCredentials(this.credentialsPath);
            WebSocketFactory factory = new WebSocketFactory();
            this.ws = factory.createSocket("wss://web.whatsapp.com/ws");
            this.ws.addHeader("Origin", "https://web.whatsapp.com");
            this.ws.addHeader("User-Agent", "User-Agent: Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:78.0) Gecko/20100101 Firefox/78.0");
            this.ws.addListener(this);
            this.ws.setPingPayloadGenerator(this);
            this.ws.setPingInterval(15000L);
            this.ws.connect();
            return this.initOrRestoreSession();
        }
        catch (WebSocketException | IOException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public void disconnect() {
        if (this.ws != null && this.ws.isOpen()) {
            this.ws.disconnect();
        }
    }

    public void setCredentialsPath(String credentialsPath) {
        this.credentialsPath = credentialsPath;
    }

    public void setPrintQRCode(boolean enabled) {
        this.printQRCode = enabled;
    }

    public void setVersion(String version) {
        version = version.replaceAll("\\.", ",");
        Utils.WHATSAPP_WEB_VERSION = "[" + version + "]";
    }

    public void addClientActionListener(ClientActionInterface listener) {
        this.listener = listener;
    }

    private int initOrRestoreSession() {
        int loginStatus = 0;
        String clientId = this.auth.getClientId();
        String loginRequest = Utils.buildWebSocketJsonRequest(0, clientId);
        String serverIdMessage = this.sendText(loginRequest, new String[0]);
        if (!this.auth.mayRestore()) {
            for (int i = 0; i < 6; ++i) {
                String sessionInfoMsg;
                String serverId = Utils.encodeValidJson(serverIdMessage).get("ref").getAsString();
                byte[] curvePublicKey = this.auth.getCurveKeyPair().getPublicKey();
                this.listener.onQRCodeScanRequired(QRGen.generateQRCodeImage(clientId, serverId, curvePublicKey));
                if (this.printQRCode) {
                    System.out.println(QRGen.generateQRCodeConsole(clientId, serverId, curvePublicKey));
                }
                if ((sessionInfoMsg = this.waitForTextMessage("Conn")) != null) {
                    JsonObject sessionInfo = Utils.encodeValidJson(sessionInfoMsg, "\"Conn\",");
                    this.auth.setSessionEncryptionInfo(sessionInfo.get("clientToken").getAsString(), sessionInfo.get("serverToken").getAsString(), sessionInfo.get("secret").getAsString());
                    AuthCredentials.saveAuthCredentials(this.auth, this.credentialsPath);
                    loginStatus = 200;
                    break;
                }
                String newServerIdRequest = Utils.buildWebSocketJsonRequest(3, new String[0]);
                serverIdMessage = this.sendText(newServerIdRequest, new String[0]);
            }
        } else {
            String clientToken = this.auth.getClientToken();
            String serverToken = this.auth.getServerToken();
            String restoreRequest = Utils.buildWebSocketJsonRequest(1, clientToken, serverToken, clientId);
            String restoreResponse = this.sendText(restoreRequest, "challenge");
            if (restoreResponse.contains("challenge")) {
                String challenge = Utils.encodeValidJson(restoreResponse, "\"Cmd\",").get("challenge").getAsString();
                byte[] decodedChallenge = Base64.getDecoder().decode(challenge);
                EncryptionKeyPair keyPair = this.auth.getEncryptionKeyPair();
                byte[] signedChallenge = Utils.signHMAC(keyPair.getMacKey(), decodedChallenge);
                String signedChallengeBase64 = Base64.getEncoder().encodeToString(signedChallenge);
                String challengeRequest = Utils.buildWebSocketJsonRequest(2, signedChallengeBase64, serverToken, clientId);
                String challengeResponse = this.sendText(challengeRequest, new String[0]);
                loginStatus = Utils.encodeValidJson(challengeResponse).get("status").getAsInt();
                if (loginStatus != 200) {
                    AuthCredentials.deletePreviousSession(this.credentialsPath);
                    this.disconnect();
                }
            } else {
                loginStatus = Utils.encodeValidJson(restoreResponse).get("status").getAsInt();
            }
        }
        this.listener.onReceiveLoginResponse(loginStatus);
        return loginStatus;
    }

    String sendText(String request, String ... search) {
        String[] searchArray = new String[search.length + 1];
        System.arraycopy(search, 0, searchArray, 0, search.length);
        searchArray[searchArray.length - 1] = request.split(",")[0];
        this.ws.sendText(request);
        return this.waitForTextMessage(searchArray);
    }

    String sendBinary(String json, byte[] waTags, String ... search) {
        byte[] binaryRequest = Utils.buildWebSocketBinaryRequest(this.auth.getEncryptionKeyPair(), json, waTags);
        this.ws.sendBinary(binaryRequest);
        return this.waitForTextMessage(search);
    }

    private String waitForTextMessage(String ... search) {
        this.textMessageBuffer.clear();
        if (search.length > 0) {
            for (int i = 0; i < 200; ++i) {
                for (String s : search) {
                    for (String message : this.textMessageBuffer) {
                        if (!message.contains(s)) continue;
                        return message;
                    }
                }
                Utils.waitMill(100L);
            }
        }
        return null;
    }

    @Override
    public void onTextMessage(WebSocket websocket, String message) throws Exception {
        this.textMessageBuffer.add(message);
    }

    @Override
    public void onBinaryMessage(WebSocket websocket, byte[] binaryMessage) throws Exception {
        byte[] decrypted = BinaryEncryption.decrypt(binaryMessage, this.auth.getEncryptionKeyPair());
        String decoded = new BinaryDecoder().decode(decrypted);
        this.textMessageBuffer.add(decoded);
        WAMessageParser.jsonToObjects(decoded);
    }

    @Override
    public byte[] generate() {
        return "?,,".getBytes();
    }
}

