/*
 * Decompiled with CFR 0.152.
 */
package icu.jnet.whatsjava.whatsapp;

import icu.jnet.whatsjava.constants.Presence;
import icu.jnet.whatsjava.constants.WAMetric;
import icu.jnet.whatsjava.encryption.MediaEncryption;
import icu.jnet.whatsjava.helper.Utils;
import icu.jnet.whatsjava.messages.WAMessageBuilder;
import icu.jnet.whatsjava.messages.WAMessageParser;
import icu.jnet.whatsjava.messages.generic.WAChat;
import icu.jnet.whatsjava.messages.generic.WAContact;
import icu.jnet.whatsjava.messages.generic.WAEmoji;
import icu.jnet.whatsjava.messages.generic.WAMessage;
import icu.jnet.whatsjava.whatsapp.WABackendConnector;
import java.awt.image.BufferedImage;
import java.time.Instant;

public class WAClient
extends WABackendConnector {
    public void sendMessage(String remoteJid, String messageContent) {
        String reformattedRemoteJid = remoteJid.replace("c.us", "s.whatsapp.net");
        String request = WAMessageBuilder.generateJson(reformattedRemoteJid, messageContent, true, Instant.now().getEpochSecond());
        this.sendBinary(request, new byte[]{WAMetric.MESSAGE, -128}, new String[0]);
    }

    public void clearMessage(String remoteJid, String messageId, boolean owner) {
        String reformattedRemoteJid = remoteJid.replace("c.us", "s.whatsapp.net");
        String modTag = String.valueOf(Math.round(Math.random() * 1000000.0));
        String request = String.format("['action', {type: 'set', epoch: '%s'}, [['chat', {jid: '%s', modify_tag: '%s', type: 'clear'}, [['item', {owner: '%s', index: '%s'}, null]]]]]", Utils.getMessageCount(), remoteJid, modTag, owner, messageId);
        this.sendBinary(request, new byte[]{WAMetric.GROUP, -128}, new String[0]);
    }

    public void updatePresence(String presence) {
        String request = String.format("['action', {type: 'set', epoch: '%s'}, [['presence', {type: '%s'}, null]]]", Utils.getMessageCount(), presence);
        this.sendBinary(request, new byte[]{WAMetric.PRESENCE, Presence.getCode(presence)}, new String[0]);
    }

    public WAChat[] loadChats() {
        String request = String.format("['query', {type: 'chat', epoch: '%s'}, null]", Utils.getMessageCount());
        String jsonMessages = this.sendBinary(request, new byte[]{WAMetric.QUERY_CHAT, -128}, "\"type\":\"chat\"");
        WAChat[] waChats = (WAChat[])WAMessageParser.jsonToObjects(jsonMessages);
        this.listener.onWAChat(waChats);
        return waChats;
    }

    public WAContact[] loadContacts() {
        String request = String.format("['query', {type: 'contacts', epoch: '%s'}, null]", Utils.getMessageCount());
        String jsonMessages = this.sendBinary(request, new byte[]{WAMetric.QUERY_CONTACT, -128}, "\"type\":\"contacts\"");
        WAContact[] waContacts = (WAContact[])WAMessageParser.jsonToObjects(jsonMessages);
        this.listener.onWAContact(waContacts);
        return waContacts;
    }

    public WAEmoji[] loadEmojis() {
        String request = String.format("['query', {type: 'emoji', epoch: '%s'}, null]", Utils.getMessageCount());
        String jsonMessage = this.sendBinary(request, new byte[]{WAMetric.QUERY_STATUS, -128}, "\"type\":\"emoji\"");
        WAEmoji[] emojis = (WAEmoji[])WAMessageParser.jsonToObjects(jsonMessage);
        this.listener.onWAEmoji(emojis);
        return emojis;
    }

    public WAMessage[] loadChatHistory(String remoteJid, int messageCount) {
        String request = String.format("['query', {type: 'message', epoch: '%s', jid: '%s', kind: 'before', count: '%s'}, null]", Utils.getMessageCount(), remoteJid, messageCount - 1);
        String jsonMessage = this.sendBinary(request, new byte[]{WAMetric.QUERY_MESSAGES, -128}, "{\"type\":\"message\"}");
        WAMessage[] waMessages = (WAMessage[])WAMessageParser.jsonToObjects(jsonMessage);
        this.listener.onWAMessage(waMessages);
        return waMessages;
    }

    public WAMessage[] loadChatHistory(String remoteJid, int messageCount, String lastMessageId, boolean lastOwner) {
        String request = String.format("['query', {type: 'message', epoch: '%s', jid: '%s', kind: 'before', count: '%s', index: '%s', owner: '%s'}, null]", Utils.getMessageCount(), remoteJid, messageCount, lastMessageId, lastOwner);
        String jsonMessage = this.sendBinary(request, new byte[]{WAMetric.QUERY_MESSAGES, -128}, "{\"type\":\"message\"}");
        WAMessage[] waMessages = (WAMessage[])WAMessageParser.jsonToObjects(jsonMessage);
        this.listener.onWAMessage(waMessages);
        return waMessages;
    }

    public BufferedImage getChatPicture(String remoteJid) {
        String request = Utils.buildWebSocketJsonRequest(4, remoteJid);
        String jsonMessage = this.sendText(request, new String[0]);
        return jsonMessage.contains("eurl") ? MediaEncryption.convertBytesToImage(Utils.urlToUnencryptedMedia(Utils.encodeValidJson(jsonMessage).get("eurl").getAsString())) : null;
    }

    public String getStatus(String remoteJid) {
        String request = Utils.buildWebSocketJsonRequest(6, remoteJid);
        String jsonMessage = this.sendText(request, new String[0]);
        return Utils.encodeValidJson(jsonMessage).get("status").getAsString();
    }

    public String requestPresenceUpdate(String remoteJid) {
        String request = Utils.buildWebSocketJsonRequest(7, remoteJid);
        String jsonMessage = this.sendText(request, new String[0]);
        return jsonMessage.contains("type") ? Utils.encodeValidJson(jsonMessage).get("type").getAsString() : "unavailable";
    }
}

