/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.syntheticaaddons;

import java.awt.Component;
import java.awt.Container;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.JComponent;

public class ButtonBar
extends JComponent {
    private static final long serialVersionUID = -8995510780386573538L;
    public static final String uiClassID = "ButtonBarUI";
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    private static final String POS_KEY = "JButton.segmentPosition";
    private static final String ONLY = "only";
    private static final String FIRST = "first";
    private static final String MIDDLE = "middle";
    private static final String LAST = "last";
    private int orientation = 0;
    private String styleName = null;

    public ButtonBar() {
        this(0);
    }

    public ButtonBar(int n) {
        this.orientation = n;
        if (n == 0) {
            this.setLayout(new ButtonBarLayout(this, 2));
        } else {
            this.setLayout(new ButtonBarLayout(this, 3));
        }
        this.setName("ButtonBar");
    }

    public void setButtonStyleName(String string) {
        this.styleName = string;
    }

    @Override
    public Component add(Component component) {
        return this.addButton((AbstractButton)component);
    }

    public AbstractButton addButton(AbstractButton abstractButton) {
        abstractButton.getMaximumSize();
        Component[] componentArray = this.getComponents();
        int n = componentArray.length;
        String string = null;
        if (n == 0) {
            string = ONLY;
        } else if (n >= 1) {
            string = LAST;
            AbstractButton abstractButton2 = (AbstractButton)componentArray[n - 1];
            if (n == 1) {
                abstractButton2.putClientProperty(POS_KEY, FIRST);
            } else {
                abstractButton2.putClientProperty(POS_KEY, MIDDLE);
            }
        }
        abstractButton.putClientProperty(POS_KEY, string);
        if (this.styleName != null) {
            abstractButton.putClientProperty("Synthetica.style", this.styleName);
        }
        abstractButton.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                JComponent jComponent;
                String string;
                if ("componentOrientation".equals(propertyChangeEvent.getPropertyName()) && ((string = (String)(jComponent = (JComponent)propertyChangeEvent.getSource()).getClientProperty(ButtonBar.POS_KEY)).equals(ButtonBar.FIRST) || string.equals(ButtonBar.LAST))) {
                    jComponent.putClientProperty(ButtonBar.POS_KEY, string.equals(ButtonBar.FIRST) ? ButtonBar.LAST : ButtonBar.FIRST);
                }
            }
        });
        super.add(abstractButton);
        return abstractButton;
    }

    @Override
    public void remove(Component component) {
        this.removeButton((AbstractButton)component);
    }

    public void removeButton(AbstractButton abstractButton) {
        Object object;
        Component[] componentArray = this.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        Component[] componentArray2 = componentArray;
        int n3 = componentArray.length;
        int n4 = 0;
        while (n4 < n3) {
            object = componentArray2[n4];
            if (object == abstractButton) break;
            ++n2;
            ++n4;
        }
        if (n == n2) {
            return;
        }
        object = null;
        AbstractButton abstractButton2 = null;
        if (n == 2) {
            object = ONLY;
            abstractButton2 = n2 == 0 ? (AbstractButton)componentArray[1] : (AbstractButton)componentArray[0];
        } else if (n > 2) {
            if (n2 == 0) {
                object = FIRST;
                abstractButton2 = (AbstractButton)componentArray[n2 + 1];
            } else if (n2 == n - 1) {
                object = LAST;
                abstractButton2 = (AbstractButton)componentArray[n2 - 1];
            }
        }
        if (abstractButton2 != null) {
            abstractButton2.putClientProperty(POS_KEY, object);
        }
        super.remove(abstractButton);
    }

    public int getOrientation() {
        return this.orientation;
    }

    private class ButtonBarLayout
    extends BoxLayout {
        public ButtonBarLayout(Container container, int n) {
            super(container, n);
        }

        @Override
        public void layoutContainer(Container container) {
            Rectangle rectangle;
            Component component;
            super.layoutContainer(container);
            Rectangle rectangle2 = new Rectangle();
            Component[] componentArray = container.getComponents();
            int n = componentArray.length;
            int n2 = 0;
            while (n2 < n) {
                component = componentArray[n2];
                rectangle = component.getBounds();
                rectangle2 = ButtonBar.this.getOrientation() == 0 ? (rectangle.height > rectangle2.height ? rectangle : rectangle2) : (rectangle.width > rectangle2.width ? rectangle : rectangle2);
                ++n2;
            }
            componentArray = container.getComponents();
            n = componentArray.length;
            n2 = 0;
            while (n2 < n) {
                component = componentArray[n2];
                rectangle = component.getBounds();
                if (ButtonBar.this.getOrientation() == 0) {
                    rectangle.y = rectangle2.y;
                    rectangle.height = rectangle2.height;
                } else {
                    rectangle.x = rectangle2.x;
                    rectangle.width = rectangle2.width;
                }
                component.setBounds(rectangle);
                ++n2;
            }
        }
    }
}

