/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.syntheticaaddons;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.painter.SyntheticaBasicIconPainter;
import de.javasoft.syntheticaaddons.SyntheticaAddons;
import de.javasoft.syntheticaaddons.SyntheticaAddonsUtilities;
import de.javasoft.syntheticaaddons.ui.DropDownButtonUI;
import de.javasoft.syntheticaaddons.ui.addons.DropDownButtonAddon;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.GeneralPath;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Method;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.ButtonUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.synth.SynthContext;
import org.jdesktop.swingx.plaf.AbstractComponentAddon;
import org.jdesktop.swingx.plaf.ComponentAddon;
import org.jdesktop.swingx.plaf.LookAndFeelAddons;

public class DropDownButton
extends JButton
implements PopupMenuListener,
PropertyChangeListener {
    private static final long serialVersionUID = 1285169006195587840L;
    public static final String uiClassID = "DropDownButtonUI";
    private static Object HIDE_POPUP_KEY = new JComboBox().getClientProperty("doNotCancelPopup");
    private JButton mainButton;
    private JButton arrowButton;
    protected JPopupMenu popup;
    private int arrowIconSpace;
    private boolean useLargeArrowIcon = false;
    private Icon arrowIcon = null;
    private int horizontalPopupMenuPosition = 2;
    private int verticalPopupMenuPosition = 3;
    private MouseListener mainButtonMouseListener;
    private MouseListener arrowButtonMouseListener;
    private boolean initDone;
    protected static AbstractComponentAddon addon = new DropDownButtonAddon();

    static {
        SyntheticaAddons.contribute((ComponentAddon)addon);
    }

    public DropDownButton(Action action) {
        super(action);
        this.init();
    }

    public DropDownButton(String string) {
        this.getMainButton().setText(string);
        this.init();
    }

    public DropDownButton(Icon icon) {
        this.getMainButton().setIcon(icon);
        this.init();
    }

    public DropDownButton(String string, Icon icon) {
        this.getMainButton().setText(string);
        this.getMainButton().setIcon(icon);
        this.init();
    }

    private void init() {
        this.getArrowButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (DropDownButton.this.getPopupMenu().isVisible()) {
                    DropDownButton.this.popup.setVisible(false);
                } else {
                    int n;
                    if (DropDownButton.this.getMainButton().getModel().isArmed() && DropDownButton.this.getMainButton().getModel().isPressed()) {
                        return;
                    }
                    if (SyntheticaLookAndFeel.isToplevelPopupMenu((JPopupMenu)DropDownButton.this.popup)) {
                        DropDownButton.this.popup.updateUI();
                    }
                    DropDownButton.this.popup.addPopupMenuListener(DropDownButton.this);
                    boolean bl = DropDownButton.this.horizontalPopupMenuPosition == 2;
                    boolean bl2 = !(DropDownButton.this.getComponentOrientation().isLeftToRight() ^ bl);
                    int n2 = n = bl2 ? 0 : DropDownButton.this.getWidth() - DropDownButton.this.popup.getPreferredSize().width;
                    if (DropDownButton.this.horizontalPopupMenuPosition == 0) {
                        n = DropDownButton.this.getWidth() / 2 - DropDownButton.this.popup.getPreferredSize().width / 2;
                    }
                    int n3 = DropDownButton.this.getHeight();
                    if (DropDownButton.this.verticalPopupMenuPosition == 1) {
                        n3 -= DropDownButton.this.getHeight() + DropDownButton.this.popup.getPreferredSize().height;
                    }
                    int n4 = SyntheticaLookAndFeel.getInt((String)"DropDownButton.popup.xOffset", (Component)DropDownButton.this, (int)0, (boolean)true);
                    int n5 = SyntheticaLookAndFeel.getInt((String)"DropDownButton.popup.yOffset", (Component)DropDownButton.this, (int)0, (boolean)true);
                    DropDownButton.this.popup.show(DropDownButton.this, n + (bl2 ? n4 : -n4), n3 + n5);
                }
            }
        });
        this.getArrowButton().putClientProperty("doNotCancelPopup", HIDE_POPUP_KEY);
        this.addPropertyChangeListener(this);
        this.initDone = true;
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    @Override
    public void updateUI() {
        this.setUI((ButtonUI)LookAndFeelAddons.getUI((JComponent)this, DropDownButtonUI.class));
        if (this.initDone) {
            SyntheticaAddonsUtilities.updateChildrenUI(this.getPopupMenu());
        }
    }

    @Override
    public void addActionListener(ActionListener actionListener) {
        this.getMainButton().addActionListener(actionListener);
    }

    @Override
    public void removeActionListener(ActionListener actionListener) {
        this.getMainButton().removeActionListener(actionListener);
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.isPreferredSizeSet()) {
            return super.getPreferredSize();
        }
        Dimension dimension = this.getMainButton().getPreferredSize();
        Dimension dimension2 = this.getArrowButton().getPreferredSize();
        return new Dimension(dimension.width + dimension2.width, Math.max(dimension.height, dimension2.height));
    }

    public JButton getMainButton() {
        if (this.mainButton == null) {
            this.mainButton = new JButton(){
                private static final long serialVersionUID = 1983457115217812336L;

                @Override
                public void updateUI() {
                    this.removeMouseListener(DropDownButton.this.getMainButtonMouseListener());
                    super.updateUI();
                    this.addMouseListener(DropDownButton.this.getMainButtonMouseListener());
                }
            };
            this.mainButton.putClientProperty("JButton.segmentPosition", "first");
        }
        return this.mainButton;
    }

    public JButton getArrowButton() {
        if (this.arrowButton == null) {
            this.arrowButton = new JButton(){
                private static final long serialVersionUID = -1258068774098394796L;

                @Override
                public void updateUI() {
                    this.removeMouseListener(DropDownButton.this.getArrowButtonMouseListener());
                    super.updateUI();
                    this.addMouseListener(DropDownButton.this.getArrowButtonMouseListener());
                    if (DropDownButton.this.arrowButton != null) {
                        DropDownButton.this.updateArrowButton(DropDownButton.this.arrowButton);
                    }
                }
            };
            this.setArrowIconSpace(SyntheticaLookAndFeel.getInt((String)"DropDownButton.arrowIconGap", (Component)this, (int)4, (boolean)true));
            this.installArrowIcon(this.arrowButton);
            this.arrowButton.putClientProperty("JButton.segmentPosition", "last");
        }
        return this.arrowButton;
    }

    public JPopupMenu getPopupMenu() {
        if (this.popup == null) {
            this.popup = this.createPopupMenu();
        }
        return this.popup;
    }

    protected JPopupMenu createPopupMenu() {
        return new JPopupMenu();
    }

    private void updateArrowButton(JButton jButton) {
        this.installArrowIcon(jButton);
        Insets insets = SyntheticaLookAndFeel.getInsets((String)"DropDownButton.margin", (Component)this, (boolean)false, (boolean)true);
        if (!this.getComponentOrientation().isLeftToRight()) {
            insets = new Insets(insets.top, insets.right, insets.bottom, insets.left);
        }
        jButton.setMargin(insets);
        jButton.setPreferredSize(new Dimension(this.getArrowIconWidth(), this.getMainButton().getPreferredSize().height));
        jButton.setMaximumSize(new Dimension(this.getArrowIconWidth(), this.getMainButton().getPreferredSize().height));
    }

    private void installArrowIcon(JButton jButton) {
        Object object;
        Icon icon = this.getArrowIcon();
        Icon icon2 = icon;
        if ((icon2 == null || icon2 instanceof UIResource) && UIManager.getLookAndFeel() instanceof SyntheticaLookAndFeel) {
            object = "Synthetica.arrow.down";
            if (this.getParent() instanceof JToolBar && SyntheticaLookAndFeel.get((String)"DropDownButton.toolBarArrowIcon", (Component)this) != null) {
                object = "DropDownButton.toolBarArrowIcon";
            } else if (SyntheticaLookAndFeel.get((String)"DropDownButton.arrowIcon", (Component)this) != null) {
                object = "DropDownButton.arrowIcon";
            } else if (this.getUseSmallArrowIcon() && UIManager.getString("Synthetica.arrow.8x8.down") != null) {
                object = "Synthetica.arrow.8x8.down";
            }
            icon2 = SyntheticaLookAndFeel.loadIcon((String)object, (Component)this, (boolean)true);
        } else if (icon2 == null || icon2 instanceof UIResource) {
            icon2 = new SyntheticaBasicIconPainter(null, SyntheticaLookAndFeel.getInstance().scaleInteger(Integer.valueOf(9)), SyntheticaLookAndFeel.getInstance().scaleInteger(Integer.valueOf(4))){

                public void paint2D(SynthContext synthContext, Graphics2D graphics2D, float f, float f2, float f3, float f4) {
                    if (DropDownButton.this.isEnabled()) {
                        graphics2D.setPaint(Color.BLACK);
                    } else {
                        graphics2D.setPaint(Color.GRAY);
                    }
                    f2 = 0.0f;
                    f = 0.0f;
                    GeneralPath generalPath = new GeneralPath();
                    generalPath.moveTo(f, f2);
                    generalPath.lineTo(f + f3 / 2.0f, f2 + f4);
                    generalPath.lineTo(f + f3, f2);
                    graphics2D.fill(generalPath);
                }
            };
        }
        jButton.setIcon(icon2);
        object = this.getRolloverIcon();
        if (icon2 instanceof UIResource && (object == null || object instanceof UIResource) && UIManager.getLookAndFeel() instanceof SyntheticaLookAndFeel) {
            if (this.getParent() instanceof JToolBar) {
                if (SyntheticaLookAndFeel.get((String)"DropDownButton.hover.toolBarArrowIcon", (Component)this) != null) {
                    object = SyntheticaLookAndFeel.loadIcon((String)"DropDownButton.hover.toolBarArrowIcon", (Component)this, (boolean)true);
                    jButton.setRolloverIcon((Icon)object);
                }
            } else if (SyntheticaLookAndFeel.get((String)"DropDownButton.hover.arrowIcon", (Component)this) != null) {
                object = SyntheticaLookAndFeel.loadIcon((String)"DropDownButton.hover.arrowIcon", (Component)this, (boolean)true);
                jButton.setRolloverIcon((Icon)object);
            }
        } else if (object == null || object instanceof UIResource) {
            jButton.setRolloverIcon(null);
        }
        Icon icon3 = this.getPressedIcon();
        if (icon2 instanceof UIResource && (icon3 == null || icon3 instanceof UIResource) && UIManager.getLookAndFeel() instanceof SyntheticaLookAndFeel) {
            if (this.getParent() instanceof JToolBar) {
                if (SyntheticaLookAndFeel.get((String)"DropDownButton.pressed.toolBarArrowIcon", (Component)this) != null) {
                    icon3 = SyntheticaLookAndFeel.loadIcon((String)"DropDownButton.pressed.toolBarArrowIcon", (Component)this, (boolean)true);
                    jButton.setPressedIcon(icon3);
                }
            } else if (SyntheticaLookAndFeel.get((String)"DropDownButton.pressed.arrowIcon", (Component)this) != null) {
                icon3 = SyntheticaLookAndFeel.loadIcon((String)"DropDownButton.pressed.arrowIcon", (Component)this, (boolean)true);
                jButton.setPressedIcon(icon3);
            }
        } else if (icon3 == null || icon3 instanceof UIResource) {
            jButton.setPressedIcon(null);
        }
        Icon icon4 = this.getDisabledIcon();
        if (icon2 instanceof UIResource && (icon4 == null || icon4 instanceof UIResource) && UIManager.getLookAndFeel() instanceof SyntheticaLookAndFeel) {
            if (this.getParent() instanceof JToolBar) {
                if (SyntheticaLookAndFeel.get((String)"DropDownButton.disabled.toolBarArrowIcon", (Component)this) != null) {
                    icon4 = SyntheticaLookAndFeel.loadIcon((String)"DropDownButton.disabled.toolBarArrowIcon", (Component)this, (boolean)true);
                    jButton.setDisabledIcon(icon4);
                }
            } else if (SyntheticaLookAndFeel.get((String)"DropDownButton.disabled.arrowIcon", (Component)this) != null) {
                icon4 = SyntheticaLookAndFeel.loadIcon((String)"DropDownButton.disabled.arrowIcon", (Component)this, (boolean)true);
                jButton.setDisabledIcon(icon4);
            }
        } else if (icon4 == null || icon4 instanceof UIResource) {
            jButton.setDisabledIcon(null);
        }
    }

    public void setPreferredHorizontalPopupMenuPosition(int n) {
        this.horizontalPopupMenuPosition = n;
    }

    public int getPreferredHorizontalPopupMenuPosition() {
        return this.horizontalPopupMenuPosition;
    }

    public void setPreferredVerticalPopupMenuPosition(int n) {
        this.verticalPopupMenuPosition = n;
    }

    public int getPreferredVerticalPopupMenuPosition() {
        return this.verticalPopupMenuPosition;
    }

    private MouseListener getMainButtonMouseListener() {
        if (this.mainButtonMouseListener == null) {
            this.mainButtonMouseListener = new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent mouseEvent) {
                    DropDownButton.this.getArrowButton().getModel().setRollover(true);
                }

                @Override
                public void mouseExited(MouseEvent mouseEvent) {
                    if (DropDownButton.this.getPopupMenu().isVisible()) {
                        DropDownButton.this.getMainButton().getModel().setRollover(true);
                        DropDownButton.this.getArrowButton().getModel().setRollover(true);
                        return;
                    }
                    DropDownButton.this.getArrowButton().getModel().setArmed(false);
                    DropDownButton.this.getArrowButton().getModel().setRollover(false);
                }

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    DropDownButton.this.getArrowButton().getModel().setArmed(true);
                    DropDownButton.this.getArrowButton().getModel().setPressed(true);
                }

                @Override
                public void mouseReleased(MouseEvent mouseEvent) {
                    if (DropDownButton.this.getPopupMenu().isVisible()) {
                        return;
                    }
                    DropDownButton.this.getArrowButton().getModel().setArmed(false);
                    DropDownButton.this.getArrowButton().getModel().setPressed(false);
                }
            };
        }
        return this.mainButtonMouseListener;
    }

    private MouseListener getArrowButtonMouseListener() {
        if (this.arrowButtonMouseListener == null) {
            this.arrowButtonMouseListener = new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent mouseEvent) {
                    DropDownButton.this.getMainButton().getModel().setRollover(true);
                }

                @Override
                public void mouseExited(MouseEvent mouseEvent) {
                    if (DropDownButton.this.getPopupMenu().isVisible()) {
                        DropDownButton.this.getMainButton().getModel().setRollover(true);
                        DropDownButton.this.getArrowButton().getModel().setRollover(true);
                    } else {
                        DropDownButton.this.getMainButton().getModel().setRollover(false);
                    }
                }

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    DropDownButton.this.getMainButton().getModel().setRollover(true);
                }

                @Override
                public void mouseReleased(MouseEvent mouseEvent) {
                }
            };
        }
        return this.arrowButtonMouseListener;
    }

    public void setUseSmallArrowIcon(boolean bl) {
        boolean bl2 = !this.useLargeArrowIcon;
        this.useLargeArrowIcon = !bl;
        this.firePropertyChange("useSmallArrowIcon", bl2, bl);
    }

    public boolean getUseSmallArrowIcon() {
        return !this.useLargeArrowIcon;
    }

    public void setArrowIcon(Icon icon) {
        Icon icon2 = this.arrowIcon;
        this.arrowIcon = icon;
        this.firePropertyChange("arrowIcon", icon2, icon);
    }

    public Icon getArrowIcon() {
        return this.arrowIcon;
    }

    public int getArrowIconWidth() {
        JButton jButton = this.getArrowButton();
        if (jButton.getIcon() == null) {
            return 0;
        }
        int n = jButton.getIcon().getIconWidth() + jButton.getMargin().left + jButton.getMargin().right;
        return Math.max(SyntheticaLookAndFeel.getInstance().scaleInteger(Integer.valueOf(14)), n + this.arrowIconSpace);
    }

    public void setArrowIconSpace(int n) {
        this.arrowIconSpace = n;
    }

    public int getArrowIconSpace() {
        return this.arrowIconSpace;
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
        this.getMainButton().getModel().setRollover(true);
        this.getArrowButton().getModel().setRollover(true);
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
        this.getMainButton().getModel().setRollover(false);
        this.getArrowButton().getModel().setRollover(false);
        ((JPopupMenu)popupMenuEvent.getSource()).removePopupMenuListener(this);
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        DropDownButton dropDownButton = (DropDownButton)propertyChangeEvent.getSource();
        JButton jButton = this.getMainButton();
        JButton jButton2 = this.getArrowButton();
        if (string.equals("ancestor")) {
            if (dropDownButton.getParent() instanceof JToolBar) {
                JToolBar jToolBar = new JToolBar(){

                    @Override
                    public boolean isOpaque() {
                        return false;
                    }
                };
                jToolBar.setName("DropDownButton.toolBar");
                jToolBar.setFloatable(false);
                jToolBar.setBorder(SyntheticaLookAndFeel.getInstance().createEmptyBorder(0, 0, 0, 0, true));
                jToolBar.add(jButton);
                jToolBar.add(jButton2);
                jToolBar.putClientProperty("Synthetica.opaque", false);
                Component component = SyntheticaLookAndFeel.findComponent(JToolBar.class, (Container)dropDownButton);
                if (component != null) {
                    dropDownButton.remove(component);
                }
                dropDownButton.add(jToolBar);
            } else {
                dropDownButton.setLayout(new BorderLayout(){

                    @Override
                    public Dimension maximumLayoutSize(Container container) {
                        return this.preferredLayoutSize(container);
                    }
                });
                dropDownButton.add(jButton);
                dropDownButton.add((Component)jButton2, "After");
            }
            this.updateArrowButton(jButton2);
            return;
        }
        if (string.equals("useSmallArrowIcon") || string.equals("arrowIcon")) {
            this.updateArrowButton(jButton2);
            return;
        }
        if (string.equals("componentOrientation")) {
            ComponentOrientation componentOrientation = (ComponentOrientation)propertyChangeEvent.getNewValue();
            this.getPopupMenu().applyComponentOrientation(componentOrientation);
            jButton.applyComponentOrientation(componentOrientation);
            jButton2.applyComponentOrientation(componentOrientation);
            boolean bl = !componentOrientation.isLeftToRight();
            jButton.putClientProperty("Synthetica.flipHorizontal", bl);
            jButton2.putClientProperty("Synthetica.flipHorizontal", bl);
            this.updateArrowButton(jButton2);
            return;
        }
        if (string.equals("Synthetica.style") || string.equals("name")) {
            jButton.setName("" + propertyChangeEvent.getNewValue());
            jButton2.setName("" + propertyChangeEvent.getNewValue());
        } else if (string.equals("JButton.segmentPosition")) {
            return;
        }
        Object object = propertyChangeEvent.getNewValue();
        String string2 = "set" + string.substring(0, 1).toUpperCase() + string.substring(1);
        Class<Object> clazz = Object.class;
        if (object instanceof String) {
            clazz = String.class;
        } else if (object instanceof Action) {
            clazz = Action.class;
        } else if (object instanceof ActionMap) {
            clazz = ActionMap.class;
        } else if (object instanceof Boolean) {
            clazz = Boolean.TYPE;
        } else if (object instanceof Integer) {
            clazz = Integer.TYPE;
        } else if (object instanceof Float) {
            clazz = Float.TYPE;
        } else if (object instanceof Icon) {
            clazz = Icon.class;
        } else if (object instanceof Color) {
            clazz = Color.class;
        } else {
            return;
        }
        try {
            Method method = JButton.class.getMethod(string2, clazz);
            method.invoke((Object)jButton, object);
            if (string.equals("borderPainted") || string.equals("contentAreaFilled") || string.equals("focusable") || string.equals("enabled")) {
                method.invoke((Object)jButton2, object);
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

