/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.syntheticaaddons;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.painter.SyntheticaBasicIconPainter;
import de.javasoft.syntheticaaddons.SyntheticaAddonsUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.GeneralPath;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.InsetsUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.synth.SynthContext;

public class SimpleDropDownButton
extends JButton
implements PropertyChangeListener,
PopupMenuListener,
ChangeListener {
    private static final long serialVersionUID = 9122091784625141251L;
    public static final String uiClassID = "SimpleDropDownButtonUI";
    private static Object HIDE_POPUP_KEY = new JComboBox().getClientProperty("doNotCancelPopup");
    protected JPopupMenu popup;
    private int arrowIconSpace;
    private boolean useLargeArrowIcon = false;
    private Icon arrowIcon = null;
    private Border originalBorder;
    private int hPos = 4;
    private int vPos = 0;
    private boolean openPopupByArrow = false;
    private boolean arrowVisible = true;
    private int horizontalPopupMenuPosition = 2;
    private int verticalPopupMenuPosition = 3;
    private boolean initDone;
    private boolean rolloverEnabled;

    public SimpleDropDownButton() {
        this.init();
    }

    public SimpleDropDownButton(Action action) {
        super(action);
        this.init();
    }

    public SimpleDropDownButton(String string) {
        super(string);
        this.init();
    }

    public SimpleDropDownButton(Icon icon) {
        super(icon);
        this.init();
    }

    public SimpleDropDownButton(String string, Icon icon) {
        super(string, icon);
        this.init();
    }

    private void init() {
        this.updateArrowIcon();
        this.setArrowIconSpace(SyntheticaLookAndFeel.getInt((String)"SimpleDropDownButton.arrowIconGap", (Component)this, (int)4, (boolean)true));
        this.putClientProperty("doNotCancelPopup", HIDE_POPUP_KEY);
        this.addPropertyChangeListener(this);
        this.getModel().addChangeListener(this);
        this.getInputMap().put(KeyStroke.getKeyStroke(40, 512), "openPopup");
        this.getActionMap().put("openPopup", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (SimpleDropDownButton.this.getPopupMenu().isVisible()) {
                    SimpleDropDownButton.this.popup.setVisible(false);
                } else if (!SimpleDropDownButton.this.getOpenPopupByArrow() || SimpleDropDownButton.this.getOpenPopupByArrow() && SimpleDropDownButton.this.isMouseInArrowArea()) {
                    int n;
                    JComponent jComponent = (JComponent)actionEvent.getSource();
                    MenuSelectionManager.defaultManager().clearSelectedPath();
                    jComponent.requestFocusInWindow();
                    if (SyntheticaLookAndFeel.isToplevelPopupMenu((JPopupMenu)SimpleDropDownButton.this.popup)) {
                        SimpleDropDownButton.this.popup.updateUI();
                    }
                    SimpleDropDownButton.this.popup.addPopupMenuListener(SimpleDropDownButton.this);
                    boolean bl = SimpleDropDownButton.this.horizontalPopupMenuPosition == 2;
                    boolean bl2 = !(jComponent.getComponentOrientation().isLeftToRight() ^ bl);
                    int n2 = n = bl2 ? 0 : SimpleDropDownButton.this.getWidth() - SimpleDropDownButton.this.popup.getPreferredSize().width;
                    if (SimpleDropDownButton.this.horizontalPopupMenuPosition == 0) {
                        n = SimpleDropDownButton.this.getWidth() / 2 - SimpleDropDownButton.this.popup.getPreferredSize().width / 2;
                    }
                    int n3 = SwingUtilities.convertPoint((Component)jComponent, (int)0, (int)jComponent.getHeight(), (Component)SimpleDropDownButton.this).y;
                    if (SimpleDropDownButton.this.verticalPopupMenuPosition == 1) {
                        n3 -= jComponent.getHeight() + SimpleDropDownButton.this.popup.getPreferredSize().height;
                    }
                    int n4 = SyntheticaLookAndFeel.getInt((String)"DropDownButton.popup.xOffset", (Component)SimpleDropDownButton.this, (int)0, (boolean)true);
                    int n5 = SyntheticaLookAndFeel.getInt((String)"DropDownButton.popup.yOffset", (Component)SimpleDropDownButton.this, (int)0, (boolean)true);
                    SimpleDropDownButton.this.popup.show(SimpleDropDownButton.this, n + (bl2 ? n4 : -n4), n3 + n5);
                }
            }
        });
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SimpleDropDownButton.this.getActionMap().get("openPopup").actionPerformed(actionEvent);
            }
        });
        this.initDone = true;
    }

    public void setPreferredHorizontalPopupMenuPosition(int n) {
        this.horizontalPopupMenuPosition = n;
    }

    public int getPreferredHorizontalPopupMenuPosition() {
        return this.horizontalPopupMenuPosition;
    }

    public void setPreferredVerticalPopupMenuPosition(int n) {
        this.verticalPopupMenuPosition = n;
    }

    public int getPreferredVerticalPopupMenuPosition() {
        return this.verticalPopupMenuPosition;
    }

    public boolean isMouseInArrowArea() {
        Point point = MouseInfo.getPointerInfo().getLocation();
        SwingUtilities.convertPointFromScreen(point, this);
        return this.isMouseInArrowArea(point);
    }

    private boolean isMouseInArrowArea(Point point) {
        Rectangle rectangle = SwingUtilities.calculateInnerArea(this, null);
        if (rectangle.contains(point)) {
            return false;
        }
        Border border = this.getArrowBorder();
        if (border != null) {
            Insets insets = border.getBorderInsets(this);
            rectangle.x -= insets.left;
            rectangle.y -= insets.top;
            rectangle.width += insets.left + insets.right;
            rectangle.height += insets.top + insets.bottom;
            return rectangle.contains(point);
        }
        return false;
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (this.initDone) {
            SyntheticaAddonsUtilities.updateChildrenUI(this.getPopupMenu());
        }
        this.updateArrowIcon();
        this.originalBorder = this.getBorder();
        if (this.isArrowVisible()) {
            this.installBorder(this.isToolBarButton());
        }
    }

    private boolean isToolBarButton() {
        return this.getParent() != null && this.getParent() instanceof JToolBar;
    }

    private void installBorder(boolean bl) {
        Border border = this.originalBorder;
        border = UIManager.getLookAndFeel() instanceof MetalLookAndFeel && bl && border instanceof CompoundBorder ? new CompoundArrowBorder(new CompoundBorder(((CompoundBorder)border).getOutsideBorder(), SyntheticaLookAndFeel.getInstance().createEmptyBorder(3, 3, 3, 3, true)), new ArrowBorder()) : ("Windows".equals(UIManager.getLookAndFeel().getID()) && bl ? new CompoundArrowBorder(SyntheticaLookAndFeel.getInstance().createEmptyBorder(3, 3, 3, 3, true), new ArrowBorder()) : new CompoundArrowBorder(border, new ArrowBorder()));
        Insets insets = SyntheticaLookAndFeel.getInsets((String)"SimpleDropDownButton.margin", (Component)this, (boolean)true);
        if (insets != null) {
            this.setMargin(new InsetsUIResource(insets.top, insets.left, insets.bottom, insets.right));
        }
        this.setBorder(border);
    }

    private Border getArrowBorder() {
        Border border = this.getBorder();
        if (border instanceof CompoundArrowBorder) {
            return ((CompoundArrowBorder)border).getInsideBorder();
        }
        return null;
    }

    private void updateArrowIcon() {
        Icon icon = this.getArrowIcon();
        if ((icon == null || icon instanceof UIResource) && UIManager.getLookAndFeel() instanceof SyntheticaLookAndFeel) {
            boolean bl = this.getParent() instanceof JToolBar;
            String string = "Synthetica.arrow.down";
            if (!bl && !this.getModel().isEnabled() && SyntheticaLookAndFeel.get((String)"DropDownButton.disabled.arrowIcon", (Component)this) != null) {
                string = "DropDownButton.disabled.arrowIcon";
            } else if (!bl && this.getModel().isPressed() && SyntheticaLookAndFeel.get((String)"DropDownButton.pressed.arrowIcon", (Component)this) != null) {
                string = "DropDownButton.pressed.arrowIcon";
            } else if (!bl && this.getModel().isRollover() && SyntheticaLookAndFeel.get((String)"DropDownButton.hover.arrowIcon", (Component)this) != null) {
                string = "DropDownButton.hover.arrowIcon";
            } else if (bl && !this.getModel().isEnabled() && SyntheticaLookAndFeel.get((String)"DropDownButton.disabled.toolBarArrowIcon", (Component)this) != null) {
                string = "DropDownButton.disabled.toolBarArrowIcon";
            } else if (bl && this.getModel().isPressed() && SyntheticaLookAndFeel.get((String)"DropDownButton.pressed.toolBarArrowIcon", (Component)this) != null) {
                string = "DropDownButton.pressed.toolBarArrowIcon";
            } else if (bl && this.getModel().isRollover() && SyntheticaLookAndFeel.get((String)"DropDownButton.hover.toolBarArrowIcon", (Component)this) != null) {
                string = "DropDownButton.hover.toolBarArrowIcon";
            } else if (bl && SyntheticaLookAndFeel.get((String)"DropDownButton.toolBarArrowIcon", (Component)this) != null) {
                string = "DropDownButton.toolBarArrowIcon";
            } else if (SyntheticaLookAndFeel.get((String)"DropDownButton.arrowIcon", (Component)this) != null) {
                string = "DropDownButton.arrowIcon";
            } else if (this.getUseSmallArrowIcon() && UIManager.getString("Synthetica.arrow.8x8.down") != null) {
                string = "Synthetica.arrow.8x8.down";
            }
            icon = SyntheticaLookAndFeel.loadIcon((String)string, (Component)this, (boolean)true);
        } else if (icon == null || icon instanceof UIResource) {
            icon = new SyntheticaBasicIconPainter(null, SyntheticaLookAndFeel.getInstance().scaleInteger(Integer.valueOf(9)), SyntheticaLookAndFeel.getInstance().scaleInteger(Integer.valueOf(4))){

                public void paint2D(SynthContext synthContext, Graphics2D graphics2D, float f, float f2, float f3, float f4) {
                    if (SimpleDropDownButton.this.isEnabled()) {
                        graphics2D.setPaint(Color.BLACK);
                    } else {
                        graphics2D.setPaint(Color.GRAY);
                    }
                    f2 = 0.0f;
                    f = 0.0f;
                    GeneralPath generalPath = new GeneralPath();
                    generalPath.moveTo(f, f2);
                    generalPath.lineTo(f + f3 / 2.0f, f2 + f4);
                    generalPath.lineTo(f + f3, f2);
                    graphics2D.fill(generalPath);
                }
            };
        }
        this.arrowIcon = icon;
    }

    public JPopupMenu getPopupMenu() {
        if (this.popup == null) {
            this.popup = this.createPopupMenu();
        }
        return this.popup;
    }

    public void setPopupMenu(JPopupMenu jPopupMenu) {
        this.popup = jPopupMenu;
    }

    protected JPopupMenu createPopupMenu() {
        return new JPopupMenu();
    }

    public void setArrowVisible(boolean bl) {
        this.arrowVisible = bl;
        if (bl) {
            this.installBorder(this.isToolBarButton());
        } else {
            this.setBorder(this.originalBorder);
        }
    }

    public boolean isArrowVisible() {
        return this.arrowVisible;
    }

    public void setOpenPopupByArrow(boolean bl) {
        this.openPopupByArrow = bl;
    }

    public boolean getOpenPopupByArrow() {
        return this.openPopupByArrow;
    }

    public void setUseSmallArrowIcon(boolean bl) {
        boolean bl2 = !this.useLargeArrowIcon;
        this.useLargeArrowIcon = !bl;
        this.firePropertyChange("useSmallArrowIcon", bl2, bl);
    }

    public boolean getUseSmallArrowIcon() {
        return !this.useLargeArrowIcon;
    }

    public void setArrowIcon(Icon icon) {
        Icon icon2 = this.arrowIcon;
        this.arrowIcon = icon;
        this.firePropertyChange("arrowIcon", icon2, icon);
    }

    public Icon getArrowIcon() {
        return this.arrowIcon;
    }

    public void setArrowIconSpace(int n) {
        this.arrowIconSpace = n;
    }

    public int getArrowIconSpace() {
        return this.arrowIconSpace;
    }

    public void setHorizontalArrowPosition(int n) {
        int n2 = this.hPos;
        this.hPos = n;
        this.firePropertyChange("arrowPosition", n2, n);
    }

    public int getHorizontalArrowPosition() {
        return this.hPos;
    }

    public void setVerticalArrowPosition(int n) {
        int n2 = this.vPos;
        this.vPos = n;
        this.firePropertyChange("arrowPosition", n2, n);
    }

    public int getVerticalArrowPosition() {
        return this.vPos;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("useSmallArrowIcon") || string.equals("arrowIcon")) {
            this.updateArrowIcon();
            return;
        }
        if (string.equals("arrowPosition")) {
            return;
        }
        if (string.equals("ancestor")) {
            this.updateArrowIcon();
            if (this.isArrowVisible()) {
                this.installBorder(((Component)propertyChangeEvent.getSource()).getParent() instanceof JToolBar);
            }
            return;
        }
        if (string.equals("componentOrientation")) {
            this.getPopupMenu().applyComponentOrientation((ComponentOrientation)propertyChangeEvent.getNewValue());
            return;
        }
        if (string.equals("name")) {
            if (this.getBorder() instanceof UIResource) {
                this.setBorder(null);
                this.updateUI();
            }
            return;
        }
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        this.updateArrowIcon();
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
        this.rolloverEnabled = this.isRolloverEnabled();
        this.setRolloverEnabled(false);
        if (this.rolloverEnabled) {
            this.getModel().setRollover(true);
        }
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
        this.setRolloverEnabled(true);
        if (this.rolloverEnabled) {
            this.getModel().setRollover(false);
        }
        ((JPopupMenu)popupMenuEvent.getSource()).removePopupMenuListener(this);
        this.setRolloverEnabled(this.rolloverEnabled);
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
    }

    private class ArrowBorder
    implements Border {
        private ArrowBorder() {
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            this.paintArrow(graphics, n, n2, n3, n4);
        }

        private void paintArrow(Graphics graphics, int n, int n2, int n3, int n4) {
            int n5 = 0;
            int n6 = 0;
            switch (SimpleDropDownButton.this.getHorizontalArrowPosition()) {
                case 4: {
                    n5 = n + n3 - SimpleDropDownButton.this.getArrowIcon().getIconWidth();
                    break;
                }
                case 0: {
                    n5 = n + (n3 - SimpleDropDownButton.this.getArrowIcon().getIconWidth()) / 2;
                    break;
                }
                default: {
                    n5 = n;
                }
            }
            switch (SimpleDropDownButton.this.getVerticalArrowPosition()) {
                case 3: {
                    n6 = n2 + n4 - SimpleDropDownButton.this.getArrowIcon().getIconHeight();
                    break;
                }
                case 0: {
                    n6 = n2 + (n4 - SimpleDropDownButton.this.getArrowIcon().getIconHeight()) / 2;
                    break;
                }
                default: {
                    n6 = n2;
                }
            }
            int n7 = SyntheticaLookAndFeel.getInt((String)"Button.textShiftOffset", (Component)SimpleDropDownButton.this);
            if (!SimpleDropDownButton.this.getModel().isArmed() || !SimpleDropDownButton.this.getModel().isPressed()) {
                n7 = 0;
            }
            SimpleDropDownButton.this.getArrowIcon().paintIcon(SimpleDropDownButton.this, graphics, n5 + n7, n6 + n7);
        }

        @Override
        public Insets getBorderInsets(Component component) {
            if (SimpleDropDownButton.this.hPos == 2) {
                return new Insets(0, SimpleDropDownButton.this.getArrowIcon().getIconWidth() + SimpleDropDownButton.this.getArrowIconSpace(), 0, 0);
            }
            if (SimpleDropDownButton.this.hPos == 4) {
                return new Insets(0, 0, 0, SimpleDropDownButton.this.getArrowIcon().getIconWidth() + SimpleDropDownButton.this.getArrowIconSpace());
            }
            if (SimpleDropDownButton.this.vPos == 1) {
                return new Insets(SimpleDropDownButton.this.getArrowIcon().getIconHeight() + SimpleDropDownButton.this.getArrowIconSpace(), 0, 0, 0);
            }
            if (SimpleDropDownButton.this.vPos == 3) {
                return new Insets(0, 0, SimpleDropDownButton.this.getArrowIcon().getIconHeight() + SimpleDropDownButton.this.getArrowIconSpace(), 0);
            }
            return new Insets(0, 0, 0, 0);
        }

        @Override
        public boolean isBorderOpaque() {
            return false;
        }
    }

    private static class CompoundArrowBorder
    extends CompoundBorder
    implements UIResource {
        private static final long serialVersionUID = -7456112460542420750L;

        public CompoundArrowBorder(Border border, Border border2) {
            super(border, border2);
        }
    }
}

