/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.syntheticaaddons;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.syntheticaaddons.SyntheticaAddons;
import de.javasoft.syntheticaaddons.systemmonitor.Collector;
import de.javasoft.syntheticaaddons.systemmonitor.ModelChangedEvent;
import de.javasoft.syntheticaaddons.systemmonitor.ModelChangedListener;
import de.javasoft.syntheticaaddons.systemmonitor.SystemMonitorModel;
import de.javasoft.syntheticaaddons.ui.SystemMonitorUI;
import de.javasoft.syntheticaaddons.ui.addons.SystemMonitorAddon;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.JToolTip;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.jdesktop.swingx.plaf.ComponentAddon;
import org.jdesktop.swingx.plaf.LookAndFeelAddons;

public class SystemMonitor
extends JPanel
implements ModelChangedListener {
    private static final long serialVersionUID = 4415684173640314897L;
    public static final String uiClassID = "SystemMonitorUI";
    private boolean autoStop = false;
    private SystemMonitorModel model = null;
    private RepaintThread repaintThread = null;
    private Color gridColor = null;
    private Integer gridSize = null;
    private Integer gradientStartAlpha = null;
    private Integer gradientEndAlpha = null;
    private boolean spotlightEnabled = true;
    private int refreshTime = 1000;
    private int collectorBufferSize = 400;
    private int collectorDelay = 500;
    private LinkedHashMap<String, JLabel> valueLabels = new LinkedHashMap();
    private HashMap<String, String> popupMenuCaptions = new HashMap();
    private Integer popupMonitorGridSize = 0;
    private int popupMonitorWidth = SyntheticaLookAndFeel.getInstance().scaleInteger(Integer.valueOf(300));
    private int popupMonitorHeight = SyntheticaLookAndFeel.getInstance().scaleInteger(Integer.valueOf(150));

    static {
        SyntheticaAddons.contribute((ComponentAddon)new SystemMonitorAddon());
    }

    public SystemMonitor() {
        this(true);
    }

    public SystemMonitor(boolean bl) {
        this.autoStop = bl;
        this.setModel(new SystemMonitorModel());
        this.setPopupMonitorGridSize(this.getGridSize());
        this.addAncestorListener(new MonitorAncestorListener());
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                SystemMonitor.this.initPopupMenu((JPopupMenu)popupMenuEvent.getSource());
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
            }
        });
        this.setComponentPopupMenu(jPopupMenu);
        this.enableEvents(16L);
        this.updateUI();
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    @Override
    public void updateUI() {
        this.setUI(LookAndFeelAddons.getUI((JComponent)this, SystemMonitorUI.class));
        if (this.getComponentPopupMenu() != null) {
            this.getComponentPopupMenu().updateUI();
        }
    }

    public void addCollector(String string, Collector collector) {
        this.addCollector(string, this.collectorDelay, collector);
    }

    public void addCollector(String string, int n, Collector collector) {
        this.addCollector(string, this.collectorBufferSize, n, collector);
    }

    public void addCollector(String string, int n, int n2, Collector collector) {
        this.model.addCollector(string, n, n2, collector);
    }

    public void stop() {
        this.stopRepaintThread();
        this.model.removeAll();
    }

    public void stopRepaintThread() {
        if (this.repaintThread != null) {
            this.repaintThread.interrupt();
        }
    }

    protected void initPopupMenu(JPopupMenu jPopupMenu) {
        jPopupMenu.removeAll();
        for (String string : this.getModel().getIds()) {
            JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(new VisibilityAction(string));
            jCheckBoxMenuItem.setSelected(this.getVisible(string));
            jPopupMenu.add(jCheckBoxMenuItem);
        }
    }

    public void setPopupMenuCaption(String string, String string2) {
        this.popupMenuCaptions.put(string, string2);
    }

    public Map<String, String> getPopupMenuCaptions() {
        return this.popupMenuCaptions;
    }

    public JPanel getCaptionPanel() {
        if (!(this.getLayout() instanceof BorderLayout)) {
            return null;
        }
        return (JPanel)((BorderLayout)this.getLayout()).getLayoutComponent("South");
    }

    public void addCaption(final String string, String string2, String string3, boolean bl) {
        JPanel jPanel = this.getCaptionPanel();
        boolean bl2 = this.getVisible(string);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = this.valueLabels.size();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 18;
        JLabel jLabel = new JLabel(string2){
            private static final long serialVersionUID = -4720079886913206351L;

            @Override
            public void updateUI() {
                super.updateUI();
                Color color = SystemMonitor.this.getColor(string) == null ? SystemMonitor.this.getForeground() : SystemMonitor.this.getColor(string);
                this.setForeground(color);
            }
        };
        jLabel.setVisible(bl2);
        if (!bl) {
            jPanel.add((Component)jLabel, gridBagConstraints);
        }
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        JLabel jLabel2 = new JLabel(){
            private static final long serialVersionUID = 8576091583872363920L;

            @Override
            public void updateUI() {
                super.updateUI();
                Color color = SystemMonitor.this.getColor(string) == null ? SystemMonitor.this.getForeground() : SystemMonitor.this.getColor(string);
                this.setForeground(color);
            }
        };
        jLabel2.setVisible(bl2);
        jLabel2.putClientProperty("id", string);
        jLabel2.putClientProperty("caption", string2);
        jLabel2.putClientProperty("format", string3);
        jLabel2.putClientProperty("popupOnly", bl);
        jLabel2.putClientProperty("captionLabel", jLabel);
        this.valueLabels.put(string, jLabel2);
        if (!bl) {
            jPanel.add((Component)jLabel2, gridBagConstraints);
        }
    }

    public void setRefreshTime(int n) {
        this.refreshTime = n;
    }

    public int getRefreshTime() {
        return this.refreshTime;
    }

    public void setModel(SystemMonitorModel systemMonitorModel) {
        this.model = systemMonitorModel;
        if (systemMonitorModel != null) {
            systemMonitorModel.addModelChangedListener(this, new int[0]);
        }
    }

    public SystemMonitorModel getModel() {
        return this.model;
    }

    public void setVisible(String string, boolean bl) {
        this.getModel().setVisible(string, bl);
    }

    public boolean getVisible(String string) {
        return this.getModel().getVisible(string);
    }

    public boolean isVisible(String string) {
        return this.getVisible(string);
    }

    public void setColor(String string, Color color) {
        if (this.getModel() != null) {
            this.getModel().setColor(string, color);
        }
    }

    public Color getColor(String string) {
        if (this.getModel() != null) {
            return this.getModel().getColor(string);
        }
        return null;
    }

    public void setGridColor(Color color) {
        this.gridColor = color;
    }

    public Color getGridColor() {
        return this.gridColor;
    }

    public void setGridSize(Integer n) {
        this.gridSize = n;
    }

    public Integer getGridSize() {
        return this.gridSize;
    }

    public void setGradientStartAlpha(Integer n) {
        this.gradientStartAlpha = n;
    }

    public Integer getGradientStartAlpha() {
        return this.gradientStartAlpha;
    }

    public void setGradientEndAlpha(Integer n) {
        this.gradientEndAlpha = n;
    }

    public Integer getGradientEndAlpha() {
        return this.gradientEndAlpha;
    }

    public void setSpotlightEnabled(boolean bl) {
        this.spotlightEnabled = bl;
    }

    public boolean getSpotlightEnabled() {
        return this.spotlightEnabled;
    }

    public boolean isSpotlightEnabled() {
        return this.getSpotlightEnabled();
    }

    public Map<String, JLabel> getValueLabels() {
        return this.valueLabels;
    }

    public void setPopupEnabled(boolean bl) {
        if (bl) {
            this.setToolTipText(" ");
        } else {
            this.setToolTipText(null);
        }
    }

    public boolean getPopupEnabled() {
        return this.getToolTipText() != null;
    }

    public boolean isPopupEnabled() {
        return this.getPopupEnabled();
    }

    public void setPopupMonitorSize(Dimension dimension) {
        this.popupMonitorWidth = dimension.width;
        this.popupMonitorHeight = dimension.height;
    }

    public Dimension getPopupMonitorSize() {
        return new Dimension(this.popupMonitorWidth, this.popupMonitorHeight);
    }

    public void setPopupMonitorGridSize(Integer n) {
        this.popupMonitorGridSize = n;
    }

    public int getPopupMonitorGridSize() {
        return this.popupMonitorGridSize;
    }

    @Override
    public void modelChanged(ModelChangedEvent<?> modelChangedEvent) {
        JLabel jLabel = this.getValueLabels().get(modelChangedEvent.getId());
        if (jLabel == null) {
            return;
        }
        Object obj = modelChangedEvent.getValue();
        switch (modelChangedEvent.getType()) {
            case 3: {
                jLabel.setVisible((Boolean)obj);
                ((JLabel)jLabel.getClientProperty("captionLabel")).setVisible((Boolean)obj);
                this.repaint();
                break;
            }
            case 2: {
                jLabel.setForeground((Color)obj);
                ((JLabel)jLabel.getClientProperty("captionLabel")).setForeground((Color)obj);
                this.repaint();
            }
        }
    }

    @Override
    public JToolTip createToolTip() {
        return new MonitorPopup(this);
    }

    protected SystemMonitor createPopupMonitor() {
        SystemMonitor systemMonitor = new SystemMonitor();
        systemMonitor.setModel(this.getModel());
        systemMonitor.setPreferredSize(new Dimension(this.popupMonitorWidth, this.popupMonitorHeight));
        systemMonitor.setGridSize(this.popupMonitorGridSize);
        return systemMonitor;
    }

    private class MonitorAncestorListener
    implements AncestorListener {
        private boolean moved = false;
        private boolean added = false;

        private MonitorAncestorListener() {
        }

        @Override
        public void ancestorAdded(AncestorEvent ancestorEvent) {
            this.added = true;
            if (SystemMonitor.this.repaintThread == null) {
                SystemMonitor.this.repaintThread = new RepaintThread();
            }
        }

        @Override
        public void ancestorRemoved(AncestorEvent ancestorEvent) {
            if (!SystemMonitor.this.autoStop) {
                return;
            }
            this.added = false;
            this.moved = false;
            SystemMonitor systemMonitor = (SystemMonitor)ancestorEvent.getSource();
            if (systemMonitor.getParent() instanceof MonitorPopup) {
                systemMonitor.getModel().removeModelChangedListener(systemMonitor);
                systemMonitor.stopRepaintThread();
            } else {
                Container container = ancestorEvent.getAncestorParent();
                if (!(container instanceof JTabbedPane)) {
                    Thread thread = new Thread(){

                        @Override
                        public void run() {
                            try {
                                Thread.sleep(1000L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            if (!MonitorAncestorListener.this.added && !MonitorAncestorListener.this.moved) {
                                SystemMonitor.this.getModel().removeModelChangedListener(SystemMonitor.this);
                                SystemMonitor.this.stop();
                            }
                        }
                    };
                    thread.setDaemon(true);
                    thread.start();
                }
            }
        }

        @Override
        public void ancestorMoved(AncestorEvent ancestorEvent) {
            this.moved = true;
        }
    }

    public class MonitorPopup
    extends JToolTip {
        private static final long serialVersionUID = -3047512396032229021L;

        public MonitorPopup(SystemMonitor systemMonitor2) {
            this.setName("SystemMonitor.monitorPopup");
            SystemMonitor systemMonitor3 = SystemMonitor.this.createPopupMonitor();
            if (systemMonitor3.getModel() == systemMonitor2.getModel()) {
                for (JLabel jLabel : systemMonitor2.getValueLabels().values()) {
                    String string = (String)jLabel.getClientProperty("id");
                    String string2 = (String)jLabel.getClientProperty("caption");
                    String string3 = (String)jLabel.getClientProperty("format");
                    systemMonitor3.addCaption(string, string2, string3, false);
                    systemMonitor3.setPopupMenuCaption(string, (String)SystemMonitor.this.popupMenuCaptions.get(string));
                }
            }
            this.setLayout(new BorderLayout());
            this.add(systemMonitor3);
        }

        @Override
        public Dimension getPreferredSize() {
            return this.getLayout().preferredLayoutSize(this);
        }

        @Override
        public void setTipText(String string) {
        }

        @Override
        public boolean isManagingFocus() {
            return true;
        }

        @Override
        public boolean isFocusTraversable() {
            return false;
        }
    }

    private class RepaintThread
    extends Thread {
        public RepaintThread() {
            this.setDaemon(true);
            this.setName("SystemMonitor RepaintThread " + SystemMonitor.this.refreshTime);
            this.start();
        }

        private void updateLabels() {
            for (String string : SystemMonitor.this.valueLabels.keySet()) {
                this.updateLabel(string);
            }
        }

        private void updateLabel(String string) {
            final JLabel jLabel = (JLabel)SystemMonitor.this.valueLabels.get(string);
            String string2 = (String)jLabel.getClientProperty("format");
            final String string3 = string2.replace("{value}", "1$").replace("{maxValue}", "2$").replace("{percentValue}", "3$");
            final double d = SystemMonitor.this.model.getLastValue(string);
            final double d2 = SystemMonitor.this.model.getLastMaxValue(string);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    jLabel.setText(String.format(string3, d, d2, d / d2 * 100.0));
                }
            });
        }

        @Override
        public void run() {
            while (!this.isInterrupted()) {
                try {
                    SystemMonitor.this.repaint();
                    this.updateLabels();
                    Thread.sleep(SystemMonitor.this.refreshTime);
                }
                catch (InterruptedException interruptedException) {
                    this.interrupt();
                }
            }
        }
    }

    private class VisibilityAction
    extends AbstractAction {
        private static final long serialVersionUID = 3588456282246735885L;
        private String id;

        public VisibilityAction(String string) {
            this.id = string;
            String string2 = SystemMonitor.this.popupMenuCaptions.get(string) == null ? string : (String)SystemMonitor.this.popupMenuCaptions.get(string);
            this.putValue("Name", string2);
            this.putValue("SmallIcon", new Icon(){

                @Override
                public void paintIcon(Component component, Graphics graphics, int n, int n2) {
                    Color color = graphics.getColor();
                    Color color2 = SystemMonitor.this.getColor(VisibilityAction.this.id);
                    if (color2 == null) {
                        color2 = SystemMonitor.this.getForeground();
                    }
                    graphics.setColor(SystemMonitor.this.getBackground());
                    graphics.fillRect(n, n2, this.getIconWidth() - 1, this.getIconHeight() - 1);
                    graphics.setColor(color2);
                    graphics.drawRect(n, n2, this.getIconWidth() - 1, this.getIconHeight() - 1);
                    color2 = new Color(color2.getRed(), color2.getGreen(), color2.getBlue(), 128);
                    graphics.setColor(color2);
                    graphics.fillRect(n, n2, this.getIconWidth() - 1, this.getIconHeight() - 1);
                    graphics.setColor(color);
                }

                @Override
                public int getIconWidth() {
                    return 16;
                }

                @Override
                public int getIconHeight() {
                    return 8;
                }
            });
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)actionEvent.getSource();
            SystemMonitor.this.setVisible(this.id, jCheckBoxMenuItem.isSelected());
        }
    }
}

