/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.syntheticaaddons.highlighter;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import org.jdesktop.swingx.decorator.ComponentAdapter;
import org.jdesktop.swingx.decorator.HighlightPredicate;
import org.jdesktop.swingx.decorator.PainterHighlighter;
import org.jdesktop.swingx.painter.AbstractPainter;
import org.jdesktop.swingx.painter.Painter;

public class ColorTextHighlighter
extends PainterHighlighter {
    private Color background;
    private Color foreground;
    private Color selectedBackground;
    private Color selectedForeground;
    private TextBackgroundPainter<JComponent> backgroundPainter;

    public ColorTextHighlighter(HighlightPredicate highlightPredicate, Color color, Color color2) {
        this(highlightPredicate, color, color2, null, null);
    }

    public ColorTextHighlighter(HighlightPredicate highlightPredicate, Color color, Color color2, Color color3, Color color4) {
        super(highlightPredicate, null);
        this.background = color;
        this.foreground = color2;
        this.selectedBackground = color3;
        this.selectedForeground = color4;
        this.backgroundPainter = new TextBackgroundPainter(color);
        this.setPainter((Painter)this.backgroundPainter);
    }

    protected Component doHighlight(Component component, ComponentAdapter componentAdapter) {
        Color color;
        Color color2 = color = componentAdapter.isSelected() ? this.getSelectedBackground() : this.getBackground();
        if (color != null) {
            this.backgroundPainter.setColor(color);
            super.doHighlight(component, componentAdapter);
        }
        this.applyForeground(component, componentAdapter);
        return component;
    }

    protected void applyForeground(Component component, ComponentAdapter componentAdapter) {
        Color color;
        Color color2 = color = componentAdapter.isSelected() ? this.getSelectedForeground() : this.getForeground();
        if (color != null) {
            component.setForeground(color);
        }
    }

    public Color getBackground() {
        return this.background;
    }

    public void setBackground(Color color) {
        if (this.areEqual(color, this.getBackground())) {
            return;
        }
        this.background = color;
        this.fireStateChanged();
    }

    public Color getForeground() {
        return this.foreground;
    }

    public void setForeground(Color color) {
        if (this.areEqual(color, this.getForeground())) {
            return;
        }
        this.foreground = color;
        this.fireStateChanged();
    }

    public Color getSelectedBackground() {
        return this.selectedBackground;
    }

    public void setSelectedBackground(Color color) {
        if (this.areEqual(color, this.getSelectedBackground())) {
            return;
        }
        this.selectedBackground = color;
        this.fireStateChanged();
    }

    public Color getSelectedForeground() {
        return this.selectedForeground;
    }

    public void setSelectedForeground(Color color) {
        if (this.areEqual(color, this.getSelectedForeground())) {
            return;
        }
        this.selectedForeground = color;
        this.fireStateChanged();
    }

    private static class TextBackgroundPainter<T extends JComponent>
    extends AbstractPainter<T> {
        private Rectangle paintIconR = new Rectangle();
        private Rectangle paintViewR = new Rectangle();
        private Rectangle paintTextR = new Rectangle();
        private Insets insetss = SyntheticaLookAndFeel.getInstance().scaleInsets(0, 0, 0, 0);
        private Color background;

        public TextBackgroundPainter(Color color) {
            this.background = color;
        }

        protected void doPaint(Graphics2D graphics2D, JComponent jComponent, int n, int n2) {
            if (!(jComponent instanceof JLabel)) {
                return;
            }
            JLabel jLabel = (JLabel)jComponent;
            Insets insets = jLabel.getInsets(this.insetss);
            this.paintViewR.x = insets.left;
            this.paintViewR.y = insets.top;
            this.paintViewR.width = n - (insets.left + insets.right);
            this.paintViewR.height = n2 - (insets.top + insets.bottom);
            this.paintIconR.height = 0;
            this.paintIconR.width = 0;
            this.paintIconR.y = 0;
            this.paintIconR.x = 0;
            this.paintTextR.height = 0;
            this.paintTextR.width = 0;
            this.paintTextR.y = 0;
            this.paintTextR.x = 0;
            SwingUtilities.layoutCompoundLabel(jLabel, jLabel.getFontMetrics(jLabel.getFont()), jLabel.getText(), null, jLabel.getVerticalAlignment(), jLabel.getHorizontalAlignment(), jLabel.getVerticalTextPosition(), jLabel.getHorizontalTextPosition(), this.paintViewR, this.paintIconR, this.paintTextR, jLabel.getIconTextGap());
            this.doPaint(graphics2D, this.paintViewR);
        }

        private void doPaint(Graphics2D graphics2D, Rectangle rectangle) {
            Color color = graphics2D.getColor();
            graphics2D.setColor(this.background);
            graphics2D.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            graphics2D.setColor(color);
        }

        public void setColor(Color color) {
            this.background = color;
        }
    }
}

