/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.syntheticaaddons.table;

import de.javasoft.plaf.synthetica.SyntheticaDefaultTableCellEditor;
import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public abstract class AbstractTableCellEditor<T extends JComponent>
extends AbstractCellEditor
implements TableCellEditor {
    protected TableCellEditor delegate;
    protected T editorComponent;
    protected boolean useRendererBorder;
    protected boolean modelDriven;
    protected boolean acceptNullValue;
    private int clicksToEdit;

    public AbstractTableCellEditor(TableCellEditor tableCellEditor) {
        this(tableCellEditor, false);
    }

    public AbstractTableCellEditor(TableCellEditor tableCellEditor, boolean bl) {
        this.delegate = tableCellEditor;
        this.acceptNullValue = bl;
        this.editorComponent = this.createEditorComponent();
        if (this.editorComponent != null && ((Component)this.editorComponent).getName() == null) {
            ((Component)this.editorComponent).setName("Table.editor");
        }
    }

    public abstract T createEditorComponent();

    public T getEditorComponent() {
        return this.editorComponent;
    }

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        this.setCellEditorValue(object);
        ((JComponent)this.editorComponent).setBorder(this.getEditorComponentBorder(jTable, object, bl, n, n2));
        return this.editorComponent;
    }

    protected Border getEditorComponentBorder(JTable jTable, Object object, boolean bl, int n, int n2) {
        Border border = null;
        if (this.useRendererBorder) {
            TableCellRenderer tableCellRenderer = jTable.getCellRenderer(n, n2);
            JComponent jComponent = (JComponent)tableCellRenderer.getTableCellRendererComponent(jTable, object, bl, true, n, n2);
            if (jComponent != null) {
                border = jComponent.getBorder();
            }
        } else {
            JComponent jComponent = (JComponent)this.delegate.getTableCellEditorComponent(jTable, object, bl, n, n2);
            if (jComponent != null) {
                border = jComponent.getBorder();
            }
        }
        return border;
    }

    @Override
    public abstract Object getCellEditorValue();

    public abstract void setCellEditorValue(Object var1);

    @Override
    public boolean isCellEditable(EventObject eventObject) {
        if (eventObject instanceof MouseEvent) {
            return ((MouseEvent)eventObject).getClickCount() >= this.clicksToEdit;
        }
        return true;
    }

    @Override
    public boolean stopCellEditing() {
        if (this.getCellEditorValue() == null && !this.acceptNullValue) {
            this.applyErrorBorder();
            return false;
        }
        return super.stopCellEditing();
    }

    protected void applyErrorBorder() {
        Color color = SyntheticaLookAndFeel.getColor((String)"Synthetica.table.cellEditor.focus.errorColor", null, (Color)new Color(0xE70000));
        ((JComponent)this.editorComponent).setBorder((Border)new SyntheticaDefaultTableCellEditor.CellFocusBorder(color));
    }

    public void setClicksToEdit(int n) {
        this.clicksToEdit = n;
    }

    public int getClicksToEdit() {
        return this.clicksToEdit;
    }
}

