/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.syntheticaaddons.table;

import de.javasoft.syntheticaaddons.table.AbstractTableCellEditor;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellEditor;

public class ComboBoxTableCellEditor
extends AbstractTableCellEditor<JComboBox<Object>> {
    public ComboBoxTableCellEditor(TableCellEditor tableCellEditor) {
        this(tableCellEditor, false);
    }

    public ComboBoxTableCellEditor(TableCellEditor tableCellEditor, boolean bl) {
        super(tableCellEditor);
        ((JComboBox)this.editorComponent).setEditable(bl);
    }

    @Override
    public JComboBox<Object> createEditorComponent() {
        JComboBox<Object> jComboBox = new JComboBox<Object>();
        jComboBox.putClientProperty("Synthetica.opaque", false);
        jComboBox.putClientProperty("JComboBox.isTableCellEditor", Boolean.TRUE);
        jComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ComboBoxTableCellEditor.this.stopCellEditing();
            }
        });
        return jComboBox;
    }

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        Component component = super.getTableCellEditorComponent(jTable, object, bl, n, n2);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (((JComboBox)ComboBoxTableCellEditor.this.editorComponent).isEditable()) {
                    ((JComboBox)ComboBoxTableCellEditor.this.editorComponent).getEditor().getEditorComponent().requestFocusInWindow();
                } else {
                    ((JComboBox)ComboBoxTableCellEditor.this.editorComponent).requestFocusInWindow();
                }
            }
        });
        return component;
    }

    @Override
    public void setCellEditorValue(Object object) {
        this.modelDriven = object instanceof ComboBoxModel;
        DefaultComboBoxModel defaultComboBoxModel = new DefaultComboBoxModel();
        if (this.modelDriven) {
            ComboBoxModel comboBoxModel = (ComboBoxModel)object;
            int n = 0;
            while (n < comboBoxModel.getSize()) {
                defaultComboBoxModel.addElement(comboBoxModel.getElementAt(n));
                ++n;
            }
            defaultComboBoxModel.setSelectedItem(comboBoxModel.getSelectedItem());
        } else {
            ComboBoxModel comboBoxModel = ((JComboBox)this.editorComponent).getModel();
            int n = 0;
            while (n < comboBoxModel.getSize()) {
                defaultComboBoxModel.addElement(comboBoxModel.getElementAt(n));
                ++n;
            }
            defaultComboBoxModel.setSelectedItem(object);
        }
        ((JComboBox)this.editorComponent).setModel(defaultComboBoxModel);
    }

    @Override
    public Object getCellEditorValue() {
        if (this.modelDriven) {
            return ((JComboBox)this.editorComponent).getModel();
        }
        return ((JComboBox)this.editorComponent).getSelectedItem();
    }
}

