/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.syntheticaaddons.table;

import de.javasoft.syntheticaaddons.table.AbstractTableCellEditor;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import java.util.HashMap;
import javax.swing.AbstractCellEditor;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableCellEditor;

public class ObjectTableCellEditor
extends AbstractCellEditor
implements TableCellEditor {
    protected TableCellEditor delegate;
    protected HashMap<String, TableCellEditor> editors = new HashMap();
    protected TableCellEditor activeEditor;
    private int clicksToEdit;

    public ObjectTableCellEditor(TableCellEditor tableCellEditor) {
        this.delegate = tableCellEditor;
        this.setClicksToEdit(1);
    }

    public void setClicksToEdit(int n) {
        this.clicksToEdit = n;
    }

    public int getClicksToEdit() {
        return this.clicksToEdit;
    }

    public void addEditor(Class<?> clazz, TableCellEditor tableCellEditor) {
        this.editors.put(this.getEditorKey(clazz), tableCellEditor);
        this.installActionListener(tableCellEditor);
    }

    public void removeEditor(Class<?> clazz) {
        this.editors.remove(this.getEditorKey(clazz));
    }

    public TableCellEditor getEditor(Class<?> clazz) {
        return this.editors.get(this.getEditorKey(clazz));
    }

    public void addEditor(int n, int n2, TableCellEditor tableCellEditor) {
        this.editors.put(this.getEditorKey(n, n2), tableCellEditor);
        this.installActionListener(tableCellEditor);
    }

    public void removeEditor(int n, int n2) {
        this.editors.remove(this.getEditorKey(n, n2));
    }

    public TableCellEditor getEditor(int n, int n2) {
        return this.editors.get(this.getEditorKey(n, n2));
    }

    private String getEditorKey(Class<?> clazz) {
        return this.getEditorKey(clazz, -1, -1);
    }

    private String getEditorKey(int n, int n2) {
        return this.getEditorKey(null, n, n2);
    }

    private String getEditorKey(Class<?> clazz, int n, int n2) {
        return clazz + "/" + n + "/" + n2;
    }

    private void installActionListener(TableCellEditor tableCellEditor) {
        if (tableCellEditor instanceof AbstractTableCellEditor) {
            Object t = ((AbstractTableCellEditor)tableCellEditor).getEditorComponent();
            ActionListener actionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ObjectTableCellEditor.this.stopCellEditing();
                }
            };
            if (t instanceof JComboBox) {
                ((JComboBox)t).addActionListener(actionListener);
            } else if (t instanceof JTextField) {
                ((JTextField)t).addActionListener(actionListener);
            }
        }
    }

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        this.activeEditor = this.getEditor(jTable.convertRowIndexToModel(n), jTable.convertColumnIndexToModel(n2));
        if (this.activeEditor == null) {
            this.activeEditor = this.getEditor(object == null ? Object.class : object.getClass());
        }
        if (this.activeEditor == null) {
            TableCellEditor tableCellEditor = this.activeEditor = object == null ? null : this.getEditor(object.getClass().getSuperclass());
        }
        if (this.activeEditor == null) {
            return this.delegate.getTableCellEditorComponent(jTable, object, bl, n, n2);
        }
        return this.activeEditor.getTableCellEditorComponent(jTable, object, bl, n, n2);
    }

    @Override
    public Object getCellEditorValue() {
        return this.activeEditor == null ? this.delegate.getCellEditorValue() : this.activeEditor.getCellEditorValue();
    }

    @Override
    public boolean isCellEditable(EventObject eventObject) {
        if (eventObject instanceof MouseEvent) {
            return ((MouseEvent)eventObject).getClickCount() >= this.clicksToEdit;
        }
        return true;
    }

    @Override
    public boolean shouldSelectCell(EventObject eventObject) {
        return this.activeEditor == null ? this.delegate.shouldSelectCell(eventObject) : this.activeEditor.shouldSelectCell(eventObject);
    }

    @Override
    public boolean stopCellEditing() {
        boolean bl;
        boolean bl2 = bl = this.activeEditor == null ? this.delegate.stopCellEditing() : this.activeEditor.stopCellEditing();
        if (bl) {
            super.stopCellEditing();
        }
        return bl;
    }

    @Override
    public void cancelCellEditing() {
        if (this.activeEditor == null) {
            this.delegate.stopCellEditing();
        } else {
            this.activeEditor.cancelCellEditing();
        }
        super.cancelCellEditing();
    }
}

