/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.syntheticaaddons.ui;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.SyntheticaState;
import de.javasoft.syntheticaaddons.ui.painter.TaskPanePainter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import org.jdesktop.swingx.JXHyperlink;
import org.jdesktop.swingx.JXTaskPane;
import org.jdesktop.swingx.plaf.basic.BasicTaskPaneUI;

public class TaskPaneUI
extends BasicTaskPaneUI {
    private static final String CONTENT_PANE_DEFAULT_NAME = "JXTaskPane.contentPane";
    private PropertyChangeListener propertyListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if ("name".equals(string)) {
                TaskPaneUI.this.group.setBorder(TaskPaneUI.this.createPaneBorder());
                ((JComponent)TaskPaneUI.this.group.getContentPane()).setBorder(TaskPaneUI.this.createContentPaneBorder());
                Container container = TaskPaneUI.this.group.getContentPane();
                container.setName("JXTaskPane.contentPane." + propertyChangeEvent.getNewValue());
                if (SyntheticaLookAndFeel.get((String)"TaskPane.font", (Component)TaskPaneUI.this.group) != null && TaskPaneUI.this.group.getFont() instanceof UIResource) {
                    TaskPaneUI.this.group.setFont((Font)SyntheticaLookAndFeel.get((String)"TaskPane.font", (Component)TaskPaneUI.this.group));
                }
            }
        }
    };

    public static ComponentUI createUI(JComponent jComponent) {
        return new TaskPaneUI();
    }

    protected Border createPaneBorder() {
        return new TaskPaneBorder();
    }

    public void installDefaults() {
        super.installDefaults();
        this.group.setOpaque(false);
        this.group.getContentPane().setName(CONTENT_PANE_DEFAULT_NAME);
    }

    protected void installListeners() {
        super.installListeners();
        this.group.addPropertyChangeListener(this.propertyListener);
    }

    protected void uninstallListeners() {
        super.uninstallListeners();
        this.group.removePropertyChangeListener(this.propertyListener);
    }

    protected void configure(JXHyperlink jXHyperlink) {
        jXHyperlink.setOpaque(false);
        Insets insets = SyntheticaLookAndFeel.getInsets((String)"Synthetica.taskPane.link.insets", (Component)this.group, (Insets)new Insets(2, 2, 2, 2), (boolean)true);
        jXHyperlink.setBorder(SyntheticaLookAndFeel.getInstance().createEmptyBorder(insets, false));
        jXHyperlink.setBorderPainted(false);
        jXHyperlink.setFocusPainted(true);
        Color color = SyntheticaLookAndFeel.getColor((String)"Synthetica.taskPane.link.foreground", (Component)jXHyperlink, (Color)UIManager.getColor("TaskPane.titleForeground"));
        jXHyperlink.setForeground(color);
    }

    protected int getTitleHeight(Component component) {
        Insets insets = this.getTitleInsets();
        return super.getTitleHeight(component) + insets.top + insets.bottom;
    }

    protected Border createContentPaneBorder() {
        Color color = UIManager.getColor("TaskPane.borderColor");
        Insets insets = SyntheticaLookAndFeel.getInsets((String)"Synthetica.taskPane.contentPane.insets", (Component)this.group, (Insets)new Insets(10, 10, 10, 10), (boolean)true);
        boolean bl = SyntheticaLookAndFeel.get((String)"Synthetica.taskPane.contentPane.image", (Component)this.group) != null;
        return bl ? new TaskPaneContentBorder() : new CompoundBorder((Border)new BasicTaskPaneUI.ContentPaneBorder(color), SyntheticaLookAndFeel.getInstance().createEmptyBorder(insets, false));
    }

    private Insets getTitleInsets() {
        return SyntheticaLookAndFeel.getInsets((String)"Synthetica.taskPane.title.insets", (Component)this.group, (Insets)new Insets(0, 3, 0, 0), (boolean)true);
    }

    protected class TaskPaneBorder
    extends BasicTaskPaneUI.PaneBorder {
        public TaskPaneBorder() {
            super((BasicTaskPaneUI)TaskPaneUI.this);
            this.borderColor = SyntheticaLookAndFeel.getColor((String)"TaskPane.borderColor", (Component)TaskPaneUI.this.group);
            this.titleForeground = SyntheticaLookAndFeel.getColor((String)"TaskPane.titleForeground", (Component)TaskPaneUI.this.group);
            this.specialTitleBackground = SyntheticaLookAndFeel.getColor((String)"TaskPane.specialTitleBackground", (Component)TaskPaneUI.this.group);
            this.specialTitleForeground = SyntheticaLookAndFeel.getColor((String)"TaskPane.specialTitleForeground", (Component)TaskPaneUI.this.group);
            this.titleBackgroundGradientStart = SyntheticaLookAndFeel.getColor((String)"TaskPane.titleBackgroundGradientStart", (Component)TaskPaneUI.this.group);
            this.titleBackgroundGradientEnd = SyntheticaLookAndFeel.getColor((String)"TaskPane.titleBackgroundGradientEnd", (Component)TaskPaneUI.this.group);
            this.titleOver = SyntheticaLookAndFeel.getColor((String)"TaskPane.titleOver", (Component)TaskPaneUI.this.group);
            if (this.titleOver == null) {
                this.titleOver = this.specialTitleBackground.brighter();
            }
            this.specialTitleOver = SyntheticaLookAndFeel.getColor((String)"TaskPane.specialTitleOver", (Component)TaskPaneUI.this.group);
            if (this.specialTitleOver == null) {
                this.specialTitleOver = this.specialTitleBackground.brighter();
            }
        }

        protected void paintTitleBackground(JXTaskPane jXTaskPane, Graphics graphics) {
            SyntheticaState syntheticaState = new SyntheticaState(TaskPaneUI.this.mouseOver ? SyntheticaState.State.HOVER.toInt() : 0);
            TaskPanePainter.getInstance().paintTaskPaneTitleBackground((JComponent)jXTaskPane, syntheticaState, jXTaskPane.isSpecial(), !jXTaskPane.isCollapsed(), graphics, 0, 0, jXTaskPane.getWidth(), TaskPaneUI.this.getTitleHeight((Component)jXTaskPane));
        }

        protected void paintExpandedControls(JXTaskPane jXTaskPane, Graphics graphics, int n, int n2, int n3, int n4) {
            SyntheticaState syntheticaState = new SyntheticaState(TaskPaneUI.this.mouseOver ? SyntheticaState.State.HOVER.toInt() : 0);
            TaskPanePainter.getInstance().paintTaskPaneExpandedControl((JComponent)jXTaskPane, syntheticaState, jXTaskPane.isSpecial(), !jXTaskPane.isCollapsed(), graphics, n, n2, n3, n4);
        }

        protected void paintFocus(Graphics graphics, Color color, int n, int n2, int n3, int n4) {
            TaskPanePainter.getInstance().paintTaskPaneFocus((JComponent)TaskPaneUI.this.group, new SyntheticaState(SyntheticaState.State.FOCUSED.toInt()), graphics, n - 3, n2 - 3, n3 + 6, n4 + 6);
        }

        protected boolean isMouseOverBorder() {
            return true;
        }

        public Dimension getPreferredSize(JXTaskPane jXTaskPane) {
            this.configureLabel(jXTaskPane);
            Dimension dimension = this.label.getPreferredSize();
            Insets insets = TaskPaneUI.this.getTitleInsets();
            dimension.width += insets.left + insets.right;
            dimension.width += TaskPaneUI.this.getTitleHeight((Component)jXTaskPane);
            dimension.width += SyntheticaLookAndFeel.getInstance().scaleInteger(Integer.valueOf(3)).intValue();
            dimension.height = TaskPaneUI.this.getTitleHeight((Component)jXTaskPane);
            return dimension;
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            JXTaskPane jXTaskPane = (JXTaskPane)component;
            boolean bl = jXTaskPane.getComponentOrientation().isLeftToRight();
            Insets insets = TaskPaneUI.this.getTitleInsets();
            int n5 = TaskPaneUI.this.getTitleHeight((Component)jXTaskPane) - 2 * TaskPaneUI.this.getRoundHeight();
            int n6 = jXTaskPane.getWidth() - TaskPaneUI.this.getTitleHeight((Component)jXTaskPane) - insets.right;
            int n7 = TaskPaneUI.this.getRoundHeight() - 1;
            int n8 = insets.left;
            int n9 = insets.top;
            int n10 = jXTaskPane.getWidth() - TaskPaneUI.this.getTitleHeight((Component)jXTaskPane) - insets.left - insets.right;
            int n11 = TaskPaneUI.this.getTitleHeight((Component)jXTaskPane);
            if (!bl) {
                n6 = jXTaskPane.getWidth() - n6 - n5;
                n8 = jXTaskPane.getWidth() - n8 - n10;
            }
            this.paintTitleBackground(jXTaskPane, graphics);
            this.paintExpandedControls(jXTaskPane, graphics, n6, n7, n5, n5);
            Color color = this.getPaintColor(jXTaskPane);
            if (jXTaskPane.hasFocus()) {
                this.paintFocus(graphics, color, 3, 3, n3 - 6, TaskPaneUI.this.getTitleHeight((Component)jXTaskPane) - 6);
            }
            this.paintTitle(jXTaskPane, graphics, color, n8, n9, n10, n11);
        }
    }

    private class TaskPaneContentBorder
    implements Border,
    UIResource {
        private Insets insets;

        private TaskPaneContentBorder() {
            this.insets = SyntheticaLookAndFeel.getInsets((String)"Synthetica.taskPane.contentPane.insets", (Component)TaskPaneUI.this.group, (boolean)false, (boolean)true);
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            TaskPanePainter.getInstance().paintTaskPaneContentPaneBackground((JComponent)TaskPaneUI.this.group, new SyntheticaState(0), graphics, n, n2, n3, n4);
        }

        @Override
        public Insets getBorderInsets(Component component) {
            return this.insets;
        }

        @Override
        public boolean isBorderOpaque() {
            return false;
        }
    }
}

