/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.syntheticaaddons.ui;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.syntheticaaddons.TextAreaLabel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.RenderingHints;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Locale;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;
import javax.swing.plaf.ComponentUI;
import javax.swing.text.html.HTMLEditorKit;
import org.jdesktop.swingx.JXTipOfTheDay;
import org.jdesktop.swingx.plaf.UIManagerExt;
import org.jdesktop.swingx.plaf.basic.BasicTipOfTheDayUI;
import org.jdesktop.swingx.tips.TipOfTheDayModel;

public class TipOfTheDayUI
extends BasicTipOfTheDayUI {
    public TipOfTheDayUI(JXTipOfTheDay jXTipOfTheDay) {
        super(jXTipOfTheDay);
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new TipOfTheDayUI((JXTipOfTheDay)jComponent);
    }

    protected void installComponents() {
        this.tipPane.setLayout((LayoutManager)new BorderLayout());
        JPanel jPanel = new JPanel(null){
            private static final long serialVersionUID = -8214509584793918142L;
            private int w;
            private int h;
            private Image image;
            {
                String string = UIManager.getString("Synthetica.tipOfTheDay.icon");
                this.image = new ImageIcon(SyntheticaLookAndFeel.getResource((String)string)).getImage();
                this.w = SyntheticaLookAndFeel.getInstance().scaleInteger(Integer.valueOf(this.image.getWidth(null)));
                this.h = SyntheticaLookAndFeel.getInstance().scaleInteger(Integer.valueOf(this.image.getHeight(null)));
            }

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(this.w, this.h);
            }

            @Override
            protected void paintComponent(Graphics graphics) {
                graphics.drawImage(this.image, 0, 0, this.w, this.h, null);
            }
        };
        this.tipPane.add((Component)jPanel, (Object)"West");
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setName("JXTipOfTheDay.EastPanel");
        JLabel jLabel = new JLabel(UIManagerExt.getString((Object)"TipOfTheDay.didYouKnowText", (Locale)this.tipPane.getLocale())){
            private static final long serialVersionUID = -3777618872544570049L;

            @Override
            public void paintComponent(Graphics graphics) {
                Graphics2D graphics2D = (Graphics2D)graphics;
                graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                super.paintComponent(graphics2D);
            }
        };
        jLabel.setPreferredSize(SyntheticaLookAndFeel.getInstance().scaleDimension(50, 32));
        jLabel.setOpaque(true);
        jLabel.setBackground(SyntheticaLookAndFeel.getColor((String)"TextField.background", (Component)this.tipPane));
        jLabel.setBorder(new CompoundBorder(SyntheticaLookAndFeel.getInstance().createMatteBorder(0, 0, 2, 0, this.tipPane.getBackground(), true), SyntheticaLookAndFeel.getInstance().createEmptyBorder(4, 4, 4, 4, true)));
        jLabel.setFont(jLabel.getFont().deriveFont(1, (float)jLabel.getFont().getSize() + 4.0f));
        jPanel2.add((Component)jLabel, "North");
        this.tipArea = new JPanel(new BorderLayout());
        this.tipArea.setName("JXTipOfTheDay.TipPanel");
        this.tipArea.setOpaque(true);
        this.tipArea.setBorder(SyntheticaLookAndFeel.getInstance().createEmptyBorder(4, 4, 4, 4, true));
        this.tipArea.setBackground(SyntheticaLookAndFeel.getColor((String)"TextField.background", (Component)this.tipPane));
        jPanel2.add(this.tipArea);
        this.tipPane.add((Component)jPanel2);
        this.tipPane.setBorder(SyntheticaLookAndFeel.getInstance().createLineBorder(this.tipPane.getBackground(), true));
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        return SyntheticaLookAndFeel.getInstance().scaleDimension(420, 175, true);
    }

    protected void showCurrentTip() {
        int n;
        if (this.currentTipComponent != null) {
            this.tipArea.remove(this.currentTipComponent);
        }
        if ((n = this.tipPane.getCurrentTip()) == -1) {
            JLabel jLabel = new JLabel();
            jLabel.setOpaque(true);
            jLabel.setBackground(Color.WHITE);
            this.currentTipComponent = jLabel;
            this.tipArea.add(this.currentTipComponent);
            return;
        }
        if (this.tipPane.getModel() == null || this.tipPane.getModel().getTipCount() == 0 || n < 0 && n >= this.tipPane.getModel().getTipCount()) {
            this.currentTipComponent = new JLabel();
        } else {
            TipOfTheDayModel.Tip tip = this.tipPane.getModel().getTipAt(n);
            Object object = tip.getTip();
            if (object instanceof Component) {
                this.currentTipComponent = (Component)object;
            } else if (object instanceof Icon) {
                this.currentTipComponent = new JLabel((Icon)object);
            } else {
                String string;
                JScrollPane jScrollPane = new JScrollPane();
                jScrollPane.setBorder(null);
                jScrollPane.setOpaque(false);
                jScrollPane.putClientProperty("Synthetica.opaque", Boolean.FALSE);
                jScrollPane.getViewport().setOpaque(false);
                jScrollPane.setBorder(null);
                String string2 = string = object == null ? "" : object.toString();
                if (string.toLowerCase().startsWith("<html>")) {
                    JTextPane jTextPane = new JTextPane();
                    jTextPane.setEditorKit(new HTMLEditorKit());
                    jTextPane.setContentType("text/html");
                    jTextPane.setText(string);
                    jTextPane.setEditable(false);
                    jTextPane.setFont(jTextPane.getFont().deriveFont((float)jTextPane.getFont().getSize() + 2.0f));
                    jTextPane.setBorder(null);
                    jTextPane.setMargin(null);
                    jTextPane.setOpaque(false);
                    jTextPane.putClientProperty("Synthetica.opaque", Boolean.FALSE);
                    jScrollPane.getViewport().setView(jTextPane);
                } else {
                    TextAreaLabel textAreaLabel = new TextAreaLabel(string);
                    textAreaLabel.setFocusable(true);
                    textAreaLabel.setFont(textAreaLabel.getFont().deriveFont((float)textAreaLabel.getFont().getSize() + 2.0f));
                    jScrollPane.getViewport().setView(textAreaLabel);
                }
                this.currentTipComponent = jScrollPane;
            }
        }
        this.tipArea.add(this.currentTipComponent);
        this.tipArea.revalidate();
        this.tipArea.repaint();
    }

    protected JDialog createDialog(Component component, final JXTipOfTheDay.ShowOnStartupChoice showOnStartupChoice, boolean bl) {
        JButton jButton;
        JCheckBox jCheckBox;
        Locale locale = component == null ? null : component.getLocale();
        String string = UIManagerExt.getString((Object)"TipOfTheDay.dialogTitle", (Locale)locale);
        Window window = component == null ? JOptionPane.getRootFrame() : (component instanceof Window ? (Window)component : SwingUtilities.getWindowAncestor(component));
        final JDialog jDialog = window instanceof Frame ? new JDialog((Frame)window, string, true) : new JDialog((Dialog)window, string, true);
        int n = SyntheticaLookAndFeel.getInstance().scaleInteger(Integer.valueOf(10));
        jDialog.getContentPane().setLayout(new BorderLayout(n, n));
        jDialog.getContentPane().add((Component)this.tipPane, "Center");
        ((JComponent)jDialog.getContentPane()).setBorder(SyntheticaLookAndFeel.getInstance().createEmptyBorder(10, 10, 10, 10, true));
        JPanel jPanel = new JPanel(new BorderLayout());
        jDialog.add("South", jPanel);
        if (showOnStartupChoice != null) {
            jCheckBox = new JCheckBox(UIManagerExt.getString((Object)"TipOfTheDay.showOnStartupText", (Locale)locale), showOnStartupChoice.isShowingOnStartup());
            jPanel.add((Component)jCheckBox, "Center");
        } else {
            jCheckBox = null;
        }
        JPanel jPanel2 = new JPanel(new GridLayout(1, bl ? 3 : 2, SyntheticaLookAndFeel.getInstance().scaleInteger(Integer.valueOf(9)), 0));
        jPanel.add((Component)jPanel2, "After");
        if (bl) {
            jButton = new JButton(UIManagerExt.getString((Object)"TipOfTheDay.previousTipText", (Locale)locale));
            jPanel2.add(jButton);
            jButton.addActionListener(this.getActionMap().get("previousTip"));
        }
        jButton = new JButton(UIManagerExt.getString((Object)"TipOfTheDay.nextTipText", (Locale)locale));
        jPanel2.add(jButton);
        jButton.addActionListener(this.getActionMap().get("nextTip"));
        JButton jButton2 = new JButton(UIManagerExt.getString((Object)"TipOfTheDay.closeText", (Locale)locale));
        jPanel2.add(jButton2);
        final ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (showOnStartupChoice != null) {
                    showOnStartupChoice.setShowingOnStartup(jCheckBox.isSelected());
                }
                jDialog.setVisible(false);
            }
        };
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                jDialog.setVisible(false);
                actionListener.actionPerformed(null);
            }
        });
        jDialog.getRootPane().setDefaultButton(jButton2);
        jDialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                actionListener.actionPerformed(null);
            }
        });
        ((JComponent)jDialog.getContentPane()).registerKeyboardAction(actionListener, KeyStroke.getKeyStroke(27, 0), 2);
        jDialog.pack();
        jDialog.setLocationRelativeTo(component);
        return jDialog;
    }
}

