/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.syntheticaaddons.ui.datecombobox;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.syntheticaaddons.DateComboBox;
import de.javasoft.syntheticaaddons.ui.MonthViewUI;
import de.javasoft.syntheticaaddons.ui.datecombobox.DateComboBoxEditor;
import de.javasoft.syntheticaaddons.ui.datecombobox.DateComboBoxMonthView;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.Date;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.ListModel;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataListener;
import javax.swing.plaf.basic.ComboPopup;
import org.jdesktop.swingx.JXMonthView;

public class DateComboBoxPopup
extends JPopupMenu
implements ComboPopup {
    private static final long serialVersionUID = -2125831396907754915L;
    private JComboBox<Object> comboBox;
    private JList<Object> list;
    private Handler handler;
    private DateComboBoxMonthView monthView;
    private boolean openPopupAllowed;
    private static final ListModel<Object> EmptyListModel = new EmptyListModelClass();
    protected boolean hasEntered = false;

    public DateComboBoxPopup(JComboBox<Object> jComboBox) {
        this.setName("DateComboBoxPopup");
        this.comboBox = jComboBox;
        this.setLightWeightPopupEnabled(this.comboBox.isLightWeightPopupEnabled());
        this.openPopupAllowed = true;
        this.list = this.createList();
        this.list.setName("ComboBox.list");
        this.list.setOpaque(false);
        this.list.addMouseMotionListener(new MouseAdapter(){

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                Container container = mouseEvent.getComponent().getParent();
                DateComboBoxPopup.this.monthView.dispatchEvent(SwingUtilities.convertMouseEvent(DateComboBoxPopup.this.list, mouseEvent, container));
                DateComboBoxPopup.this.list.repaint();
            }
        });
        this.add(this.list);
        this.monthView = this.createMonthView((DateComboBox)jComboBox);
        this.monthView.setTraversable(true);
        this.monthView.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DateComboBoxPopup.this.hide();
                if (DateComboBoxPopup.this.comboBox.isEditable() && !DateComboBoxPopup.this.monthView.isSelectionEmpty()) {
                    DateComboBoxPopup.this.comboBox.getEditor().setItem(DateComboBoxPopup.this.monthView.getSelection().first());
                }
                if (DateComboBoxPopup.this.monthView.getSelection().size() > 0) {
                    Date date = DateComboBoxEditor.getDateTime((Date)DateComboBoxPopup.this.monthView.getSelection().first(), (Date)DateComboBoxPopup.this.comboBox.getSelectedItem(), DateComboBoxPopup.this.monthView.getTimeZone());
                    ((DateComboBox)DateComboBoxPopup.this.comboBox).setDate(date);
                }
            }
        });
        this.installingUI();
    }

    @Override
    public void updateUI() {
        if (this.monthView != null) {
            ((MonthViewUI)this.monthView.getUI()).installDefaults();
        }
        if (this.getList() != null) {
            this.getList().updateUI();
        }
        super.updateUI();
    }

    protected DateComboBoxMonthView createMonthView(DateComboBox dateComboBox) {
        return new DateComboBoxMonthView(dateComboBox, this);
    }

    public JXMonthView getMonthView() {
        return this.monthView;
    }

    void installingUI() {
        this.list.setModel(this.comboBox.getModel());
        this.handler = new Handler();
        this.comboBox.addPropertyChangeListener(this.handler);
    }

    @Override
    protected void firePopupMenuWillBecomeVisible() {
        super.firePopupMenuWillBecomeVisible();
        this.comboBox.firePopupMenuWillBecomeVisible();
    }

    @Override
    protected void firePopupMenuWillBecomeInvisible() {
        super.firePopupMenuWillBecomeInvisible();
        this.comboBox.firePopupMenuWillBecomeInvisible();
    }

    @Override
    protected void firePopupMenuCanceled() {
        super.firePopupMenuCanceled();
        this.comboBox.firePopupMenuCanceled();
    }

    protected JList<Object> createList() {
        return new JList<Object>(){
            private static final long serialVersionUID = 1494046847830802401L;

            @Override
            public void processMouseEvent(MouseEvent mouseEvent) {
                DateComboBoxPopup.this.monthView.processMouseEvent(mouseEvent);
            }
        };
    }

    @Override
    public boolean isFocusTraversable() {
        return false;
    }

    public void setOpenPopupAllowed(boolean bl) {
        this.openPopupAllowed = bl;
        this.comboBox.putClientProperty("ComboBox.arrowButton.enabled", this.comboBox.isEnabled() & bl);
    }

    public boolean isOpenPopupAllowed() {
        return this.openPopupAllowed;
    }

    protected void togglePopup() {
        if (this.isVisible()) {
            this.hide();
        } else {
            this.show();
        }
    }

    @Override
    public void show() {
        if (this.isOpenPopupAllowed()) {
            boolean bl = this.comboBox.getComponentOrientation().isLeftToRight();
            int n = bl ? 0 : this.comboBox.getWidth() - this.getPreferredSize().width;
            int n2 = SyntheticaLookAndFeel.getInt((String)"DateComboBox.popup.xOffset", this.comboBox, (int)0, (boolean)true);
            int n3 = SyntheticaLookAndFeel.getInt((String)"DateComboBox.popup.yOffset", this.comboBox, (int)0, (boolean)true);
            this.show(this.comboBox, n + n2, this.comboBox.getHeight() + n3);
        }
    }

    @Override
    public void hide() {
        MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
        MenuElement[] menuElementArray = menuSelectionManager.getSelectedPath();
        int n = 0;
        while (n < menuElementArray.length) {
            if (menuElementArray[n] == this) {
                menuSelectionManager.clearSelectedPath();
                break;
            }
            ++n;
        }
        if (menuElementArray.length > 0) {
            this.comboBox.repaint();
        }
    }

    @Override
    public JList<Object> getList() {
        return this.list;
    }

    @Override
    public MouseListener getMouseListener() {
        return this.handler;
    }

    @Override
    public MouseMotionListener getMouseMotionListener() {
        return null;
    }

    @Override
    public KeyListener getKeyListener() {
        return this.handler;
    }

    @Override
    public void uninstallingUI() {
        this.comboBox.removePropertyChangeListener(this.handler);
        this.list.setModel(EmptyListModel);
    }

    private static class EmptyListModelClass
    implements ListModel<Object>,
    Serializable {
        private static final long serialVersionUID = 5906623665344402502L;

        private EmptyListModelClass() {
        }

        @Override
        public int getSize() {
            return 0;
        }

        @Override
        public Object getElementAt(int n) {
            return null;
        }

        @Override
        public void addListDataListener(ListDataListener listDataListener) {
        }

        @Override
        public void removeListDataListener(ListDataListener listDataListener) {
        }
    }

    private class Handler
    implements MouseListener,
    PropertyChangeListener,
    KeyListener {
        private Handler() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.getSource() == DateComboBoxPopup.this.list || !SwingUtilities.isLeftMouseButton(mouseEvent) || !DateComboBoxPopup.this.comboBox.isEnabled()) {
                return;
            }
            if (DateComboBoxPopup.this.comboBox.isEditable()) {
                Component component = DateComboBoxPopup.this.comboBox.getEditor().getEditorComponent();
                if (!(component instanceof JComponent) || ((JComponent)component).isRequestFocusEnabled()) {
                    component.requestFocus();
                }
                ((DateComboBoxEditor)DateComboBoxPopup.this.comboBox.getEditor()).commit();
                if (!DateComboBoxPopup.this.monthView.isSelectionEmpty()) {
                    DateComboBoxPopup.this.comboBox.getEditor().setItem(DateComboBoxPopup.this.monthView.getSelection().first());
                    DateComboBoxPopup.this.monthView.ensureDateVisible();
                }
            } else if (DateComboBoxPopup.this.comboBox.isRequestFocusEnabled()) {
                DateComboBoxPopup.this.comboBox.requestFocus();
            }
            DateComboBoxPopup.this.togglePopup();
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            JComboBox jComboBox = (JComboBox)propertyChangeEvent.getSource();
            String string = propertyChangeEvent.getPropertyName();
            if ("renderer".equals(string)) {
                DateComboBoxPopup.this.list.setCellRenderer(jComboBox.getRenderer());
                if (DateComboBoxPopup.this.isVisible()) {
                    DateComboBoxPopup.this.hide();
                }
            } else if ("componentOrientation".equals(string)) {
                ComponentOrientation componentOrientation = (ComponentOrientation)propertyChangeEvent.getNewValue();
                if (componentOrientation != DateComboBoxPopup.this.getComponentOrientation()) {
                    DateComboBoxPopup.this.applyComponentOrientation(componentOrientation);
                    DateComboBoxPopup.this.monthView.applyComponentOrientation(componentOrientation);
                }
            } else if ("lightWeightPopupEnabled".equals(string)) {
                DateComboBoxPopup.this.setLightWeightPopupEnabled(jComboBox.isLightWeightPopupEnabled());
            }
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            boolean bl;
            boolean bl2 = bl = keyEvent.getKeyCode() == 40 && (keyEvent.getModifiersEx() & 0x200) == 512;
            if (bl || keyEvent.getModifiersEx() != 0) {
                return;
            }
            if (!(keyEvent.getKeyCode() != 40 && keyEvent.getKeyCode() != 38 && keyEvent.getKeyCode() != 32 || DateComboBoxPopup.this.isVisible())) {
                DateComboBoxPopup.this.show();
                return;
            }
            if ((keyEvent.getKeyCode() == 27 || keyEvent.getKeyCode() == 10) && DateComboBoxPopup.this.isVisible()) {
                DateComboBoxPopup.this.hide();
            }
            DateComboBoxPopup.this.monthView.processKeyEvent(keyEvent);
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
        }
    }
}

