/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.plaf.synthetica;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.SyntheticaState;
import de.javasoft.plaf.synthetica.painter.MonthViewPainter;
import de.javasoft.synthetica.addons.SyntheticaAddonsUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.CellRendererPane;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JSpinner;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ComponentUI;
import javax.swing.text.JTextComponent;
import org.jdesktop.swingx.JXHyperlink;
import org.jdesktop.swingx.plaf.basic.BasicMonthViewUI;
import org.jdesktop.swingx.plaf.basic.CalendarHeaderHandler;
import org.jdesktop.swingx.plaf.basic.CalendarState;

public class MonthViewUI
extends BasicMonthViewUI {
    public static ComponentUI createUI(JComponent jComponent) {
        return new MonthViewUI();
    }

    public void installDefaults() {
        super.installDefaults();
        if (UIManager.getLookAndFeel() instanceof SyntheticaLookAndFeel) {
            LookAndFeel.installProperty((JComponent)this.monthView, "opaque", SyntheticaLookAndFeel.getBoolean((String)"Synthetica.monthView.opaque", (Component)this.monthView, (boolean)Boolean.FALSE));
        } else {
            LookAndFeel.installProperty((JComponent)this.monthView, "opaque", Boolean.TRUE);
        }
        this.installDelegate();
        this.updateCalendarHeader();
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        this.updateCalendarHeader();
    }

    private void updateCalendarHeader() {
        CalendarHeaderHandler calendarHeaderHandler = this.getCalendarHeaderHandler();
        if (calendarHeaderHandler != null && calendarHeaderHandler.getHeaderComponent() != null && (this.isZoomable() || SyntheticaLookAndFeel.getBoolean((String)"JXDatePicker.forceZoomable", null))) {
            Serializable serializable;
            JComponent jComponent = calendarHeaderHandler.getHeaderComponent();
            SyntheticaAddonsUtilities.updateChildrenUI(jComponent);
            Color color = UIManager.getColor("JXMonthView.monthStringForeground");
            Component[] componentArray = jComponent.getComponents();
            int n = componentArray.length;
            int n2 = 0;
            while (n2 < n) {
                serializable = componentArray[n2];
                serializable.setForeground(color);
                if (serializable instanceof JComponent) {
                    ((JComponent)serializable).setBorder(null);
                }
                if (serializable instanceof JSpinner) {
                    SyntheticaLookAndFeel.findComponent(JTextComponent.class, (Container)((JSpinner)serializable)).setForeground(color);
                    ((JSpinner)serializable).setBorder(new EmptyBorder(1, 0, 1, 0));
                }
                ++n2;
            }
            serializable = SyntheticaLookAndFeel.getInsets((String)"JXMonthView.calendarHeader.insets", null, (Insets)new Insets(3, 3, 3, 3));
            jComponent.setBorder(new EmptyBorder((Insets)serializable));
            jComponent.setOpaque(false);
            jComponent.setBackground(new Color(0, 0, 0, 0));
            this.updateActionIcon("previousMonth", this.monthDownImage);
            this.updateActionIcon("nextMonth", this.monthUpImage);
        }
    }

    private void updateActionIcon(String string, Icon icon) {
        Action action = this.monthView.getActionMap().get(string);
        if (action != null) {
            action.putValue("SmallIcon", icon);
        }
    }

    public void uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
    }

    protected void installDelegate() {
        this.isLeftToRight = this.monthView.getComponentOrientation().isLeftToRight();
        if (UIManager.getLookAndFeel() instanceof SyntheticaLookAndFeel) {
            this.monthDownImage = SyntheticaLookAndFeel.loadIcon((String)"JXMonthView.monthDownFileName");
            this.monthUpImage = SyntheticaLookAndFeel.loadIcon((String)"JXMonthView.monthUpFileName");
        } else {
            this.monthDownImage = UIManager.getIcon("JXMonthView.monthDownFileName");
            this.monthUpImage = UIManager.getIcon("JXMonthView.monthUpFileName");
        }
        this.setFirstDisplayedDay(this.monthView.getFirstDisplayedDay());
    }

    protected void paintDaysOfWeekSeparator(Graphics graphics, Calendar calendar) {
        Rectangle rectangle = this.getSeparatorBounds(calendar, 0, 1);
        if (rectangle != null) {
            graphics.setColor(SyntheticaLookAndFeel.getColor((String)"JXMonthView.daysOfWeekSeparator.foreground", (Component)this.monthView, (Color)this.monthView.getForeground()));
            graphics.drawLine(rectangle.x, rectangle.y, rectangle.x + rectangle.width, rectangle.y);
        }
    }

    protected void paintWeekOfYearSeparator(Graphics graphics, Calendar calendar) {
        Rectangle rectangle = this.getSeparatorBounds(calendar, 1, 0);
        if (rectangle != null) {
            graphics.setColor(SyntheticaLookAndFeel.getColor((String)"JXMonthView.weekOfYearSeparator.foreground", (Component)this.monthView, (Color)this.monthView.getForeground()));
            graphics.drawLine(rectangle.x, rectangle.y, rectangle.x, rectangle.y + rectangle.height);
        }
    }

    private Rectangle getSeparatorBounds(Calendar calendar, int n, int n2) {
        Rectangle rectangle = this.getDayBoundsInMonth(calendar.getTime(), n, n2);
        if (rectangle == null) {
            return null;
        }
        if (n2 == 0) {
            rectangle.height *= 6;
            if (this.isLeftToRight) {
                rectangle.x += rectangle.width - 1;
            }
            rectangle.width = 1;
        } else if (n == 0) {
            int n3 = rectangle.width;
            rectangle.width *= 7;
            if (!this.isLeftToRight) {
                rectangle.x -= rectangle.width - n3;
            }
            rectangle.y += rectangle.height - 1;
            rectangle.height = 1;
        }
        return rectangle;
    }

    protected void paintMonthHeader(Graphics graphics, Calendar calendar) {
        if (UIManager.getLookAndFeel() instanceof SyntheticaLookAndFeel) {
            Rectangle rectangle = new Rectangle(this.getMonthHeaderBounds(calendar.getTime(), false));
            MonthViewPainter.getInstance().paintMonthViewMonthBackground((JComponent)this.monthView, new SyntheticaState(), graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            if (this.monthView.isTraversable() && !this.isZoomable()) {
                int n = 3;
                int n2 = 0;
                rectangle.y = rectangle.y + (rectangle.height - this.monthDownImage.getIconHeight()) / 2 + n2;
                this.monthDownImage.paintIcon(null, graphics, rectangle.x + n, rectangle.y);
                this.monthUpImage.paintIcon(null, graphics, rectangle.x + rectangle.width - this.monthUpImage.getIconWidth() - n, rectangle.y);
            }
        }
        if (!this.isZoomable()) {
            super.paintMonthHeader(graphics, calendar);
        }
    }

    protected void paintDayOfMonth(Graphics graphics, Rectangle rectangle, Calendar calendar, CalendarState calendarState) {
        if (UIManager.getLookAndFeel() instanceof SyntheticaLookAndFeel) {
            Date date;
            boolean bl;
            long l = calendar.getTime().getTime();
            JComponent jComponent = this.getRenderingHandler().prepareRenderingComponent(this.monthView, calendar, calendarState);
            boolean bl2 = bl = (calendarState == CalendarState.IN_MONTH || calendarState == CalendarState.TODAY) && this.monthView.getSelection().size() > 0 && l >= ((Date)this.monthView.getSelection().first()).getTime() && l <= ((Date)this.monthView.getSelection().last()).getTime();
            if (SyntheticaLookAndFeel.getBoolean((String)"Synthetica.monthView.opaqueDayHighlighterSupport", (Component)this.monthView, (boolean)false)) {
                bl = calendarState != CalendarState.TITLE && calendarState != CalendarState.WEEK_OF_YEAR && calendarState != CalendarState.DAY_OF_WEEK;
            }
            boolean bl3 = (date = (Date)SyntheticaLookAndFeel.getClientProperty((String)"MOUSE_OVER_DATE", (JComponent)this.monthView, null)) != null && date.equals(calendar.getTime()) && (calendarState == CalendarState.IN_MONTH || calendarState == CalendarState.TODAY);
            jComponent.setOpaque(bl3 || bl);
            CellRendererPane cellRendererPane = (CellRendererPane)this.monthView.getComponent(0);
            cellRendererPane.paintComponent(graphics, jComponent, (Container)this.monthView, rectangle.x, rectangle.y, rectangle.width, rectangle.height, true);
        } else {
            super.paintDayOfMonth(graphics, rectangle, calendar, calendarState);
        }
    }

    protected int getTraversableGridPositionAtLocation(int n, int n2) {
        int n3 = super.getTraversableGridPositionAtLocation(n, n2);
        if (this.monthView.isZoomable()) {
            JSpinner jSpinner;
            n3 = -1;
            ArrayList arrayList = new ArrayList();
            SyntheticaLookAndFeel.findComponents(JXHyperlink.class, (Container)this.monthView, arrayList);
            if (arrayList.size() == 2) {
                if (((JXHyperlink)arrayList.get(0)).getBounds().contains(n, n2)) {
                    return 1;
                }
                if (((JXHyperlink)arrayList.get(1)).getBounds().contains(n, n2)) {
                    return 2;
                }
            }
            if ((jSpinner = (JSpinner)SyntheticaLookAndFeel.findComponent(JSpinner.class, (Container)this.monthView)) != null && jSpinner.getBounds().contains(n, n2)) {
                AbstractButton abstractButton = (AbstractButton)SyntheticaLookAndFeel.findComponent((String)"Spinner.nextButton", (Container)jSpinner);
                Point point = SwingUtilities.convertPoint((Component)this.monthView, new Point(n, n2), jSpinner);
                if (abstractButton.getBounds().contains(point)) {
                    this.nextYear();
                    return -1;
                }
                abstractButton = (AbstractButton)SyntheticaLookAndFeel.findComponent((String)"Spinner.previousButton", (Container)jSpinner);
                point = SwingUtilities.convertPoint((Component)this.monthView, new Point(n, n2), jSpinner);
                if (abstractButton.getBounds().contains(point)) {
                    this.previousYear();
                    return -1;
                }
            }
        }
        return n3;
    }

    private void nextYear() {
        Date date = this.monthView.getUpperBound();
        if (date == null || date.after(this.getLastDisplayedDay())) {
            Calendar calendar = this.getCalendar();
            calendar.add(1, 1);
            this.monthView.setFirstDisplayedDay(calendar.getTime());
        }
    }

    private void previousYear() {
        Date date = this.monthView.getLowerBound();
        if (date == null || date.before(this.getFirstDisplayedDay())) {
            Calendar calendar = this.getCalendar();
            calendar.add(1, -1);
            this.monthView.setFirstDisplayedDay(calendar.getTime());
        }
    }
}

