/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.plaf.synthetica;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.swing.TextAreaLabel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.RenderingHints;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.LineBorder;
import javax.swing.plaf.ComponentUI;
import javax.swing.text.html.HTMLEditorKit;
import org.jdesktop.swingx.JXTipOfTheDay;
import org.jdesktop.swingx.plaf.UIManagerExt;
import org.jdesktop.swingx.plaf.basic.BasicTipOfTheDayUI;
import org.jdesktop.swingx.tips.TipOfTheDayModel;

public class TipOfTheDayUI
extends BasicTipOfTheDayUI {
    public TipOfTheDayUI(JXTipOfTheDay jXTipOfTheDay) {
        super(jXTipOfTheDay);
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new TipOfTheDayUI((JXTipOfTheDay)jComponent);
    }

    protected void installComponents() {
        this.tipPane.setLayout((LayoutManager)new BorderLayout());
        JPanel jPanel = new JPanel(){
            private static final long serialVersionUID = -8214509584793918142L;
            private Image image;
            {
                String string = UIManager.getString("Synthetica.tipOfTheDay.icon");
                this.image = new ImageIcon(SyntheticaLookAndFeel.class.getResource(string)).getImage();
            }

            public Dimension getPreferredSize() {
                return new Dimension(this.image.getWidth(null), this.image.getHeight(null));
            }

            protected void paintComponent(Graphics graphics) {
                graphics.drawImage(this.image, 0, 0, null);
            }
        };
        this.tipPane.add((Component)jPanel, (Object)"West");
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setName("JXTipOfTheDay.EastPanel");
        JLabel jLabel = new JLabel(UIManagerExt.getString((Object)"TipOfTheDay.didYouKnowText", (Locale)this.tipPane.getLocale())){
            private static final long serialVersionUID = -3777618872544570049L;

            public void paintComponent(Graphics graphics) {
                Graphics2D graphics2D = (Graphics2D)graphics;
                graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                super.paintComponent(graphics2D);
            }
        };
        jLabel.setPreferredSize(new Dimension(50, 32));
        jLabel.setOpaque(true);
        jLabel.setBackground(SyntheticaLookAndFeel.getColor((String)"TextField.background", (Component)this.tipPane));
        jLabel.setBorder(new CompoundBorder(BorderFactory.createMatteBorder(0, 0, 2, 0, this.tipPane.getBackground()), BorderFactory.createEmptyBorder(4, 4, 4, 4)));
        jLabel.setFont(jLabel.getFont().deriveFont(1, (float)jLabel.getFont().getSize() + 4.0f));
        jPanel2.add((Component)jLabel, "North");
        this.tipArea = new JPanel(new BorderLayout());
        this.tipArea.setName("JXTipOfTheDay.TipPanel");
        this.tipArea.setOpaque(true);
        this.tipArea.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.tipArea.setBackground(SyntheticaLookAndFeel.getColor((String)"TextField.background", (Component)this.tipPane));
        jPanel2.add(this.tipArea);
        this.tipPane.add((Component)jPanel2);
        this.tipPane.setBorder((Border)new LineBorder(this.tipPane.getBackground()));
    }

    protected void showCurrentTip() {
        int n;
        if (this.currentTipComponent != null) {
            this.tipArea.remove(this.currentTipComponent);
        }
        if ((n = this.tipPane.getCurrentTip()) == -1) {
            JLabel jLabel = new JLabel();
            jLabel.setOpaque(true);
            jLabel.setBackground(Color.WHITE);
            this.currentTipComponent = jLabel;
            this.tipArea.add(this.currentTipComponent);
            return;
        }
        if (this.tipPane.getModel() == null || this.tipPane.getModel().getTipCount() == 0 || n < 0 && n >= this.tipPane.getModel().getTipCount()) {
            this.currentTipComponent = new JLabel();
        } else {
            TipOfTheDayModel.Tip tip = this.tipPane.getModel().getTipAt(n);
            Object object = tip.getTip();
            if (object instanceof Component) {
                this.currentTipComponent = (Component)object;
            } else if (object instanceof Icon) {
                this.currentTipComponent = new JLabel((Icon)object);
            } else {
                String string;
                JScrollPane jScrollPane = new JScrollPane();
                jScrollPane.setBorder(null);
                jScrollPane.setOpaque(false);
                jScrollPane.putClientProperty("Synthetica.opaque", Boolean.FALSE);
                jScrollPane.getViewport().setOpaque(false);
                jScrollPane.setBorder(null);
                String string2 = string = object == null ? "" : object.toString();
                if (string.toLowerCase().startsWith("<html>")) {
                    JTextPane jTextPane = new JTextPane();
                    jTextPane.setEditorKit(new HTMLEditorKit());
                    jTextPane.setContentType("text/html");
                    jTextPane.setText(string);
                    jTextPane.setEditable(false);
                    jTextPane.setFont(jTextPane.getFont().deriveFont((float)jTextPane.getFont().getSize() + 2.0f));
                    jTextPane.setBorder(null);
                    jTextPane.setMargin(null);
                    jTextPane.setOpaque(false);
                    jTextPane.putClientProperty("Synthetica.opaque", Boolean.FALSE);
                    jScrollPane.getViewport().setView(jTextPane);
                } else {
                    TextAreaLabel textAreaLabel = new TextAreaLabel(string);
                    textAreaLabel.setFocusable(true);
                    textAreaLabel.setFont(textAreaLabel.getFont().deriveFont((float)textAreaLabel.getFont().getSize() + 2.0f));
                    jScrollPane.getViewport().setView(textAreaLabel);
                }
                this.currentTipComponent = jScrollPane;
            }
        }
        this.tipArea.add(this.currentTipComponent);
        this.tipArea.revalidate();
        this.tipArea.repaint();
    }
}

