/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.plaf.synthetica.simple2D;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.simple2D.ScrollPanePainter;
import de.javasoft.swing.JYTableScrollPane;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.plaf.synth.SynthContext;

public class JYTableScrollPanePainter
extends ScrollPanePainter {
    public void paintScrollPaneBorder(SynthContext sc, Graphics g, int x, int y, int w, int h) {
        JYTableScrollPane scroller = (JYTableScrollPane)sc.getComponent();
        JYTableScrollPane.JYTableScrollPaneLayout layout = (JYTableScrollPane.JYTableScrollPaneLayout)scroller.getLayout();
        if (SyntheticaLookAndFeel.isOpaque((JComponent)scroller)) {
            Graphics2D g2 = this.prepareGraphics2D(sc, g, 0, 0, true);
            int offset = 0;
            int i = 0;
            while (i < layout.getColumnSubHeaderCount()) {
                JViewport port = layout.getColumnSubHeader(i);
                if (port.isVisible()) {
                    Rectangle r = port.getBounds();
                    int yy = r.y;
                    int hh = r.height;
                    g2.setPaint(((JTable)scroller.getViewport().getView()).getTableHeader().getBackground());
                    Shape headerShape = this.createSubHeaderShape(this.calcRelativePos(g2, x, offset), this.calcRelativePos(g2, yy, offset), JYTableScrollPanePainter.calcRelativeLength((Graphics2D)g2, (float)w, (float)(-offset * 2)), JYTableScrollPanePainter.calcRelativeLength((Graphics2D)g2, (float)hh, (float)0.0f));
                    g2.fill(headerShape);
                    g2.draw(headerShape);
                    g2.setPaint(SyntheticaLookAndFeel.getColor((String)"Synthetica.tableHeader.gridColor", (Component)scroller.getViewport().getView()));
                    g2.draw(this.createSubHeaderLine(this.calcRelativePos(g2, x, offset), this.calcRelativePos(g2, yy + hh, -1.0f), JYTableScrollPanePainter.calcRelativeLength((Graphics2D)g2, (float)w, (float)(-offset * 2))));
                }
                ++i;
            }
            this.restoreGraphics2D(g2);
        }
        super.paintScrollPaneBorder(sc, g, x, y, w, h);
    }

    private int getSubHeadersHeight(JYTableScrollPane.JYTableScrollPaneLayout layout) {
        int height = 0;
        int i = 0;
        while (i < layout.getColumnSubHeaderCount()) {
            JViewport port = layout.getColumnSubHeader(i);
            if (port.isVisible()) {
                height += port.getHeight();
            }
            ++i;
        }
        return height;
    }

    private Shape createSubHeaderShape(float x, float y, float w, float h) {
        return new Rectangle2D.Float(x, y, w, h);
    }

    private Shape createSubHeaderLine(float x, float y, float w) {
        return new Line2D.Float(x, y, x + w, y);
    }

    public Insets getCacheScaleInsets(SynthContext sc, String id) {
        Insets insets = super.getCacheScaleInsets(sc, id);
        if (id.equals("paintScrollPaneBorder")) {
            JYTableScrollPane scroller = (JYTableScrollPane)sc.getComponent();
            JYTableScrollPane.JYTableScrollPaneLayout layout = (JYTableScrollPane.JYTableScrollPaneLayout)scroller.getLayout();
            insets.top += this.getSubHeadersHeight(layout);
        }
        return insets;
    }

    public int getCacheHash(SynthContext sc, int w, int h, int meta, String id) {
        int hash = super.getCacheHash(sc, w, h, meta, id);
        if (hash != -1 && id.equals("paintScrollPaneBorder")) {
            JYTableScrollPane scroller = (JYTableScrollPane)sc.getComponent();
            JYTableScrollPane.JYTableScrollPaneLayout layout = (JYTableScrollPane.JYTableScrollPaneLayout)scroller.getLayout();
            hash = 31 * hash + this.getSubHeadersHeight(layout);
        }
        return hash;
    }
}

