/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.swing;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.painter.ImagePainter;
import de.javasoft.swing.plaf.AboutDialogUI;
import de.javasoft.swing.plaf.addons.AboutDialogAddon;
import de.javasoft.swing.table.MultiLineTableCellRenderer;
import de.javasoft.synthetica.addons.SyntheticaAddons;
import de.javasoft.synthetica.addons.SyntheticaAddonsUtilities;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URL;
import java.util.Locale;
import java.util.Map;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.plaf.AbstractComponentAddon;
import org.jdesktop.swingx.plaf.ComponentAddon;
import org.jdesktop.swingx.plaf.LookAndFeelAddons;

public class AboutDialog
extends JComponent {
    private static final boolean JAVA5 = System.getProperty("java.version").startsWith("1.5.");
    private static final long serialVersionUID = 3944221583946202891L;
    public static final String uiClassID = "AboutDialogUI";
    private JTextPane descriptionPane = null;
    private JScrollPane aboutScrollPane = null;
    private JTabbedPane tabbedPane = null;
    private JDialog dialog = null;
    private Dimension dialogSize = null;
    private boolean sortable;
    private String bgImage = null;
    private Insets bgInsets = null;
    protected static AbstractComponentAddon addon = new AboutDialogAddon();

    static {
        SyntheticaAddons.contribute((ComponentAddon)addon);
    }

    public AboutDialog(Window window, boolean bl) {
        this(window, bl, null);
    }

    public AboutDialog(Window window, boolean bl, Locale locale) {
        this(window, bl, null, true);
    }

    public AboutDialog(Window window, boolean bl, Locale locale, boolean bl2) {
        this.dialog = window instanceof Frame ? new JDialog((Frame)window, bl) : new JDialog((Dialog)window, bl);
        if (locale != null) {
            this.setLocale(locale);
        }
        this.sortable = bl2;
        this.setUI(UIManager.getUI(this));
        this.init();
    }

    public String getUIClassID() {
        return uiClassID;
    }

    public void updateUI() {
        this.setUI(LookAndFeelAddons.getUI((JComponent)this, AboutDialogUI.class));
    }

    private void init() {
        this.descriptionPane = new JTextPane();
        this.descriptionPane.setText(UIManager.getString("AboutDialog.description"));
        this.aboutScrollPane = new JScrollPane(new JEditorPane());
        this.tabbedPane = this.createTabbedPane();
        this.tabbedPane.addTab(UIManager.getString("AboutDialog.aboutTab"), this.aboutScrollPane);
        JTable jTable = this.createSystemTable();
        JScrollPane jScrollPane = new JScrollPane(jTable);
        JComponent jComponent = this.createSystemTableCorner(jTable);
        if (this.sortable && jTable != null) {
            ((JXTable)jTable).setColumnControl(jComponent);
        } else if (!this.sortable) {
            jScrollPane.setCorner("UPPER_TRAILING_CORNER", jComponent);
        }
        if (jTable != null) {
            this.tabbedPane.addTab(UIManager.getString("AboutDialog.systemTab"), jScrollPane);
        }
    }

    protected JTabbedPane createTabbedPane() {
        JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.setBorder(new EmptyBorder(10, 10, 10, 10));
        jTabbedPane.setPreferredSize(new Dimension(580, 360));
        return jTabbedPane;
    }

    protected JComponent createSystemTableCorner(JTable jTable) {
        JTableHeader jTableHeader = new JTableHeader();
        jTableHeader.setTable(jTable);
        return jTableHeader;
    }

    protected JTable createSystemTable() {
        JTable jTable = null;
        if (this.sortable) {
            try {
                jTable = (JTable)Class.forName("org.jdesktop.swingx.JXTable").newInstance();
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        } else {
            jTable = new JTable();
        }
        jTable.setModel(new DefaultTableModel(){
            private Map.Entry<?, ?>[] props = System.getProperties().entrySet().toArray(new Map.Entry[0]);

            public int getRowCount() {
                if (this.props == null) {
                    return 0;
                }
                return this.props.length;
            }

            public int getColumnCount() {
                return 2;
            }

            public Object getValueAt(int n, int n2) {
                if (n2 == 0) {
                    return this.props[n].getKey();
                }
                return this.props[n].getValue();
            }

            public String getColumnName(int n) {
                if (n == 0) {
                    return UIManager.getString("AboutDialog.systemName");
                }
                return UIManager.getString("AboutDialog.systemValue");
            }

            public boolean isCellEditable(int n, int n2) {
                return false;
            }
        });
        jTable.getColumnModel().getColumn(1).setCellRenderer(new MultiLineTableCellRenderer(jTable.getDefaultRenderer(Object.class)));
        if (this.sortable) {
            JXTable jXTable = (JXTable)jTable;
            if (JAVA5) {
                jXTable.setRowHeightEnabled(true);
            }
            jXTable.packColumn(1, 100);
            jXTable.setColumnControlVisible(true);
        }
        return jTable;
    }

    private void addComponents() {
        this.dialog.getContentPane().removeAll();
        this.dialog.setLayout(new BorderLayout());
        this.descriptionPane.setOpaque(false);
        this.descriptionPane.putClientProperty("Synthetica.opaque", Boolean.FALSE);
        this.descriptionPane.setEditable(false);
        this.descriptionPane.setCaretPosition(0);
        this.descriptionPane.setBorder(new EmptyBorder(10, 10, 10, 10));
        JPanel jPanel = new JPanel(new BorderLayout()){

            protected void paintComponent(Graphics graphics) {
                super.paintComponent(graphics);
                if (AboutDialog.this.bgImage != null) {
                    new ImagePainter(graphics, 0, 0, this.getSize().width, this.getSize().height, AboutDialog.this.bgImage, AboutDialog.this.bgInsets, AboutDialog.this.bgInsets, 0, 0).draw();
                }
            }
        };
        jPanel.add(this.descriptionPane);
        JSeparator jSeparator = new JSeparator(0);
        jSeparator.setName("AboutDialog.separator");
        jPanel.add((Component)jSeparator, "South");
        jPanel.setBackground(new Color(UIManager.getColor("TextField.background").getRGB()));
        jPanel.setOpaque(SyntheticaLookAndFeel.getBoolean((String)"AboutDialog.topPanel.opaque", (Component)this.dialog, (boolean)true));
        this.dialog.add((Component)jPanel, "North");
        JEditorPane jEditorPane = (JEditorPane)this.aboutScrollPane.getViewport().getView();
        jEditorPane.setBackground(new Color(UIManager.getColor("TextField.background").getRGB()));
        jEditorPane.setEditable(false);
        jEditorPane.setCaretPosition(0);
        jEditorPane.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.dialog.add(this.tabbedPane);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 2));
        jPanel2.add(Box.createHorizontalGlue());
        JButton jButton = new JButton(UIManager.getString("AboutDialog.okButton")){

            public Dimension getPreferredSize() {
                Dimension dimension = super.getPreferredSize();
                dimension.width = 80;
                return dimension;
            }
        };
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AboutDialog.this.dialog.dispose();
            }
        });
        jPanel2.add(jButton);
        jPanel2.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.dialog.add((Component)jPanel2, "South");
    }

    public static void showDialog(Window window, String string, String string2, String string3, URL uRL, Locale locale, boolean bl) throws IOException {
        AboutDialog aboutDialog = new AboutDialog(window, true, locale, bl);
        aboutDialog.setTitle(string);
        aboutDialog.setDescription(string2);
        aboutDialog.setAboutText(string3, uRL);
        aboutDialog.showDialog();
    }

    public static void showDialog(Window window, String string, String string2, String string3, Locale locale, boolean bl) throws IOException {
        AboutDialog.showDialog(window, string, string2, string3, null, locale, true);
    }

    public static void showDialog(Window window, String string, String string2, String string3, Locale locale) throws IOException {
        AboutDialog.showDialog(window, string, string2, string3, null, null, true);
    }

    public static void showDialog(Window window, String string, String string2, String string3) throws IOException {
        AboutDialog.showDialog(window, string, string2, string3, null);
    }

    public void showDialog() {
        this.addComponents();
        if (this.dialog.getTitle() == null) {
            this.dialog.setTitle(UIManager.getString("AboutDialog.title"));
        }
        if (this.dialogSize == null) {
            this.dialog.pack();
        } else {
            this.dialog.setSize(this.dialogSize);
        }
        this.dialog.setLocationRelativeTo(this.dialog.getOwner());
        this.dialog.setVisible(true);
    }

    public void setTitle(String string) {
        this.dialog.setTitle(string);
    }

    public String getTitle() {
        return this.dialog.getTitle();
    }

    public void setAboutText(String string) throws IOException {
        this.setAboutText(string, null);
    }

    public void setAboutText(String string, URL uRL) throws IOException {
        if (string.toUpperCase().trim().startsWith("<HTML>")) {
            JEditorPane jEditorPane = new JEditorPane("text/html", string);
            if (uRL != null) {
                ((HTMLDocument)jEditorPane.getDocument()).setBase(uRL);
            }
            jEditorPane.addHyperlinkListener(this.createHyperlinkListener());
            this.aboutScrollPane.getViewport().setView(jEditorPane);
        } else {
            JEditorPane jEditorPane = (JEditorPane)this.aboutScrollPane.getViewport().getView();
            jEditorPane.setText(string);
        }
    }

    protected HyperlinkListener createHyperlinkListener() {
        return new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
                if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    SyntheticaAddonsUtilities.openInBrowser(hyperlinkEvent.getURL().toExternalForm());
                }
            }
        };
    }

    public void setAboutText(URL uRL) throws IOException {
        this.setAboutText(uRL.toString());
        JEditorPane jEditorPane = new JEditorPane(uRL.toString());
        jEditorPane.addHyperlinkListener(this.createHyperlinkListener());
        this.aboutScrollPane.getViewport().setView(jEditorPane);
    }

    public String getAboutText() {
        JEditorPane jEditorPane = (JEditorPane)this.aboutScrollPane.getViewport().getView();
        return jEditorPane.getText();
    }

    public void setDescription(String string) {
        if (string == null) {
            return;
        }
        if (string.toUpperCase().trim().startsWith("<HTML>")) {
            this.descriptionPane.setEditorKit(new HTMLEditorKit());
            this.descriptionPane.setContentType("text/html");
            this.descriptionPane.addHyperlinkListener(this.createHyperlinkListener());
        }
        this.descriptionPane.setText(string);
    }

    public String getDetails() {
        return this.descriptionPane.getText();
    }

    public void setBackgroundImage(String string, Insets insets) {
        this.bgImage = string;
        this.bgInsets = insets;
    }

    public JTabbedPane getTabbedPane() {
        return this.tabbedPane;
    }

    public void setDialogSize(Dimension dimension) {
        this.dialogSize = dimension;
    }

    public Dimension setDialogSize() {
        return this.dialogSize;
    }
}

