/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.swing;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.painter.SyntheticaBasicIconPainter;
import de.javasoft.swing.DropDownButton;
import de.javasoft.swing.SimpleDropDownButton;
import de.javasoft.synthetica.addons.SyntheticaAddonsUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.GeneralPath;
import java.io.Serializable;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.DefaultButtonModel;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSeparator;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.synth.SynthContext;

public class ToolBar
extends JToolBar {
    private static final long serialVersionUID = 6512375619025421868L;
    private static final String TOOLBAR_VISIBILITY = "ToolBar.Visibility";
    private static final String TOOLBAR_PREFERRED_COMPONENT_SIZE = "ToolBar.PrefComponentSize";
    private static final String TOOLBAR_PREFERRED_COMPONENT_SIZE_SET = "ToolBar.PrefComponentSizeSet";
    private JToolBar popupButtonBar;
    private PopupButton popupButton = new PopupButton(this);
    private int popupButtonIndex;
    private VisibilityListener visibilityListener;

    public ToolBar() {
        this.popupButtonBar = new JToolBar(){

            public boolean isOpaque() {
                return false;
            }
        };
        this.popupButtonBar.setMargin(new Insets(0, 0, 0, 0));
        this.popupButtonBar.putClientProperty("Synthetica.opaque", false);
        this.popupButtonBar.setFloatable(false);
        this.popupButtonBar.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.popupButtonBar.add(Box.createHorizontalGlue());
        this.popupButtonBar.add(this.popupButton);
        this.visibilityListener = new VisibilityListener();
        this.addContainerListener(new ContainerListener(){

            public void componentRemoved(ContainerEvent containerEvent) {
                containerEvent.getChild().removeComponentListener(ToolBar.this.visibilityListener);
            }

            public void componentAdded(ContainerEvent containerEvent) {
                Component component = containerEvent.getChild();
                component.addComponentListener(ToolBar.this.visibilityListener);
                if (component instanceof JComponent) {
                    ToolBar.this.updateComponentSize((JComponent)component);
                }
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                ToolBar.this.updateToolBar();
            }
        });
    }

    private void updateToolBar() {
        this.removePopupButton();
        int n = this.getComponentCount();
        int n2 = -1;
        int n3 = 0;
        while (n3 < n) {
            JComponent jComponent = (JComponent)this.getComponent(n3);
            boolean bl = this.isOnToolBar(this, jComponent);
            if (jComponent.isVisible() || ((Boolean)SyntheticaLookAndFeel.getClientProperty((String)TOOLBAR_VISIBILITY, (JComponent)jComponent, (Object)false)).booleanValue()) {
                this.setComponentVisible(jComponent, bl);
            }
            if (n3 < n - 1 && bl && !this.isOnToolBar(this, this.getComponent(n3 + 1))) {
                n2 = n3 + 1;
            }
            ++n3;
        }
        if (n2 > 0) {
            this.popupButtonBar.setOrientation(this.getOrientation());
            this.addPopupButton(n2);
        }
        this.popupButton.setComponentOrientation(this.getComponentOrientation());
    }

    private void updateComponentSize(JComponent jComponent) {
        if (((Boolean)SyntheticaLookAndFeel.getClientProperty((String)TOOLBAR_VISIBILITY, (JComponent)jComponent, (Object)false)).booleanValue()) {
            return;
        }
        if (jComponent.isVisible()) {
            Boolean bl = (Boolean)jComponent.getClientProperty(TOOLBAR_PREFERRED_COMPONENT_SIZE_SET);
            Dimension dimension = (Dimension)jComponent.getClientProperty(TOOLBAR_PREFERRED_COMPONENT_SIZE);
            if (dimension != null) {
                jComponent.setPreferredSize(bl != false ? dimension : null);
                jComponent.putClientProperty(TOOLBAR_PREFERRED_COMPONENT_SIZE, null);
                this.updateToolBar();
            }
        } else {
            Dimension dimension = (Dimension)SyntheticaLookAndFeel.getClientProperty((String)TOOLBAR_PREFERRED_COMPONENT_SIZE, (JComponent)jComponent, null);
            if (dimension == null) {
                jComponent.putClientProperty(TOOLBAR_PREFERRED_COMPONENT_SIZE_SET, jComponent.isPreferredSizeSet());
                jComponent.putClientProperty(TOOLBAR_PREFERRED_COMPONENT_SIZE, jComponent.getPreferredSize());
                jComponent.setPreferredSize(new Dimension(0, 0));
                this.updateToolBar();
            }
        }
    }

    private void setComponentVisible(JComponent jComponent, boolean bl) {
        jComponent.setVisible(bl);
        if (bl) {
            jComponent.putClientProperty(TOOLBAR_VISIBILITY, null);
        } else {
            jComponent.putClientProperty(TOOLBAR_VISIBILITY, true);
        }
    }

    public void updateUI() {
        if (this.popupButton != null) {
            this.removePopupButton();
            this.popupButton.updateUI();
        }
        super.updateUI();
        if (this.popupButton != null) {
            this.dispatchEvent(new ComponentEvent(this, 101));
        }
    }

    public AbstractButton getPopupButton() {
        return this.popupButton;
    }

    protected void addPopupButton(int n) {
        this.popupButtonIndex = n;
        this.add((Component)this.popupButtonBar, n);
    }

    protected void removePopupButton() {
        this.popupButtonIndex = -1;
        this.remove(this.popupButtonBar);
    }

    private boolean isOnToolBar(JToolBar jToolBar, Component component) {
        int n = 0;
        int n2 = 0;
        int n3 = component.getPreferredSize().width;
        int n4 = component.getPreferredSize().height;
        int n5 = this.popupButton.getMinimumSize().width;
        int n6 = this.popupButton.getMinimumSize().height;
        Component[] componentArray = jToolBar.getComponents();
        int n7 = componentArray.length;
        int n8 = 0;
        while (n8 < n7) {
            Component component2 = componentArray[n8];
            if (component2 == component) break;
            n += component2.getPreferredSize().width;
            n2 += component2.getPreferredSize().height;
            ++n8;
        }
        if (jToolBar.getOrientation() == 0) {
            if (component == jToolBar.getComponent(jToolBar.getComponentCount() - 1) && this.popupButtonIndex < 0) {
                n5 = 0;
            }
            return (double)(n + n3 + n5) <= jToolBar.getVisibleRect().getWidth();
        }
        if (component == jToolBar.getComponent(jToolBar.getComponentCount() - 1) && this.popupButtonIndex < 0) {
            n6 = 0;
        }
        return (double)(n2 + n4 + n6) <= jToolBar.getVisibleRect().getHeight();
    }

    private static class PopupButton
    extends JToggleButton
    implements ActionListener {
        private static final long serialVersionUID = 112096722125942373L;
        private ToolBar toolBar;

        private PopupButton(ToolBar toolBar) {
            this.toolBar = toolBar;
            this.addActionListener(this);
            this.setFocusPainted(false);
        }

        public void updateUI() {
            super.updateUI();
            Icon icon = this.getIcon();
            if ((icon == null || icon instanceof UIResource) && UIManager.getLookAndFeel() instanceof SyntheticaLookAndFeel) {
                String string = "Synthetica.arrow.down";
                if (SyntheticaLookAndFeel.get((String)"ToolBar.arrowIcon", (Component)this) != null) {
                    string = "ToolBar.arrowIcon";
                }
                this.setIcon(SyntheticaLookAndFeel.loadIcon((String)string));
                if (SyntheticaLookAndFeel.get((String)"ToolBar.arrowIcon.hover", (Component)this) != null) {
                    string = "ToolBar.arrowIcon.hover";
                    icon = SyntheticaLookAndFeel.loadIcon((String)string);
                    this.setRolloverIcon(icon);
                    this.setPressedIcon(icon);
                    this.setSelectedIcon(icon);
                }
                if (SyntheticaLookAndFeel.get((String)"ToolBar.arrowIcon.pressed", (Component)this) != null) {
                    string = "ToolBar.arrowIcon.pressed";
                    icon = SyntheticaLookAndFeel.loadIcon((String)string);
                    this.setPressedIcon(icon);
                    this.setSelectedIcon(icon);
                }
            } else if (icon == null || icon instanceof UIResource) {
                icon = new SyntheticaBasicIconPainter(null, 9, 4){

                    public void paint2D(SynthContext synthContext, Graphics2D graphics2D, float f, float f2, float f3, float f4) {
                        graphics2D.setPaint(Color.BLACK);
                        f2 = 0.0f;
                        f = 0.0f;
                        GeneralPath generalPath = new GeneralPath();
                        generalPath.moveTo(f, f2);
                        generalPath.lineTo(f + f3 / 2.0f, f2 + f4);
                        generalPath.lineTo(f + f3, f2);
                        graphics2D.fill(generalPath);
                    }
                };
                this.setIcon(icon);
            }
        }

        public Dimension getMaximumSize() {
            Insets insets = this.toolBar.getInsets();
            if (this.toolBar.getOrientation() == 0) {
                return new Dimension(super.getMaximumSize().width, this.toolBar.getHeight() - insets.top);
            }
            return new Dimension(this.toolBar.getWidth() - insets.left - insets.right, super.getMaximumSize().height);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Serializable serializable;
            JPopupMenu jPopupMenu = new JPopupMenu();
            Component[] componentArray = this.toolBar.getComponents();
            int n = componentArray.length;
            int n2 = 0;
            while (n2 < n) {
                serializable = componentArray[n2];
                if (!((Component)serializable).isVisible() && ((Boolean)SyntheticaLookAndFeel.getClientProperty((String)ToolBar.TOOLBAR_VISIBILITY, (JComponent)((JComponent)serializable), (Object)false)).booleanValue()) {
                    if (serializable instanceof JSeparator) {
                        jPopupMenu.addSeparator();
                    } else {
                        this.addItems((Container)serializable, jPopupMenu);
                    }
                }
                ++n2;
            }
            jPopupMenu.addPopupMenuListener(new PopupMenuListener(){

                public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                    PopupButton.this.setSelected(false);
                    final JPopupMenu jPopupMenu = (JPopupMenu)popupMenuEvent.getSource();
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            PopupButton.this.releaseMenuItems(jPopupMenu);
                        }
                    });
                }

                public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
                }

                public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                }
            });
            serializable = this.getComponentOrientation();
            jPopupMenu.applyComponentOrientation((ComponentOrientation)serializable);
            n2 = ((ComponentOrientation)serializable).isLeftToRight() ? 0 : this.getWidth() - jPopupMenu.getPreferredSize().width;
            jPopupMenu.show(this, n2, this.getHeight());
        }

        private void releaseMenuItems(Container container) {
            Component[] componentArray = container.getComponents();
            int n = componentArray.length;
            int n2 = 0;
            while (n2 < n) {
                Component component = componentArray[n2];
                if (component instanceof AbstractButton) {
                    ((AbstractButton)component).setModel(new DefaultButtonModel());
                }
                if (component instanceof JMenu) {
                    this.releaseMenuItems(((JMenu)component).getPopupMenu());
                }
                ++n2;
            }
        }

        private void addItems(Container container, Container container2) {
            if (container instanceof SimpleDropDownButton) {
                SimpleDropDownButton simpleDropDownButton = (SimpleDropDownButton)container;
                JMenu jMenu = new JMenu(simpleDropDownButton.getText());
                jMenu.setIcon(PopupButton.resizeIcon(simpleDropDownButton.getIcon()));
                jMenu.setEnabled(simpleDropDownButton.isEnabled());
                this.addItems(simpleDropDownButton.getPopupMenu(), jMenu);
                this.addEmulatedActionToMenu(jMenu, simpleDropDownButton);
                container2.add(jMenu);
            } else if (container instanceof DropDownButton) {
                DropDownButton dropDownButton = (DropDownButton)container;
                JMenu jMenu = new JMenu(dropDownButton.getMainButton().getText());
                jMenu.setIcon(PopupButton.resizeIcon(dropDownButton.getMainButton().getIcon()));
                jMenu.setEnabled(dropDownButton.isEnabled());
                this.addItems(dropDownButton.getPopupMenu(), jMenu);
                this.addEmulatedActionToMenu(jMenu, dropDownButton);
                container2.add(jMenu);
            } else if (container instanceof JComboBox) {
                JComboBox jComboBox = (JComboBox)container;
                container2.add(new JMenuItem(jComboBox.getSelectedItem().toString()));
            } else if (container instanceof JMenu) {
                JMenu jMenu = (JMenu)container;
                JMenu jMenu2 = new JMenu(jMenu.getText());
                jMenu2.setIcon(jMenu.getIcon());
                jMenu2.setEnabled(jMenu.isEnabled());
                Component[] componentArray = jMenu.getMenuComponents();
                int n = componentArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Component component = componentArray[n2];
                    this.addItems((Container)component, jMenu2);
                    ++n2;
                }
                container2.add(jMenu2);
            } else if (container instanceof AbstractButton && !"ScrollBar.button".equals(container.getName())) {
                AbstractButton abstractButton = (AbstractButton)container;
                if (abstractButton.getAction() != null && container2 instanceof JPopupMenu) {
                    ((JPopupMenu)container2).add(abstractButton.getAction());
                } else {
                    JMenuItem jMenuItem = null;
                    jMenuItem = abstractButton instanceof JRadioButtonMenuItem ? new JRadioButtonMenuItem(abstractButton.getText(), abstractButton.getIcon()) : (abstractButton instanceof JCheckBoxMenuItem ? new JCheckBoxMenuItem(abstractButton.getText(), abstractButton.getIcon()) : new JMenuItem(abstractButton.getText(), PopupButton.resizeIcon(abstractButton.getIcon())));
                    ((AbstractButton)jMenuItem).setModel(abstractButton.getModel());
                    container2.add(jMenuItem);
                }
            } else {
                Component[] componentArray = container.getComponents();
                int n = componentArray.length;
                int n3 = 0;
                while (n3 < n) {
                    Component component = componentArray[n3];
                    this.addItems((Container)component, container2);
                    ++n3;
                }
            }
        }

        private void addEmulatedActionToMenu(JMenu jMenu, final AbstractButton abstractButton) {
            jMenu.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent mouseEvent) {
                    Action action = abstractButton.getAction();
                    if (action != null && abstractButton.isEnabled()) {
                        action.actionPerformed(new ActionEvent(mouseEvent.getSource(), mouseEvent.getID(), null));
                    }
                }
            });
        }

        private static Icon resizeIcon(Icon icon) {
            if (icon == null) {
                return null;
            }
            int n = 16;
            if (icon.getIconWidth() == n && icon.getIconHeight() == n) {
                return icon;
            }
            return SyntheticaAddonsUtilities.resizeIcon(icon, n, n);
        }
    }

    private static class VisibilityListener
    extends ComponentAdapter {
        private VisibilityListener() {
        }

        public void componentShown(ComponentEvent componentEvent) {
            if (!(componentEvent.getSource() instanceof JComponent)) {
                return;
            }
            JComponent jComponent = (JComponent)componentEvent.getSource();
            ToolBar toolBar = (ToolBar)jComponent.getParent();
            toolBar.updateComponentSize(jComponent);
        }

        public void componentHidden(ComponentEvent componentEvent) {
            if (!(componentEvent.getSource() instanceof JComponent)) {
                return;
            }
            JComponent jComponent = (JComponent)componentEvent.getComponent();
            ToolBar toolBar = (ToolBar)jComponent.getParent();
            toolBar.updateComponentSize(jComponent);
        }
    }
}

