/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.swing.plaf;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.SyntheticaState;
import de.javasoft.plaf.synthetica.painter.SystemMonitorPainter;
import de.javasoft.swing.SystemMonitor;
import de.javasoft.synthetica.addons.systemmonitor.CollectorFactory;
import de.javasoft.synthetica.addons.systemmonitor.SystemMonitorModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.LookAndFeel;
import javax.swing.border.Border;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.PanelUI;
import javax.swing.plaf.UIResource;

public class SystemMonitorUI
extends PanelUI {
    public void paint(Graphics graphics, JComponent jComponent) {
        Object object;
        int n = 0;
        int n2 = 0;
        int n3 = jComponent.getWidth();
        int n4 = ((SystemMonitor)jComponent).getCaptionPanel() == null ? 0 : ((SystemMonitor)jComponent).getCaptionPanel().getHeight();
        int n5 = jComponent.getHeight() - n4;
        if (jComponent.getBorder() != null) {
            object = jComponent.getBorder().getBorderInsets(jComponent);
            n = object.left;
            n2 = object.top;
            n3 -= object.left + object.right;
            n5 -= object.top + object.bottom;
        }
        object = new SyntheticaState();
        SystemMonitorPainter.getInstance().paintSystemMonitorBackground(jComponent, (SyntheticaState)object, graphics, n, n2, n3, n5);
        SystemMonitorPainter.getInstance().paintSystemMonitorForeground(jComponent, (SyntheticaState)object, graphics, n, n2, n3, n5);
        SystemMonitorPainter.getInstance().paintSystemMonitorSpotlight(jComponent, (SyntheticaState)object, graphics, n, n2, n3, n5);
    }

    public static PanelUI createUI(JComponent jComponent) {
        return new SystemMonitorUI();
    }

    public void installUI(final JComponent jComponent) {
        super.installUI(jComponent);
        this.installDefaults(jComponent);
        JPanel jPanel = ((SystemMonitor)jComponent).getCaptionPanel();
        if (jPanel == null) {
            jPanel = new JPanel(new GridBagLayout()){
                private static final long serialVersionUID = -4306816688362297522L;

                public void updateUI() {
                    super.updateUI();
                    this.setBackground(jComponent.getBackground());
                    super.setOpaque(true);
                }

                public void setOpaque(boolean bl) {
                }
            };
            jPanel.setName("SystemMonitor.CaptionPanel");
        }
        jComponent.setLayout(new BorderLayout());
        jComponent.add((Component)jPanel, "South");
    }

    public void uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
        this.uninstallDefaults(jComponent);
    }

    protected void installDefaults(JComponent jComponent) {
        SystemMonitorModel systemMonitorModel;
        SystemMonitor systemMonitor = (SystemMonitor)jComponent;
        if (systemMonitor.getForeground() == null || systemMonitor.getForeground() instanceof UIResource) {
            systemMonitor.setForeground(SyntheticaLookAndFeel.getColor((String)"Synthetica.systemMonitor.foreground.color", (Component)systemMonitor));
        }
        if (systemMonitor.getBackground() == null || systemMonitor.getBackground() instanceof UIResource) {
            systemMonitor.setBackground(SyntheticaLookAndFeel.getColor((String)"Synthetica.systemMonitor.background.color", (Component)systemMonitor));
        }
        if (systemMonitor.getGridColor() == null || systemMonitor.getGridColor() instanceof UIResource) {
            systemMonitor.setGridColor(SyntheticaLookAndFeel.getColor((String)"Synthetica.systemMonitor.grid.color", (Component)systemMonitor));
        }
        if (systemMonitor.getBorder() == null || systemMonitor.getBorder() instanceof UIResource) {
            systemMonitor.setBorder(new BorderUIResource(new Border(){

                public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
                    SystemMonitorPainter.getInstance().paintSystemMonitorBorder((JComponent)component, new SyntheticaState(), graphics, n, n2, n3, n4);
                }

                public Insets getBorderInsets(Component component) {
                    return SyntheticaLookAndFeel.getInsets((String)"Synthetica.systemMonitor.border.insets", (Component)component);
                }

                public boolean isBorderOpaque() {
                    return false;
                }
            }));
        }
        if ((systemMonitorModel = systemMonitor.getModel()) != null) {
            String string = "Synthetica.systemMonitor.{id}.color";
            CollectorFactory.CollectorID[] collectorIDArray = CollectorFactory.CollectorID.values();
            int n = collectorIDArray.length;
            int n2 = 0;
            while (n2 < n) {
                CollectorFactory.CollectorID collectorID = collectorIDArray[n2];
                if (systemMonitorModel.getColor(collectorID.id) == null || systemMonitorModel.getColor(collectorID.id) instanceof UIResource) {
                    systemMonitorModel.setColor(collectorID.id, SyntheticaLookAndFeel.getColor((String)string.replace("{id}", collectorID.id), (Component)systemMonitor));
                }
                ++n2;
            }
        }
        LookAndFeel.installProperty(jComponent, "opaque", Boolean.FALSE);
    }

    protected void uninstallDefaults(JComponent jComponent) {
    }

    public static /* bridge */ /* synthetic */ ComponentUI createUI(JComponent jComponent) {
        return SystemMonitorUI.createUI(jComponent);
    }
}

