/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.swing.table;

import de.javasoft.swing.table.AbstractTableCellRenderer;
import de.javasoft.swing.table.ObjectTableCellRenderer;
import de.javasoft.synthetica.addons.SyntheticaAddonsUtilities;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import org.jdesktop.swingx.JXHyperlink;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HyperlinkTableCellRenderer
extends AbstractTableCellRenderer<JXHyperlink>
implements MouseListener,
MouseMotionListener {
    private int row;
    private int col;

    public HyperlinkTableCellRenderer(TableCellRenderer tableCellRenderer) {
        super(tableCellRenderer);
    }

    @Override
    protected JXHyperlink createRendererComponent() {
        JXHyperlink jXHyperlink = new JXHyperlink();
        return jXHyperlink;
    }

    @Override
    protected void setValue(JXHyperlink jXHyperlink, Object object) {
        jXHyperlink.setAction((Action)new AbstractAction(object.toString()){

            public void actionPerformed(ActionEvent actionEvent) {
                SyntheticaAddonsUtilities.openInBrowser((String)this.getValue("Name"));
            }
        });
    }

    @Override
    protected void configureRendererComponent(JXHyperlink jXHyperlink, JComponent jComponent, JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        if (bl) {
            super.configureRendererComponent(jXHyperlink, jComponent, jTable, object, bl, bl2, n, n2);
        }
        boolean bl3 = !jTable.isEditing() && this.row == n && this.col == n2;
        jXHyperlink.getModel().setRollover(bl3);
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        Component component;
        JTable jTable = (JTable)mouseEvent.getSource();
        TableCellRenderer tableCellRenderer = jTable.getCellRenderer(this.row, this.col);
        if (tableCellRenderer instanceof ObjectTableCellRenderer) {
            tableCellRenderer = (ObjectTableCellRenderer)jTable.getCellRenderer(this.row, this.col);
        }
        if ((component = tableCellRenderer.getTableCellRendererComponent(jTable, jTable.getValueAt(this.row, this.col), false, false, this.row, this.col)) instanceof HyperlinkTableCellRenderer) {
            ((JXHyperlink)this.rendererComponent).getAction().actionPerformed(new ActionEvent(this.rendererComponent, 1001, ""));
        }
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        JTable jTable = (JTable)mouseEvent.getSource();
        this.row = -1;
        this.col = -1;
        jTable.repaint();
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        JTable jTable = (JTable)mouseEvent.getSource();
        Point point = mouseEvent.getPoint();
        this.row = jTable.rowAtPoint(point);
        this.col = jTable.columnAtPoint(point);
        if (this.row < 0 || this.col < 0) {
            this.row = -1;
            this.col = -1;
        }
        jTable.repaint();
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
    }
}

