/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.swing.table;

import de.javasoft.swing.table.AbstractTableCellEditor;
import java.awt.Component;
import java.lang.reflect.Constructor;
import java.text.NumberFormat;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellEditor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextFieldTableCellEditor
extends AbstractTableCellEditor<JTextField> {
    private Constructor<?> constructor;
    private Object value;

    public TextFieldTableCellEditor(TableCellEditor tableCellEditor) {
        super(tableCellEditor);
    }

    @Override
    public JTextField createEditorComponent() {
        JTextField jTextField = new JTextField();
        jTextField.putClientProperty("Synthetica.opaque", false);
        return jTextField;
    }

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        Object object2;
        this.value = null;
        try {
            object2 = object.getClass();
            if (object2 == Object.class) {
                object2 = String.class;
            }
            this.constructor = ((Class)object2).getConstructor(String.class);
        }
        catch (Exception exception) {
            return null;
        }
        object2 = super.getTableCellEditorComponent(jTable, object, bl, n, n2);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ((JTextField)TextFieldTableCellEditor.this.editorComponent).requestFocusInWindow();
            }
        });
        return object2;
    }

    @Override
    public Object getCellEditorValue() {
        return this.value;
    }

    @Override
    public void setCellEditorValue(Object object) {
        if (object instanceof Number) {
            object = NumberFormat.getInstance().format(object);
        }
        ((JTextField)this.editorComponent).setText(object == null ? "" : object.toString());
    }

    @Override
    public boolean stopCellEditing() {
        String string = ((JTextField)this.editorComponent).getText();
        try {
            if (Number.class.isAssignableFrom(this.constructor.getDeclaringClass())) {
                string = "" + NumberFormat.getNumberInstance().parse(string);
            }
            this.value = this.constructor.newInstance(string);
        }
        catch (Exception exception) {
            this.applyErrorBorder();
            return false;
        }
        return super.stopCellEditing();
    }

    public static class NumberEditor
    extends TextFieldTableCellEditor {
        public NumberEditor(TableCellEditor tableCellEditor) {
            super(tableCellEditor);
        }

        public JTextField createEditorComponent() {
            JTextField jTextField = super.createEditorComponent();
            jTextField.setHorizontalAlignment(4);
            return jTextField;
        }
    }
}

