#!/bin/bash
## Desinstalador Avirato PMS para Linux
## Actualizado: 2025-11-11

NAME_APP="Avirato"
NAME_APP_REPAIR="AviratoRepair"

# Verificar si zenity está instalado
if ! command -v zenity >/dev/null 2>&1; then
    echo "Desinstalando Avirato..."
    echo "zenity no está disponible. Continuando con desinstalación manual."
    USE_ZENITY=false
else
    USE_ZENITY=true
fi

# Función para mostrar mensaje
show_message() {
    if [ "$USE_ZENITY" = true ]; then
        zenity --question --text="$1" --title="Desinstalar Avirato" --width=400
    else
        echo "$1"
        read -p "¿Continuar? (s/n): " response
        [[ "$response" =~ ^[Ss]$ ]]
    fi
}

# Confirmar desinstalación
if ! show_message "¿Está seguro de que desea desinstalar Avirato PMS?\n\nSe eliminarán todos los archivos de la aplicación."; then
    [ "$USE_ZENITY" = true ] && zenity --info --text="Desinstalación cancelada"
    echo "Desinstalación cancelada"
    exit 0
fi

# Detectar ubicación de instalación
if [ -d "$HOME/$NAME_APP" ]; then
    INSTALL_DIR="$HOME/$NAME_APP"
    RUTA_APPLICATIONS="$HOME/.local/share/applications"
    ICON_DIR="$HOME/.local/share/icons/hicolor/256x256/apps"
    REQUIRES_SUDO=false
elif [ -d "/opt/$NAME_APP" ]; then
    INSTALL_DIR="/opt/$NAME_APP"
    RUTA_APPLICATIONS="/usr/share/applications"
    ICON_DIR="/usr/share/icons/hicolor/256x256/apps"
    REQUIRES_SUDO=true
else
    if [ "$USE_ZENITY" = true ]; then
        zenity --error --text="No se encontró una instalación de Avirato en este sistema."
    fi
    echo "Error: No se encontró una instalación de Avirato"
    exit 1
fi

echo "Desinstalando desde: $INSTALL_DIR"

# Función para eliminar archivos
remove_files() {
    if [ "$REQUIRES_SUDO" = true ]; then
        sudo rm -rf "$INSTALL_DIR"
        sudo rm -f "$RUTA_APPLICATIONS/$NAME_APP-PMS.desktop"
        sudo rm -f "$RUTA_APPLICATIONS/$NAME_APP-Repair.desktop"
        sudo rm -f "$ICON_DIR/avirato.png"
        sudo rm -f "$ICON_DIR/avirato-repair.png"
    else
        rm -rf "$INSTALL_DIR"
        rm -f "$RUTA_APPLICATIONS/$NAME_APP-PMS.desktop"
        rm -f "$RUTA_APPLICATIONS/$NAME_APP-Repair.desktop"
        rm -f "$ICON_DIR/avirato.png"
        rm -f "$ICON_DIR/avirato-repair.png"
    fi
}

# Realizar desinstalación
if remove_files; then
    # Actualizar menús y caché de iconos
    if [ "$REQUIRES_SUDO" = false ]; then
        xdg-desktop-menu uninstall "$RUTA_APPLICATIONS/$NAME_APP-PMS.desktop" 2>/dev/null || true
        xdg-desktop-menu uninstall "$RUTA_APPLICATIONS/$NAME_APP-Repair.desktop" 2>/dev/null || true
    fi
    
    # Actualizar caché de iconos
    if [ "$REQUIRES_SUDO" = true ]; then
        sudo gtk-update-icon-cache -f -t /usr/share/icons/hicolor 2>/dev/null || true
    else
        gtk-update-icon-cache -f -t "$HOME/.local/share/icons/hicolor" 2>/dev/null || true
    fi
    
    if [ "$USE_ZENITY" = true ]; then
        zenity --info --text="Avirato PMS ha sido desinstalado correctamente."
    fi
    echo "Avirato PMS desinstalado correctamente"
    exit 0
else
    if [ "$USE_ZENITY" = true ]; then
        zenity --error --text="Error durante la desinstalación. Algunos archivos pueden no haberse eliminado."
    fi
    echo "Error durante la desinstalación"
    exit 1
fi

