/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.syntheticaaddons;

import de.javasoft.syntheticaaddons.SyntheticaAddons;
import de.javasoft.syntheticaaddons.ui.addons.DateComboBoxAddon;
import de.javasoft.syntheticaaddons.ui.datecombobox.DateComboBoxMonthView;
import de.javasoft.syntheticaaddons.ui.datecombobox.DateComboBoxPopup;
import de.javasoft.syntheticaaddons.ui.datecombobox.DateComboBoxUI;
import java.awt.event.ActionListener;
import java.text.DateFormat;
import java.util.Date;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.text.DefaultFormatterFactory;
import org.jdesktop.swingx.calendar.DatePickerFormatter;
import org.jdesktop.swingx.plaf.AbstractComponentAddon;
import org.jdesktop.swingx.plaf.ComponentAddon;
import org.jdesktop.swingx.plaf.LookAndFeelAddons;

public class DateComboBox
extends JComboBox<Object> {
    private static final long serialVersionUID = -7632254110701579290L;
    public static final String uiClassID = "DateComboBoxUI";
    private DateFormat[] dateFormats;
    private DateComboBoxPopup popup;
    protected static AbstractComponentAddon addon = new DateComboBoxAddon();

    static {
        SyntheticaAddons.contribute((ComponentAddon)addon);
    }

    public DateComboBox() {
        this(new Date().getTime());
    }

    public DateComboBox(Date date) {
        this(date.getTime());
    }

    public DateComboBox(Long l) {
        this.setName("DateComboBox");
        this.setDateFormat(DateFormat.getDateInstance(2));
        this.setDate(l);
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    @Override
    public void updateUI() {
        if (this.popup != null) {
            this.popup.updateUI();
        }
        this.setUI(LookAndFeelAddons.getUI((JComponent)this, DateComboBoxUI.class));
    }

    public void setDate(Date date) {
        if (date == null) {
            this.setDate((Long)null);
        } else {
            this.setDate(date.getTime());
        }
    }

    public void setDate(Long l) {
        if (this.getItemCount() > 0) {
            ActionListener actionListener;
            ActionListener[] actionListenerArray;
            ActionListener[] actionListenerArray2 = actionListenerArray = this.getActionListeners();
            int n = actionListenerArray.length;
            int n2 = 0;
            while (n2 < n) {
                actionListener = actionListenerArray2[n2];
                this.removeActionListener(actionListener);
                ++n2;
            }
            this.removeItemAt(0);
            actionListenerArray2 = actionListenerArray;
            n = actionListenerArray.length;
            n2 = 0;
            while (n2 < n) {
                actionListener = actionListenerArray2[n2];
                this.addActionListener(actionListener);
                ++n2;
            }
        }
        if (l == null) {
            this.popup.getMonthView().clearSelection();
            this.getDateField().setValue(null);
            this.getDateField().setText("");
            this.addItem((Object)null);
            this.fireActionEvent();
        } else {
            this.getDateField().setValue(new Date(l));
            this.popup.getMonthView().setSelectionInterval(new Date(l), new Date(l));
            ((DateComboBoxMonthView)this.popup.getMonthView()).ensureDateVisible();
            this.addItem(new Date(l));
        }
        this.repaint();
    }

    public Date getDate() {
        if (this.popup.getMonthView().isSelectionEmpty()) {
            return null;
        }
        return (Date)this.popup.getMonthView().getSelection().first();
    }

    public Date getDateTime() {
        if (!this.isEditable) {
            return this.getDate();
        }
        Object object = this.getDateField().getValue();
        if (object instanceof Date) {
            return (Date)object;
        }
        if (object instanceof Long) {
            return new Date((Long)object);
        }
        return null;
    }

    public String getFormattedDate() {
        return this.dateFormats[0].format(this.getDate());
    }

    public void setDateFormat(DateFormat dateFormat) {
        this.setDateFormats(new DateFormat[]{dateFormat});
    }

    public void setDateFormats(DateFormat[] dateFormatArray) {
        this.dateFormats = dateFormatArray;
        this.getDateField().setFormatterFactory(new DefaultFormatterFactory((JFormattedTextField.AbstractFormatter)new DatePickerFormatter(dateFormatArray)));
    }

    public DateFormat[] getDateFormats() {
        return this.dateFormats;
    }

    private JFormattedTextField getDateField() {
        return (JFormattedTextField)this.getEditor().getEditorComponent();
    }

    public DateComboBoxPopup getPopup() {
        return this.popup;
    }

    public void setPopup(DateComboBoxPopup dateComboBoxPopup) {
        this.popup = dateComboBoxPopup;
    }

    @Override
    public void setSelectedIndex(int n) {
    }

    @Override
    public int getSelectedIndex() {
        return 0;
    }

    @Override
    public void addItem(Object object) {
        if (this.getItemCount() == 0) {
            super.addItem(object);
        }
    }

    public boolean isEmpty() {
        return this.popup.getMonthView().isSelectionEmpty();
    }

    @Override
    public Object getSelectedItem() {
        return this.getDateTime();
    }
}

