/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.syntheticaaddons;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.syntheticaaddons.SyntheticaAddons;
import de.javasoft.syntheticaaddons.SyntheticaAddonsUtilities;
import de.javasoft.syntheticaaddons.ui.DetailsDialogUI;
import de.javasoft.syntheticaaddons.ui.addons.DetailsDialogAddon;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.Spring;
import javax.swing.SpringLayout;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLEditorKit;
import org.jdesktop.swingx.JXTitledSeparator;
import org.jdesktop.swingx.plaf.AbstractComponentAddon;
import org.jdesktop.swingx.plaf.ComponentAddon;
import org.jdesktop.swingx.plaf.LookAndFeelAddons;

public class DetailsDialog
extends JComponent {
    private static final long serialVersionUID = 5226616259351485637L;
    public static final String uiClassID = "DetailsDialogUI";
    public static final int UNKNOWN_TYPE = -1;
    public static final int INFO_TYPE = 0;
    public static final int WARNING_TYPE = 1;
    public static final int ERROR_TYPE = 2;
    private final Icon INFO_ICON = UIManager.getIcon("OptionPane.informationIcon");
    private final Icon WARNING_ICON = UIManager.getIcon("OptionPane.warningIcon");
    private final Icon ERROR_ICON = UIManager.getIcon("OptionPane.errorIcon");
    private int type = -1;
    private JLabel icon = new JLabel();
    private JScrollPane messagePane;
    private JScrollPane detailsPane;
    private JButton detailsButton;
    private JButton okButton;
    private int messageWidth = SyntheticaLookAndFeel.getInstance().scaleInteger(Integer.valueOf(400));
    private int messageHeight = SyntheticaLookAndFeel.getInstance().scaleInteger(Integer.valueOf(55));
    private int detailsHeight = SyntheticaLookAndFeel.getInstance().scaleInteger(Integer.valueOf(250));
    private boolean details = false;
    private boolean lineWrap = false;
    private int xGap = SyntheticaLookAndFeel.getInstance().scaleInteger(Integer.valueOf(5));
    private int yGap = SyntheticaLookAndFeel.getInstance().scaleInteger(Integer.valueOf(8));
    private JDialog dialog = null;
    protected static AbstractComponentAddon addon = new DetailsDialogAddon();

    static {
        SyntheticaAddons.contribute((ComponentAddon)addon);
    }

    public DetailsDialog(Window window, boolean bl) {
        this(window, bl, null);
    }

    public DetailsDialog(Window window, boolean bl, Locale locale) {
        this.dialog = window instanceof Frame ? new JDialog((Frame)window, bl) : new JDialog((Dialog)window, bl);
        if (locale != null) {
            this.setLocale(locale);
        }
        this.setUI(UIManager.getUI(this));
        this.init();
    }

    public JDialog getDialog() {
        return this.dialog;
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    @Override
    public void updateUI() {
        this.setUI(LookAndFeelAddons.getUI((JComponent)this, DetailsDialogUI.class));
    }

    public static void showDialog(Window window, String string, String string2, Throwable throwable, Locale locale) {
        StringWriter stringWriter = new StringWriter();
        throwable.printStackTrace(new PrintWriter(stringWriter));
        String string3 = stringWriter.getBuffer().toString();
        if (string2 == null) {
            string2 = throwable.getMessage();
        }
        DetailsDialog.showDialog(window, string, string2, string3, 2, locale);
    }

    public static void showDialog(Window window, String string, String string2, Throwable throwable) {
        DetailsDialog.showDialog(window, string, string2, throwable, null);
    }

    public static void showDialog(Window window, String string, String string2, String string3, int n, Locale locale) {
        DetailsDialog detailsDialog = new DetailsDialog(window, true, locale);
        detailsDialog.init();
        detailsDialog.setTitle(string);
        detailsDialog.setMessage(string2);
        detailsDialog.setDetails(string3);
        detailsDialog.setType(n);
        detailsDialog.showDialog();
    }

    public static void showDialog(Window window, String string, String string2, String string3, int n) {
        DetailsDialog.showDialog(window, string, string2, string3, n, null);
    }

    public void showDialog() {
        this.addComponents();
        this.dialog.pack();
        this.dialog.setLocationRelativeTo(this.dialog.getOwner());
        this.dialog.setVisible(true);
    }

    private void init() {
        this.dialog.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), "closeDialog");
        this.dialog.getRootPane().getActionMap().put("closeDialog", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SwingUtilities.getWindowAncestor((Component)actionEvent.getSource()).dispose();
            }
        });
        this.messagePane = new JScrollPane(new JTextPane());
        this.messagePane.setOpaque(false);
        if (this.lineWrap) {
            this.detailsPane = new JScrollPane(new JTextPane());
        } else {
            JPanel jPanel = new JPanel(new BorderLayout());
            jPanel.add(new JTextPane());
            this.detailsPane = new JScrollPane(jPanel);
        }
        this.detailsPane.setOpaque(false);
        this.addComponents();
        this.dialog.addComponentListener(new ComponentListener(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                DetailsDialog.this.addComponents();
                JDialog jDialog = (JDialog)componentEvent.getComponent();
                jDialog.getRootPane().revalidate();
                jDialog.getRootPane().repaint();
            }

            @Override
            public void componentMoved(ComponentEvent componentEvent) {
            }

            @Override
            public void componentShown(ComponentEvent componentEvent) {
            }

            @Override
            public void componentHidden(ComponentEvent componentEvent) {
            }
        });
    }

    private void addComponents() {
        this.dialog.getContentPane().removeAll();
        this.dialog.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = this.details ? 0.0 : 1.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = this.details ? 2 : 1;
        gridBagConstraints.insets = new Insets(0, 0, this.yGap, 0);
        this.dialog.add((Component)this.createMessagePanel(), gridBagConstraints);
        if (this.details) {
            ++gridBagConstraints.gridy;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.fill = 1;
            this.dialog.add((Component)this.createDetailsPanel(), gridBagConstraints);
        }
        ++gridBagConstraints.gridy;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.dialog.add((Component)this.createButtonsPanel(), gridBagConstraints);
        ((JPanel)this.dialog.getContentPane()).setBorder(new EmptyBorder(this.yGap, this.xGap, this.yGap, this.xGap));
    }

    private JPanel createMessagePanel() {
        this.messagePane.setBorder(SyntheticaLookAndFeel.getInstance().createEmptyBorder(0, 0, 0, 0, true));
        JTextPane jTextPane = (JTextPane)this.messagePane.getViewport().getView();
        jTextPane.setEditable(false);
        jTextPane.setOpaque(false);
        jTextPane.putClientProperty("Synthetica.opaque", Boolean.FALSE);
        jTextPane.setCaretPosition(0);
        JPanel jPanel = new JPanel(new GridBagLayout()){
            private static final long serialVersionUID = 8449172557508808235L;

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(DetailsDialog.this.messageWidth + ((DetailsDialog)DetailsDialog.this).icon.getSize().width + DetailsDialog.this.xGap, Math.max(((DetailsDialog)DetailsDialog.this).icon.getPreferredSize().height, Math.max(DetailsDialog.this.messageHeight, ((DetailsDialog)DetailsDialog.this).messagePane.getPreferredSize().height)));
            }
        };
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 18;
        jPanel.add((Component)this.icon, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        int n = Math.max(0, (this.icon.getPreferredSize().height - jTextPane.getPreferredSize().height) / 2);
        gridBagConstraints.insets = new Insets(n, this.xGap, 0, 0);
        jPanel.add((Component)this.messagePane, gridBagConstraints);
        return jPanel;
    }

    private JPanel createDetailsPanel() {
        this.detailsPane.setBorder(SyntheticaLookAndFeel.getInstance().createEmptyBorder(0, 0, 0, 0, true));
        JTextPane jTextPane = null;
        jTextPane = this.lineWrap ? (JTextPane)this.detailsPane.getViewport().getView() : (JTextPane)((JPanel)this.detailsPane.getViewport().getView()).getComponent(0);
        jTextPane.setEditable(false);
        jTextPane.setOpaque(false);
        jTextPane.putClientProperty("Synthetica.opaque", Boolean.FALSE);
        jTextPane.setCaretPosition(0);
        this.detailsPane.setPreferredSize(new Dimension(this.messageWidth, this.detailsHeight));
        JPanel jPanel = new JPanel(new BorderLayout());
        JXTitledSeparator jXTitledSeparator = new JXTitledSeparator();
        jXTitledSeparator.setHorizontalAlignment(0);
        jXTitledSeparator.setTitle(UIManager.getString("DetailsDialog.details"));
        jPanel.add((Component)jXTitledSeparator, "North");
        jPanel.add(this.detailsPane);
        if (this.lineWrap || this.detailsPane.getViewport().getSize().width >= this.detailsPane.getViewport().getPreferredSize().width) {
            jPanel.add((Component)new JSeparator(0), "South");
        }
        return jPanel;
    }

    private JButton getOkButton() {
        if (this.okButton == null) {
            this.okButton = new JButton(UIManager.getString("DetailsDialog.okButton"));
            this.okButton.setName("DetailsDialog.OkButton");
            this.okButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DetailsDialog.this.dialog.dispose();
                }
            });
        }
        return this.okButton;
    }

    private JButton getDetailsButton() {
        if (this.detailsButton == null) {
            this.detailsButton = new JButton();
            this.detailsButton.setName("DetailsDialog.DetailsButton");
            this.detailsButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DetailsDialog.this.details = !DetailsDialog.this.details;
                    DetailsDialog.this.addComponents();
                    DetailsDialog.this.dialog.pack();
                }
            });
        }
        if (this.details) {
            this.detailsButton.setText(UIManager.getString("DetailsDialog.detailsButtonClose"));
        } else {
            this.detailsButton.setText(UIManager.getString("DetailsDialog.detailsButtonOpen"));
        }
        return this.detailsButton;
    }

    private JPanel createButtonsPanel() {
        Object object;
        SpringLayout springLayout = new SpringLayout();
        JPanel jPanel = new JPanel(springLayout);
        jPanel.setName("DetailsDialog.ButtonPanel");
        JButton jButton = this.getOkButton();
        jPanel.add(jButton);
        JButton jButton2 = this.getDetailsButton();
        jPanel.add(jButton2);
        springLayout.putConstraint("East", (Component)jButton2, 0, "East", (Component)jPanel);
        springLayout.putConstraint("East", (Component)jButton, -this.xGap, "West", (Component)jButton2);
        int n = 0;
        Spring spring = Spring.constant(0);
        Component[] componentArray = jPanel.getComponents();
        int n2 = componentArray.length;
        int n3 = 0;
        while (n3 < n2) {
            object = componentArray[n3];
            spring = Spring.max(spring, springLayout.getConstraints((Component)object).getWidth());
            ++n3;
        }
        componentArray = jPanel.getComponents();
        n2 = componentArray.length;
        n3 = 0;
        while (n3 < n2) {
            object = componentArray[n3];
            SpringLayout.Constraints constraints = springLayout.getConstraints((Component)object);
            constraints.setWidth(spring);
            n += spring.getMinimumValue() + this.xGap;
            ++n3;
        }
        object = jPanel.getBorder();
        Dimension dimension = null;
        dimension = object != null ? new Dimension(n += object.getBorderInsets((Component)jPanel).left + object.getBorderInsets((Component)jPanel).right - this.xGap, jButton.getPreferredSize().height + object.getBorderInsets((Component)jPanel).top + object.getBorderInsets((Component)jPanel).bottom) : new Dimension(n, jButton.getPreferredSize().height);
        jPanel.setPreferredSize(dimension);
        jPanel.setMinimumSize(dimension);
        return jPanel;
    }

    public void setTitle(String string) {
        this.dialog.setTitle(string);
    }

    public String getTitle() {
        return this.dialog.getTitle();
    }

    public void setMessage(String string) {
        JTextPane jTextPane = (JTextPane)this.messagePane.getViewport().getView();
        if (string.toUpperCase().trim().startsWith("<HTML>")) {
            jTextPane.setEditorKit(new HTMLEditorKit());
            jTextPane.setContentType("text/html");
            jTextPane.addHyperlinkListener(this.createHyperlinkListener(false));
        }
        jTextPane.setText(string);
    }

    protected HyperlinkListener createHyperlinkListener(boolean bl) {
        return new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
                if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    SyntheticaAddonsUtilities.openInBrowser(hyperlinkEvent.getURL().toExternalForm());
                }
            }
        };
    }

    public String getMessage() {
        return ((JTextPane)this.messagePane.getViewport().getView()).getText();
    }

    public void setDetails(String string) {
        JTextPane jTextPane = null;
        jTextPane = this.lineWrap ? (JTextPane)this.detailsPane.getViewport().getView() : (JTextPane)((JPanel)this.detailsPane.getViewport().getView()).getComponent(0);
        if (string.toUpperCase().trim().startsWith("<HTML>")) {
            jTextPane.setEditorKit(new HTMLEditorKit());
            jTextPane.setContentType("text/html");
            jTextPane.addHyperlinkListener(this.createHyperlinkListener(true));
        }
        jTextPane.setText(string);
    }

    public String getDetails() {
        if (this.lineWrap) {
            return ((JTextPane)this.detailsPane.getViewport().getView()).getText();
        }
        return ((JTextPane)((JPanel)this.detailsPane.getViewport().getView()).getComponent(0)).getText();
    }

    public void setIcon(Icon icon) {
        this.icon.setIcon(icon);
    }

    public Icon getIcon() {
        return this.icon.getIcon();
    }

    public void setType(int n) {
        this.type = n;
        if (n == 0) {
            if (this.icon.getIcon() == null) {
                this.setIcon(this.INFO_ICON);
            }
            if (this.getTitle() == null) {
                this.setTitle(UIManager.getString("DetailsDialog.infoTitle"));
            }
        } else if (n == 1) {
            if (this.icon.getIcon() == null) {
                this.setIcon(this.WARNING_ICON);
            }
            if (this.getTitle() == null) {
                this.setTitle(UIManager.getString("DetailsDialog.warningTitle"));
            }
        } else if (n == 2) {
            if (this.icon.getIcon() == null) {
                this.setIcon(this.ERROR_ICON);
            }
            if (this.getTitle() == null) {
                this.setTitle(UIManager.getString("DetailsDialog.errorTitle"));
            }
        } else if (this.icon.getIcon() == null) {
            this.setIcon(null);
        }
    }

    public int getType() {
        return this.type;
    }
}

