/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.syntheticaaddons.table;

import de.javasoft.syntheticaaddons.table.FormattedTextFieldTableCellEditor;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.Serializable;
import java.text.ParseException;
import javax.swing.JFormattedTextField;
import javax.swing.table.TableCellEditor;
import javax.swing.text.DefaultFormatterFactory;

public class IntegerGroupTableCellEditor
extends FormattedTextFieldTableCellEditor {
    private String delimiter;
    private int numberOfNumbers;
    private Class<?> dataClass;

    public IntegerGroupTableCellEditor(TableCellEditor tableCellEditor, Class<?> clazz, int n) {
        this(tableCellEditor, clazz, n, ',');
    }

    public IntegerGroupTableCellEditor(TableCellEditor tableCellEditor, Class<?> clazz, int n, char c) {
        super(tableCellEditor);
        this.delimiter = String.valueOf(c);
        this.numberOfNumbers = n;
        this.dataClass = clazz;
        ((JFormattedTextField)this.editorComponent).setFormatterFactory(new DefaultFormatterFactory(new Formatter()));
    }

    private class Formatter
    extends JFormattedTextField.AbstractFormatter {
        private Formatter() {
        }

        @Override
        public Object stringToValue(String string) throws ParseException {
            String[] stringArray = string.split(IntegerGroupTableCellEditor.this.delimiter);
            int[] nArray = new int[IntegerGroupTableCellEditor.this.numberOfNumbers];
            if (stringArray.length != IntegerGroupTableCellEditor.this.numberOfNumbers) {
                throw new ParseException("Required number: " + IntegerGroupTableCellEditor.this.numberOfNumbers, -1);
            }
            int n = 0;
            while (n < nArray.length) {
                try {
                    nArray[n] = Integer.parseInt(stringArray[n].trim());
                }
                catch (NumberFormatException numberFormatException) {
                    throw new ParseException(numberFormatException.getMessage(), -1);
                }
                ++n;
            }
            Serializable serializable = null;
            if (IntegerGroupTableCellEditor.this.dataClass == Integer.class) {
                serializable = nArray[0];
            } else if (IntegerGroupTableCellEditor.this.dataClass == Point.class) {
                serializable = new Point(nArray[0], nArray[1]);
            } else if (IntegerGroupTableCellEditor.this.dataClass == Dimension.class) {
                serializable = new Dimension(nArray[0], nArray[1]);
            } else if (IntegerGroupTableCellEditor.this.dataClass == Rectangle.class) {
                serializable = new Rectangle(nArray[0], nArray[1], nArray[2], nArray[3]);
            } else if (IntegerGroupTableCellEditor.this.dataClass == Insets.class) {
                serializable = new Insets(nArray[0], nArray[1], nArray[2], nArray[3]);
            } else if (IntegerGroupTableCellEditor.this.dataClass == Color.class) {
                try {
                    serializable = nArray.length == 3 ? new Color(nArray[0], nArray[1], nArray[2]) : new Color(nArray[0], nArray[1], nArray[2], nArray[3]);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new ParseException(illegalArgumentException.getMessage(), -1);
                }
            }
            return serializable;
        }

        @Override
        public String valueToString(Object object) throws ParseException {
            if (object == null) {
                return null;
            }
            String string = null;
            if (object.getClass() == Integer.class) {
                string = object.toString();
            } else if (object.getClass() == Point.class) {
                Point point = (Point)object;
                string = String.valueOf(point.x) + IntegerGroupTableCellEditor.this.delimiter + " " + point.y;
            } else if (object.getClass() == Dimension.class) {
                Dimension dimension = (Dimension)object;
                string = String.valueOf(dimension.width) + IntegerGroupTableCellEditor.this.delimiter + " " + dimension.height;
            } else if (object.getClass() == Rectangle.class) {
                Rectangle rectangle = (Rectangle)object;
                string = String.valueOf(rectangle.x) + IntegerGroupTableCellEditor.this.delimiter + " " + rectangle.y + IntegerGroupTableCellEditor.this.delimiter + " " + rectangle.width + IntegerGroupTableCellEditor.this.delimiter + " " + rectangle.height;
            } else if (object.getClass() == Insets.class) {
                Insets insets = (Insets)object;
                string = String.valueOf(insets.top) + IntegerGroupTableCellEditor.this.delimiter + " " + insets.left + IntegerGroupTableCellEditor.this.delimiter + " " + insets.bottom + IntegerGroupTableCellEditor.this.delimiter + " " + insets.right;
            } else if (object.getClass() == Color.class) {
                Color color = (Color)object;
                string = String.valueOf(color.getRed()) + IntegerGroupTableCellEditor.this.delimiter + " " + color.getGreen() + IntegerGroupTableCellEditor.this.delimiter + " " + color.getBlue() + IntegerGroupTableCellEditor.this.delimiter + " " + color.getAlpha();
            }
            return string;
        }
    }
}

