/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.syntheticaaddons.table;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.syntheticaaddons.table.AbstractTableCellRenderer;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JTextField;
import javax.swing.table.TableCellRenderer;

public class IntegerGroupTableCellRenderer
extends AbstractTableCellRenderer<JTextField> {
    private String delimiter;

    public IntegerGroupTableCellRenderer(TableCellRenderer tableCellRenderer) {
        this(tableCellRenderer, ',');
    }

    public IntegerGroupTableCellRenderer(TableCellRenderer tableCellRenderer, char c) {
        super(tableCellRenderer);
        this.delimiter = String.valueOf(c);
    }

    @Override
    protected JTextField createRendererComponent() {
        JTextField jTextField = new JTextField();
        jTextField.setBorder(SyntheticaLookAndFeel.getInstance().createEmptyBorder(0, 0, 0, 0, true));
        jTextField.putClientProperty("Synthetica.opaque", false);
        return jTextField;
    }

    @Override
    protected void setValue(JTextField jTextField, Object object) {
        String string = null;
        if (object.getClass() == Integer.class) {
            string = object.toString();
        } else if (object.getClass() == Point.class) {
            Point point = (Point)object;
            string = String.valueOf(point.x) + this.delimiter + " " + point.y;
        } else if (object.getClass() == Dimension.class) {
            Dimension dimension = (Dimension)object;
            string = String.valueOf(dimension.width) + this.delimiter + " " + dimension.height;
        } else if (object.getClass() == Rectangle.class) {
            Rectangle rectangle = (Rectangle)object;
            string = String.valueOf(rectangle.x) + this.delimiter + " " + rectangle.y + this.delimiter + " " + rectangle.width + this.delimiter + " " + rectangle.height;
        } else if (object.getClass() == Insets.class) {
            Insets insets = (Insets)object;
            string = String.valueOf(insets.top) + this.delimiter + " " + insets.left + this.delimiter + " " + insets.bottom + this.delimiter + " " + insets.right;
        } else if (object.getClass() == Color.class) {
            Color color = (Color)object;
            string = String.valueOf(color.getRed()) + this.delimiter + " " + color.getGreen() + this.delimiter + " " + color.getBlue() + this.delimiter + " " + color.getAlpha();
        }
        jTextField.setText(string);
    }
}

