/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.syntheticaaddons.ui;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.SyntheticaState;
import de.javasoft.syntheticaaddons.ui.painter.HyperlinkPainter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.synth.ColorType;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.swing.plaf.synth.SynthStyle;
import javax.swing.text.View;
import org.jdesktop.swingx.JXHyperlink;
import org.jdesktop.swingx.plaf.basic.BasicHyperlinkUI;

public class HyperlinkUI
extends BasicHyperlinkUI {
    public static ComponentUI createUI(JComponent jComponent) {
        return new HyperlinkUI();
    }

    protected void installDefaults(AbstractButton abstractButton) {
        Color color;
        JXHyperlink jXHyperlink;
        Color color2;
        super.installDefaults(abstractButton);
        abstractButton.setFocusable(true);
        Font font = abstractButton.getFont();
        if (font instanceof FontUIResource) {
            float f = font.getSize2D();
            abstractButton.setFont(new FontUIResource(font.deriveFont(0, f)));
        }
        if ((color2 = (jXHyperlink = (JXHyperlink)abstractButton).getUnclickedColor()) == null || color2 instanceof UIResource) {
            color = SyntheticaLookAndFeel.getColor((String)"JXHyperlink.unclickedColor", (Component)abstractButton, (Color)new ColorUIResource(13311));
            jXHyperlink.setUnclickedColor(color);
        }
        if ((color = jXHyperlink.getClickedColor()) == null || color instanceof UIResource) {
            Color color3 = SyntheticaLookAndFeel.getColor((String)"JXHyperlink.clickedColor", (Component)abstractButton, (Color)new ColorUIResource(0x990099));
            jXHyperlink.setClickedColor(color3);
        }
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        Rectangle rectangle = new Rectangle(0, 0, 0, 0);
        Rectangle rectangle2 = new Rectangle(0, 0, 0, 0);
        Rectangle rectangle3 = new Rectangle(0, 0, 0, 0);
        int n = jComponent.isEnabled() ? 0 : 8;
        AbstractButton abstractButton = (AbstractButton)jComponent;
        ButtonModel buttonModel = abstractButton.getModel();
        boolean bl = buttonModel.isRollover();
        Insets insets = jComponent.getInsets();
        rectangle.x = insets.left;
        rectangle.y = insets.top;
        rectangle.width = abstractButton.getWidth() - (insets.right + rectangle.x);
        rectangle.height = abstractButton.getHeight() - (insets.bottom + rectangle.y);
        int n2 = abstractButton.getText() == null ? 0 : abstractButton.getIconTextGap();
        SynthStyle synthStyle = SynthLookAndFeel.getStyle(abstractButton, Region.BUTTON);
        SynthContext synthContext = new SynthContext(abstractButton, Region.BUTTON, synthStyle, n);
        String string = synthStyle.getGraphicsUtils(synthContext).layoutText(synthContext, graphics.getFontMetrics(), abstractButton.getText(), abstractButton.getIcon(), abstractButton.getHorizontalAlignment(), abstractButton.getVerticalAlignment(), abstractButton.getHorizontalTextPosition(), abstractButton.getVerticalTextPosition(), rectangle, rectangle3, rectangle2, n2);
        this.clearTextShiftOffset();
        if (abstractButton.getIcon() != null) {
            this.paintIcon(graphics, jComponent, rectangle3);
        }
        if (string != null && string.trim().length() > 0) {
            View view = (View)jComponent.getClientProperty("html");
            if (view != null) {
                this.paintHTMLText(graphics, abstractButton, rectangle2, string, view);
            } else {
                if (n == 8) {
                    graphics.setColor(synthStyle.getColor(synthContext, ColorType.TEXT_FOREGROUND));
                } else {
                    graphics.setColor(abstractButton.getForeground());
                }
                synthStyle.getGraphicsUtils(synthContext).paintText(synthContext, graphics, string, rectangle2, abstractButton.getDisplayedMnemonicIndex());
                if (bl) {
                    this.paintUnderline(graphics, string, rectangle2);
                }
            }
        }
        if (abstractButton.isFocusPainted() && abstractButton.hasFocus()) {
            this.paintFocus(graphics, abstractButton, rectangle, rectangle2, rectangle3);
        }
    }

    private void paintUnderline(Graphics graphics, String string, Rectangle rectangle) {
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n = rectangle.x + this.getTextShiftOffset();
        int n2 = rectangle.x + rectangle.width + this.getTextShiftOffset();
        int n3 = rectangle.y + rectangle.height - fontMetrics.getDescent() + this.getTextShiftOffset() + 1;
        graphics.drawLine(n, n3, n2, n3);
    }

    protected void paintFocus(Graphics graphics, AbstractButton abstractButton, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3) {
        int n = abstractButton.getWidth();
        int n2 = abstractButton.getHeight();
        HyperlinkPainter.getInstance().paintHyperlinkFocus(abstractButton, new SyntheticaState(), graphics, 0, 0, n, n2);
    }
}

