/*
 * Decompiled with CFR 0.152.
 */
package icu.jnet.whatsjava.encryption;

import com.google.gson.Gson;
import com.google.protobuf.InvalidProtocolBufferException;
import icu.jnet.whatsjava.constants.BinaryConstants;
import icu.jnet.whatsjava.encryption.proto.ProtoBuf;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;

public class BinaryDecoder {
    private byte[] buffer;
    private int index = 0;

    public String decode(byte[] buffer) {
        this.buffer = buffer;
        this.index = 0;
        return this.readNode();
    }

    private int unpackNibble(int value) {
        if (value >= 0 && value <= 9) {
            return 48 + value;
        }
        switch (value) {
            case 10: {
                return 45;
            }
            case 11: {
                return 46;
            }
            case 15: {
                return 0;
            }
        }
        System.err.println("Invalid nibble: " + value);
        return 0;
    }

    private int unpackHex(int value) {
        if (value >= 0 && value <= 15) {
            return value < 10 ? 48 + value : 65 + value - 10;
        }
        System.err.println("Invalid hex: " + value);
        return 0;
    }

    private int unpackByte(int tag, int value) {
        if (tag == 255) {
            return this.unpackNibble(value);
        }
        if (tag == 251) {
            return this.unpackHex(value);
        }
        System.err.println("Unknown tag: " + tag);
        return 0;
    }

    private int readInt(int n, boolean littleEndian) {
        this.checkEOS(n);
        int val = 0;
        for (int i = 0; i < n; ++i) {
            int shift = littleEndian ? i : n - 1 - i;
            val |= this.next() << shift * 8;
        }
        return val;
    }

    private int readInt20() {
        this.checkEOS(3);
        int a = this.next() & 0xFF;
        int b = this.next() & 0xFF;
        int c = this.next() & 0xFF;
        return ((a & 0xF) << 16) + (b << 8) + c;
    }

    private String readPacked8(int tag) {
        byte startByte = this.readByte();
        Object value = "";
        for (int i = 0; i < (startByte & 0x7F); ++i) {
            byte curByte = this.readByte();
            int nibbleOne = this.unpackByte(tag, (curByte & 0xF0) >> 4);
            int nibbleSecond = this.unpackByte(tag, curByte & 0xF);
            value = (String)value + String.valueOf(Character.toChars(nibbleOne));
            value = (String)value + String.valueOf(Character.toChars(nibbleSecond));
        }
        if (startByte >> 7 != 0) {
            value = ((String)value).substring(0, ((String)value).length() - 1);
        }
        return value;
    }

    private byte[] readBytes(int n) {
        this.checkEOS(n);
        byte[] byteArray = Arrays.copyOfRange(this.buffer, this.index, this.index + n);
        this.index += n;
        return byteArray;
    }

    private byte readByte() {
        this.checkEOS(1);
        return this.next();
    }

    private boolean isListTag(int tag) {
        return tag == 0 || tag == 248 || tag == 249;
    }

    private int readListSize(int tag) {
        switch (tag) {
            case 0: {
                return 0;
            }
            case 248: {
                return this.readByte();
            }
            case 249: {
                return this.readInt(2, false);
            }
        }
        System.err.println("Invalid tag for list size: " + tag);
        return 0;
    }

    private String readStringFromCharacters(int length) {
        this.checkEOS(length);
        byte[] value = Arrays.copyOfRange(this.buffer, this.index, this.index + length);
        this.index += length;
        return new String(value);
    }

    private String getToken(int index) {
        if (index < 3 || index >= BinaryConstants.singleByteTokens.length) {
            System.err.println("Invalid token index: " + index);
        }
        return BinaryConstants.singleByteTokens[index];
    }

    private String getDoubleToken(int a, int b) {
        int n = a * 256 + b;
        if (n < 0 || n > BinaryConstants.doubleByteTokens.length) {
            System.err.println("Invalid token index: " + this.index);
        }
        try {
            return BinaryConstants.doubleByteTokens[n];
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private String readString(int tag) {
        if (tag >= 3 && tag <= 235) {
            String token = this.getToken(tag);
            return token.equals("s.whatsapp.net") ? "c.us" : token;
        }
        switch (tag) {
            case 236: 
            case 237: 
            case 238: 
            case 239: {
                return this.getDoubleToken(tag - 236, this.readByte());
            }
            case 0: {
                return null;
            }
            case 252: {
                return this.readStringFromCharacters(this.readByte());
            }
            case 253: {
                return this.readStringFromCharacters(this.readInt20());
            }
            case 254: {
                return this.readStringFromCharacters(this.readInt(4, false));
            }
            case 250: {
                String i = this.readString(this.readByte() & 0xFF);
                String j = this.readString(this.readByte() & 0xFF);
                if (i != null && j != null) {
                    return i + "@" + j;
                }
                System.err.println("Invalid jid pair: " + i + ", " + j);
            }
            case 251: 
            case 255: {
                return this.readPacked8(tag);
            }
        }
        System.err.println("Invalid tag: " + tag);
        return null;
    }

    private String readAttributes(int n) {
        if (n != 0) {
            HashMap<String, String> attributeMap = new HashMap<String, String>();
            for (int i = 0; i < n; ++i) {
                String key = this.readString(this.readByte() & 0xFF);
                String value = this.readString(this.readByte() & 0xFF);
                attributeMap.put(key, value);
            }
            return new Gson().toJson(attributeMap);
        }
        return null;
    }

    private String readNode() {
        int readByte = this.readByte() & 0xFF;
        int listSize = this.readListSize(readByte);
        int descrTag = this.readByte() & 0xFF;
        if (descrTag == 2) {
            System.err.println("Unexpected stream end");
        }
        String descr = this.readString(descrTag);
        if (listSize == 0 || descr == null) {
            System.err.println("Invalid node");
        }
        String attrs = this.readAttributes(listSize - 1 >> 1);
        String[] content = null;
        if (listSize % 2 == 0) {
            int tag = this.readByte() & 0xFF;
            if (this.isListTag(tag)) {
                content = this.readList(tag);
            } else {
                String decodedString = "";
                byte[] decodedArray = null;
                switch (tag) {
                    case 252: {
                        decodedArray = this.readBytes(this.readByte() & 0xFF);
                        break;
                    }
                    case 253: {
                        decodedArray = this.readBytes(this.readInt20());
                        break;
                    }
                    case 254: {
                        decodedArray = this.readBytes(this.readInt(4, false));
                        break;
                    }
                    default: {
                        decodedString = this.readString(tag);
                    }
                }
                if (descr.equals("message") && decodedArray != null) {
                    try {
                        String base64Decoded = Base64.getEncoder().encodeToString(ProtoBuf.WebMessageInfo.parseFrom(decodedArray).toByteArray());
                        content = new String[]{"\"" + base64Decoded + "\""};
                    }
                    catch (InvalidProtocolBufferException e) {
                        e.printStackTrace();
                    }
                } else {
                    content = new String[]{"\"" + decodedString + "\""};
                }
            }
        }
        return "[\"" + descr + "\", " + attrs + ", " + Arrays.toString(content) + "]";
    }

    private String[] readList(int tag) {
        String[] arr = new String[this.readListSize(tag)];
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = this.readNode();
        }
        return arr;
    }

    private void checkEOS(int length) {
        if (this.index + length > this.buffer.length) {
            System.err.println("End of stream");
        }
    }

    private byte next() {
        return this.buffer[this.index++];
    }
}

