/*
 * Decompiled with CFR 0.152.
 */
package icu.jnet.whatsjava.encryption;

import icu.jnet.whatsjava.encryption.AES;
import icu.jnet.whatsjava.encryption.EncryptionKeyPair;
import icu.jnet.whatsjava.helper.Utils;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Base64;
import org.whispersystems.curve25519.Curve25519;

public class EncryptionKeys {
    public static EncryptionKeyPair generate(String base64Secret, byte[] privateKey) {
        byte[] decryptKey;
        byte[] secretEnc;
        byte[] sharedEnc;
        byte[] keysEncrypted;
        byte[] keysDecrypted;
        byte[] secret = Base64.getDecoder().decode(base64Secret);
        if (secret.length != 144) {
            System.err.println("Invalid secret length received: " + secret.length);
            return null;
        }
        byte[] publicKey = Arrays.copyOfRange(secret, 0, 32);
        byte[] sharedSecret = Curve25519.getInstance("best").calculateAgreement(publicKey, privateKey);
        byte[] sharedSecretExpanded = Utils.expandUsingHKDF(sharedSecret, 80, null);
        boolean valid = EncryptionKeys.hmacValidate(sharedSecretExpanded, secret);
        if (valid && (keysDecrypted = AES.decrypt(keysEncrypted = ByteBuffer.allocate((sharedEnc = Arrays.copyOfRange(sharedSecretExpanded, 64, sharedSecretExpanded.length)).length + (secretEnc = Arrays.copyOfRange(secret, 64, secret.length)).length).put(sharedEnc).put(secretEnc).array(), decryptKey = Arrays.copyOfRange(sharedSecretExpanded, 0, 32))).length == 64) {
            byte[] encKey = Arrays.copyOfRange(keysDecrypted, 0, 32);
            byte[] macKey = Arrays.copyOfRange(keysDecrypted, 32, 64);
            return new EncryptionKeyPair(encKey, macKey);
        }
        return null;
    }

    private static boolean hmacValidate(byte[] sharedSecretExpanded, byte[] secret) {
        byte[] hmacValidationKey = Arrays.copyOfRange(sharedSecretExpanded, 32, 64);
        byte[] hmacSecretA = Arrays.copyOfRange(secret, 0, 32);
        byte[] hmacSecretB = Arrays.copyOfRange(secret, 64, secret.length);
        byte[] hmacValidationMessage = ByteBuffer.allocate(hmacSecretA.length + hmacSecretB.length).put(hmacSecretA).put(hmacSecretB).array();
        byte[] hmac = Utils.signHMAC(hmacValidationKey, hmacValidationMessage);
        return Arrays.equals(hmac, Arrays.copyOfRange(secret, 32, 64));
    }
}

