/*
 * Decompiled with CFR 0.152.
 */
package icu.jnet.whatsjava.helper;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import icu.jnet.whatsjava.encryption.CurveKeyPair;
import icu.jnet.whatsjava.encryption.EncryptionKeyPair;
import icu.jnet.whatsjava.encryption.EncryptionKeys;
import icu.jnet.whatsjava.helper.Utils;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Base64;
import java.util.List;
import org.whispersystems.curve25519.Curve25519;
import org.whispersystems.curve25519.Curve25519KeyPair;

public class AuthCredentials {
    private final String clientId;
    private String serverToken;
    private String clientToken;
    private String encKey;
    private String macKey;
    private String curvePrivateKey;
    private String curvePublicKey;

    public AuthCredentials(String clientId, String serverToken, String clientToken, String encKey, String macKey) {
        this.clientId = clientId;
        this.clientToken = clientToken;
        this.serverToken = serverToken;
        this.encKey = encKey;
        this.macKey = macKey;
    }

    public AuthCredentials() {
        this.clientId = Base64.getEncoder().encodeToString(Utils.randomBytes(16));
        Curve25519KeyPair curveKeys = Curve25519.getInstance("best").generateKeyPair();
        this.curvePrivateKey = Base64.getEncoder().encodeToString(curveKeys.getPrivateKey());
        this.curvePublicKey = Base64.getEncoder().encodeToString(curveKeys.getPublicKey());
    }

    public void setSessionEncryptionInfo(String clientToken, String serverToken, String secret) {
        EncryptionKeyPair keyPair = EncryptionKeys.generate(secret, this.getCurveKeyPair().getPrivateKey());
        String encKey = Base64.getEncoder().encodeToString(keyPair.getEncKey());
        String macKey = Base64.getEncoder().encodeToString(keyPair.getMacKey());
        this.clientToken = clientToken;
        this.serverToken = serverToken;
        this.encKey = encKey;
        this.macKey = macKey;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getServerToken() {
        return this.serverToken;
    }

    public String getClientToken() {
        return this.clientToken;
    }

    public EncryptionKeyPair getEncryptionKeyPair() {
        return new EncryptionKeyPair(Base64.getDecoder().decode(this.encKey), Base64.getDecoder().decode(this.macKey));
    }

    public CurveKeyPair getCurveKeyPair() {
        return new CurveKeyPair(Base64.getDecoder().decode(this.curvePrivateKey), Base64.getDecoder().decode(this.curvePublicKey));
    }

    public boolean mayRestore() {
        return this.clientToken != null & this.serverToken != null && this.encKey != null && this.macKey != null;
    }

    public static AuthCredentials loadAuthCredentials(String authCredentialsPath) {
        if (!new File(authCredentialsPath).exists()) {
            return new AuthCredentials();
        }
        try {
            List<String> list = Files.readAllLines(Paths.get(authCredentialsPath, new String[0]));
            StringBuilder builder = new StringBuilder();
            for (String line : list) {
                builder.append(line);
            }
            JsonObject jsonCredentials = JsonParser.parseString(builder.toString()).getAsJsonObject();
            String clientId = jsonCredentials.get("clientId").getAsString();
            String serverToken = jsonCredentials.get("serverToken").getAsString();
            String clientToken = jsonCredentials.get("clientToken").getAsString();
            String encKey = jsonCredentials.get("encKey").getAsString();
            String macKey = jsonCredentials.get("macKey").getAsString();
            return new AuthCredentials(clientId, serverToken, clientToken, encKey, macKey);
        }
        catch (IOException e) {
            e.printStackTrace();
            return new AuthCredentials();
        }
    }

    public static void saveAuthCredentials(AuthCredentials credentials, String authCredentialsPath) {
        try {
            Files.writeString(Paths.get(authCredentialsPath, new String[0]), (CharSequence)new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create().toJson(credentials), new OpenOption[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void deletePreviousSession(String authCredentialsPath) {
        File file = new File(authCredentialsPath);
        if (file.exists()) {
            file.delete();
        }
    }
}

