/*
 * Decompiled with CFR 0.152.
 */
package icu.jnet.whatsjava.messages;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.protobuf.InvalidProtocolBufferException;
import icu.jnet.whatsjava.encryption.proto.ProtoBuf;
import icu.jnet.whatsjava.messages.generic.WAChat;
import icu.jnet.whatsjava.messages.generic.WAContact;
import icu.jnet.whatsjava.messages.generic.WAConversationMessage;
import icu.jnet.whatsjava.messages.generic.WAEmoji;
import icu.jnet.whatsjava.messages.generic.WAImageMessage;
import icu.jnet.whatsjava.messages.generic.WAMessage;
import icu.jnet.whatsjava.messages.generic.WAStatusMessage;
import icu.jnet.whatsjava.messages.generic.WAVideoMessage;
import icu.jnet.whatsjava.messages.stub.WAStubMessage;
import java.util.Base64;
import java.util.Set;

public class WAMessageParser {
    private static WAChat[] storedWAChats;
    private static WAContact[] storedWAContacts;

    public static Object[] jsonToObjects(String json) {
        JsonObject attributes;
        Set<String> keys;
        JsonArray node;
        Object[] objects = null;
        if (json != null && !(node = JsonParser.parseString(json).getAsJsonArray()).get(1).isJsonNull() && (keys = (attributes = node.get(1).getAsJsonObject()).keySet()).contains("type")) {
            String typeValue = attributes.get("type").getAsString();
            JsonArray childrenArray = node.get(2).isJsonArray() ? node.get(2).getAsJsonArray() : new JsonArray();
            switch (typeValue) {
                case "message": {
                    objects = WAMessageParser.messageToObject(childrenArray);
                    break;
                }
                case "chat": {
                    objects = !keys.contains("duplicate") ? WAMessageParser.chatToObject(childrenArray) : storedWAChats;
                    break;
                }
                case "contacts": {
                    objects = !keys.contains("duplicate") ? WAMessageParser.contactToObject(childrenArray) : storedWAContacts;
                    break;
                }
                case "status": {
                    objects = WAMessageParser.statusToObject(childrenArray);
                    break;
                }
                case "emoji": {
                    objects = WAMessageParser.emojiToObject(childrenArray);
                }
            }
        }
        return objects;
    }

    private static WAMessage[] messageToObject(JsonArray childrenArray) {
        WAMessage[] messages = new WAMessage[childrenArray.size()];
        for (int i = 0; i < childrenArray.size(); ++i) {
            String base64Message = childrenArray.get(i).getAsJsonArray().get(2).getAsJsonArray().get(0).getAsString();
            byte[] byteMessage = Base64.getDecoder().decode(base64Message);
            try {
                ProtoBuf.WebMessageInfo webMessageInfo = ProtoBuf.WebMessageInfo.parseFrom(byteMessage);
                WAMessage message = new WAMessage(webMessageInfo);
                if (webMessageInfo.getMessage().hasImageMessage()) {
                    message.setImageMessage(new WAImageMessage(webMessageInfo));
                } else if (webMessageInfo.getMessage().hasVideoMessage()) {
                    message.setVideoMessage(new WAVideoMessage(webMessageInfo));
                } else if (webMessageInfo.getMessage().hasConversation() || webMessageInfo.getMessage().hasExtendedTextMessage()) {
                    message.setConversationMessage(new WAConversationMessage(webMessageInfo));
                } else if (webMessageInfo.hasMessageStubType()) {
                    message.setStubMessage(new WAStubMessage(webMessageInfo));
                }
                messages[i] = message;
                continue;
            }
            catch (InvalidProtocolBufferException e) {
                e.printStackTrace();
            }
        }
        return messages;
    }

    private static WAChat[] chatToObject(JsonArray childrenArray) {
        WAChat[] WAChats = new WAChat[childrenArray.size()];
        for (int i = 0; i < childrenArray.size(); ++i) {
            JsonObject chatAttributes = childrenArray.get(i).getAsJsonArray().get(1).getAsJsonObject();
            String jid = chatAttributes.get("jid").getAsString();
            String name = chatAttributes.keySet().contains("name") ? chatAttributes.get("name").getAsString() : null;
            int unreadMessages = chatAttributes.get("count").getAsInt();
            long lastInteraction = chatAttributes.get("t").getAsLong();
            boolean muted = chatAttributes.get("mute").getAsBoolean();
            WAChats[i] = new WAChat(jid, name, unreadMessages, lastInteraction, muted);
        }
        storedWAChats = WAChats;
        return WAChats;
    }

    private static WAContact[] contactToObject(JsonArray childrenArray) {
        WAContact[] contacts = new WAContact[childrenArray.size()];
        for (int i = 0; i < childrenArray.size(); ++i) {
            JsonObject chatAttributes = childrenArray.get(i).getAsJsonArray().get(1).getAsJsonObject();
            String jid = chatAttributes.get("jid").getAsString();
            String name = chatAttributes.keySet().contains("name") ? chatAttributes.get("name").getAsString() : (chatAttributes.keySet().contains("notify") ? chatAttributes.get("notify").getAsString() : null);
            contacts[i] = new WAContact(jid, name);
        }
        storedWAContacts = contacts;
        return contacts;
    }

    private static WAStatusMessage[] statusToObject(JsonArray childrenArray) {
        JsonArray messageArray = childrenArray.get(0).getAsJsonArray().get(2).getAsJsonArray();
        WAStatusMessage[] waStatusMessages = new WAStatusMessage[messageArray.size()];
        for (int i = 0; i < messageArray.size(); ++i) {
            String base64Message = messageArray.get(i).getAsJsonArray().get(2).getAsJsonArray().get(0).getAsString();
            try {
                ProtoBuf.WebMessageInfo message = ProtoBuf.WebMessageInfo.parseFrom(Base64.getDecoder().decode(base64Message));
                if (message.getMessage().hasImageMessage()) {
                    waStatusMessages[i] = new WAStatusMessage(new WAMessage(message).setImageMessage(new WAImageMessage(message)));
                    continue;
                }
                if (!message.getMessage().hasVideoMessage()) continue;
                waStatusMessages[i] = new WAStatusMessage(new WAVideoMessage(message));
                continue;
            }
            catch (InvalidProtocolBufferException e) {
                e.printStackTrace();
            }
        }
        return waStatusMessages;
    }

    private static WAEmoji[] emojiToObject(JsonArray childrenArray) {
        WAEmoji[] waEmojis = new WAEmoji[childrenArray.size()];
        for (int i = 0; i < childrenArray.size(); ++i) {
            JsonObject emojiAttributes = childrenArray.get(i).getAsJsonArray().get(1).getAsJsonObject();
            String code = emojiAttributes.get("code").getAsString();
            double value = Double.parseDouble(emojiAttributes.get("value").getAsString());
            waEmojis[i] = new WAEmoji(code, value);
        }
        return waEmojis;
    }
}

