/*
 * Decompiled with CFR 0.152.
 */
package icu.jnet.whatsjava.messages.generic;

import icu.jnet.whatsjava.encryption.proto.ProtoBuf;
import icu.jnet.whatsjava.messages.generic.WAConversationMessage;
import icu.jnet.whatsjava.messages.generic.WAImageMessage;
import icu.jnet.whatsjava.messages.generic.WAVideoMessage;
import icu.jnet.whatsjava.messages.stub.WAStubMessage;

public class WAMessage {
    private final String remoteJid;
    private final String id;
    private final boolean fromMe;
    private final long messageTimestamp;
    private final ProtoBuf.WebMessageInfo.WEB_MESSAGE_INFO_STATUS status;
    private WAImageMessage imageMessage = null;
    private WAVideoMessage videoMessage = null;
    private WAConversationMessage conversationMessage = null;
    private WAStubMessage stubMessage = null;

    public WAMessage(ProtoBuf.WebMessageInfo message) {
        this.remoteJid = message.getKey().getRemoteJid();
        this.id = message.getKey().getId();
        this.fromMe = message.getKey().getFromMe();
        this.messageTimestamp = message.getMessageTimestamp();
        this.status = message.getStatus();
    }

    public String getRemoteJid() {
        return this.remoteJid;
    }

    public String getId() {
        return this.id;
    }

    public boolean getFromMe() {
        return this.fromMe;
    }

    public long getMessageTimestamp() {
        return this.messageTimestamp;
    }

    public ProtoBuf.WebMessageInfo.WEB_MESSAGE_INFO_STATUS getStatus() {
        return this.status;
    }

    public WAMessage setImageMessage(WAImageMessage imageMessage) {
        this.imageMessage = imageMessage;
        return this;
    }

    public WAMessage setVideoMessage(WAVideoMessage videoMessage) {
        this.videoMessage = videoMessage;
        return this;
    }

    public WAMessage setConversationMessage(WAConversationMessage conversationMessage) {
        this.conversationMessage = conversationMessage;
        return this;
    }

    public WAMessage setStubMessage(WAStubMessage stubMessage) {
        this.stubMessage = stubMessage;
        return this;
    }

    public WAImageMessage getImageMessage() {
        return this.imageMessage;
    }

    public WAConversationMessage getConversationMessage() {
        return this.conversationMessage;
    }

    public WAVideoMessage getVideoMessage() {
        return this.videoMessage;
    }

    public WAStubMessage getStubMessage() {
        return this.stubMessage;
    }

    public boolean hasImageMessage() {
        return this.imageMessage != null;
    }

    public boolean hasVideoMessage() {
        return this.videoMessage != null;
    }

    public boolean hasConversationMessage() {
        return this.conversationMessage != null;
    }

    public boolean hasStubMessage() {
        return this.stubMessage != null;
    }
}

