/*
 * Decompiled with CFR 0.152.
 */
package icu.jnet.whatsjava.messages.generic;

import icu.jnet.whatsjava.encryption.MediaEncryption;
import icu.jnet.whatsjava.encryption.proto.ProtoBuf;
import icu.jnet.whatsjava.messages.generic.WAMessage;

public class WAVideoMessage
extends WAMessage {
    private final String mimetype;
    private final String url;
    private final byte[] fileSha256;
    private final byte[] mediaKey;
    private final byte[] jpegMp4Thumbnail;
    private final byte[] mp4FullResolution;
    private final long fileLength;
    private final int seconds;
    private final ProtoBuf.VideoMessage.VIDEO_MESSAGE_ATTRIBUTION gifAttribution;
    private final boolean gifPlayback;

    public WAVideoMessage(ProtoBuf.WebMessageInfo message) {
        super(message);
        ProtoBuf.VideoMessage videoMessage = message.getMessage().getVideoMessage();
        this.url = videoMessage.getUrl();
        this.mimetype = videoMessage.getMimetype();
        this.fileSha256 = videoMessage.getFileSha256().toByteArray();
        this.fileLength = videoMessage.getFileLength();
        this.seconds = videoMessage.getSeconds();
        this.mediaKey = videoMessage.getMediaKey().toByteArray();
        this.gifPlayback = videoMessage.getGifPlayback();
        this.gifAttribution = videoMessage.getGifAttribution();
        this.jpegMp4Thumbnail = videoMessage.getJpegThumbnail().toByteArray();
        byte[] decryptedBytes = MediaEncryption.decrypt(this.mediaKey, this.url, MediaEncryption.MEDIA_TYPE_VIDEO);
        this.mp4FullResolution = decryptedBytes != null ? decryptedBytes : this.jpegMp4Thumbnail;
    }

    public String getMimetype() {
        return this.mimetype;
    }

    public String getUrl() {
        return this.url;
    }

    public byte[] getFileSha256() {
        return this.fileSha256;
    }

    public byte[] getMediaKey() {
        return this.mediaKey;
    }

    public byte[] getMp4Thumbnail() {
        return this.jpegMp4Thumbnail;
    }

    public byte[] getMp4FullResolution() {
        return this.mp4FullResolution;
    }

    public long getFileLength() {
        return this.fileLength;
    }

    public int getSeconds() {
        return this.seconds;
    }

    public ProtoBuf.VideoMessage.VIDEO_MESSAGE_ATTRIBUTION getGifAttribution() {
        return this.gifAttribution;
    }

    public boolean getGifPlayback() {
        return this.gifPlayback;
    }
}

