/*
 * Decompiled with CFR 0.152.
 */
package javafx.embed.swt;

import com.sun.glass.ui.Application;
import com.sun.glass.ui.Pixels;
import com.sun.javafx.cursor.CursorFrame;
import com.sun.javafx.cursor.CursorType;
import com.sun.javafx.embed.EmbeddedSceneDSInterface;
import com.sun.javafx.embed.EmbeddedSceneDTInterface;
import com.sun.javafx.embed.EmbeddedSceneInterface;
import com.sun.javafx.embed.EmbeddedStageInterface;
import com.sun.javafx.embed.HostInterface;
import com.sun.javafx.stage.EmbeddedWindow;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.security.AccessController;
import java.security.Permission;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.CountDownLatch;
import javafx.application.Platform;
import javafx.beans.NamedArg;
import javafx.embed.swt.CustomTransfer;
import javafx.embed.swt.SWTCursors;
import javafx.embed.swt.SWTEvents;
import javafx.scene.Scene;
import javafx.scene.input.TransferMode;
import javafx.stage.Window;
import javafx.util.FXPermission;
import org.eclipse.swt.SWT;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.HTMLTransfer;
import org.eclipse.swt.dnd.ImageTransfer;
import org.eclipse.swt.dnd.RTFTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.dnd.URLTransfer;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.GestureEvent;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MenuDetectEvent;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class FXCanvas
extends Canvas {
    private static final FXPermission FXCANVAS_PERMISSION = new FXPermission("accessFXCanvasInternals");
    private HostContainer hostContainer;
    private volatile EmbeddedWindow stage;
    private volatile Scene scene;
    private EmbeddedStageInterface stagePeer;
    private EmbeddedSceneInterface scenePeer;
    private int pWidth = 0;
    private int pHeight = 0;
    private volatile int pPreferredWidth = -1;
    private volatile int pPreferredHeight = -1;
    private IntBuffer pixelsBuf = null;
    Listener moveFilter = event -> {
        for (FXCanvas control = this; control != null; control = control.getParent()) {
            if (control != event.widget) continue;
            this.sendMoveEventToFX();
            break;
        }
    };
    private DropTarget dropTarget;
    static Transfer[] StandardTransfers = new Transfer[]{TextTransfer.getInstance(), RTFTransfer.getInstance(), HTMLTransfer.getInstance(), URLTransfer.getInstance(), ImageTransfer.getInstance(), FileTransfer.getInstance()};
    static Transfer[] CustomTransfers = new Transfer[0];
    private static Field windowField;
    private static Method windowMethod;
    private static Method screenMethod;
    private static Method backingScaleFactorMethod;
    private static Method swtDPIUtilMethod;
    static ArrayList<DropTarget> targets;
    double lastScaleFactor = 1.0;
    int lastWidth;
    int lastHeight;
    IntBuffer lastPixelsBuf = null;
    double totalScrollX = 0.0;
    double totalScrollY = 0.0;
    private boolean gestureActive = false;
    private boolean panGestureInertiaActive = false;
    private GestureEvent lastGestureEvent;
    private Stack<Integer> nestedGestures = new Stack();
    private long inertiaTime = 0L;
    private double inertiaXScroll = 0.0;
    private double inertiaYScroll = 0.0;
    private double lastTotalZoom = 0.0;
    private double lastTotalAngle = 0.0;

    private double getScaleFactor() {
        if (SWT.getPlatform().equals("cocoa")) {
            if (windowField == null || screenMethod == null || backingScaleFactorMethod == null) {
                return 1.0;
            }
            try {
                Object nsWindow = windowField.get(this.getShell());
                Object nsScreen = screenMethod.invoke(nsWindow, new Object[0]);
                Object bsFactor = backingScaleFactorMethod.invoke(nsScreen, new Object[0]);
                return (Double)bsFactor;
            }
            catch (Exception nsWindow) {}
        } else if (SWT.getPlatform().equals("win32")) {
            if (swtDPIUtilMethod == null) {
                return 1.0;
            }
            try {
                Integer value = (Integer)swtDPIUtilMethod.invoke(null, new Object[0]);
                return (double)value.intValue() / 100.0;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return 1.0;
    }

    static Transfer[] getAllTransfers() {
        Transfer[] transfers = new Transfer[StandardTransfers.length + CustomTransfers.length];
        System.arraycopy(StandardTransfers, 0, transfers, 0, StandardTransfers.length);
        System.arraycopy(CustomTransfers, 0, transfers, StandardTransfers.length, CustomTransfers.length);
        return transfers;
    }

    static Transfer getCustomTransfer(String mime) {
        for (int i = 0; i < CustomTransfers.length; ++i) {
            if (!((CustomTransfer)CustomTransfers[i]).getMime().equals(mime)) continue;
            return CustomTransfers[i];
        }
        CustomTransfer transfer = new CustomTransfer(mime, mime);
        Transfer[] newCustom = new Transfer[CustomTransfers.length + 1];
        System.arraycopy(CustomTransfers, 0, newCustom, 0, CustomTransfers.length);
        newCustom[FXCanvas.CustomTransfers.length] = transfer;
        CustomTransfers = newCustom;
        return transfer;
    }

    public FXCanvas(@NamedArg(value="parent") Composite parent, @NamedArg(value="style") int style) {
        super(parent, style | 0x40000);
        this.setApplicationName(Display.getAppName());
        this.hostContainer = new HostContainer();
        this.registerEventListeners();
        Display display = parent.getDisplay();
        display.addFilter(10, this.moveFilter);
    }

    public static FXCanvas getFXCanvas(Scene scene) {
        HostInterface hostInterface;
        Window window = scene.getWindow();
        if (window != null && window instanceof EmbeddedWindow && (hostInterface = ((EmbeddedWindow)window).getHost()) instanceof HostContainer) {
            return ((HostContainer)hostInterface).fxCanvas;
        }
        return null;
    }

    private static void initFx() {
        long eventProc = 0L;
        try {
            Field field = Display.class.getDeclaredField("eventProc");
            field.setAccessible(true);
            if (field.getType() == Integer.TYPE) {
                eventProc = field.getInt(Display.getDefault());
            } else if (field.getType() == Long.TYPE) {
                eventProc = field.getLong(Display.getDefault());
            }
        }
        catch (Throwable field) {
            // empty catch block
        }
        String eventProcStr = String.valueOf(eventProc);
        AccessController.doPrivileged(() -> {
            System.setProperty("com.sun.javafx.application.type", "FXCanvas");
            System.setProperty("javafx.embed.isEventThread", "true");
            if (swtDPIUtilMethod == null) {
                System.setProperty("glass.win.uiScale", "100%");
                System.setProperty("glass.win.renderScale", "100%");
            } else {
                Integer scale = 100;
                try {
                    scale = (Integer)swtDPIUtilMethod.invoke(null, new Object[0]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                System.setProperty("glass.win.uiScale", scale + "%");
                System.setProperty("glass.win.renderScale", scale + "%");
            }
            System.setProperty("javafx.embed.eventProc", eventProcStr);
            return null;
        });
        CountDownLatch startupLatch = new CountDownLatch(1);
        AccessController.doPrivileged(() -> {
            Platform.startup(() -> startupLatch.countDown());
            return null;
        }, null, new Permission[]{FXCANVAS_PERMISSION});
        try {
            startupLatch.await();
        }
        catch (InterruptedException ex) {
            throw new RuntimeException(ex);
        }
    }

    private void setApplicationName(String name) {
        Platform.runLater(() -> Application.GetApplication().setName(name));
    }

    public void reskin(int flags) {
        super.reskin(flags);
        if (flags == 1) {
            this.sendMoveEventToFX();
        }
    }

    DropTarget getDropTarget() {
        return this.dropTarget;
    }

    void setDropTarget(DropTarget newTarget) {
        if (this.dropTarget != null) {
            targets.remove(this.dropTarget);
            this.dropTarget.dispose();
        }
        this.dropTarget = newTarget;
        if (this.dropTarget != null) {
            targets.add(this.dropTarget);
        }
    }

    static void updateDropTarget() {
        for (DropTarget target : targets) {
            target.setTransfer(FXCanvas.getAllTransfers());
        }
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        if (wHint == -1 && hHint == -1 && this.pPreferredWidth != -1 && this.pPreferredHeight != -1) {
            return new Point(this.pPreferredWidth, this.pPreferredHeight);
        }
        return super.computeSize(wHint, hHint, changed);
    }

    public Scene getScene() {
        this.checkWidget();
        return this.scene;
    }

    public void setScene(Scene newScene) {
        this.checkWidget();
        if (this.stage == null && newScene != null) {
            this.stage = new EmbeddedWindow((HostInterface)this.hostContainer);
            this.stage.show();
        }
        this.scene = newScene;
        if (this.stage != null) {
            this.stage.setScene(newScene);
        }
        if (this.stage != null && newScene == null) {
            this.stage.hide();
            this.stage = null;
        }
    }

    private void registerEventListeners() {
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent de) {
                Display display = FXCanvas.this.getDisplay();
                display.removeFilter(10, FXCanvas.this.moveFilter);
                FXCanvas.this.widgetDisposed(de);
            }
        });
        this.addPaintListener(pe -> this.paintControl(pe));
        this.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent me) {
            }

            public void mouseDown(MouseEvent me) {
                if (me.button > 5) {
                    return;
                }
                FXCanvas.this.sendMouseEventToFX(me, 0);
            }

            public void mouseUp(MouseEvent me) {
                if (me.button > 5) {
                    return;
                }
                FXCanvas.this.sendMouseEventToFX(me, 1);
            }
        });
        this.addMouseMoveListener(me -> {
            if ((me.stateMask & SWT.BUTTON_MASK) != 0) {
                if ((me.stateMask & 0x2B80000) != 0) {
                    this.sendMouseEventToFX(me, 6);
                } else {
                    this.sendMouseEventToFX(me, 5);
                }
            } else {
                this.sendMouseEventToFX(me, 5);
            }
        });
        this.addListener(37, e -> {
            if (!(this.gestureActive || this.panGestureInertiaActive && this.lastGestureEvent != null && e.time == this.lastGestureEvent.time)) {
                this.sendScrollEventToFX(7, 0.0, SWTEvents.getWheelRotation(e), e.x, e.y, e.stateMask, false);
            }
        });
        this.addListener(38, e -> {
            if (!(this.gestureActive || this.panGestureInertiaActive && this.lastGestureEvent != null && e.time == this.lastGestureEvent.time)) {
                this.sendScrollEventToFX(8, SWTEvents.getWheelRotation(e), 0.0, e.x, e.y, e.stateMask, false);
            }
        });
        this.addMouseTrackListener(new MouseTrackListener(){

            public void mouseEnter(MouseEvent me) {
                FXCanvas.this.sendMouseEventToFX(me, 3);
            }

            public void mouseExit(MouseEvent me) {
                FXCanvas.this.sendMouseEventToFX(me, 4);
            }

            public void mouseHover(MouseEvent me) {
            }
        });
        this.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent ce) {
                FXCanvas.this.sendMoveEventToFX();
            }

            public void controlResized(ControlEvent ce) {
                FXCanvas.this.sendResizeEventToFX();
            }
        });
        this.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent fe) {
                FXCanvas.this.sendFocusEventToFX(fe, true);
            }

            public void focusLost(FocusEvent fe) {
                FXCanvas.this.sendFocusEventToFX(fe, false);
            }
        });
        this.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                FXCanvas.this.sendKeyEventToFX(e, 1);
            }

            public void keyReleased(KeyEvent e) {
                FXCanvas.this.sendKeyEventToFX(e, 2);
            }
        });
        this.addGestureListener(ge -> this.sendGestureEventToFX(ge));
        this.addMenuDetectListener(e -> {
            Runnable r = () -> {
                if (this.isDisposed()) {
                    return;
                }
                this.sendMenuEventToFX(e);
            };
            if ("cocoa".equals(SWT.getPlatform())) {
                this.getDisplay().asyncExec(r);
            } else {
                r.run();
            }
        });
    }

    private void widgetDisposed(DisposeEvent de) {
        this.setDropTarget(null);
        if (this.stage != null) {
            this.stage.hide();
        }
    }

    private void paintControl(PaintEvent pe) {
        PaletteData palette;
        if (this.scenePeer == null || this.pixelsBuf == null) {
            return;
        }
        double scaleFactor = this.getScaleFactor();
        if (this.lastScaleFactor != scaleFactor) {
            this.resizePixelBuffer(scaleFactor);
            this.lastScaleFactor = scaleFactor;
            this.scenePeer.setPixelScaleFactors((float)scaleFactor, (float)scaleFactor);
        }
        IntBuffer buffer = this.pixelsBuf;
        int width = this.pWidth;
        int height = this.pHeight;
        if (this.scenePeer.getPixels(this.pixelsBuf, this.pWidth, this.pHeight)) {
            width = this.lastWidth = this.pWidth;
            height = this.lastHeight = this.pHeight;
            buffer = this.lastPixelsBuf = this.pixelsBuf;
        } else {
            if (this.lastPixelsBuf == null) {
                return;
            }
            width = this.lastWidth;
            height = this.lastHeight;
            buffer = this.lastPixelsBuf;
        }
        width = (int)Math.ceil((double)width * scaleFactor);
        height = (int)Math.ceil((double)height * scaleFactor);
        ImageData imageData = null;
        if ("win32".equals(SWT.getPlatform())) {
            palette = new PaletteData(65280, 0xFF0000, -16777216);
            int scanline = width * 4;
            byte[] dstData = new byte[scanline * height];
            int[] srcData = buffer.array();
            int dp = 0;
            int sp = 0;
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    int p = srcData[sp++];
                    dstData[dp++] = (byte)(p & 0xFF);
                    dstData[dp++] = (byte)(p >> 8 & 0xFF);
                    dstData[dp++] = (byte)(p >> 16 & 0xFF);
                    dstData[dp++] = 0;
                }
            }
            imageData = new ImageData(width, height, 32, palette, 4, dstData);
        } else {
            if (width * height > buffer.array().length) {
                System.err.println("FXCanvas.paintControl: scale mismatch!");
                return;
            }
            palette = new PaletteData(0xFF0000, 65280, 255);
            imageData = new ImageData(width, height, 32, palette);
            imageData.setPixels(0, 0, width * height, buffer.array(), 0);
        }
        Image image = new Image((Device)Display.getDefault(), imageData);
        pe.gc.drawImage(image, 0, 0, width, height, 0, 0, this.pWidth, this.pHeight);
        image.dispose();
    }

    private void sendMoveEventToFX() {
        if (this.stagePeer == null) {
            return;
        }
        Rectangle rect = this.getClientArea();
        Point los = this.toDisplay(rect.x, rect.y);
        this.stagePeer.setLocation(los.x, los.y);
    }

    private void sendMouseEventToFX(MouseEvent me, int embedMouseType) {
        if (this.scenePeer == null) {
            return;
        }
        Point los = this.toDisplay(me.x, me.y);
        boolean primaryBtnDown = (me.stateMask & 0x80000) != 0;
        boolean middleBtnDown = (me.stateMask & 0x100000) != 0;
        boolean secondaryBtnDown = (me.stateMask & 0x200000) != 0;
        boolean backBtnDown = (me.stateMask & 0x800000) != 0;
        boolean forwardBtnDown = (me.stateMask & 0x2000000) != 0;
        boolean shift = (me.stateMask & 0x20000) != 0;
        boolean control = (me.stateMask & 0x40000) != 0;
        boolean alt = (me.stateMask & 0x10000) != 0;
        boolean meta = (me.stateMask & 0x400000) != 0;
        int button = me.button;
        switch (embedMouseType) {
            case 0: {
                primaryBtnDown |= me.button == 1;
                middleBtnDown |= me.button == 2;
                secondaryBtnDown |= me.button == 3;
                backBtnDown |= me.button == 4;
                forwardBtnDown |= me.button == 5;
                break;
            }
            case 1: {
                primaryBtnDown &= me.button != 1;
                middleBtnDown &= me.button != 2;
                secondaryBtnDown &= me.button != 3;
                backBtnDown &= me.button == 4;
                forwardBtnDown &= me.button == 5;
                break;
            }
            case 2: {
                return;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                if (button != 0) break;
                if ((me.stateMask & 0x80000) != 0) {
                    button = 1;
                    break;
                }
                if ((me.stateMask & 0x100000) != 0) {
                    button = 2;
                    break;
                }
                if ((me.stateMask & 0x200000) != 0) {
                    button = 3;
                    break;
                }
                if ((me.stateMask & 0x800000) != 0) {
                    button = 4;
                    break;
                }
                if ((me.stateMask & 0x2000000) == 0) break;
                button = 5;
                break;
            }
        }
        this.scenePeer.mouseEvent(embedMouseType, SWTEvents.mouseButtonToEmbedMouseButton(button, me.stateMask), primaryBtnDown, middleBtnDown, secondaryBtnDown, backBtnDown, forwardBtnDown, me.x, me.y, los.x, los.y, shift, control, alt, meta, false);
    }

    private void sendScrollEventToFX(int type, double scrollX, double scrollY, int x, int y, int stateMask, boolean inertia) {
        if (this.scenePeer == null) {
            return;
        }
        double multiplier = 5.0;
        if (type == 8 || type == 7) {
            multiplier = 40.0;
            this.totalScrollX = scrollX;
            this.totalScrollY = scrollY;
        } else {
            if ("cocoa".equals(SWT.getPlatform()) && SWT.getVersion() < 4600) {
                multiplier *= -1.0;
            }
            if (type == 0) {
                this.totalScrollX = 0.0;
                this.totalScrollY = 0.0;
            } else if (inertia) {
                this.totalScrollX = scrollX;
                this.totalScrollY = scrollY;
            } else {
                this.totalScrollX += scrollX;
                this.totalScrollY += scrollY;
            }
        }
        Point los = this.toDisplay(x, y);
        this.scenePeer.scrollEvent(type, scrollX, scrollY, this.totalScrollX, this.totalScrollY, multiplier, multiplier, (double)x, (double)y, (double)los.x, (double)los.y, (stateMask & 0x20000) != 0, (stateMask & 0x40000) != 0, (stateMask & 0x10000) != 0, (stateMask & 0x400000) != 0, inertia);
    }

    private void sendKeyEventToFX(KeyEvent e, int type) {
        if (this.scenePeer == null) {
            return;
        }
        int stateMask = e.stateMask;
        if (type == 1) {
            if (e.keyCode == 131072) {
                stateMask |= 0x20000;
            }
            if (e.keyCode == 262144) {
                stateMask |= 0x40000;
            }
            if (e.keyCode == 65536) {
                stateMask |= 0x10000;
            }
            if (e.keyCode == 0x400000) {
                stateMask |= 0x400000;
            }
        } else {
            if (e.keyCode == 131072) {
                stateMask &= 0xFFFDFFFF;
            }
            if (e.keyCode == 262144) {
                stateMask &= 0xFFFBFFFF;
            }
            if (e.keyCode == 65536) {
                stateMask &= 0xFFFEFFFF;
            }
            if (e.keyCode == 0x400000) {
                stateMask &= 0xFFBFFFFF;
            }
        }
        int keyCode = SWTEvents.keyCodeToEmbedKeyCode(e.keyCode);
        this.scenePeer.keyEvent(SWTEvents.keyIDToEmbedKeyType(type), keyCode, new char[0], SWTEvents.keyModifiersToEmbedKeyModifiers(stateMask));
        if (e.character != '\u0000' && type == 1) {
            char[] chars = new char[]{e.character};
            this.scenePeer.keyEvent(2, e.keyCode, chars, SWTEvents.keyModifiersToEmbedKeyModifiers(stateMask));
        }
    }

    private void sendGestureEventToFX(GestureEvent gestureEvent) {
        if (this.scenePeer == null) {
            return;
        }
        switch (gestureEvent.detail) {
            case 2: {
                this.gestureActive = true;
                this.panGestureInertiaActive = false;
                break;
            }
            case 32: {
                if (this.gestureActive && !this.nestedGestures.contains(32)) {
                    this.sendZoomEventToFX(0, gestureEvent);
                    this.nestedGestures.push(32);
                }
                this.sendZoomEventToFX(1, gestureEvent);
                break;
            }
            case 64: {
                if (this.gestureActive && !this.nestedGestures.contains(64)) {
                    this.sendScrollEventToFX(0, gestureEvent.xDirection, gestureEvent.yDirection, gestureEvent.x, gestureEvent.y, gestureEvent.stateMask, false);
                    this.nestedGestures.push(64);
                }
                if (this.panGestureInertiaActive && gestureEvent.time > this.lastGestureEvent.time + 250) {
                    this.panGestureInertiaActive = false;
                }
                if (!this.gestureActive && !this.panGestureInertiaActive) break;
                double xDirection = gestureEvent.xDirection;
                double yDirection = gestureEvent.yDirection;
                if (this.panGestureInertiaActive && xDirection == 0.0 && yDirection == 0.0) {
                    double delta = Math.max(0.0, Math.min(1.0, (double)((long)gestureEvent.time - this.inertiaTime) / 1500.0));
                    xDirection = (1.0 - delta) * this.inertiaXScroll;
                    yDirection = (1.0 - delta) * this.inertiaYScroll;
                }
                this.sendScrollEventToFX(1, xDirection, yDirection, gestureEvent.x, gestureEvent.y, gestureEvent.stateMask, this.panGestureInertiaActive);
                break;
            }
            case 8: {
                if (this.gestureActive && !this.nestedGestures.contains(8)) {
                    this.sendRotateEventToFX(0, gestureEvent);
                    this.nestedGestures.push(8);
                }
                this.sendRotateEventToFX(1, gestureEvent);
                break;
            }
            case 16: {
                this.sendSwipeEventToFX(gestureEvent);
                break;
            }
            case 4: {
                while (!this.nestedGestures.isEmpty()) {
                    switch (this.nestedGestures.pop()) {
                        case 32: {
                            this.sendZoomEventToFX(2, gestureEvent);
                            break;
                        }
                        case 64: {
                            this.sendScrollEventToFX(2, gestureEvent.xDirection, gestureEvent.yDirection, gestureEvent.x, gestureEvent.y, gestureEvent.stateMask, false);
                            this.inertiaXScroll = this.lastGestureEvent.xDirection;
                            this.inertiaYScroll = this.lastGestureEvent.yDirection;
                            this.inertiaTime = gestureEvent.time;
                            this.panGestureInertiaActive = true;
                            break;
                        }
                        case 8: {
                            this.sendRotateEventToFX(2, gestureEvent);
                        }
                    }
                }
                this.gestureActive = false;
                break;
            }
        }
        this.lastGestureEvent = gestureEvent;
    }

    private void sendZoomEventToFX(int type, GestureEvent gestureEvent) {
        Point los = this.toDisplay(gestureEvent.x, gestureEvent.y);
        double totalZoom = gestureEvent.magnification;
        if (type == 0) {
            this.lastTotalZoom = 1.0;
            totalZoom = 1.0;
        } else if (type == 2) {
            totalZoom = this.lastTotalZoom;
        }
        double zoom = type == 2 ? 1.0 : totalZoom / this.lastTotalZoom;
        this.lastTotalZoom = totalZoom;
        this.scenePeer.zoomEvent(type, zoom, totalZoom, (double)gestureEvent.x, (double)gestureEvent.y, (double)los.x, (double)los.y, (gestureEvent.stateMask & 0x20000) != 0, (gestureEvent.stateMask & 0x40000) != 0, (gestureEvent.stateMask & 0x10000) != 0, (gestureEvent.stateMask & 0x400000) != 0, !this.gestureActive);
    }

    private void sendRotateEventToFX(int type, GestureEvent gestureEvent) {
        Point los = this.toDisplay(gestureEvent.x, gestureEvent.y);
        double totalAngle = -gestureEvent.rotation;
        if (type == 0) {
            this.lastTotalAngle = 0.0;
            totalAngle = 0.0;
        } else if (type == 2) {
            totalAngle = this.lastTotalAngle;
        }
        double angle = type == 2 ? 0.0 : totalAngle - this.lastTotalAngle;
        this.lastTotalAngle = totalAngle;
        this.scenePeer.rotateEvent(type, angle, totalAngle, (double)gestureEvent.x, (double)gestureEvent.y, (double)los.x, (double)los.y, (gestureEvent.stateMask & 0x20000) != 0, (gestureEvent.stateMask & 0x40000) != 0, (gestureEvent.stateMask & 0x10000) != 0, (gestureEvent.stateMask & 0x400000) != 0, !this.gestureActive);
    }

    private void sendSwipeEventToFX(GestureEvent gestureEvent) {
        Point los = this.toDisplay(gestureEvent.x, gestureEvent.y);
        int type = -1;
        if (gestureEvent.yDirection > 0) {
            type = 0;
        } else if (gestureEvent.yDirection < 0) {
            type = 1;
        } else if (gestureEvent.xDirection > 0) {
            type = 3;
        } else if (gestureEvent.xDirection < 0) {
            type = 2;
        }
        this.scenePeer.swipeEvent(type, (double)gestureEvent.x, (double)gestureEvent.y, (double)los.x, (double)los.y, (gestureEvent.stateMask & 0x20000) != 0, (gestureEvent.stateMask & 0x40000) != 0, (gestureEvent.stateMask & 0x10000) != 0, (gestureEvent.stateMask & 0x400000) != 0);
    }

    private void sendMenuEventToFX(MenuDetectEvent me) {
        if (this.scenePeer == null) {
            return;
        }
        Point pt = this.toControl(me.x, me.y);
        this.scenePeer.menuEvent(pt.x, pt.y, me.x, me.y, false);
    }

    private void sendResizeEventToFX() {
        this.redraw();
        this.update();
        this.pWidth = this.getClientArea().width;
        this.pHeight = this.getClientArea().height;
        this.resizePixelBuffer(this.lastScaleFactor);
        if (this.scenePeer == null) {
            return;
        }
        this.stagePeer.setSize(this.pWidth, this.pHeight);
        this.scenePeer.setSize(this.pWidth, this.pHeight);
    }

    private void resizePixelBuffer(double newScaleFactor) {
        this.lastPixelsBuf = null;
        if (this.pWidth <= 0 || this.pHeight <= 0) {
            this.pixelsBuf = null;
        } else {
            this.pixelsBuf = IntBuffer.allocate((int)Math.ceil((double)this.pWidth * newScaleFactor) * (int)Math.ceil((double)this.pHeight * newScaleFactor));
            RGB rgb = this.getBackground().getRGB();
            Arrays.fill(this.pixelsBuf.array(), rgb.red << 16 | rgb.green << 8 | rgb.blue);
        }
    }

    private void sendFocusEventToFX(FocusEvent fe, boolean focused) {
        if (this.stage == null || this.stagePeer == null) {
            return;
        }
        int focusCause = focused ? 0 : 3;
        this.stagePeer.setFocused(focused, focusCause);
    }

    static {
        if (SWT.getPlatform().equals("cocoa")) {
            try {
                windowField = Shell.class.getDeclaredField("window");
                windowField.setAccessible(true);
                Class<?> nsViewClass = Class.forName("org.eclipse.swt.internal.cocoa.NSView");
                windowMethod = nsViewClass.getDeclaredMethod("window", new Class[0]);
                windowMethod.setAccessible(true);
                Class<?> nsWindowClass = Class.forName("org.eclipse.swt.internal.cocoa.NSWindow");
                screenMethod = nsWindowClass.getDeclaredMethod("screen", new Class[0]);
                screenMethod.setAccessible(true);
                Class<?> nsScreenClass = Class.forName("org.eclipse.swt.internal.cocoa.NSScreen");
                backingScaleFactorMethod = nsScreenClass.getDeclaredMethod("backingScaleFactor", new Class[0]);
                backingScaleFactorMethod.setAccessible(true);
            }
            catch (Exception nsViewClass) {}
        } else if (SWT.getPlatform().equals("win32")) {
            try {
                String autoScale = AccessController.doPrivileged(() -> System.getProperty("swt.autoScale"));
                if (autoScale == null || !"false".equalsIgnoreCase(autoScale)) {
                    Class<?> dpiUtilClass = Class.forName("org.eclipse.swt.internal.DPIUtil");
                    swtDPIUtilMethod = dpiUtilClass.getMethod("getDeviceZoom", new Class[0]);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        FXCanvas.initFx();
        targets = new ArrayList();
    }

    private class HostContainer
    implements HostInterface {
        final FXCanvas fxCanvas;
        Object lock;
        boolean queued;

        private HostContainer() {
            this.fxCanvas = FXCanvas.this;
            this.lock = new Object();
            this.queued = false;
        }

        public void setEmbeddedStage(EmbeddedStageInterface embeddedStage) {
            FXCanvas.this.stagePeer = embeddedStage;
            if (FXCanvas.this.stagePeer == null) {
                return;
            }
            if (FXCanvas.this.pWidth > 0 && FXCanvas.this.pHeight > 0) {
                FXCanvas.this.stagePeer.setSize(FXCanvas.this.pWidth, FXCanvas.this.pHeight);
            }
            if (FXCanvas.this.isFocusControl()) {
                FXCanvas.this.stagePeer.setFocused(true, 0);
            }
            FXCanvas.this.sendMoveEventToFX();
            FXCanvas.this.sendResizeEventToFX();
        }

        TransferMode getTransferMode(int bits) {
            switch (bits) {
                case 1: {
                    return TransferMode.COPY;
                }
                case 2: 
                case 8: {
                    return TransferMode.MOVE;
                }
                case 4: {
                    return TransferMode.LINK;
                }
            }
            return null;
        }

        Set<TransferMode> getTransferModes(int bits) {
            HashSet<TransferMode> set = new HashSet<TransferMode>();
            if ((bits & 1) != 0) {
                set.add(TransferMode.COPY);
            }
            if ((bits & 2) != 0) {
                set.add(TransferMode.MOVE);
            }
            if ((bits & 8) != 0) {
                set.add(TransferMode.MOVE);
            }
            if ((bits & 4) != 0) {
                set.add(TransferMode.LINK);
            }
            return set;
        }

        ImageData createImageData(Pixels pixels) {
            int y;
            Buffer pixbuf;
            if (pixels == null) {
                return null;
            }
            int width = pixels.getWidth();
            int height = pixels.getHeight();
            int bpr = width * 4;
            int dataSize = bpr * height;
            byte[] buffer = new byte[dataSize];
            byte[] alphaData = new byte[width * height];
            if (pixels.getBytesPerComponent() == 1) {
                pixbuf = (ByteBuffer)pixels.getPixels();
                int offset = 0;
                int alphaOffset = 0;
                for (y = 0; y < height; ++y) {
                    int x = 0;
                    while (x < width) {
                        byte b = ((ByteBuffer)pixbuf).get();
                        byte g = ((ByteBuffer)pixbuf).get();
                        byte r = ((ByteBuffer)pixbuf).get();
                        byte a = ((ByteBuffer)pixbuf).get();
                        alphaData[alphaOffset++] = a;
                        buffer[offset] = b;
                        buffer[offset + 1] = g;
                        buffer[offset + 2] = r;
                        buffer[offset + 3] = 0;
                        ++x;
                        offset += 4;
                    }
                }
            } else if (pixels.getBytesPerComponent() == 4) {
                pixbuf = (IntBuffer)pixels.getPixels();
                int offset = 0;
                int alphaOffset = 0;
                for (y = 0; y < height; ++y) {
                    int x = 0;
                    while (x < width) {
                        int pixel = ((IntBuffer)pixbuf).get();
                        byte b = (byte)(pixel & 0xFF);
                        byte g = (byte)(pixel >> 8 & 0xFF);
                        byte r = (byte)(pixel >> 16 & 0xFF);
                        byte a = (byte)(pixel >> 24 & 0xFF);
                        alphaData[alphaOffset++] = a;
                        buffer[offset] = b;
                        buffer[offset + 1] = g;
                        buffer[offset + 2] = r;
                        buffer[offset + 3] = 0;
                        ++x;
                        offset += 4;
                    }
                }
            } else {
                return null;
            }
            PaletteData palette = new PaletteData(65280, 0xFF0000, -16777216);
            ImageData imageData = new ImageData(width, height, 32, palette, 4, buffer);
            imageData.alphaData = alphaData;
            return imageData;
        }

        private DragSource createDragSource(final EmbeddedSceneDSInterface fxDragSource, TransferMode dragAction) {
            Transfer[] transfers = this.getTransferTypes(fxDragSource.getMimeTypes());
            if (transfers.length == 0) {
                return null;
            }
            int dragOperation = this.getDragActions(fxDragSource.getSupportedActions());
            final DragSource dragSource = new DragSource((Control)FXCanvas.this, dragOperation);
            dragSource.setTransfer(transfers);
            dragSource.addDragListener(new DragSourceListener(){

                public void dragFinished(DragSourceEvent event) {
                    dragSource.dispose();
                    fxDragSource.dragDropEnd(HostContainer.this.getTransferMode(event.detail));
                }

                public void dragSetData(DragSourceEvent event) {
                    Transfer[] transfers = dragSource.getTransfer();
                    for (int i = 0; i < transfers.length; ++i) {
                        String mime;
                        if (transfers[i].isSupportedType(event.dataType) && (mime = HostContainer.this.getMime(transfers[i])) != null) {
                            event.doit = true;
                            event.data = fxDragSource.getData(mime);
                            if (event.data instanceof Pixels) {
                                event.data = HostContainer.this.createImageData((Pixels)event.data);
                            }
                            return;
                        }
                        event.doit = false;
                    }
                }

                public void dragStart(DragSourceEvent event) {
                }
            });
            return dragSource;
        }

        int getDragAction(TransferMode tm) {
            if (tm == null) {
                return 0;
            }
            switch (tm) {
                case COPY: {
                    return 1;
                }
                case MOVE: {
                    return 2;
                }
                case LINK: {
                    return 4;
                }
            }
            throw new IllegalArgumentException("Invalid transfer mode");
        }

        int getDragActions(Set<TransferMode> set) {
            int result = 0;
            for (TransferMode mode : set) {
                result |= this.getDragAction(mode);
            }
            return result;
        }

        Transfer getTransferType(String mime) {
            if (mime.equals("text/plain")) {
                return TextTransfer.getInstance();
            }
            if (mime.equals("text/rtf")) {
                return RTFTransfer.getInstance();
            }
            if (mime.equals("text/html")) {
                return HTMLTransfer.getInstance();
            }
            if (mime.equals("text/uri-list")) {
                return URLTransfer.getInstance();
            }
            if (mime.equals("application/x-java-rawimage")) {
                return ImageTransfer.getInstance();
            }
            if (mime.equals("application/x-java-file-list") || mime.equals("java.file-list")) {
                return FileTransfer.getInstance();
            }
            return FXCanvas.getCustomTransfer(mime);
        }

        Transfer[] getTransferTypes(String[] mimeTypes) {
            int count = 0;
            Transfer[] transfers = new Transfer[mimeTypes.length];
            for (int i = 0; i < mimeTypes.length; ++i) {
                Transfer transfer = this.getTransferType(mimeTypes[i]);
                if (transfer == null) continue;
                transfers[count++] = transfer;
            }
            if (count != mimeTypes.length) {
                Transfer[] newTransfers = new Transfer[count];
                System.arraycopy(transfers, 0, newTransfers, 0, count);
                transfers = newTransfers;
            }
            return transfers;
        }

        String getMime(Transfer transfer) {
            if (transfer.equals(TextTransfer.getInstance())) {
                return "text/plain";
            }
            if (transfer.equals(RTFTransfer.getInstance())) {
                return "text/rtf";
            }
            if (transfer.equals(HTMLTransfer.getInstance())) {
                return "text/html";
            }
            if (transfer.equals(URLTransfer.getInstance())) {
                return "text/uri-list";
            }
            if (transfer.equals(ImageTransfer.getInstance())) {
                return "application/x-java-rawimage";
            }
            if (transfer.equals(FileTransfer.getInstance())) {
                return "application/x-java-file-list";
            }
            if (transfer instanceof CustomTransfer) {
                return ((CustomTransfer)transfer).getMime();
            }
            return null;
        }

        String[] getMimes(Transfer[] transfers, TransferData data) {
            int count = 0;
            String[] result = new String[transfers.length];
            for (int i = 0; i < transfers.length; ++i) {
                if (!transfers[i].isSupportedType(data)) continue;
                result[count++] = this.getMime(transfers[i]);
            }
            if (count != result.length) {
                String[] newResult = new String[count];
                System.arraycopy(result, 0, newResult, 0, count);
                result = newResult;
            }
            return result;
        }

        DropTarget createDropTarget(EmbeddedSceneInterface embeddedScene) {
            final DropTarget dropTarget = new DropTarget((Control)FXCanvas.this, 7);
            final EmbeddedSceneDTInterface fxDropTarget = embeddedScene.createDropTarget();
            dropTarget.setTransfer(FXCanvas.getAllTransfers());
            dropTarget.addDropListener(new DropTargetListener(){
                Object data;
                TransferData currentTransferData;
                boolean ignoreLeave;
                int detail = 0;
                int operations = 0;
                EmbeddedSceneDSInterface fxDragSource = new EmbeddedSceneDSInterface(){

                    public Set<TransferMode> getSupportedActions() {
                        return HostContainer.this.getTransferModes(operations);
                    }

                    public Object getData(String mimeType) {
                        return data;
                    }

                    public String[] getMimeTypes() {
                        if (currentTransferData == null) {
                            return new String[0];
                        }
                        return HostContainer.this.getMimes(FXCanvas.getAllTransfers(), currentTransferData);
                    }

                    public boolean isMimeTypeAvailable(String mimeType) {
                        String[] mimes = this.getMimeTypes();
                        for (int i = 0; i < mimes.length; ++i) {
                            if (!mimes[i].equals(mimeType)) continue;
                            return true;
                        }
                        return false;
                    }

                    public void dragDropEnd(TransferMode performedAction) {
                        data = null;
                        currentTransferData = null;
                    }
                };

                public void dragEnter(DropTargetEvent event) {
                    this.ignoreLeave = false;
                    dropTarget.setTransfer(FXCanvas.getAllTransfers());
                    this.detail = event.detail;
                    this.operations = event.operations;
                    this.dragOver(event, true, this.detail);
                }

                public void dragLeave(DropTargetEvent event) {
                    this.operations = 0;
                    this.detail = 0;
                    this.data = null;
                    this.currentTransferData = null;
                    FXCanvas.this.getDisplay().asyncExec(() -> {
                        if (this.ignoreLeave) {
                            return;
                        }
                        fxDropTarget.handleDragLeave();
                    });
                }

                public void dragOperationChanged(DropTargetEvent event) {
                    this.detail = event.detail;
                    this.operations = event.operations;
                    this.dragOver(event, false, this.detail);
                }

                public void dragOver(DropTargetEvent event) {
                    this.operations = event.operations;
                    this.dragOver(event, false, this.detail);
                }

                public void dragOver(DropTargetEvent event, boolean enter, int detail) {
                    this.currentTransferData = event.currentDataType;
                    Point pt = FXCanvas.this.toControl(event.x, event.y);
                    if (detail == 0) {
                        detail = 1;
                    }
                    TransferMode recommendedMode = HostContainer.this.getTransferMode(detail);
                    TransferMode acceptedMode = enter ? fxDropTarget.handleDragEnter(pt.x, pt.y, event.x, event.y, recommendedMode, this.fxDragSource) : fxDropTarget.handleDragOver(pt.x, pt.y, event.x, event.y, recommendedMode);
                    event.detail = HostContainer.this.getDragAction(acceptedMode);
                }

                public void drop(DropTargetEvent event) {
                    this.detail = event.detail;
                    this.operations = event.operations;
                    this.data = event.data;
                    this.currentTransferData = event.currentDataType;
                    Point pt = FXCanvas.this.toControl(event.x, event.y);
                    TransferMode recommendedDropAction = HostContainer.this.getTransferMode(event.detail);
                    TransferMode acceptedMode = fxDropTarget.handleDragDrop(pt.x, pt.y, event.x, event.y, recommendedDropAction);
                    event.detail = HostContainer.this.getDragAction(acceptedMode);
                    this.data = null;
                    this.currentTransferData = null;
                }

                public void dropAccept(DropTargetEvent event) {
                    this.ignoreLeave = true;
                }
            });
            return dropTarget;
        }

        public void setEmbeddedScene(EmbeddedSceneInterface embeddedScene) {
            FXCanvas.this.scenePeer = embeddedScene;
            if (FXCanvas.this.scenePeer == null) {
                return;
            }
            if (FXCanvas.this.pWidth > 0 && FXCanvas.this.pHeight > 0) {
                FXCanvas.this.scenePeer.setSize(FXCanvas.this.pWidth, FXCanvas.this.pHeight);
            }
            double scaleFactor = FXCanvas.this.getScaleFactor();
            FXCanvas.this.resizePixelBuffer(scaleFactor);
            FXCanvas.this.lastScaleFactor = scaleFactor;
            FXCanvas.this.scenePeer.setPixelScaleFactors((float)scaleFactor, (float)scaleFactor);
            FXCanvas.this.scenePeer.setDragStartListener((fxDragSource, dragAction) -> Platform.runLater(() -> {
                DragSource dragSource = this.createDragSource(fxDragSource, dragAction);
                if (dragSource == null) {
                    fxDragSource.dragDropEnd(null);
                } else {
                    FXCanvas.updateDropTarget();
                    FXCanvas.this.notifyListeners(29, null);
                }
            }));
            FXCanvas.this.setDropTarget(null);
            FXCanvas.this.setDropTarget(this.createDropTarget(embeddedScene));
        }

        public boolean requestFocus() {
            Display.getDefault().asyncExec(() -> {
                if (FXCanvas.this.isDisposed()) {
                    return;
                }
                FXCanvas.this.forceFocus();
            });
            return true;
        }

        public boolean traverseFocusOut(boolean bln) {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void repaint() {
            Object object = this.lock;
            synchronized (object) {
                if (this.queued) {
                    return;
                }
                this.queued = true;
                Display.getDefault().asyncExec(() -> {
                    try {
                        if (FXCanvas.this.isDisposed()) {
                            return;
                        }
                        FXCanvas.this.redraw();
                    }
                    finally {
                        Object object = this.lock;
                        synchronized (object) {
                            this.queued = false;
                        }
                    }
                });
            }
        }

        public void setPreferredSize(int width, int height) {
            FXCanvas.this.pPreferredWidth = width;
            FXCanvas.this.pPreferredHeight = height;
        }

        public void setEnabled(boolean bln) {
            FXCanvas.this.setEnabled(bln);
        }

        public void setCursor(CursorFrame cursorFrame) {
            FXCanvas.this.setCursor(this.getPlatformCursor(cursorFrame));
        }

        private Cursor getPlatformCursor(CursorFrame cursorFrame) {
            if (cursorFrame.getCursorType() == CursorType.DEFAULT) {
                return null;
            }
            Cursor cachedPlatformCursor = (Cursor)cursorFrame.getPlatformCursor(Cursor.class);
            if (cachedPlatformCursor != null) {
                return cachedPlatformCursor;
            }
            Cursor platformCursor = SWTCursors.embedCursorToCursor(cursorFrame);
            cursorFrame.setPlatforCursor(Cursor.class, (Object)platformCursor);
            return platformCursor;
        }

        public boolean grabFocus() {
            return true;
        }

        public void ungrabFocus() {
        }
    }
}

