/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.catalog.component;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.RoundRectangle2D;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jensoft.core.catalog.component.DemoTab;
import org.jensoft.core.catalog.component.DemoTabEvent;
import org.jensoft.core.catalog.component.DemoTabListener;
import org.jensoft.core.palette.color.RosePalette;

public class DemoTabSet
extends JComponent
implements DemoTabListener {
    private static final long serialVersionUID = 8990735952213763143L;
    private List<DemoTab> commands = new ArrayList<DemoTab>();
    private String title = "";
    private int baseLine;
    private int baseLineOffset = 2;
    private int baseLineTab;
    private int verticalOffset = 50;
    private int offsetStart = 20;
    private int interTab = 5;
    private int cornerRadius = 30;
    private boolean drawOutline = true;
    private JPanel pSQouche = new JPanel();
    private Font f = new Font("lucida console", 0, 12);
    private Insets insetComandBar = new Insets(80, 6, 6, 6);

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public List<DemoTab> getCommands() {
        return this.commands;
    }

    @Override
    public Insets getInsets() {
        FontMetrics metrics = this.getFontMetrics(this.f);
        int sheigh = metrics.getHeight();
        this.insetComandBar = new Insets(sheigh + this.verticalOffset + this.baseLineOffset + 6, 6, 16, 6);
        return this.insetComandBar;
    }

    public void addComandTab(DemoTab ct, JComponent component) {
        ct.addComandGroupListener(this);
        ct.setComponent(component);
        this.commands.add(ct);
    }

    @Override
    public void tabSelect(DemoTabEvent groupEvent) {
        this.removeAll();
        this.setLayout(new BorderLayout());
        if (((DemoTab)groupEvent.getSource()).getComponent() != null) {
            this.add((Component)((DemoTab)groupEvent.getSource()).getComponent(), "Center");
            this.revalidate();
            ((DemoTab)groupEvent.getSource()).getComponent().requestFocus();
        }
    }

    public DemoTabSet() {
        this.setPreferredSize(new Dimension(400, 150));
        BarListener listener = new BarListener();
        this.addMouseListener(listener);
        this.addMouseMotionListener(listener);
    }

    public int getCornerRadius() {
        return this.cornerRadius;
    }

    public void setCornerRadius(int cornerRadius) {
        this.cornerRadius = cornerRadius;
    }

    public boolean isDrawOutline() {
        return this.drawOutline;
    }

    public void setDrawOutline(boolean drawOutline) {
        this.drawOutline = drawOutline;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        g2d.setColor(this.pSQouche.getBackground());
        RenderingHints hints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        hints.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g2d.setRenderingHints(hints);
        g2d.setFont(this.f);
        FontMetrics metrics = g.getFontMetrics(this.f);
        int sheigh = metrics.getHeight();
        this.baseLine = sheigh + this.verticalOffset;
        this.baseLineTab = this.baseLine + this.baseLineOffset;
        this.insetComandBar = new Insets(this.baseLineTab + 6, 6, 6, 6);
        int offset = this.offsetStart;
        g2d.setColor(Color.DARK_GRAY);
        for (int i = 0; i < this.commands.size(); ++i) {
            DemoTab c = this.commands.get(i);
            String name = c.getComandName();
            int startX = offset + this.offsetStart;
            c.setStartX(startX);
            int swidth = metrics.stringWidth(name);
            c.setWidthMetrics(swidth);
            int widthIcon = 0;
            if (c.getTabIcon() != null) {
                widthIcon = c.getTabIcon().getIconWidth();
                c.setIconWidth(widthIcon + 4);
            }
            int endX = swidth + widthIcon;
            c.setEndX(endX);
            offset = offset + swidth + widthIcon + 20 + this.interTab;
            g2d.setColor(Color.DARK_GRAY);
            GeneralPath tabPath = new GeneralPath();
            tabPath.moveTo(15.0f, this.getHeight() - 6);
            tabPath.quadTo(5.0f, this.getHeight() - 6, 5.0f, this.getHeight() - 16);
            tabPath.lineTo(5.0f, this.baseLineTab);
            tabPath.lineTo(c.getStartX() - 15, this.baseLineTab);
            tabPath.quadTo(c.getStartX() - 10, this.baseLineTab, c.getStartX() - 10, this.baseLineTab - 5);
            tabPath.lineTo(c.getStartX() - 10, this.baseLine - sheigh);
            tabPath.quadTo(c.getStartX() - 10, this.baseLine - sheigh - 10, c.getStartX(), this.baseLine - sheigh - 10);
            tabPath.lineTo(c.getStartX() + c.getEndX(), this.baseLine - sheigh - 10);
            tabPath.quadTo(c.getStartX() + c.getEndX() + 10, this.baseLine - sheigh - 10, c.getStartX() + c.getEndX() + 10, this.baseLine - sheigh);
            tabPath.lineTo(c.getStartX() + c.getEndX() + 10, this.baseLineTab);
            tabPath.lineTo(this.getWidth() - 6, this.baseLineTab);
            tabPath.lineTo(this.getWidth() - 6, this.getHeight() - 16);
            tabPath.quadTo(this.getWidth() - 6, this.getHeight() - 6, this.getWidth() - 16, this.getHeight() - 6);
            tabPath.closePath();
            c.setTabShape(tabPath);
            GeneralPath tabSensiblePath = new GeneralPath();
            int innerMargin = 4;
            tabSensiblePath.moveTo(c.getStartX() - 10 + innerMargin, this.baseLineTab - 5);
            tabSensiblePath.lineTo(c.getStartX() - 10 + innerMargin, this.baseLine - sheigh);
            tabSensiblePath.quadTo(c.getStartX() - 10 + innerMargin, this.baseLine - sheigh - 10 + innerMargin, c.getStartX(), this.baseLine - sheigh - 10 + innerMargin);
            tabSensiblePath.lineTo(c.getStartX() + c.getEndX(), this.baseLine - sheigh - 10 + innerMargin);
            tabSensiblePath.quadTo(c.getStartX() + c.getEndX() + 10 - innerMargin, this.baseLine - sheigh - 10 + innerMargin, c.getStartX() + c.getEndX() + 10 - innerMargin, this.baseLine - sheigh);
            tabSensiblePath.lineTo(c.getStartX() + c.getEndX() + 10 - innerMargin, this.baseLineTab - 5);
            tabSensiblePath.closePath();
            c.setSensibleTabShape(tabSensiblePath);
            GeneralPath gpathDeco = new GeneralPath();
            gpathDeco.moveTo(5.0f, this.baseLineTab);
            gpathDeco.lineTo(this.getWidth() - 6, this.baseLineTab);
            gpathDeco.lineTo(this.getWidth() - 6, this.getHeight() / 2);
            CubicCurve2D.Double curve = new CubicCurve2D.Double(this.getWidth() - 6, this.getHeight() / 2, this.getWidth() / 2, this.baseLineTab, this.getWidth() / 2, this.getHeight(), 5.0, this.getHeight() / 2);
            gpathDeco.append(curve, true);
            gpathDeco.closePath();
            c.setCubicDeco(gpathDeco);
        }
        RoundRectangle2D.Double roundBaseShape = new RoundRectangle2D.Double(0.0, 0.0, this.getWidth() - 1, this.getHeight() - 1, this.cornerRadius, this.cornerRadius);
        GradientPaint gpbase = new GradientPaint(this.getWidth() / 2, 0.0f, Color.LIGHT_GRAY, this.getWidth() / 2, this.baseLine, Color.GRAY, false);
        g2d.setColor(Color.LIGHT_GRAY);
        g2d.setPaint(gpbase);
        g2d.fill(roundBaseShape);
        g2d.setStroke(new BasicStroke(2.0f));
        if (this.drawOutline) {
            g2d.setColor(Color.WHITE);
            g2d.setStroke(new BasicStroke());
        }
        g2d.setColor(RosePalette.AEGEANBLUE);
        g2d.setFont(this.f);
        DemoTab selectedTab = null;
        for (int j = 0; j < this.commands.size(); ++j) {
            DemoTab c = this.commands.get(j);
            if (c.isSelected()) {
                selectedTab = c;
                continue;
            }
            g2d.setColor(Color.LIGHT_GRAY);
            GradientPaint gp = new GradientPaint(this.getWidth() / 2, this.baseLine - sheigh - 10, Color.WHITE, this.getWidth() / 2, this.baseLineTab + 5, c.getTabColor(), false);
            g2d.setPaint(gp);
            g2d.fill(c.getTabShape());
            g2d.setColor(Color.WHITE);
            g2d.draw(c.getTabShape());
            g2d.setColor(Color.BLACK);
            g2d.drawString(c.getComandName(), c.getStartX() + c.getIconWidth(), this.baseLine - 5);
            if (c.getTabIcon() == null) continue;
            g2d.drawImage(c.getTabIcon().getImage(), c.getStartX(), this.baseLine - c.getTabIcon().getIconHeight() - 2, c.getTabIcon().getIconWidth(), c.getTabIcon().getIconHeight(), null);
        }
        if (selectedTab != null) {
            GradientPaint gp = new GradientPaint(this.getWidth() / 2, 20.0f, Color.WHITE, this.getWidth() / 2, this.getHeight() / 2, selectedTab.getTabColor(), false);
            g2d.setPaint(gp);
            g2d.fill(selectedTab.getTabShape());
            g2d.setStroke(new BasicStroke(2.0f));
            g2d.setColor(Color.WHITE);
            g2d.draw(selectedTab.getTabShape());
            g2d.setStroke(new BasicStroke());
            g2d.setColor(Color.DARK_GRAY);
            g2d.drawString(selectedTab.getComandName(), selectedTab.getStartX() + selectedTab.getIconWidth(), this.baseLine - 5);
            if (selectedTab.getTabIcon() != null) {
                g2d.drawImage(selectedTab.getTabIcon().getImage(), selectedTab.getStartX(), this.baseLine - selectedTab.getTabIcon().getIconHeight() - 2, selectedTab.getTabIcon().getIconWidth(), selectedTab.getTabIcon().getIconHeight(), null);
            }
            g2d.setComposite(AlphaComposite.getInstance(3, 0.15f));
            g2d.setColor(Color.WHITE);
            g2d.fill(selectedTab.getCubicDeco());
            g2d.setComposite(AlphaComposite.getInstance(3, 1.0f));
        }
    }

    class BarListener
    implements MouseListener,
    MouseMotionListener {
        BarListener() {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            for (int i = 0; i < DemoTabSet.this.commands.size(); ++i) {
                DemoTab c = (DemoTab)DemoTabSet.this.commands.get(i);
                Shape tabShape = c.getSensibleTabShape();
                if (!tabShape.contains(new Point2D.Double(e.getX(), e.getY()))) continue;
                for (int j = 0; j < DemoTabSet.this.commands.size(); ++j) {
                    DemoTab cd = (DemoTab)DemoTabSet.this.commands.get(j);
                    cd.setSelected(false);
                }
                c.setSelected(true);
            }
            DemoTabSet.this.repaint();
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }
    }
}

