/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.catalog.source;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.io.StringWriter;
import javax.swing.JComponent;
import javax.swing.text.StyledDocument;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.jensoft.core.catalog.source.ControlPanel;
import org.jensoft.core.catalog.source.SourceScrollPane;
import org.jensoft.core.catalog.xml.XmlTextPane;
import org.jensoft.core.x2d.X2D;
import org.w3c.dom.Document;

public class X2DSourcePane
extends JComponent {
    private static final long serialVersionUID = 3845341077628968936L;
    private XmlTextPane sourceTextPane;

    public X2DSourcePane() {
        this.setLayout(new BorderLayout());
        this.setOpaque(false);
        this.sourceTextPane = new XmlTextPane(){
            private static final long serialVersionUID = -1726266447933631743L;

            @Override
            public Insets getInsets() {
                return new Insets(10, 10, 10, 10);
            }
        };
        this.sourceTextPane.setOpaque(false);
        this.sourceTextPane.setMargin(new Insets(10, 10, 10, 10));
        this.sourceTextPane.setEditable(false);
        SourceScrollPane scroll = new SourceScrollPane(this.sourceTextPane);
        scroll.setWheelScrollingEnabled(true);
        try {
            this.add((Component)new ControlPanel(this.sourceTextPane), "North");
        }
        catch (Error error) {
            // empty catch block
        }
        this.add((Component)scroll, "Center");
    }

    public void loadX2DSource(X2D x2d) {
        try {
            Document doc = x2d.getX2dDocument();
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer transformer = tf.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "1");
            StringWriter sw = new StringWriter();
            transformer.transform(new DOMSource(doc), new StreamResult(sw));
            StyledDocument styledDoc = this.sourceTextPane.getStyledDocument();
            styledDoc.insertString(0, sw.toString(), null);
        }
        catch (Exception e) {
            System.err.println("JenSoft API - Load x2d source of demo failed with error :" + e.getMessage());
        }
    }
}

