/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.catalog.styles;

import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Style;

public class WordStyle {
    private String[] words;
    private Style style;
    protected JTextComponent comp;

    public WordStyle(JTextComponent comp, Style style, String ... words) {
        this.comp = comp;
        this.style = style;
        this.words = words;
    }

    public void apply() {
        for (int i = 0; i < this.words.length; ++i) {
            String content = null;
            try {
                Document d = this.comp.getDocument();
                content = d.getText(0, d.getLength()).toLowerCase();
            }
            catch (BadLocationException e) {
                // empty catch block
            }
            String word = this.words[i].toLowerCase();
            int lastIndex = 0;
            int wordSize = word.length();
            while ((lastIndex = content.indexOf(word, lastIndex)) != -1) {
                int endIndex = lastIndex + wordSize;
                try {
                    DefaultStyledDocument d = (DefaultStyledDocument)this.comp.getDocument();
                    d.setCharacterAttributes(lastIndex, wordSize, this.style, true);
                }
                catch (Exception e) {
                    // empty catch block
                }
                lastIndex = endIndex;
            }
        }
    }
}

