/*
 * Decompiled with CFR 0.152.
 */
package org.jensoft.core.catalog.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JApplet;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.jensoft.core.catalog.component.DemoTab;
import org.jensoft.core.catalog.component.DemoTabSet;
import org.jensoft.core.catalog.nature.JenSoftDashboard;
import org.jensoft.core.catalog.source.JavaSourcePane;
import org.jensoft.core.catalog.ui.Dashboard;
import org.jensoft.core.catalog.ui.ImageResource;
import org.jensoft.core.palette.color.JennyPalette;
import org.jensoft.core.view.View;

public class DashboardAppletUI
extends JApplet {
    private static final long serialVersionUID = -4394607925193376209L;
    private String inset;
    private String drawOutline;
    private String cornerRadius;
    private String className;

    @Override
    public void init() {
        this.inset = this.getParameter("inset");
        this.drawOutline = this.getParameter("drawOutline");
        this.cornerRadius = this.getParameter("cornerRadius");
        this.className = this.getParameter("dashboardName");
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    DashboardAppletUI.this.create();
                }
            });
        }
        catch (Exception e) {
            System.err.println("Applet UI didn't successfully complete");
        }
    }

    private void create() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            // empty catch block
        }
        ImageIcon iconFrame = ImageResource.getInstance().createImageIcon("jensoft.png", "");
        this.getContentPane().removeAll();
        this.getContentPane().setLayout(new BorderLayout());
        JPanel masterPane = new JPanel();
        masterPane.setBackground(Color.WHITE);
        masterPane.setLayout(new BorderLayout());
        try {
            StringTokenizer tokenizer = new StringTokenizer(this.inset, ",");
            masterPane.setBorder(BorderFactory.createEmptyBorder(Integer.parseInt(tokenizer.nextToken()), Integer.parseInt(tokenizer.nextToken()), Integer.parseInt(tokenizer.nextToken()), Integer.parseInt(tokenizer.nextToken())));
        }
        catch (Throwable e) {
            masterPane.setBorder(BorderFactory.createEmptyBorder(50, 50, 50, 50));
        }
        DemoTabSet tabSet = new DemoTabSet();
        tabSet.setTitle("JenSoft - API");
        if (this.cornerRadius != null) {
            tabSet.setCornerRadius(Integer.parseInt(this.cornerRadius));
        }
        if (this.drawOutline != null) {
            tabSet.setDrawOutline(Boolean.parseBoolean(this.drawOutline));
        }
        tabSet.setTitle("JenSoft");
        DemoTab demoTab = new DemoTab("Dashboard");
        demoTab.setTabColor(Color.DARK_GRAY);
        ImageIcon icon1 = ImageResource.getInstance().createImageIcon("demo.png", "");
        demoTab.setTabIcon(icon1);
        Dashboard dashboard = null;
        try {
            Class<?> dashboardClass = Class.forName(this.className);
            dashboard = (Dashboard)dashboardClass.newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        tabSet.addComandTab(demoTab, dashboard);
        DemoTab dashboardTab = new DemoTab("Dashboard");
        dashboardTab.setTabColor(JennyPalette.JENNY6);
        ImageIcon icon = ImageResource.getInstance().createImageIcon("source.png", "");
        dashboardTab.setTabIcon(icon);
        JavaSourcePane dashboardSourcePane = new JavaSourcePane();
        tabSet.addComandTab(dashboardTab, dashboardSourcePane);
        dashboardSourcePane.loadSource(dashboard.getClass());
        if (dashboard.getClass().isAnnotationPresent(JenSoftDashboard.class)) {
            JenSoftDashboard dashboardAnnotation = dashboard.getClass().getAnnotation(JenSoftDashboard.class);
            Class[] views = dashboardAnnotation.views();
            for (int i = 0; i < views.length; ++i) {
                if (!View.class.isAssignableFrom(views[i])) continue;
                DemoTab viewContributorTab = new DemoTab(views[i].getSimpleName());
                viewContributorTab.setTabColor(JennyPalette.JENNY6);
                ImageIcon vIcon = ImageResource.getInstance().createImageIcon("source.png", "");
                viewContributorTab.setTabIcon(vIcon);
                JavaSourcePane viewSourcePane = new JavaSourcePane();
                tabSet.addComandTab(viewContributorTab, viewSourcePane);
                viewSourcePane.loadSource(views[i]);
            }
        }
        demoTab.setSelected(true);
        masterPane.add((Component)tabSet, "Center");
        this.getContentPane().add((Component)masterPane, "Center");
        this.setVisible(true);
    }
}

